/*++

Copyright (c) 1990-1991  Microsoft Corporation


Module Name:

    htmath.c


Abstract:

    This module contains the basic math. functions for the halftone
    process.

Author:

    16-Jan-1991 Wed 10:51:27 created  -by-  Daniel Chou (danielc)

[Environment:]

    GDI Device Driver - Halftone.


[Notes:]


Revision History:

    02-Feb-1994 Wed 18:08:13 updated  -by-  Daniel Chou (danielc)
        Remove unary unsigned wranings.



--*/

#define DBGP_VARNAME        dbgpHTMath



#define HAS_80x86_EQUIVALENT_CODES

#include "htp.h"
#include "htmath.h"


#define DBGP_REGRESS        0x0001
#define DBGP_CONCAT_M       0x0002

DEF_DBGPVAR(BIT_IF(DBGP_CONCAT_M,   0)  |
            BIT_IF(DBGP_REGRESS,    0))



#if DBG
LPBYTE  pDbgRegMode[] = { "LINEAR", "LOG", "EXP", "POWER" };
#endif



//
// Local definitions only used in this file
//

#define ABSFD6(a)           (FD6)(((a) < 0L) ? -(a) : (a))
#define SWAPFD6(a, b, t)    (t)=(a); (a)=(b); (b)=(t)
#define U16_H_U32(a)        (WORD)((DWORD)(a) >> 16)
#define U16_L_U32(a)        (WORD)((DWORD)(a) & 0xffffL)
#define FD6_LOG_MIN         -FD6_6
#define FD6_LOG_MAX         (FD6)3331930L
#define FD6ToL(n)           (LONG)(n)
#define FD6FromL(n)         (FD6)(n)

#define NEGDW(x)            (DWORD)(-(LONG)(x))
#define MIN_FD6             (FD6)-(LONG)2147483648
#define MAX_FD6             (FD6)(LONG)2147483647



//
// MANTISSATABLE
//
//  This is the look up table for the mantissa portion of the log number, the
//  table range from 1.00 to 10.00 at increment of 0.01 for the look up
//  numbers.  If the requested number has lies between two look up numbers
//  then an interpolation is done using those two look up numbers.
//

#define MANTISSATABLE_SIZE          901


FD6 MantissaTable[MANTISSATABLE_SIZE] = {

    (FD6)0,      (FD6)4321,     //  1.00 - 1.01
    (FD6)8600,   (FD6)12837,    //  1.02 - 1.03
    (FD6)17033,  (FD6)21189,    //  1.04 - 1.05
    (FD6)25306,  (FD6)29384,    //  1.06 - 1.07
    (FD6)33424,  (FD6)37426,    //  1.08 - 1.09
    (FD6)41393,  (FD6)45323,    //  1.10 - 1.11
    (FD6)49218,  (FD6)53078,    //  1.12 - 1.13
    (FD6)56905,  (FD6)60698,    //  1.14 - 1.15
    (FD6)64458,  (FD6)68186,    //  1.16 - 1.17
    (FD6)71882,  (FD6)75547,    //  1.18 - 1.19
    (FD6)79181,  (FD6)82785,    //  1.20 - 1.21
    (FD6)86360,  (FD6)89905,    //  1.22 - 1.23
    (FD6)93422,  (FD6)96910,    //  1.24 - 1.25
    (FD6)100371, (FD6)103804,   //  1.26 - 1.27
    (FD6)107210, (FD6)110590,   //  1.28 - 1.29
    (FD6)113943, (FD6)117271,   //  1.30 - 1.31
    (FD6)120574, (FD6)123852,   //  1.32 - 1.33
    (FD6)127105, (FD6)130334,   //  1.34 - 1.35
    (FD6)133539, (FD6)136721,   //  1.36 - 1.37
    (FD6)139879, (FD6)143015,   //  1.38 - 1.39
    (FD6)146128, (FD6)149219,   //  1.40 - 1.41
    (FD6)152288, (FD6)155336,   //  1.42 - 1.43
    (FD6)158362, (FD6)161368,   //  1.44 - 1.45
    (FD6)164353, (FD6)167317,   //  1.46 - 1.47
    (FD6)170262, (FD6)173186,   //  1.48 - 1.49
    (FD6)176091, (FD6)178977,   //  1.50 - 1.51
    (FD6)181844, (FD6)184691,   //  1.52 - 1.53
    (FD6)187521, (FD6)190332,   //  1.54 - 1.55
    (FD6)193125, (FD6)195900,   //  1.56 - 1.57
    (FD6)198657, (FD6)201397,   //  1.58 - 1.59
    (FD6)204120, (FD6)206826,   //  1.60 - 1.61
    (FD6)209515, (FD6)212188,   //  1.62 - 1.63
    (FD6)214844, (FD6)217484,   //  1.64 - 1.65
    (FD6)220108, (FD6)222716,   //  1.66 - 1.67
    (FD6)225309, (FD6)227887,   //  1.68 - 1.69
    (FD6)230449, (FD6)232996,   //  1.70 - 1.71
    (FD6)235528, (FD6)238046,   //  1.72 - 1.73
    (FD6)240549, (FD6)243038,   //  1.74 - 1.75
    (FD6)245513, (FD6)247973,   //  1.76 - 1.77
    (FD6)250420, (FD6)252853,   //  1.78 - 1.79
    (FD6)255273, (FD6)257679,   //  1.80 - 1.81
    (FD6)260071, (FD6)262451,   //  1.82 - 1.83
    (FD6)264818, (FD6)267172,   //  1.84 - 1.85
    (FD6)269513, (FD6)271842,   //  1.86 - 1.87
    (FD6)274158, (FD6)276462,   //  1.88 - 1.89
    (FD6)278754, (FD6)281033,   //  1.90 - 1.91
    (FD6)283301, (FD6)285557,   //  1.92 - 1.93
    (FD6)287802, (FD6)290035,   //  1.94 - 1.95
    (FD6)292256, (FD6)294466,   //  1.96 - 1.97
    (FD6)296665, (FD6)298853,   //  1.98 - 1.99
    (FD6)301030, (FD6)303196,   //  2.00 - 2.01
    (FD6)305351, (FD6)307496,   //  2.02 - 2.03
    (FD6)309630, (FD6)311754,   //  2.04 - 2.05
    (FD6)313867, (FD6)315970,   //  2.06 - 2.07
    (FD6)318063, (FD6)320146,   //  2.08 - 2.09
    (FD6)322219, (FD6)324282,   //  2.10 - 2.11
    (FD6)326336, (FD6)328380,   //  2.12 - 2.13
    (FD6)330414, (FD6)332438,   //  2.14 - 2.15
    (FD6)334454, (FD6)336460,   //  2.16 - 2.17
    (FD6)338456, (FD6)340444,   //  2.18 - 2.19
    (FD6)342423, (FD6)344392,   //  2.20 - 2.21
    (FD6)346353, (FD6)348305,   //  2.22 - 2.23
    (FD6)350248, (FD6)352183,   //  2.24 - 2.25
    (FD6)354108, (FD6)356026,   //  2.26 - 2.27
    (FD6)357935, (FD6)359835,   //  2.28 - 2.29
    (FD6)361728, (FD6)363612,   //  2.30 - 2.31
    (FD6)365488, (FD6)367356,   //  2.32 - 2.33
    (FD6)369216, (FD6)371068,   //  2.34 - 2.35
    (FD6)372912, (FD6)374748,   //  2.36 - 2.37
    (FD6)376577, (FD6)378398,   //  2.38 - 2.39
    (FD6)380211, (FD6)382017,   //  2.40 - 2.41
    (FD6)383815, (FD6)385606,   //  2.42 - 2.43
    (FD6)387390, (FD6)389166,   //  2.44 - 2.45
    (FD6)390935, (FD6)392697,   //  2.46 - 2.47
    (FD6)394452, (FD6)396199,   //  2.48 - 2.49
    (FD6)397940, (FD6)399674,   //  2.50 - 2.51
    (FD6)401401, (FD6)403121,   //  2.52 - 2.53
    (FD6)404834, (FD6)406540,   //  2.54 - 2.55
    (FD6)408240, (FD6)409933,   //  2.56 - 2.57
    (FD6)411620, (FD6)413300,   //  2.58 - 2.59
    (FD6)414973, (FD6)416641,   //  2.60 - 2.61
    (FD6)418301, (FD6)419956,   //  2.62 - 2.63
    (FD6)421604, (FD6)423246,   //  2.64 - 2.65
    (FD6)424882, (FD6)426511,   //  2.66 - 2.67
    (FD6)428135, (FD6)429752,   //  2.68 - 2.69
    (FD6)431364, (FD6)432969,   //  2.70 - 2.71
    (FD6)434569, (FD6)436163,   //  2.72 - 2.73
    (FD6)437751, (FD6)439333,   //  2.74 - 2.75
    (FD6)440909, (FD6)442480,   //  2.76 - 2.77
    (FD6)444045, (FD6)445604,   //  2.78 - 2.79
    (FD6)447158, (FD6)448706,   //  2.80 - 2.81
    (FD6)450249, (FD6)451786,   //  2.82 - 2.83
    (FD6)453318, (FD6)454845,   //  2.84 - 2.85
    (FD6)456366, (FD6)457882,   //  2.86 - 2.87
    (FD6)459392, (FD6)460898,   //  2.88 - 2.89
    (FD6)462398, (FD6)463893,   //  2.90 - 2.91
    (FD6)465383, (FD6)466868,   //  2.92 - 2.93
    (FD6)468347, (FD6)469822,   //  2.94 - 2.95
    (FD6)471292, (FD6)472756,   //  2.96 - 2.97
    (FD6)474216, (FD6)475671,   //  2.98 - 2.99
    (FD6)477121, (FD6)478566,   //  3.00 - 3.01
    (FD6)480007, (FD6)481443,   //  3.02 - 3.03
    (FD6)482874, (FD6)484300,   //  3.04 - 3.05
    (FD6)485721, (FD6)487138,   //  3.06 - 3.07
    (FD6)488551, (FD6)489958,   //  3.08 - 3.09
    (FD6)491362, (FD6)492760,   //  3.10 - 3.11
    (FD6)494155, (FD6)495544,   //  3.12 - 3.13
    (FD6)496930, (FD6)498311,   //  3.14 - 3.15
    (FD6)499687, (FD6)501059,   //  3.16 - 3.17
    (FD6)502427, (FD6)503791,   //  3.18 - 3.19
    (FD6)505150, (FD6)506505,   //  3.20 - 3.21
    (FD6)507856, (FD6)509203,   //  3.22 - 3.23
    (FD6)510545, (FD6)511883,   //  3.24 - 3.25
    (FD6)513218, (FD6)514548,   //  3.26 - 3.27
    (FD6)515874, (FD6)517196,   //  3.28 - 3.29
    (FD6)518514, (FD6)519828,   //  3.30 - 3.31
    (FD6)521138, (FD6)522444,   //  3.32 - 3.33
    (FD6)523746, (FD6)525045,   //  3.34 - 3.35
    (FD6)526339, (FD6)527630,   //  3.36 - 3.37
    (FD6)528917, (FD6)530200,   //  3.38 - 3.39
    (FD6)531479, (FD6)532754,   //  3.40 - 3.41
    (FD6)534026, (FD6)535294,   //  3.42 - 3.43
    (FD6)536558, (FD6)537819,   //  3.44 - 3.45
    (FD6)539076, (FD6)540329,   //  3.46 - 3.47
    (FD6)541579, (FD6)542825,   //  3.48 - 3.49
    (FD6)544068, (FD6)545307,   //  3.50 - 3.51
    (FD6)546543, (FD6)547775,   //  3.52 - 3.53
    (FD6)549003, (FD6)550228,   //  3.54 - 3.55
    (FD6)551450, (FD6)552668,   //  3.56 - 3.57
    (FD6)553883, (FD6)555094,   //  3.58 - 3.59
    (FD6)556303, (FD6)557507,   //  3.60 - 3.61
    (FD6)558709, (FD6)559907,   //  3.62 - 3.63
    (FD6)561101, (FD6)562293,   //  3.64 - 3.65
    (FD6)563481, (FD6)564666,   //  3.66 - 3.67
    (FD6)565848, (FD6)567026,   //  3.68 - 3.69
    (FD6)568202, (FD6)569374,   //  3.70 - 3.71
    (FD6)570543, (FD6)571709,   //  3.72 - 3.73
    (FD6)572872, (FD6)574031,   //  3.74 - 3.75
    (FD6)575188, (FD6)576341,   //  3.76 - 3.77
    (FD6)577492, (FD6)578639,   //  3.78 - 3.79
    (FD6)579784, (FD6)580925,   //  3.80 - 3.81
    (FD6)582063, (FD6)583199,   //  3.82 - 3.83
    (FD6)584331, (FD6)585461,   //  3.84 - 3.85
    (FD6)586587, (FD6)587711,   //  3.86 - 3.87
    (FD6)588832, (FD6)589950,   //  3.88 - 3.89
    (FD6)591065, (FD6)592177,   //  3.90 - 3.91
    (FD6)593286, (FD6)594393,   //  3.92 - 3.93
    (FD6)595496, (FD6)596597,   //  3.94 - 3.95
    (FD6)597695, (FD6)598791,   //  3.96 - 3.97
    (FD6)599883, (FD6)600973,   //  3.98 - 3.99
    (FD6)602060, (FD6)603144,   //  4.00 - 4.01
    (FD6)604226, (FD6)605305,   //  4.02 - 4.03
    (FD6)606381, (FD6)607455,   //  4.04 - 4.05
    (FD6)608526, (FD6)609594,   //  4.06 - 4.07
    (FD6)610660, (FD6)611723,   //  4.08 - 4.09
    (FD6)612784, (FD6)613842,   //  4.10 - 4.11
    (FD6)614897, (FD6)615950,   //  4.12 - 4.13
    (FD6)617000, (FD6)618048,   //  4.14 - 4.15
    (FD6)619093, (FD6)620136,   //  4.16 - 4.17
    (FD6)621176, (FD6)622214,   //  4.18 - 4.19
    (FD6)623249, (FD6)624282,   //  4.20 - 4.21
    (FD6)625312, (FD6)626340,   //  4.22 - 4.23
    (FD6)627366, (FD6)628389,   //  4.24 - 4.25
    (FD6)629410, (FD6)630428,   //  4.26 - 4.27
    (FD6)631444, (FD6)632457,   //  4.28 - 4.29
    (FD6)633468, (FD6)634477,   //  4.30 - 4.31
    (FD6)635484, (FD6)636488,   //  4.32 - 4.33
    (FD6)637490, (FD6)638489,   //  4.34 - 4.35
    (FD6)639486, (FD6)640481,   //  4.36 - 4.37
    (FD6)641474, (FD6)642465,   //  4.38 - 4.39
    (FD6)643453, (FD6)644439,   //  4.40 - 4.41
    (FD6)645422, (FD6)646404,   //  4.42 - 4.43
    (FD6)647383, (FD6)648360,   //  4.44 - 4.45
    (FD6)649335, (FD6)650308,   //  4.46 - 4.47
    (FD6)651278, (FD6)652246,   //  4.48 - 4.49
    (FD6)653213, (FD6)654177,   //  4.50 - 4.51
    (FD6)655138, (FD6)656098,   //  4.52 - 4.53
    (FD6)657056, (FD6)658011,   //  4.54 - 4.55
    (FD6)658965, (FD6)659916,   //  4.56 - 4.57
    (FD6)660865, (FD6)661813,   //  4.58 - 4.59
    (FD6)662758, (FD6)663701,   //  4.60 - 4.61
    (FD6)664642, (FD6)665581,   //  4.62 - 4.63
    (FD6)666518, (FD6)667453,   //  4.64 - 4.65
    (FD6)668386, (FD6)669317,   //  4.66 - 4.67
    (FD6)670246, (FD6)671173,   //  4.68 - 4.69
    (FD6)672098, (FD6)673021,   //  4.70 - 4.71
    (FD6)673942, (FD6)674861,   //  4.72 - 4.73
    (FD6)675778, (FD6)676694,   //  4.74 - 4.75
    (FD6)677607, (FD6)678518,   //  4.76 - 4.77
    (FD6)679428, (FD6)680336,   //  4.78 - 4.79
    (FD6)681241, (FD6)682145,   //  4.80 - 4.81
    (FD6)683047, (FD6)683947,   //  4.82 - 4.83
    (FD6)684845, (FD6)685742,   //  4.84 - 4.85
    (FD6)686636, (FD6)687529,   //  4.86 - 4.87
    (FD6)688420, (FD6)689309,   //  4.88 - 4.89
    (FD6)690196, (FD6)691081,   //  4.90 - 4.91
    (FD6)691965, (FD6)692847,   //  4.92 - 4.93
    (FD6)693727, (FD6)694605,   //  4.94 - 4.95
    (FD6)695482, (FD6)696356,   //  4.96 - 4.97
    (FD6)697229, (FD6)698101,   //  4.98 - 4.99
    (FD6)698970, (FD6)699838,   //  5.00 - 5.01
    (FD6)700704, (FD6)701568,   //  5.02 - 5.03
    (FD6)702431, (FD6)703291,   //  5.04 - 5.05
    (FD6)704151, (FD6)705008,   //  5.06 - 5.07
    (FD6)705864, (FD6)706718,   //  5.08 - 5.09
    (FD6)707570, (FD6)708421,   //  5.10 - 5.11
    (FD6)709270, (FD6)710117,   //  5.12 - 5.13
    (FD6)710963, (FD6)711807,   //  5.14 - 5.15
    (FD6)712650, (FD6)713491,   //  5.16 - 5.17
    (FD6)714330, (FD6)715167,   //  5.18 - 5.19
    (FD6)716003, (FD6)716838,   //  5.20 - 5.21
    (FD6)717671, (FD6)718502,   //  5.22 - 5.23
    (FD6)719331, (FD6)720159,   //  5.24 - 5.25
    (FD6)720986, (FD6)721811,   //  5.26 - 5.27
    (FD6)722634, (FD6)723456,   //  5.28 - 5.29
    (FD6)724276, (FD6)725095,   //  5.30 - 5.31
    (FD6)725912, (FD6)726727,   //  5.32 - 5.33
    (FD6)727541, (FD6)728354,   //  5.34 - 5.35
    (FD6)729165, (FD6)729974,   //  5.36 - 5.37
    (FD6)730782, (FD6)731589,   //  5.38 - 5.39
    (FD6)732394, (FD6)733197,   //  5.40 - 5.41
    (FD6)733999, (FD6)734800,   //  5.42 - 5.43
    (FD6)735599, (FD6)736397,   //  5.44 - 5.45
    (FD6)737193, (FD6)737987,   //  5.46 - 5.47
    (FD6)738781, (FD6)739572,   //  5.48 - 5.49
    (FD6)740363, (FD6)741152,   //  5.50 - 5.51
    (FD6)741939, (FD6)742725,   //  5.52 - 5.53
    (FD6)743510, (FD6)744293,   //  5.54 - 5.55
    (FD6)745075, (FD6)745855,   //  5.56 - 5.57
    (FD6)746634, (FD6)747412,   //  5.58 - 5.59
    (FD6)748188, (FD6)748963,   //  5.60 - 5.61
    (FD6)749736, (FD6)750508,   //  5.62 - 5.63
    (FD6)751279, (FD6)752048,   //  5.64 - 5.65
    (FD6)752816, (FD6)753583,   //  5.66 - 5.67
    (FD6)754348, (FD6)755112,   //  5.68 - 5.69
    (FD6)755875, (FD6)756636,   //  5.70 - 5.71
    (FD6)757396, (FD6)758155,   //  5.72 - 5.73
    (FD6)758912, (FD6)759668,   //  5.74 - 5.75
    (FD6)760422, (FD6)761176,   //  5.76 - 5.77
    (FD6)761928, (FD6)762679,   //  5.78 - 5.79
    (FD6)763428, (FD6)764176,   //  5.80 - 5.81
    (FD6)764923, (FD6)765669,   //  5.82 - 5.83
    (FD6)766413, (FD6)767156,   //  5.84 - 5.85
    (FD6)767898, (FD6)768638,   //  5.86 - 5.87
    (FD6)769377, (FD6)770115,   //  5.88 - 5.89
    (FD6)770852, (FD6)771587,   //  5.90 - 5.91
    (FD6)772322, (FD6)773055,   //  5.92 - 5.93
    (FD6)773786, (FD6)774517,   //  5.94 - 5.95
    (FD6)775246, (FD6)775974,   //  5.96 - 5.97
    (FD6)776701, (FD6)777427,   //  5.98 - 5.99
    (FD6)778151, (FD6)778874,   //  6.00 - 6.01
    (FD6)779596, (FD6)780317,   //  6.02 - 6.03
    (FD6)781037, (FD6)781755,   //  6.04 - 6.05
    (FD6)782473, (FD6)783189,   //  6.06 - 6.07
    (FD6)783904, (FD6)784617,   //  6.08 - 6.09
    (FD6)785330, (FD6)786041,   //  6.10 - 6.11
    (FD6)786751, (FD6)787460,   //  6.12 - 6.13
    (FD6)788168, (FD6)788875,   //  6.14 - 6.15
    (FD6)789581, (FD6)790285,   //  6.16 - 6.17
    (FD6)790988, (FD6)791691,   //  6.18 - 6.19
    (FD6)792392, (FD6)793092,   //  6.20 - 6.21
    (FD6)793790, (FD6)794488,   //  6.22 - 6.23
    (FD6)795185, (FD6)795880,   //  6.24 - 6.25
    (FD6)796574, (FD6)797268,   //  6.26 - 6.27
    (FD6)797960, (FD6)798651,   //  6.28 - 6.29
    (FD6)799341, (FD6)800029,   //  6.30 - 6.31
    (FD6)800717, (FD6)801404,   //  6.32 - 6.33
    (FD6)802089, (FD6)802774,   //  6.34 - 6.35
    (FD6)803457, (FD6)804139,   //  6.36 - 6.37
    (FD6)804821, (FD6)805501,   //  6.38 - 6.39
    (FD6)806180, (FD6)806858,   //  6.40 - 6.41
    (FD6)807535, (FD6)808211,   //  6.42 - 6.43
    (FD6)808886, (FD6)809560,   //  6.44 - 6.45
    (FD6)810233, (FD6)810904,   //  6.46 - 6.47
    (FD6)811575, (FD6)812245,   //  6.48 - 6.49
    (FD6)812913, (FD6)813581,   //  6.50 - 6.51
    (FD6)814248, (FD6)814913,   //  6.52 - 6.53
    (FD6)815578, (FD6)816241,   //  6.54 - 6.55
    (FD6)816904, (FD6)817565,   //  6.56 - 6.57
    (FD6)818226, (FD6)818885,   //  6.58 - 6.59
    (FD6)819544, (FD6)820201,   //  6.60 - 6.61
    (FD6)820858, (FD6)821514,   //  6.62 - 6.63
    (FD6)822168, (FD6)822822,   //  6.64 - 6.65
    (FD6)823474, (FD6)824126,   //  6.66 - 6.67
    (FD6)824776, (FD6)825426,   //  6.68 - 6.69
    (FD6)826075, (FD6)826723,   //  6.70 - 6.71
    (FD6)827369, (FD6)828015,   //  6.72 - 6.73
    (FD6)828660, (FD6)829304,   //  6.74 - 6.75
    (FD6)829947, (FD6)830589,   //  6.76 - 6.77
    (FD6)831230, (FD6)831870,   //  6.78 - 6.79
    (FD6)832509, (FD6)833147,   //  6.80 - 6.81
    (FD6)833784, (FD6)834421,   //  6.82 - 6.83
    (FD6)835056, (FD6)835691,   //  6.84 - 6.85
    (FD6)836324, (FD6)836957,   //  6.86 - 6.87
    (FD6)837588, (FD6)838219,   //  6.88 - 6.89
    (FD6)838849, (FD6)839478,   //  6.90 - 6.91
    (FD6)840106, (FD6)840733,   //  6.92 - 6.93
    (FD6)841359, (FD6)841985,   //  6.94 - 6.95
    (FD6)842609, (FD6)843233,   //  6.96 - 6.97
    (FD6)843855, (FD6)844477,   //  6.98 - 6.99
    (FD6)845098, (FD6)845718,   //  7.00 - 7.01
    (FD6)846337, (FD6)846955,   //  7.02 - 7.03
    (FD6)847573, (FD6)848189,   //  7.04 - 7.05
    (FD6)848805, (FD6)849419,   //  7.06 - 7.07
    (FD6)850033, (FD6)850646,   //  7.08 - 7.09
    (FD6)851258, (FD6)851870,   //  7.10 - 7.11
    (FD6)852480, (FD6)853090,   //  7.12 - 7.13
    (FD6)853698, (FD6)854306,   //  7.14 - 7.15
    (FD6)854913, (FD6)855519,   //  7.16 - 7.17
    (FD6)856124, (FD6)856729,   //  7.18 - 7.19
    (FD6)857332, (FD6)857935,   //  7.20 - 7.21
    (FD6)858537, (FD6)859138,   //  7.22 - 7.23
    (FD6)859739, (FD6)860338,   //  7.24 - 7.25
    (FD6)860937, (FD6)861534,   //  7.26 - 7.27
    (FD6)862131, (FD6)862728,   //  7.28 - 7.29
    (FD6)863323, (FD6)863917,   //  7.30 - 7.31
    (FD6)864511, (FD6)865104,   //  7.32 - 7.33
    (FD6)865696, (FD6)866287,   //  7.34 - 7.35
    (FD6)866878, (FD6)867467,   //  7.36 - 7.37
    (FD6)868056, (FD6)868644,   //  7.38 - 7.39
    (FD6)869232, (FD6)869818,   //  7.40 - 7.41
    (FD6)870404, (FD6)870989,   //  7.42 - 7.43
    (FD6)871573, (FD6)872156,   //  7.44 - 7.45
    (FD6)872739, (FD6)873321,   //  7.46 - 7.47
    (FD6)873902, (FD6)874482,   //  7.48 - 7.49
    (FD6)875061, (FD6)875640,   //  7.50 - 7.51
    (FD6)876218, (FD6)876795,   //  7.52 - 7.53
    (FD6)877371, (FD6)877947,   //  7.54 - 7.55
    (FD6)878522, (FD6)879096,   //  7.56 - 7.57
    (FD6)879669, (FD6)880242,   //  7.58 - 7.59
    (FD6)880814, (FD6)881385,   //  7.60 - 7.61
    (FD6)881955, (FD6)882525,   //  7.62 - 7.63
    (FD6)883093, (FD6)883661,   //  7.64 - 7.65
    (FD6)884229, (FD6)884795,   //  7.66 - 7.67
    (FD6)885361, (FD6)885926,   //  7.68 - 7.69
    (FD6)886491, (FD6)887054,   //  7.70 - 7.71
    (FD6)887617, (FD6)888179,   //  7.72 - 7.73
    (FD6)888741, (FD6)889302,   //  7.74 - 7.75
    (FD6)889862, (FD6)890421,   //  7.76 - 7.77
    (FD6)890980, (FD6)891537,   //  7.78 - 7.79
    (FD6)892095, (FD6)892651,   //  7.80 - 7.81
    (FD6)893207, (FD6)893762,   //  7.82 - 7.83
    (FD6)894316, (FD6)894870,   //  7.84 - 7.85
    (FD6)895423, (FD6)895975,   //  7.86 - 7.87
    (FD6)896526, (FD6)897077,   //  7.88 - 7.89
    (FD6)897627, (FD6)898176,   //  7.90 - 7.91
    (FD6)898725, (FD6)899273,   //  7.92 - 7.93
    (FD6)899821, (FD6)900367,   //  7.94 - 7.95
    (FD6)900913, (FD6)901458,   //  7.96 - 7.97
    (FD6)902003, (FD6)902547,   //  7.98 - 7.99
    (FD6)903090, (FD6)903633,   //  8.00 - 8.01
    (FD6)904174, (FD6)904716,   //  8.02 - 8.03
    (FD6)905256, (FD6)905796,   //  8.04 - 8.05
    (FD6)906335, (FD6)906874,   //  8.06 - 8.07
    (FD6)907411, (FD6)907949,   //  8.08 - 8.09
    (FD6)908485, (FD6)909021,   //  8.10 - 8.11
    (FD6)909556, (FD6)910091,   //  8.12 - 8.13
    (FD6)910624, (FD6)911158,   //  8.14 - 8.15
    (FD6)911690, (FD6)912222,   //  8.16 - 8.17
    (FD6)912753, (FD6)913284,   //  8.18 - 8.19
    (FD6)913814, (FD6)914343,   //  8.20 - 8.21
    (FD6)914872, (FD6)915400,   //  8.22 - 8.23
    (FD6)915927, (FD6)916454,   //  8.24 - 8.25
    (FD6)916980, (FD6)917506,   //  8.26 - 8.27
    (FD6)918030, (FD6)918555,   //  8.28 - 8.29
    (FD6)919078, (FD6)919601,   //  8.30 - 8.31
    (FD6)920123, (FD6)920645,   //  8.32 - 8.33
    (FD6)921166, (FD6)921686,   //  8.34 - 8.35
    (FD6)922206, (FD6)922725,   //  8.36 - 8.37
    (FD6)923244, (FD6)923762,   //  8.38 - 8.39
    (FD6)924279, (FD6)924796,   //  8.40 - 8.41
    (FD6)925312, (FD6)925828,   //  8.42 - 8.43
    (FD6)926342, (FD6)926857,   //  8.44 - 8.45
    (FD6)927370, (FD6)927883,   //  8.46 - 8.47
    (FD6)928396, (FD6)928908,   //  8.48 - 8.49
    (FD6)929419, (FD6)929930,   //  8.50 - 8.51
    (FD6)930440, (FD6)930949,   //  8.52 - 8.53
    (FD6)931458, (FD6)931966,   //  8.54 - 8.55
    (FD6)932474, (FD6)932981,   //  8.56 - 8.57
    (FD6)933487, (FD6)933993,   //  8.58 - 8.59
    (FD6)934498, (FD6)935003,   //  8.60 - 8.61
    (FD6)935507, (FD6)936011,   //  8.62 - 8.63
    (FD6)936514, (FD6)937016,   //  8.64 - 8.65
    (FD6)937518, (FD6)938019,   //  8.66 - 8.67
    (FD6)938520, (FD6)939020,   //  8.68 - 8.69
    (FD6)939519, (FD6)940018,   //  8.70 - 8.71
    (FD6)940516, (FD6)941014,   //  8.72 - 8.73
    (FD6)941511, (FD6)942008,   //  8.74 - 8.75
    (FD6)942504, (FD6)943000,   //  8.76 - 8.77
    (FD6)943495, (FD6)943989,   //  8.78 - 8.79
    (FD6)944483, (FD6)944976,   //  8.80 - 8.81
    (FD6)945469, (FD6)945961,   //  8.82 - 8.83
    (FD6)946452, (FD6)946943,   //  8.84 - 8.85
    (FD6)947434, (FD6)947924,   //  8.86 - 8.87
    (FD6)948413, (FD6)948902,   //  8.88 - 8.89
    (FD6)949390, (FD6)949878,   //  8.90 - 8.91
    (FD6)950365, (FD6)950851,   //  8.92 - 8.93
    (FD6)951338, (FD6)951823,   //  8.94 - 8.95
    (FD6)952308, (FD6)952792,   //  8.96 - 8.97
    (FD6)953276, (FD6)953760,   //  8.98 - 8.99
    (FD6)954243, (FD6)954725,   //  9.00 - 9.01
    (FD6)955207, (FD6)955688,   //  9.02 - 9.03
    (FD6)956168, (FD6)956649,   //  9.04 - 9.05
    (FD6)957128, (FD6)957607,   //  9.06 - 9.07
    (FD6)958086, (FD6)958564,   //  9.08 - 9.09
    (FD6)959041, (FD6)959518,   //  9.10 - 9.11
    (FD6)959995, (FD6)960471,   //  9.12 - 9.13
    (FD6)960946, (FD6)961421,   //  9.14 - 9.15
    (FD6)961895, (FD6)962369,   //  9.16 - 9.17
    (FD6)962843, (FD6)963316,   //  9.18 - 9.19
    (FD6)963788, (FD6)964260,   //  9.20 - 9.21
    (FD6)964731, (FD6)965202,   //  9.22 - 9.23
    (FD6)965672, (FD6)966142,   //  9.24 - 9.25
    (FD6)966611, (FD6)967080,   //  9.26 - 9.27
    (FD6)967548, (FD6)968016,   //  9.28 - 9.29
    (FD6)968483, (FD6)968950,   //  9.30 - 9.31
    (FD6)969416, (FD6)969882,   //  9.32 - 9.33
    (FD6)970347, (FD6)970812,   //  9.34 - 9.35
    (FD6)971276, (FD6)971740,   //  9.36 - 9.37
    (FD6)972203, (FD6)972666,   //  9.38 - 9.39
    (FD6)973128, (FD6)973590,   //  9.40 - 9.41
    (FD6)974051, (FD6)974512,   //  9.42 - 9.43
    (FD6)974972, (FD6)975432,   //  9.44 - 9.45
    (FD6)975891, (FD6)976350,   //  9.46 - 9.47
    (FD6)976808, (FD6)977266,   //  9.48 - 9.49
    (FD6)977724, (FD6)978181,   //  9.50 - 9.51
    (FD6)978637, (FD6)979093,   //  9.52 - 9.53
    (FD6)979548, (FD6)980003,   //  9.54 - 9.55
    (FD6)980458, (FD6)980912,   //  9.56 - 9.57
    (FD6)981366, (FD6)981819,   //  9.58 - 9.59
    (FD6)982271, (FD6)982723,   //  9.60 - 9.61
    (FD6)983175, (FD6)983626,   //  9.62 - 9.63
    (FD6)984077, (FD6)984527,   //  9.64 - 9.65
    (FD6)984977, (FD6)985426,   //  9.66 - 9.67
    (FD6)985875, (FD6)986324,   //  9.68 - 9.69
    (FD6)986772, (FD6)987219,   //  9.70 - 9.71
    (FD6)987666, (FD6)988113,   //  9.72 - 9.73
    (FD6)988559, (FD6)989005,   //  9.74 - 9.75
    (FD6)989450, (FD6)989895,   //  9.76 - 9.77
    (FD6)990339, (FD6)990783,   //  9.78 - 9.79
    (FD6)991226, (FD6)991669,   //  9.80 - 9.81
    (FD6)992111, (FD6)992554,   //  9.82 - 9.83
    (FD6)992995, (FD6)993436,   //  9.84 - 9.85
    (FD6)993877, (FD6)994317,   //  9.86 - 9.87
    (FD6)994757, (FD6)995196,   //  9.88 - 9.89
    (FD6)995635, (FD6)996074,   //  9.90 - 9.91
    (FD6)996512, (FD6)996949,   //  9.92 - 9.93
    (FD6)997386, (FD6)997823,   //  9.94 - 9.95
    (FD6)998259, (FD6)998695,   //  9.96 - 9.97
    (FD6)999131, (FD6)999565,   //  9.98 - 9.99
    FD6_1                       // 10.00
    };


WORD    MantSearchTable[101] = {

       0,  //  0: 0.000000 - 0.012837,  EndIndex =   3 ( 4)
       2,  //  1: 0.008600 - 0.021189,  EndIndex =   5 ( 4)
       4,  //  2: 0.017033 - 0.033424,  EndIndex =   8 ( 5)
       7,  //  3: 0.029384 - 0.041393,  EndIndex =  10 ( 4)
       9,  //  4: 0.037426 - 0.053078,  EndIndex =  13 ( 5)
      12,  //  5: 0.049218 - 0.060698,  EndIndex =  15 ( 4)
      14,  //  6: 0.056905 - 0.071882,  EndIndex =  18 ( 5)
      17,  //  7: 0.068186 - 0.082785,  EndIndex =  21 ( 5)
      20,  //  8: 0.079181 - 0.093422,  EndIndex =  24 ( 5)
      23,  //  9: 0.089905 - 0.100371,  EndIndex =  26 ( 4)
      25,  // 10: 0.096910 - 0.110590,  EndIndex =  29 ( 5)
      28,  // 11: 0.107210 - 0.120574,  EndIndex =  32 ( 5)
      31,  // 12: 0.117271 - 0.130334,  EndIndex =  35 ( 5)
      34,  // 13: 0.127105 - 0.143015,  EndIndex =  39 ( 6)
      38,  // 14: 0.139879 - 0.152288,  EndIndex =  42 ( 5)
      41,  // 15: 0.149219 - 0.161368,  EndIndex =  45 ( 5)
      44,  // 16: 0.158362 - 0.170262,  EndIndex =  48 ( 5)
      47,  // 17: 0.167317 - 0.181844,  EndIndex =  52 ( 6)
      51,  // 18: 0.178977 - 0.190332,  EndIndex =  55 ( 5)
      54,  // 19: 0.187521 - 0.201397,  EndIndex =  59 ( 6)
      58,  // 20: 0.198657 - 0.212188,  EndIndex =  63 ( 6)
      62,  // 21: 0.209515 - 0.220108,  EndIndex =  66 ( 5)
      65,  // 22: 0.217484 - 0.230449,  EndIndex =  70 ( 6)
      69,  // 23: 0.227887 - 0.240549,  EndIndex =  74 ( 6)
      73,  // 24: 0.238046 - 0.250420,  EndIndex =  78 ( 6)
      77,  // 25: 0.247973 - 0.260071,  EndIndex =  82 ( 6)
      81,  // 26: 0.257679 - 0.271842,  EndIndex =  87 ( 7)
      86,  // 27: 0.269513 - 0.281033,  EndIndex =  91 ( 6)
      90,  // 28: 0.278754 - 0.290035,  EndIndex =  95 ( 6)
      94,  // 29: 0.287802 - 0.301030,  EndIndex = 100 ( 7)
      99,  // 30: 0.298853 - 0.311754,  EndIndex = 105 ( 7)
     104,  // 31: 0.309630 - 0.320146,  EndIndex = 109 ( 6)
     108,  // 32: 0.318063 - 0.330414,  EndIndex = 114 ( 7)
     113,  // 33: 0.328380 - 0.340444,  EndIndex = 119 ( 7)
     118,  // 34: 0.338456 - 0.350248,  EndIndex = 124 ( 7)
     123,  // 35: 0.348305 - 0.361728,  EndIndex = 130 ( 8)
     129,  // 36: 0.359835 - 0.371068,  EndIndex = 135 ( 7)
     134,  // 37: 0.369216 - 0.380211,  EndIndex = 140 ( 7)
     139,  // 38: 0.378398 - 0.390935,  EndIndex = 146 ( 8)
     145,  // 39: 0.389166 - 0.401401,  EndIndex = 152 ( 8)
     151,  // 40: 0.399674 - 0.411620,  EndIndex = 158 ( 8)
     157,  // 41: 0.409933 - 0.421604,  EndIndex = 164 ( 8)
     163,  // 42: 0.419956 - 0.431364,  EndIndex = 170 ( 8)
     169,  // 43: 0.429752 - 0.440909,  EndIndex = 176 ( 8)
     175,  // 44: 0.439333 - 0.450249,  EndIndex = 182 ( 8)
     181,  // 45: 0.448706 - 0.460898,  EndIndex = 189 ( 9)
     188,  // 46: 0.459392 - 0.471292,  EndIndex = 196 ( 9)
     195,  // 47: 0.469822 - 0.480007,  EndIndex = 202 ( 8)
     201,  // 48: 0.478566 - 0.491362,  EndIndex = 210 (10)
     209,  // 49: 0.489958 - 0.501059,  EndIndex = 217 ( 9)
     216,  // 50: 0.499687 - 0.510545,  EndIndex = 224 ( 9)
     223,  // 51: 0.509203 - 0.521138,  EndIndex = 232 (10)
     231,  // 52: 0.519828 - 0.530200,  EndIndex = 239 ( 9)
     238,  // 53: 0.528917 - 0.540329,  EndIndex = 247 (10)
     246,  // 54: 0.539076 - 0.550228,  EndIndex = 255 (10)
     254,  // 55: 0.549003 - 0.561101,  EndIndex = 264 (11)
     263,  // 56: 0.559907 - 0.570543,  EndIndex = 272 (10)
     271,  // 57: 0.569374 - 0.580925,  EndIndex = 281 (11)
     280,  // 58: 0.579784 - 0.591065,  EndIndex = 290 (11)
     289,  // 59: 0.589950 - 0.600973,  EndIndex = 299 (11)
     298,  // 60: 0.599883 - 0.610660,  EndIndex = 308 (11)
     307,  // 61: 0.609594 - 0.620136,  EndIndex = 317 (11)
     316,  // 62: 0.619093 - 0.630428,  EndIndex = 327 (12)
     326,  // 63: 0.629410 - 0.640481,  EndIndex = 337 (12)
     336,  // 64: 0.639486 - 0.650308,  EndIndex = 347 (12)
     346,  // 65: 0.649335 - 0.660865,  EndIndex = 358 (13)
     357,  // 66: 0.659916 - 0.670246,  EndIndex = 368 (12)
     367,  // 67: 0.669317 - 0.680336,  EndIndex = 379 (13)
     378,  // 68: 0.679428 - 0.690196,  EndIndex = 390 (13)
     389,  // 69: 0.689309 - 0.700704,  EndIndex = 402 (14)
     401,  // 70: 0.699838 - 0.710117,  EndIndex = 413 (13)
     412,  // 71: 0.709270 - 0.720159,  EndIndex = 425 (14)
     424,  // 72: 0.719331 - 0.730782,  EndIndex = 438 (15)
     437,  // 73: 0.729974 - 0.740363,  EndIndex = 450 (14)
     449,  // 74: 0.739572 - 0.750508,  EndIndex = 463 (15)
     462,  // 75: 0.749736 - 0.760422,  EndIndex = 476 (15)
     475,  // 76: 0.759668 - 0.770115,  EndIndex = 489 (15)
     488,  // 77: 0.769377 - 0.780317,  EndIndex = 503 (16)
     502,  // 78: 0.779596 - 0.790285,  EndIndex = 517 (16)
     516,  // 79: 0.789581 - 0.800029,  EndIndex = 531 (16)
     530,  // 80: 0.799341 - 0.810233,  EndIndex = 546 (17)
     545,  // 81: 0.809560 - 0.820201,  EndIndex = 561 (17)
     560,  // 82: 0.819544 - 0.830589,  EndIndex = 577 (18)
     576,  // 83: 0.829947 - 0.840106,  EndIndex = 592 (17)
     591,  // 84: 0.839478 - 0.850033,  EndIndex = 608 (18)
     607,  // 85: 0.849419 - 0.860338,  EndIndex = 625 (19)
     624,  // 86: 0.859739 - 0.870404,  EndIndex = 642 (19)
     641,  // 87: 0.869818 - 0.880242,  EndIndex = 659 (19)
     658,  // 88: 0.879669 - 0.890421,  EndIndex = 677 (20)
     676,  // 89: 0.889862 - 0.900367,  EndIndex = 695 (20)
     694,  // 90: 0.899821 - 0.910091,  EndIndex = 713 (20)
     712,  // 91: 0.909556 - 0.920123,  EndIndex = 732 (21)
     731,  // 92: 0.919601 - 0.930440,  EndIndex = 752 (22)
     751,  // 93: 0.929930 - 0.940018,  EndIndex = 771 (21)
     770,  // 94: 0.939519 - 0.950365,  EndIndex = 792 (23)
     791,  // 95: 0.949878 - 0.960471,  EndIndex = 813 (23)
     812,  // 96: 0.959995 - 0.970347,  EndIndex = 834 (23)
     833,  // 97: 0.969882 - 0.980003,  EndIndex = 855 (23)
     854,  // 98: 0.979548 - 0.990339,  EndIndex = 878 (25)
     877,  // 99: 0.989895 - 1.000000,  EndIndex = 900 (24)
     899   // Last MantissaTable[] Index Number - 1
    };

//
// Mantissa Correction Data Bits Usage:
//
//
//       <---High Word---> <----Low Word--->
//  Bit#  3          2          1          0
//       10987654 32109876 54321098 76543210
//       | | | |  | |  |   ||  |  |
//       | | | |  | |  |   ||  |  +-- x.000 Minimum Difference
//       | | | |  | |  |   ||  +----- x.001-x.002 (0-7) Correct 1
//       | | | |  | |  |   |+-------- x.000-x.001 (0-7) Correct 2
//       | | | |  | |  |   +--------- x.009-y.000 (0-1) Correct 10
//       | | | |  | |  +------------- x.009-y.000 (0-7) Correct 3
//       | | | |  | +---------------- x.008-x.009 (0-7) Correct 4
//       | | | |  +------------------ x.007-x.008 (0-3) Correct 5
//       | | | +--------------------- x.006-x.007 (0-3) Correct 6
//       | | +----------------------- x.005-x.006 (0-3) Correct 7
//       | +------------------------- x.004-x.005 (0-3) Correct 8
//       +--------------------------- x.003-x.004 (0-3) Correct 9
//

DWORD MantissaCorrectData[MANTISSATABLE_SIZE] = {

    0x269b49ae, 0x169a49aa, 0x159339a6, 0x9ba34ba1, 0x0692399e,  // 1.00-1.04
    0x165a399a, 0x559a4796, 0x1a93c792, 0x5adb398e, 0x4692398b,  // 1.05-1.09
    0x5a934787, 0x15923784, 0x59d33980, 0x5593297d, 0x1252277a,  // 1.10-1.14
    0x269bb776, 0x56933773, 0x55923770, 0x4653276d, 0x1592276a,  // 1.15-1.19
    0x158b2767, 0x46523764, 0x49922761, 0x1992b75e, 0x2692b75b,  // 1.20-1.24
    0x11522559, 0x45922556, 0x56922753, 0x054a2551, 0x158a354e,  // 1.25-1.29
    0x599a374b, 0x458a2749, 0x014a1547, 0x55522544, 0x05492542,  // 1.30-1.34
    0x1652b53f, 0x058aa53d, 0x044a233b, 0x00491539, 0x55522536,  // 1.35-1.39
    0x154a2534, 0x05492532, 0x01492530, 0x5992272d, 0x1992a72b,  // 1.40-1.44
    0x198ab529, 0x55922527, 0x00411526, 0x56522523, 0x56522721,  // 1.45-1.49
    0x01091520, 0x0449231e, 0x0149231c, 0x4549251a, 0x154a9518,  // 1.50-1.54
    0x4651a516, 0x01091315, 0x04492313, 0x454a1511, 0x158aa50f,  // 1.55-1.59
    0x0141230e, 0x1451150c, 0x464aa50a, 0x04491309, 0x454a1507,  // 1.60-1.64
    0x1952a505, 0x05491504, 0x558a2502, 0x41491501, 0x158a94ff,  // 1.65-1.69
    0x050922fe, 0x555124fc, 0x114914fb, 0x564a24f9, 0x454914f8,  // 1.70-1.74
    0x010912f7, 0x455122f5, 0x110914f4, 0x1951a4f2, 0x154994f1,  // 1.75-1.79
    0x410912f0, 0x558a22ee, 0x454a14ed, 0x114912ec, 0x010812eb,  // 1.80-1.84
    0x1551a2e9, 0x1149a2e8, 0x110912e7, 0x010812e6, 0x000102e5,  // 1.85-1.89
    0x454922e3, 0x114914e2, 0x044912e1, 0x044112e0, 0x004102df,  // 1.90-1.94
    0x1551a2dd, 0x518914dc, 0x454914db, 0x444922da, 0x414912d9,  // 1.95-1.99
    0x110912d8, 0x014112d7, 0x040912d6, 0x010812d5, 0x010812d4,  // 2.00-2.04
    0x004102d3, 0x2551a4d1, 0x2551a4d0, 0x000812d0, 0x000812cf,  // 2.05-2.09
    0x595124cd, 0x010812cd, 0x100902cc, 0x044110cb, 0x010902ca,  // 2.10-2.14
    0x410912c9, 0x444112c8, 0x110912c7, 0x450914c6, 0x1449a2c5,  // 2.15-2.19
    0x515112c4, 0x155194c3, 0x000802c3, 0x004102c2, 0x010892c1,  // 2.20-2.24
    0x044910c0, 0x054194bf, 0x154992be, 0x554922bd, 0x004012bd,  // 2.25-2.29
    0x044102bc, 0x414112bb, 0x114992ba, 0x1549a2b9, 0x000810b9,  // 2.30-2.34
    0x044102b8, 0x114112b7, 0x144994b6, 0x000010b6, 0x004102b5,  // 2.35-2.39
    0x414112b4, 0x454912b3, 0x555114b2, 0x040812b2, 0x444812b1,  // 2.40-2.44
    0x550a12b0, 0x000802b0, 0x410902af, 0x450912ae, 0x458994ad,  // 2.45-2.49
    0x104102ad, 0x114892ac, 0x000000ac, 0x100810ab, 0x444812aa,  // 2.50-2.54
    0x1549a2a9, 0x010102a9, 0x110992a8, 0x515192a7, 0x010110a7,  // 2.55-2.59
    0x144992a6, 0x155192a5, 0x410812a5, 0x144992a4, 0x004010a4,  // 2.60-2.64
    0x044892a3, 0x554912a2, 0x104102a2, 0x450912a1, 0x000802a1,  // 2.65-2.69
    0x110902a0, 0x4549949f, 0x4041029f, 0x4509929e, 0x0101009e,  // 2.70-2.74
    0x4449029d, 0x0000109d, 0x4441029c, 0x5549129b, 0x1041029b,  // 2.75-2.79
    0x5149129a, 0x0101029a, 0x45091299, 0x00010299, 0x11099298,  // 2.80-2.84
    0x00001098, 0x44481297, 0x554a1296, 0x44411296, 0x51519295,  // 2.85-2.89
    0x41090295, 0x51519294, 0x04418294, 0x55491293, 0x41081293,  // 2.90-2.94
    0x00000093, 0x04411092, 0x55491491, 0x11081291, 0x1549a290,  // 2.95-2.99
    0x11081290, 0x00000290, 0x1109828f, 0x0008008f, 0x1109908e,  // 3.00-3.04
    0x0000108e, 0x4509128d, 0x1001028d, 0x4541128c, 0x4041028c,  // 3.05-3.09
    0x5449128b, 0x0408928b, 0x5549128a, 0x0448928a, 0x0008008a,  // 3.10-3.14
    0x45091089, 0x00401089, 0x54491288, 0x41010288, 0x45499287,  // 3.15-3.19
    0x41090287, 0x00001087, 0x14489286, 0x01010086, 0x51491285,  // 3.20-3.24
    0x04089285, 0x00000085, 0x11098284, 0x01001084, 0x15099283,  // 3.25-3.29
    0x11010283, 0x51519282, 0x44481282, 0x00080282, 0x45499281,  // 3.30-3.34
    0x10411081, 0x00000281, 0x14489280, 0x40401080, 0x4549927f,  // 3.35-3.39
    0x1109027f, 0x0008027f, 0x1449927e, 0x0441027e, 0x0000027e,  // 3.40-3.44
    0x5141127d, 0x0108027d, 0x1549947c, 0x4448127c, 0x0401027c,  // 3.45-3.49
    0x1549927b, 0x1108927b, 0x1001007b, 0x5509127a, 0x1108127a,  // 3.50-3.54
    0x0040027a, 0x54491279, 0x41090279, 0x00001079, 0x51499278,  // 3.55-3.59
    0x11081078, 0x04001078, 0x45498277, 0x11081077, 0x00400277,  // 3.60-3.64
    0x15099276, 0x44410276, 0x01001076, 0x55091275, 0x11089275,  // 3.65-3.69
    0x04010075, 0x45499274, 0x11098274, 0x00409074, 0x15499273,  // 3.70-3.74
    0x11419273, 0x04081073, 0x00000273, 0x51481272, 0x04418272,  // 3.75-3.79
    0x00080072, 0x54491271, 0x11089271, 0x01001071, 0x00000071,  // 3.80-3.84
    0x45090270, 0x41010270, 0x00080070, 0x4548926f, 0x1108906f,  // 3.85-3.89
    0x1001006f, 0x4549926e, 0x4448926e, 0x1040106e, 0x0000106e,  // 3.90-3.94
    0x5509126d, 0x1109826d, 0x0401006d, 0x0000006d, 0x1448926c,  // 3.95-3.99
    0x1041026c, 0x0040026c, 0x4549926b, 0x4448126b, 0x1041026b,  // 4.00-4.04
    0x0001006b, 0x5449126a, 0x4448126a, 0x0408026a, 0x0000106a,  // 4.05-4.09
    0x45419269, 0x44411069, 0x10080269, 0x45899268, 0x14499268,  // 4.10-4.14
    0x41410268, 0x04080268, 0x00000068, 0x15099267, 0x44410267,  // 4.15-4.19
    0x04080267, 0x55511266, 0x54491266, 0x11089266, 0x10401066,  // 4.20-4.24
    0x00400066, 0x45498265, 0x11098265, 0x10401065, 0x00000265,  // 4.25-4.29
    0x15499264, 0x14489264, 0x41081064, 0x10010064, 0x15499263,  // 4.30-4.34
    0x45411263, 0x11081263, 0x04080263, 0x00080063, 0x51499062,  // 4.35-4.39
    0x14419062, 0x10401062, 0x04000262, 0x51499261, 0x14489261,  // 4.40-4.44
    0x04418261, 0x01009061, 0x00000061, 0x55091260, 0x44489260,  // 4.45-4.49
    0x04418060, 0x00080060, 0x5149945f, 0x4509925f, 0x4441025f,  // 4.50-4.54
    0x4101025f, 0x0008005f, 0x5549125e, 0x4509925e, 0x0448905e,  // 4.55-4.59
    0x4040105e, 0x0008005e, 0x5149925d, 0x1448925d, 0x4441025d,  // 4.60-4.64
    0x4040105d, 0x0008005d, 0x5149925c, 0x1449825c, 0x0441905c,  // 4.65-4.69
    0x4040105c, 0x0008005c, 0x4549925b, 0x5141125b, 0x1108925b,  // 4.70-4.74
    0x4041005b, 0x0001005b, 0x0000005b, 0x5148925a, 0x4448105a,  // 4.75-4.79
    0x4101025a, 0x0400105a, 0x0000005a, 0x55091259, 0x14489259,  // 4.80-4.84
    0x11081059, 0x10080259, 0x00080059, 0x54499258, 0x14498258,  // 4.85-4.89
    0x11410258, 0x10410258, 0x04001058, 0x00000058, 0x15419257,  // 4.90-4.94
    0x14489257, 0x11081057, 0x04080257, 0x40000257, 0x55099256,  // 4.95-4.99
    0x45419256, 0x11419056, 0x44081056, 0x01009056, 0x00000056,  // 5.00-5.04
    0x00000056, 0x15099055, 0x11418255, 0x04089055, 0x04010055,  // 5.05-5.09
    0x00010055, 0x51499254, 0x51481254, 0x45081254, 0x11010254,  // 5.10-5.14
    0x40400254, 0x10000054, 0x55489253, 0x51490253, 0x44481253,  // 5.15-5.19
    0x04418253, 0x01018053, 0x04000053, 0x45499252, 0x55091252,  // 5.20-5.24
    0x14489252, 0x11089052, 0x41010052, 0x40010052, 0x00000052,  // 5.25-5.29
    0x55099251, 0x45099051, 0x44481051, 0x11010251, 0x40400251,  // 5.30-5.34
    0x01000051, 0x15499250, 0x55091250, 0x14489250, 0x11089050,  // 5.35-5.39
    0x10401050, 0x01000250, 0x00001050, 0x5449924f, 0x5148924f,  // 5.40-5.44
    0x1448904f, 0x1108104f, 0x0408824f, 0x0040004f, 0x0000104f,  // 5.45-5.49
    0x5541924e, 0x1449904e, 0x5109024e, 0x0441824e, 0x4040104e,  // 5.50-5.54
    0x1001004e, 0x0000004e, 0x1549924d, 0x4541924d, 0x1141904d,  // 5.55-5.59
    0x0441824d, 0x1040104d, 0x0040024d, 0x0000024d, 0x5549124c,  // 5.60-5.64
    0x5449124c, 0x1141924c, 0x4441024c, 0x1101024c, 0x4040024c,  // 5.65-5.69
    0x0008004c, 0x0000004c, 0x5509924b, 0x1509904b, 0x1141824b,  // 5.70-5.74
    0x1108104b, 0x4101024b, 0x1001004b, 0x1000004b, 0x5541924a,  // 5.75-5.79
    0x1541924a, 0x1448924a, 0x1441824a, 0x0440904a, 0x4040104a,  // 5.80-5.84
    0x0001804a, 0x0000004a, 0x15499249, 0x55091249, 0x14489249,  // 5.85-5.89
    0x44410249, 0x04418249, 0x01018049, 0x00080049, 0x00000249,  // 5.90-5.94
    0x45499248, 0x55091248, 0x51411248, 0x11098248, 0x41081048,  // 5.95-5.99
    0x04080248, 0x00400248, 0x00000248, 0x00000048, 0x55411247,  // 6.00-6.04
    0x45419247, 0x14419047, 0x11089047, 0x10410047, 0x40400247,  // 6.05-6.09
    0x00080047, 0x00000047, 0x55491246, 0x54491246, 0x11419246,  // 6.10-6.14
    0x11418246, 0x41081046, 0x04080246, 0x00408246, 0x10000046,  // 6.15-6.19
    0x00000046, 0x55490245, 0x15099245, 0x45098245, 0x45081045,  // 6.20-6.24
    0x11081045, 0x04088245, 0x00088045, 0x10000045, 0x00000045,  // 6.25-6.29
    0x55491044, 0x15099244, 0x44498244, 0x44481044, 0x10418244,  // 6.30-6.34
    0x10410044, 0x01001044, 0x10000244, 0x00000044, 0x54499243,  // 6.35-6.39
    0x15419243, 0x14489243, 0x11098243, 0x04418243, 0x04089043,  // 6.40-6.44
    0x01018043, 0x00400043, 0x00001043, 0x00000043, 0x55481242,  // 6.45-6.49
    0x15099242, 0x45098242, 0x44481042, 0x10418242, 0x10401042,  // 6.50-6.54
    0x40400242, 0x00080042, 0x00001042, 0x55491241, 0x51499241,  // 6.55-6.59
    0x51481241, 0x14419241, 0x44418241, 0x44401041, 0x04089041,  // 6.60-6.64
    0x04010041, 0x10001041, 0x00000041, 0x00000041, 0x54499240,  // 6.65-6.69
    0x51498240, 0x51411040, 0x51081240, 0x04418240, 0x04089040,  // 6.70-6.74
    0x01018040, 0x40080040, 0x10000040, 0x00000040, 0x5509923f,  // 6.75-6.79
    0x1548923f, 0x5148123f, 0x1448923f, 0x4448103f, 0x1101823f,  // 6.80-6.84
    0x4101003f, 0x4040103f, 0x0008003f, 0x0000023f, 0x0000003f,  // 6.85-6.89
    0x5149923e, 0x1541923e, 0x5448123e, 0x4508123e, 0x1108923e,  // 6.90-6.94
    0x4108103e, 0x0408823e, 0x0401003e, 0x0100023e, 0x0001003e,  // 6.95-6.99
    0x0000003e, 0x5149923d, 0x5509123d, 0x4541923d, 0x5141103d,  // 7.00-7.04
    0x1141823d, 0x1108103d, 0x1101023d, 0x1008023d, 0x0100103d,  // 7.05-7.09
    0x4000023d, 0x0000003d, 0x0000003d, 0x1549903c, 0x1541923c,  // 7.10-7.14
    0x1448923c, 0x5109023c, 0x4441023c, 0x0441823c, 0x0440103c,  // 7.15-7.19
    0x0408023c, 0x0100103c, 0x0001003c, 0x0008003c, 0x5548923b,  // 7.20-7.24
    0x5509923b, 0x5449103b, 0x5141123b, 0x4448923b, 0x1108903b,  // 7.25-7.29
    0x1108103b, 0x4101023b, 0x4040103b, 0x0401003b, 0x0001003b,  // 7.30-7.34
    0x0001003b, 0x5549123a, 0x5549123a, 0x5509123a, 0x4541923a,  // 7.35-7.39
    0x5141103a, 0x1109823a, 0x1108903a, 0x4408103a, 0x1040103a,  // 7.40-7.44
    0x4040023a, 0x0008803a, 0x4000003a, 0x0000003a, 0x45499239,  // 7.45-7.49
    0x51499239, 0x45489239, 0x14498239, 0x45090239, 0x11089239,  // 7.50-7.54
    0x11089039, 0x44081039, 0x10401039, 0x40401039, 0x00088039,  // 7.55-7.59
    0x10000039, 0x00000039, 0x00000039, 0x55491038, 0x55091238,  // 7.60-7.64
    0x45419238, 0x51411038, 0x45081238, 0x44410238, 0x10418238,  // 7.65-7.69
    0x10401038, 0x04080238, 0x01000238, 0x04000238, 0x04000038,  // 7.70-7.74
    0x00000038, 0x55099237, 0x55099237, 0x54491037, 0x45419237,  // 7.75-7.79
    0x11419037, 0x11418237, 0x11089037, 0x44081037, 0x04089037,  // 7.80-7.84
    0x04018037, 0x40080037, 0x00400037, 0x00010037, 0x00000037,  // 7.85-7.89
    0x55491236, 0x45499236, 0x15419236, 0x51489236, 0x11419036,  // 7.90-7.94
    0x51090236, 0x44410236, 0x04418236, 0x04089036, 0x41010036,  // 7.95-7.99
    0x01009036, 0x00400036, 0x00008236, 0x00000036, 0x00000036,  // 8.00-8.04
    0x54499235, 0x55099235, 0x54491035, 0x51419235, 0x14419035,  // 8.05-8.09
    0x11418235, 0x44481035, 0x11088235, 0x10410035, 0x04088235,  // 8.10-8.14
    0x10080035, 0x04001035, 0x00080035, 0x00010035, 0x00000035,  // 8.15-8.19
    0x51499234, 0x54499234, 0x51498234, 0x54490234, 0x14489234,  // 8.20-8.24
    0x11418234, 0x44418234, 0x44081034, 0x10418234, 0x41010034,  // 8.25-8.29
    0x40401034, 0x04001034, 0x04000234, 0x00400034, 0x00000034,  // 8.30-8.34
    0x00000034, 0x55491233, 0x45499233, 0x45489233, 0x54490233,  // 8.35-8.39
    0x14489233, 0x51090233, 0x14418233, 0x11081033, 0x10418233,  // 8.40-8.44
    0x10410033, 0x04080233, 0x40400233, 0x40080033, 0x01000033,  // 8.45-8.49
    0x40000033, 0x00000033, 0x55489232, 0x54499232, 0x15489232,  // 8.50-8.54
    0x45489232, 0x45099032, 0x51411032, 0x51081232, 0x44410232,  // 8.55-8.59
    0x44410232, 0x41080232, 0x04088232, 0x01018032, 0x10010032,  // 8.60-8.64
    0x10001032, 0x00400032, 0x01000032, 0x00000032, 0x51499231,  // 8.65-8.69
    0x45499231, 0x55091231, 0x15099231, 0x51481231, 0x14489231,  // 8.70-8.74
    0x51090231, 0x14418231, 0x11089031, 0x04418031, 0x04409031,  // 8.75-8.79
    0x41010031, 0x01018031, 0x40400031, 0x00400031, 0x00001031,  // 8.80-8.84
    0x00080031, 0x00000031, 0x55489230, 0x55099230, 0x45498230,  // 8.85-8.89
    0x51489230, 0x45099030, 0x45090230, 0x44489230, 0x51081030,  // 8.90-8.94
    0x44410230, 0x11081030, 0x11010230, 0x04088230, 0x04018030,  // 8.95-8.99
    0x40400030, 0x00088030, 0x10000030, 0x00000030, 0x00001030,  // 9.00-9.04
    0x5541922f, 0x1549922f, 0x5449922f, 0x4549822f, 0x5449022f,  // 9.05-9.09
    0x5141122f, 0x1448922f, 0x1441902f, 0x4448102f, 0x4441022f,  // 9.10-9.14
    0x1108022f, 0x1101022f, 0x0408822f, 0x0401802f, 0x4040002f,  // 9.15-9.19
    0x0008802f, 0x0400002f, 0x0400002f, 0x0000002f, 0x0000002f,  // 9.20-9.24
    0x5541922e, 0x5509922e, 0x4549822e, 0x5148922e, 0x1509902e,  // 9.25-9.29
    0x4509822e, 0x1441902e, 0x1441822e, 0x1108902e, 0x1108902e,  // 9.30-9.34
    0x0441802e, 0x0440902e, 0x4101002e, 0x0101802e, 0x4008002e,  // 9.35-9.39
    0x0008802e, 0x0400002e, 0x0400002e, 0x0000002e, 0x0000002e,  // 9.40-9.44
    0x5449922d, 0x5149922d, 0x5541122d, 0x1509922d, 0x5148922d,  // 9.45-9.49
    0x5141902d, 0x1448902d, 0x1141822d, 0x4441102d, 0x4441022d,  // 9.50-9.54
    0x0441822d, 0x4408102d, 0x1040902d, 0x0408802d, 0x1008002d,  // 9.55-9.59
    0x0100102d, 0x0400022d, 0x0008002d, 0x0001002d, 0x0000002d,  // 9.60-9.64
    0x0000002d, 0x5549122c, 0x1549922c, 0x5449922c, 0x5149822c,  // 9.65-9.69
    0x5449022c, 0x5148122c, 0x1448922c, 0x1141902c, 0x1441822c,  // 9.70-9.74
    0x1108902c, 0x1108902c, 0x0441802c, 0x0440902c, 0x4101002c,  // 9.75-9.79
    0x4040102c, 0x0100102c, 0x0040822c, 0x0100002c, 0x0008002c,  // 9.80-9.84
    0x0008002c, 0x0000002c, 0x0000002c, 0x4549922b, 0x4549922b,  // 9.85-9.89
    0x5509922b, 0x5149902b, 0x5449102b, 0x5148122b, 0x1448922b,  // 9.90-9.94
    0x4509022b, 0x5108122b, 0x4441822b, 0x1108102b, 0x4441022b,  // 9.95-9.99
    0x00000000 };


DWORD   Power10ExpNum[] = {

                    1L,
                   10L,
                  100L,
                 1000L,
                10000L,
               100000L,
              1000000L,
             10000000L,
            100000000L,
           1000000000L
        };





FD6
HTENTRY
Log(
    FD6 Number
    )

/*++

Routine Description:

    This functions calculate the common logarithm for the number passed in,
    this is 10 based logarithm.

Arguments:

    Number - the decimal (FD6) number, this is a special format decimal number
             (FD6) it depends on the #define and may be floating number or
             six (6) lower digits as number to the right of the decimal
             points. that is 3 = 0.000003, 10000 = 0.010000, 1232321 = 1.232321
             and so on.

Return Value:

    Now no error value is returned, but it will clip to the FD6 defined limit
    as following:

    FD6_LOG_MAX - if the Number passed in is >= FD6_MAX (ie. 2147.483647)
                  then it returned FD6_LOG_MAX (ie. 3.331930).

    FD6_LOG_MIN - if the Number passed in is less or equal to 0 then it treated
                  passed Number as 0.000001 so the return value will be
                  FD6_LOG_MIN (ie. -6.0)

    othewise    - the approximate logarithm (based 10) number is returnd as
                  a FD6 number.  The accuracy of the returned logarithm number
                  as minimum/maximum errors as

                    maximum error = +0.000005983
                    minimum error = -0.0000009018

Author:

    16-Jan-1991 Wed 14:03:58 created  -by-  Daniel Chou (danielc)

Revision History:

    26-Sep-1991 Thu 12:10:52 updated  -by-  Daniel Chou (danielc)

        Rewrite for more accuracy up to six significant decimal digitis, and
        also make it durable to run under floating point package.


--*/

{
    FD6     Characteristic;                     // characteristics number
    FD6     Mantissa;
    LONG    Rem;
    INT     Quot;


    //
    // Do in-line binary search to find out how many digits of this
    // number (decimal left shift count), at here the range is from
    // 0.000001 to 999.999999, the goal is to make the number range in
    // 100.000000 to 999.999999 and also get its characteristic number.
    //
    //  100.000000  = 0
    //   10.000000  = 1
    //    1.000000  = 2
    //    0.100000  = 3
    //    0.010000  = 4
    //    0.001000  = 5
    //    0.000100  = 6
    //    0.000010  = 7
    //    0.000001  = 8
    //
    // first, find out what the characteristic is
    //

    if (Number >= FD6_p01) {                            // possible 0,1,2,3,4

        if (Number >= FD6_1) {                          // possible 0,1,2

            if (Number >= FD6_10) {                     // possible 0,1

                if (Number >= FD6_100) {                // possible 0

                    if (Number >= FD6_1000) {

                        if (Number >= (FD6_MAX - FD6_p000005)) {

                            return(FD6_LOG_MAX);
                        }

                        Characteristic = FD6_3;
                        Number = FD6DivL(Number, 10);

                    } else {

                        // 100.000000 - 999.000000

                        Characteristic = FD6_2;         // alreay in range
                    }

                } else {                                // possible 1

                    // 10.000000 - 99.999999

                    Characteristic = FD6_1;
                    Number = FD6xL(Number, 10);
                }

            } else {                                    // possible 2

                // 1.000000 - 9.999999

                Characteristic = FD6_0;
                Number = FD6xL(Number, 100);
            }

        } else if (Number >= FD6_p1) {                  // possible 3

            // 0.100000 - 0.999999

            Characteristic = -FD6_1;
            Number = FD6xL(Number, 1000);

        } else {                                        // possible 4

            // 0.010000 - 0.099999

            Characteristic = -FD6_2;
            Number = FD6xL(Number, 10000);
        }

    } else if (Number >= FD6_p0001) {                   // possible 5,6

        if (Number >= FD6_p001) {                       // possible 5

            // 0.001000 - 0.009999

            Characteristic = -FD6_3;
            Number = FD6xL(Number, 100000);

        } else {                                        // possible 6

            // 0.000100 - 0.000999

            Characteristic = -FD6_4;
            Number = FD6xL(Number, 1000000);
        }

    } else if (Number >= FD6_p00001) {                  // possible 7

        // 0.000010 - 0.000099

        Characteristic = -FD6_5;
        Number = FD6xL(Number, 10000000);

    } else if (Number > FD6_0) {                        // possible 8

        // 0.000001 - 0.000009

        Characteristic = -FD6_6;
        Number = FD6xL(Number, 100000000);

    } else {

        return(FD6_LOG_MIN);                            // invalid numbers
    }

    //
    // The number now range from 100.0000 to 999.999999
    //
    //
    //  ASSERT((Number >= FD6_100) && (Number < FD6_1000));
    //

    //
    // The Number now range from 100.000000 - 999.999999 and we need to
    // find the mantissa for it.  The number will be index
    // and/or interpolate from the table as following:
    //
    // Number  123.1234567
    //         |   |
    //         |   +----> 0.1234567 (if non zero) then interpolate with
    //         |          next table entry.
    //         |
    //         +-------> (123 - 100) will be index into the table
    //
    // For example:
    //
    //  Log (1.234567)     = 0.091515
    //
    //      Characteristic = 0.000000
    //            Mantissa = Table[123-100] = 0.089905
    //            Fraction = (Table[124-100] - 0.089905) * 0.456700
    //                     = 0.003517 * 0.4567 = 0.001606
    //              Return = (Characteristic + Mantissa + Fraction) =
    //                     = 0.000000 + 0.089905 + 0.001606 = 0.091511
    //               Error = 0.091515 - 0.091511 = 0.000004
    //
    //      Max/Min Errors are +0.000006/-0.000001
    //

    Mantissa = MantissaTable[Quot = (INT)(Number / FD6_1) - (INT)100];

    if (Rem = (LONG)(Number % FD6_1)) {

        Mantissa += FractionToMantissa((FD6)Rem,
                                       MantissaCorrectData[Quot]);
    }

    return(Characteristic + Mantissa);

}



FD6
HTENTRY
AntiLog(
    FD6 Number
    )

/*++

Routine Description:

    Calculate the antilogarithm for the logarithm number passed in, that is
    this function return the exponent of Number which base 10.

Arguments:

    Number - the logarithm number, this is a special format decimal number
             (FD6) it depends on the #define and may be floating number or
             six (6) lower digits as number to the right of the decimal
             points. that is 3 = 0.000003, 10000 = 0.010000, 1232321 = 1.232321
             and so on.

Return Value:

    Now no error returned, but it clipped the result to the FD6 limit, return
    values as following:

    0.000001    - if the Number is <= -6.0

    FD6_MAX     - if the Number is >= 3.331930 then it return FD6_MAX
                  (ie. 2147.483647).

    othewise    - approximate the antilogarithm (base 10) of the Number passed
                  in. the accuracy of the function is abount +0.000008 to
                  -0.000001.

Author:

    16-Jan-1991 Wed 15:34:17 created  -by-  Daniel Chou (danielc)

Revision History:

    26-Sep-1991 Thu 12:01:06 updated  -by-  Daniel Chou (danielc)

        Rewrite for more accuracy up to six significant decimal digitis, and
        also make it durable to run under floating point package.


--*/

{
    INT     Characteristic;
    INT     Index;
    INT     IndexH;
    INT     IndexL;
    FD6     CurrentMantissa;


    //
    // The number range is from -5.999999 - 3.331928
    // Separate the Number into Characteristic and Mantissa,
    //

    Characteristic = 0;                         // assume it is 0

    if (Number < FD6_0) {

        if (Number <= FD6_LOG_MIN) {

            return(FD6_p000001);
        }

        do {

            --Characteristic;

        } while ((Number += FD6_1) < FD6_0);

    } else if (Number >= FD6_1) {

        if (Number >= FD6_LOG_MAX) {

            return(FD6_MAX);
        }

        do {

            ++Characteristic;

        } while ((Number -= FD6_1) >= FD6_1);
    }

    if (Number) {

        //
        // Do a modified binary search to find the closed low index, the
        // SearchTable[] is a estimate index for the first 2 mantissa digits.
        //

        Index  = (INT)(Number / FD6_p01);           // divide by 0.01 for index
        IndexL = (INT)MantSearchTable[Index++];     // starting estimate index
        IndexH = (INT)(MantSearchTable[Index] + 1); // ending estimate index

        while ((Index = (IndexL + IndexH) >> 1) != IndexL) {

            if (Number < (CurrentMantissa = MantissaTable[Index])) {

                IndexH = Index;

            } else if (Number > CurrentMantissa) {

                IndexL = Index;

            } else {

                Number = FD6_0;
                break;
            }
        }

        if (Number) {                   // Number = 0, if exactly match

            ASSERT((IndexL == Index) && ((IndexL + 1) == IndexH));

            //
            // Here we try to estimate for lower 4 decimal digit Mantissa
            // the table index is the index Mantissa of 0 - 900 (0.00 - 9.00)
            // the interpolate Mantissa is betwen two table indics Mantissas
            // such between 512 and 513 will be Mantissa between 5.12 and 5.13
            //

            Number = MantissaToFraction(Number - MantissaTable[IndexL],
                                        MantissaCorrectData[IndexL]);
        }

        //
        // The Index range is from 0-900
        //
        // Add in 100 to offset the mantissa table, since the first entry
        // is 1.0000
        //

        Number += INTToFD6(Index + 100);
        Characteristic -= 2;

    } else {                        // Number = 0.0, the result is 1.0

        Number = FD6_1;
    }

    //
    // Now we need to shift the decimal point around, if characteristic is
    // positive then we shift the decimal to the right (multiply), if the
    // Mantissa is negative then we shift the decimal point to the left
    // (divide), if it is a zero, then this is the final logarithm Mantissa.
    //

    if (Characteristic < 0) {

        return(FD6DivL(Number, (LONG)Power10ExpNum[-Characteristic]));

    } else if (Characteristic > 0) {

        return(FD6xL(Number, (LONG)Power10ExpNum[Characteristic]));

    } else {

        return(Number);
    }
}





FD6
HTENTRY
RaisePower(
    FD6     BaseNumber,
    FD6     Exponent,
    WORD    Flags
    )

/*++

Routine Description:

    Calculate the power of the base number (BaseNumber^Power).


Arguments:

    BaseNumber  -   The decimal (FD6) number, this is a special format decimal
                    number FD6) it depends on the #define and may be floating
                    number or six (6) lower digits as number to the right of
                    the decimal points. that is 3 = 0.000003, 10000 = 0.010000,
                    1232321 = 1.232321 and so on.

    Exponent    -   The exponent number is nth number to raise power to, it
                    has same format as BaseNumber.

    Flags       -   One or more of the following flags may be specified

                    RPF_RADICAL

                        1: This is a radical expression, the Exponent is
                              equal to 1.0/Exponent that is,

                        0: This is a regular power expression.


                    RPF_INTEXP

                        1: The Exponent field is treated as long integer number
                           rather a FD6 number.

                        0: The Exponent field is a FD6 number


        Note:   When BaseNumber is a negative number.

                1) Expoonent has fraction = .0 (ie. Integer only)

                    The whole BaseNumber is treated as an whole number.

                              2.0                    3.0
                        (-0.6)    = 0.36   and (-0.6)    = -0.216

                2) Exponent has fraction portion.

                    The negative sign is treated as a symbol.

                            2.1        2.1
                        -0.6    = -(0.6   ) = -0.342072


                The ONLY exception is that if Exponent = 0.0, then it returned

                    1.0 - if BaseNumber != 0.0
                    0.0 - if BaseNumber == 0.0 <-- Error Condition


Return Value:

    Now no error value is returned, but it will clip to the FD6 defined limit
    if condition occured as following and in this sequence:


    1)  0.0     - If BaseNumber = 0.0,

                    No error returned if Exponent <= 0.0, this number should
                    is not a real number.

    2)  1.0     - If Exponent = 0.0.

    othewise    - the approximate number for the nth power is returnd as
                  a FD6 number.  The accuracy of the returned logarithm number
                  as minimum/maximum errors as

                    maximum error = +0.000005983
                    minimum error = -0.0000009018

Author:

    16-Jan-1991 Wed 14:03:58 created  -by-  Daniel Chou (danielc)

Revision History:

    26-Sep-1991 Thu 12:10:52 updated  -by-  Daniel Chou (danielc)

        Delete OneOverExponent (BOOL) parameter

        Rewrite for more accuracy up to six significant decimal digitis, and
        also make it durable to run under floating point package.


--*/

{
    BOOL    NegativeBase;
    FD6     PowerNumber;


    //
    // check if any illegal condition exists, and preprocess any necessary
    // data
    //

    if (Flags & RPF_INTEXP) {

        if (Exponent == 1L) {

            return(BaseNumber);
        }

    } else {

        if (Exponent == FD6_1) {

            return(BaseNumber);
        }

        if (!(Exponent % FD6_1)) {

            Exponent /= FD6_1;
            Flags |= RPF_INTEXP;
        }
    }

    if (NegativeBase = (BOOL)(BaseNumber <= FD6_0)) {

        if (!(BaseNumber = -BaseNumber)) {      // 0^-num, 0^0 are illegal!!
                                                // but return as 0.0 now
            return(FD6_0);
        }
    }

    if (!Exponent) {

        return((NegativeBase) ? -FD6_1 : FD6_1);
    }

    //
    //                  y
    // Calculating the x = N with logarithms by solving following formula:
    //
    //      Log(N) = y * Log(x)
    //      ...
    //
    //      N = AntiLog(y * Log(x))
    //
    //  For example:
    //
    //       y           -1.654321
    //      x  = 0.123456           using the above formula we have
    //      -----------------------
    //
    //      Log(N) = y * Log(x)
    //      N      = AntiLog(y * Log(x))
    //
    //  ==> N = AntiLog(-1.654321 * Log(0.123456))
    //  ==> N = AntiLog(-1.654321 * -0.908488)
    //  ==> N = AntiLog(1.502931)
    //  ==> N = 31.836917                       <=== apporoximate FD6 number
    //
    //
    // If base number is 10.0 then do nothing with the logarithm, since
    // Log(10.0) = 1.0
    //

    BaseNumber = (BaseNumber == FD6_10) ? FD6_1 : Log(BaseNumber);

    if (Flags & RPF_INTEXP) {

        //
        // For EVEN interger exponent, the result always positive
        //

        if (!((DWORD)Exponent & 0x01)) {

            NegativeBase = FALSE;
        }

        PowerNumber = AntiLog((Flags & RPF_RADICAL) ?
                                            FD6DivL(BaseNumber, Exponent) :
                                            FD6xL(BaseNumber, Exponent));

    } else {

        PowerNumber = AntiLog((Flags & RPF_RADICAL) ?
                                            DivFD6(BaseNumber, Exponent) :
                                            MulFD6(BaseNumber, Exponent));
    }

    return((NegativeBase) ? -PowerNumber : PowerNumber);
}




BOOL
HTENTRY
ComputeInverseMatrix3x3(
    PMATRIX3x3  pInMatrix,
    PMATRIX3x3  pOutMatrix
    )

/*++

Routine Description:
                                           -1
    This function calculate inverse (Matrix  ) of the input 3x3 matrix

Arguments:

    pInMatrix       - 3 x 3 matrix to be inversed

    pOutMatrix      - Inverse 3 x 3 matrix of the input 3 x 3 matrix.

Return Value:

    The returned value will be TRUE if sucessfully invert the input matrix and
    returned value will be FALSE if there is singular in the input matrix.

    If the returned value is FALSE then the output matrix is not completed.

Author:

    11-Oct-1991 Fri 14:19:59 created    -by-  Daniel Chou (danielc)


Revision History:



--*/

{
    MATRIX3x3   InMatrix;
    MATRIX3x3   OutMatrix;
    FD6         Temp;
    BOOL        NoSigular = TRUE;
    INT         i;
    INT         j;
    INT         k;


    InMatrix = *pInMatrix;                      // do a local copy

    //
    // Clear all to zero and set diagnal to 1.0
    //

    ZeroMemory(&OutMatrix.m[0][0], sizeof(MATRIX3x3));
    OutMatrix.m[0][0] = OutMatrix.m[1][1] = OutMatrix.m[2][2] = FD6_1;

    //
    // Using gaussian elimination.
    //

    for (i = 0; i < 3; i++) {

        for (j = i + 1, k = i; j < 3; j++) {

            if (ABSFD6(InMatrix.m[j][i]) > ABSFD6(InMatrix.m[k][i])) {

                k = j;
            }
        }

        if (InMatrix.m[k][i]) {

            //
            // Now we need to do pivot, we will switch row 'i' and row 'k' if
            // they are not in order.
            //

            if (k != i) {

                for (j = 0; j < 3; j++) {

                    SWAPFD6( InMatrix.m[i][j],  InMatrix.m[k][j], Temp);
                    SWAPFD6(OutMatrix.m[i][j], OutMatrix.m[k][j], Temp);
                }
            }

            //
            // Normalize the row, make the diagonal (ie. Matrix[i][i]) to 1.0
            // that is
            //

            for (j = 0, Temp = InMatrix.m[i][i]; j < 3; j++) {

                InMatrix.m[i][j]  = DivFD6(InMatrix.m[i][j],  Temp);
                OutMatrix.m[i][j] = DivFD6(OutMatrix.m[i][j], Temp);
            }

            //
            // and, zero the non-diagonal items in this column (ie. column i).
            //

            for (j = 0; j < 3; j++) {

                if ((j != i) && (Temp = InMatrix.m[j][i])) {

                    for (k = 0; k < 3; k++) {

                        InMatrix.m[j][k]  -= MulFD6( InMatrix.m[i][k], Temp);
                        OutMatrix.m[j][k] -= MulFD6(OutMatrix.m[i][k], Temp);
                    }
                }
            }

        } else {

            NoSigular = FALSE;
        }
    }

    *pOutMatrix = OutMatrix;

    return(NoSigular);

}




VOID
HTENTRY
ConcatTwoMatrix3x3(
    PMATRIX3x3  pConcat,
    PMATRIX3x3  pMatrix,
    PMATRIX3x3  pOutMatrix
    )

/*++

Routine Description:

    This function concatenate 'pMatrix' to 'pConcat' and output the result in
    'pOutMatrix',  supposed you have

    pConcat = RGB->YIQ and pMatrix = YIQ->XYZ

    then pOutMatrix = RGB->XYZ


Arguments:

    pConcat     - Source matrix to be concat

    pMatrix     - Matrix to concatenate into pConcat

    pOutMatrix  - Concatenated 3 x 3 matrix.

Return Value:

    There is no return value.

Author:

    11-Oct-1991 Fri 14:19:59 created    -by-  Daniel Chou (danielc)


Revision History:



--*/

{
    MATRIX3x3   Concat = *pConcat;
    MATRIX3x3   Matrix = *pMatrix;
    MATRIX3x3   OutMatrix;
    MULDIVPAIR  MDPairs[4];
    INT         i;
    INT         j;


    MAKE_MULDIV_INFO(MDPairs, 3, MULDIV_NO_DIVISOR);

    for (i = 0; i < 3; i++) {

        for (j = 0; j < 3; j++) {

            MAKE_MULDIV_PAIR(MDPairs, 1, Matrix.m[i][0], Concat.m[0][j]);
            MAKE_MULDIV_PAIR(MDPairs, 2, Matrix.m[i][1], Concat.m[1][j]);
            MAKE_MULDIV_PAIR(MDPairs, 3, Matrix.m[i][2], Concat.m[2][j]);

            OutMatrix.m[i][j] = MulDivFD6Pairs(MDPairs);
        }
    }

    DBGP_IF(DBGP_CONCAT_M,
            DBGP("== Concat two 3x3 matrixes ==");
            DBGP("[%s %s %s]   [%s %s %s]   [%s %s %s]"
                ARGFD6(Matrix.m[0][0],2,3)
                ARGFD6(Matrix.m[0][1],2,3)      ARGFD6(Matrix.m[0][2],2,3)
                ARGFD6(Concat.m[0][0],2,3)
                ARGFD6(Concat.m[0][1],2,3)      ARGFD6(Concat.m[0][2],2,3)
                ARGFD6(OutMatrix.m[0][0],2,3)
                ARGFD6(OutMatrix.m[0][1],2,3)   ARGFD6(OutMatrix.m[0][2],2,3));

            DBGP("[%s %s %s] x [%s %s %s] = [%s %s %s]"
                ARGFD6(Matrix.m[1][0],2,3)
                ARGFD6(Matrix.m[1][1],2,3)      ARGFD6(Matrix.m[1][2],2,3)
                ARGFD6(Concat.m[1][0],2,3)
                ARGFD6(Concat.m[1][1],2,3)      ARGFD6(Concat.m[1][2],2,3)
                ARGFD6(OutMatrix.m[1][0],2,3)
                ARGFD6(OutMatrix.m[1][1],2,3)   ARGFD6(OutMatrix.m[1][2],2,3));

            DBGP("[%s %s %s]   [%s %s %s]   [%s %s %s]"
                ARGFD6(Matrix.m[2][0],2,3)
                ARGFD6(Matrix.m[2][1],2,3)      ARGFD6(Matrix.m[2][2],2,3)
                ARGFD6(Concat.m[2][0],2,3)
                ARGFD6(Concat.m[2][1],2,3)      ARGFD6(Concat.m[2][2],2,3)
                ARGFD6(OutMatrix.m[2][0],2,3)
                ARGFD6(OutMatrix.m[2][1],2,3)   ARGFD6(OutMatrix.m[2][2],2,3));
    );


    *pOutMatrix = OutMatrix;
}




BOOL
HTENTRY
RegressYFromX(
    PFD6        pX,
    PREGRESS    pRegress,
    UINT        Count
    )

/*++

Routine Description:

   This function compute Y (ouput) based on the regression analysis results.

Arguments:

    pX          - Pointer to input X value for computing the regressed Y value

    pRegress    - Pointer the REGRESS data structure, this data structure must
                  have computed by calling RegressAnalysis() function.

    Count       - count of X data pointed by the pX

Return Value:

    TRUE if sucessful, FALSE otherwise


        To compute Y value from X value the following formula can be used.


        Y = A + (B * X)


        Mode        A   B   X Input     Y Output
        --------    ------ ---------    ----------
        LINEAR:     A   B   X           Y
        LOG:        A   B   Log(X)      Y
        EXP:        A   B   X           AntiLog(Y)
        POWER       A   B   Log(X)      AntiLog(Y)

        LIGHTNESS:  can be one of the above if REGF_LIGHTNESS flag is set, and

                    Log(X)      = CIE_I2L(X)
                    AntiLog(Y)  = CIE_L2I(Y)

Author:

    12-Dec-1991 Thu 11:16:19 created  -by-  Daniel Chou (danielc)


Revision History:


--*/

{
    while (Count--) {

        FD6     X;
        FD6     Y;
        WORD    Flags;


        X = *pX;

        if ((Flags = pRegress->Flags) & REGF_X2Y_LOG_X) {

            X = (Flags & REGF_LIGHTNESS) ? CIE_I2L(X) : Log(X);

            if (X < REGRESS_LOG_X_MIN) {

                X = REGRESS_LOG_X_MIN;
            }
        }

        Y = pRegress->A + MulFD6(pRegress->B, X);

        if (Flags & REGF_X2Y_ANTILOG_Y) {

            Y = (Flags & REGF_LIGHTNESS) ? CIE_L2I(Y) : AntiLog(Y);
        }

        if (Flags & REGF_YFROMX_CLAMP_X01) {

            if (Y > FD6_1) {

                Y = FD6_1;

            } else if (Y < FD6_0) {

                Y = FD6_0;
            }
        }

        *pX++ = Y;
    }

    return(TRUE);
}





BOOL
HTENTRY
RegressXFromY(
    PFD6        pY,
    PREGRESS    pRegress,
    UINT        Count
    )

/*++

Routine Description:

   This function compute X (input) based on the regression analysis results.

Arguments:

    pY          - Pointer to input Y value for computing the regressed Y value

    pRegress    - Pointer the REGRESS data structure, this data structure must
                  have computed by calling RegressAnalysis() function.

    Count       - count of Y data pointed by the pY


Return Value:

        BOOL

        To compute X value from Y value the following formula can be used.

             Y - A
        X = --------
               B


        Mode        A   B   Y Input     X Output
        --------    ------ ---------    ----------
        LINEAR:     A   B   Y           X
        LOG:        A   B   Y           AntiLog(X)
        EXP:        A   B   Log(Y)      X
        POWER       A   B   Log(Y)      AntiLog(X)

        LIGHTNESS:  can be one of the above if REGF_LIGHTNESS flag is set, and

                    Log(Y)      = CIE_I2L(Y)
                    AntiLog(X)  = CIE_L2I(X)

Author:

    12-Dec-1991 Thu 11:16:19 created  -by-  Daniel Chou (danielc)


Revision History:


--*/

{

    while (Count--) {

        FD6     X;
        FD6     Y;
        WORD    Flags;


        Y = *pY;

        if ((Flags = pRegress->Flags) & REGF_SCALE_Y) {

            Y = MulFD6(Y, pRegress->YRange) + pRegress->MinY;
        }

        if (Flags & REGF_Y2X_LOG_Y) {

            Y = (Flags & REGF_LIGHTNESS) ? CIE_I2L(Y) : Log(Y);

            if (Y < REGRESS_LOG_Y_MIN) {

                Y = REGRESS_LOG_Y_MIN;
            }
        }

        X = DivFD6(Y - pRegress->A, pRegress->B);

        if (Flags & REGF_Y2X_ANTILOG_X) {

            X = (Flags & REGF_LIGHTNESS) ? CIE_L2I(X) : AntiLog(X);

        }

        if (Flags & REGF_SCALE_X) {

            X = DivFD6(X - pRegress->MinX, pRegress->XRange);
        }

        if (Flags & REGF_XFROMY_CLAMP_Y01) {

            if (X > FD6_1) {

                X = FD6_1;

            } else if (X < FD6_0) {

                X = FD6_0;
            }
        }

        *pY++ = X;
    }

    return(TRUE);
}


DEFDBGVAR(WORD, RegXYScale = REGF_SCALE_X)

#define MIN_XY_SCALE        (FD6)250000

#if DBG
FD6 REG_MIN_XY_SCALE =      MIN_XY_SCALE;
#else
#define REG_MIN_XY_SCALE    MIN_XY_SCALE
#endif



LONG
HTENTRY
RegressionAnalysis(
    LPVOID      pYData,
    PREGRESS    pRegress
    )

/*++

Routine Description:

    This function compute the regression formulas. The formula typically is
    used in the color work to compute the mapping of the device from its
    input intensity to output intensity.

    for example the EXPonential/POWER regression is used to compute the device
    gamma, the computed A, B is used to gamma correct the input RGB value
    before it set to the device (DCA must linear flat). or de-gamma for a
    device RGB value before transfer to the CIE or other UCS for futher
    computations.


Arguments:

    pXData      - Pointer to the X (input value) data elements, this is
                  an optional pointer.

                    pXData = NULL

                        The Y corresponse X values are computed as integer
                        1, 2, 3..., up to the pRegress->DataCount.

                    pXData != NULL

                        The pXData pointer to an array of X values (input)
                        which has total of pRegress->DataCount items, each X
                        value is corresponse to the pYData.

    pYData      - Pointer to the Y (output value) data elements, the data
                  item in to pData is consider Ys as shown below.


                    [NOTE:]

                        1. If REGRESSF_XDATA_IS_UDECI4 flag is set then the
                           pXData is pointed to an UDECI4 array else it pointed
                           to a FD6 array.

                        2. If REGRESSF_YDATA_IS_UDECI4 flag is set then the
                           pYData is pointed to an UDECI4 array else it pointed
                           to a FD6 array.

                        3. The data value pointed by pXData must be
                           non-negative values.

                        4. The data value pointed by pYData must be
                           non-negative values.

    pRegress    - Pointer to the REGRESS data structure, the following elements
                  must be set before this call.

                    Mode        - Possible regression analysis modes are

                                    REGRESS_MODE_LINEAR     - Linear
                                    REGRESS_MODE_LOG        - Logarithm
                                    REGRESS_MODE_EXP        - Exponential
                                    REGRESS_MODE_POWER      - Power

                    DataCount   - Specified how many data elements in the
                                  pXData/pYData FD6 array.

                                  The DataCount must in the range between
                                  REGRESS_DATACOUNT_MIN, REGRESS_DATACOUNT_MAX.

                    XUnitRange  - a 16-bit unsigned value, it specified the
                                  unit relationship used in the pXData, for
                                  example if 2 is the maximum unit range, then
                                  all X data will be relate to this range.

                                  Note: If pXData is NULL then this range will
                                        set by this function to have value
                                        equalt to the pRegress->DataCount

                    YUnitRange  - a 16-bit unsigned value, it specified the
                                  unit relationship used in the pYData, for
                                  example if 2 is the maximum unit range, then
                                  all Y data will be relate to this range.


                NOTE: If XUnitRang/YUnitRange are 0, then it treated as 1


        After the regression analysis this function setting the following
        fields.

            MinX    - The Minimum X value when Y is very close to 0.0

            MaxX    - The Maximum X value when Y is maximizied.

            MinY    - The Minimum Y value when X is very close to 0.0

            MaxY    - The Maximum Y value when X is maximizied.

            A       - Constant part (unit scale) of the regression formula.

            B       - Correlate X part of the regression formula.


        All above values are normalized to have range between 0.0 to 1.0


    [NOTE:]

        The regression formulas are based on following formulas:


                N * eXY - eX * eY         eY - B * eX
            B = -----------------    A = -------------
                       2       2               N
                 N * eX  - (eX)


        where   N = Total count of input value (DataCount)
                X = input step (X)
                Y = output vlaue (Y)

                * for LOG/POWER regression analysis the above X = LOG(X)
                * for EXP/POWER regression analysis the above Y = LOG(Y)
                * for LIGHTNESS regression analysis the X/Y=Lightness

                all 'e' prefix means the total of it, so eX is the total input
                value X.


        To compute x or y value the formula can be used.


        LINEAR:         x = (y - A) / B
                        y = A + B * x

                              ((y - A) / B)
        LOGARITHM:      x = 10
                        y = A + B * LOG(x)


        EXPONENTIAL:    x = ((LOG(y) - A) / B)
                              A     (B * x)
                        y = 10  * 10

                              ((LOG(y) - A) / B)
        POWER:          x = 10
                              A    B
                        y = 10  * x


Return Value:

    if return value >0 then it indicate the sucessful, and return value is
    equal to to pRegress->DataCount passed.

    If return value <= 0 then an error has occurred, the return value is
    one of the INTERR_REGRESS_xxxx defined error value


Author:

    09-Dec-1991 Mon 18:54:21 created  -by-  Daniel Chou (danielc)

    01-Apr-1995 Sat 18:05:10 updated  -by-  Daniel Chou (danielc)
        Re-compute base on the gamma and lightness


Revision History:


--*/

{
    PFD6        pY;
    REGRESS     Regress;
    FD6         X;
    FD6         Y;
    FD6         eX;
    FD6         eY;
    FD6         eXY;
    FD6         eX2;
    FD6         eXeY;
    FD6         eXeX;
    FD6         Gamma;
    MULDIVPAIR  MDPairs[2];
    UINT        cRegress;
    UINT        Loop;
    UINT        DataCount;
    UINT        RegressMode;


    DEFDBGVAR(FD6, XDataCur)
    DEFDBGVAR(FD6, YDataCur)


    if ((!(pY = (PFD6)pYData)) || (!pRegress)) {

        return(INTERR_REGRESS_NO_YDATA);
    }

    if ((RegressMode = (UINT)pRegress->Flags) & REGRESS_MODE_FLAG_L_LOG) {

        Regress.Flags  = REGF_LIGHTNESS;
        RegressMode   &= ~REGRESS_MODE_FLAG_L_LOG;

    } else {

        Regress.Flags = 0;
    }

    if (RegressMode > REGRESS_MODE_MAX) {

        return(INTERR_REGRESS_INV_MODE);
    }

    DataCount = (UINT)pRegress->DataCount;

    if ((DataCount < (UINT)REGRESS_DATACOUNT_MIN) ||
        (DataCount > (UINT)REGRESS_DATACOUNT_MAX)) {

        return(INTERR_REGRESS_INV_DATACOUNT);
    }

    Gamma = pRegress->YRange;

    //
    // Assuming non-linear computation
    //

    switch(RegressMode) {

    case REGRESS_MODE_LOG:

        Regress.Flags |= (REGF_X2Y_LOG_X        |
                          REGF_Y2X_ANTILOG_X    |
                          REGF_Y2X_IS_DENSITY);
        break;

    case REGRESS_MODE_EXP:

        Regress.Flags |= (REGF_X2Y_ANTILOG_Y    |
                          REGF_Y2X_LOG_Y);
        break;

    case REGRESS_MODE_POWER:

        Regress.Flags |= (REGF_X2Y_LOG_X | REGF_X2Y_ANTILOG_Y   |
                          REGF_Y2X_LOG_Y | REGF_Y2X_ANTILOG_X);
        break;

    default:

        //
        // Default is REGRESS_MODE_LINEAR
        //

        Regress.Flags &= ~REGF_LIGHTNESS;

        break;
    }

    eX                 =
    eY                 =
    eXY                =
    eX2                = FD6_0;
    Regress.DataCount  = (WORD)DataCount;
    Loop               =
    cRegress           = DataCount;

    while (Loop--) {

        X = DivFD6((FD6)Loop, (FD6)DataCount);

        if ((Y = *pY++) < FD6_0) {

            return(INTERR_REGRESS_INV_YDATA);
        }

        if (Regress.Flags & REGF_Y2X_IS_DENSITY) {

            X = FD6_1 - X;
        }

        SETDBGVAR(XDataCur, X);
        SETDBGVAR(YDataCur, Y);

        Y = Power(Y, Gamma);

        if (Regress.Flags & REGF_X2Y_LOG_X) {

            X = (Regress.Flags & REGF_LIGHTNESS) ? CIE_I2L(X) : Log(X);

            if (X < REGRESS_LOG_X_MIN) {

                X = REGRESS_LOG_X_MIN;
            }
        }

        if (Regress.Flags & REGF_Y2X_LOG_Y) {

            Y = (Regress.Flags & REGF_LIGHTNESS) ? CIE_I2L(Y) : Log(Y);

            if (Y < REGRESS_LOG_X_MIN) {

                Y = REGRESS_LOG_X_MIN;
            }
        }

        DBGP_IF(DBGP_REGRESS,
                DBGP("%3ld: X=%s, Y=%s, ---> X=%s, Y=%s"
                    ARGDW(Loop)
                    ARGFD6(XDataCur,  1, 6)
                    ARGFD6(YDataCur,  1, 6)
                    ARGFD6(X, 1, 6)
                    ARGFD6(Y, 1, 6)));

        eX  += X;
        eY  += Y;
        eXY += MulFD6(X, Y);
        eX2 += MulFD6(X, X);
    }

    DBGP_IF(DBGP_REGRESS,
            DBGP("eX=%s, eY=%s, eXY=%s, eX2=%s"
                    ARGFD6(eX,  4, 6)
                    ARGFD6(eY,  4, 6)
                    ARGFD6(eXY, 4, 6)
                    ARGFD6(eX2, 4, 6)));


    //
    // To preventing from overflow the 'B' FD6 number during intermediate
    // computation, we rearrange the calculation litte bit, so that it will
    // not overflow in any case.
    //
    //           N * eXY - eX * eY     eXY - ((eX * eY) / N)
    //       B = -----------------  = -----------------------
    //                  2       2           2      2
    //            N * eX  - (eX)          eX  - (eX / N)
    //
    // About 5% re-arranged computations at most will have 0.000001 difference
    // for the final A/B results, (from round off) other 95% of times will have
    // exactly same results.
    //

    MAKE_MULDIV_INFO(MDPairs, 1, MULDIV_HAS_DIVISOR);
    MAKE_MULDIV_DVSR(MDPairs, INTToFD6(cRegress));

    MAKE_MULDIV_PAIR(MDPairs, 1, eX, eY);

    eXeY = MulDivFD6Pairs(MDPairs);

    MAKE_MULDIV_PAIR(MDPairs, 1, eX, eX);

    eXeX = MulDivFD6Pairs(MDPairs);

    Regress.B         = DivFD6(eXY - eXeY, eX2 - eXeX);
    Regress.A         = FD6DivL(eY - MulFD6(Regress.B, eX), cRegress);
    Regress.MinX      =
    Regress.MinY      = DivFD6(REG_MIN_XY_SCALE, INTToFD6(DataCount));
    Regress.MaxX      =
    Regress.MaxY      = FD6_1 - Regress.MinX;

    RegressXFromY(&(Regress.MinX), &Regress, 1);
    RegressXFromY(&(Regress.MaxX), &Regress, 1);
    RegressYFromX(&(Regress.MinY), &Regress, 1);
    RegressYFromX(&(Regress.MaxY), &Regress, 1);

    if (Regress.MaxX < Regress.MinX) {

        SWAP(Regress.MaxX, Regress.MinX, X);
    }

    if (Regress.MaxY < Regress.MinY) {

        SWAP(Regress.MaxY, Regress.MinY, Y);
    }

    Regress.XRange = Regress.MaxX - Regress.MinX;
    Regress.YRange = Regress.MaxY - Regress.MinY;

    if ((Regress.MinX != FD6_0) || (Regress.MaxX != FD6_1)) {

        Regress.Flags |= REGF_SCALE_X;
    }

#if 0
    if ((Regress.MinY != FD6_0) || (Regress.MaxY != FD6_1)) {

        Regress.Flags |= REGF_SCALE_Y;
    }
#endif

    Regress.Flags |= (REGF_XFROMY_CLAMP_Y01 | REGF_YFROMX_CLAMP_X01);

#if DBG
    Regress.Flags &= ~(REGF_SCALE_X | REGF_SCALE_Y);
    Regress.Flags |= (RegXYScale & (REGF_SCALE_X | REGF_SCALE_Y));
#endif


    DBGP_IF(DBGP_REGRESS,
            DBGP("%s%s REGRESSION: N=%u (%u), A=%s, B=%s, Flags=%04x, Gamma=%s"
                    ARG((Regress.Flags & REGF_LIGHTNESS) ? "*L:" :
                         ((RegressMode) ? "LOG:" : ""))
                    ARG(pDbgRegMode[RegressMode])
                    ARGU(Regress.DataCount)
                    ARGU(cRegress)
                    ARGFD6(Regress.A, 1, 6)
                    ARGFD6(Regress.B, 1, 6)
                    ARGU(Regress.Flags)
                    ARGFD6(Gamma, 1, 6)));

    DBGP_IF(DBGP_REGRESS,
            DBGP("X: %s - %s [%s], Y: %s - %s [%s]"
                    ARGFD6(Regress.MinX,       1, 6)
                    ARGFD6(Regress.MaxX,       1, 6)
                    ARGFD6(Regress.XRange,     1, 6)
                    ARGFD6(Regress.MinY,       1, 6)
                    ARGFD6(Regress.MaxY,       1, 6)
                    ARGFD6(Regress.YRange,     1, 6)));

    *pRegress = Regress;

    return(DataCount);
}




#ifndef HT_OK_GEN_80x86_CODES


//////////////////////////////////////////////////////////////////////////////
//                                                                          //
// Following functions are compiled only if we cannot using 80x86 assembly  //
// equvalent codes                                                          //
//                                                                          //
//////////////////////////////////////////////////////////////////////////////


#define U32xU32_U64(uD1, uD2, QH, QL) {                                     \
        DWORD x0, x1, x2, x3, xT;                                           \
            (x0)=(DWORD)((DWORD)((DWORD)(uD1) & 0xffffL) *                  \
                         (DWORD)((DWORD)(uD2) & 0xffffL));                  \
            (x1)=(DWORD)((DWORD)((DWORD)(uD1) >>     16) *                  \
                         (DWORD)((DWORD)(uD2) & 0xffffL));                  \
            (x2)=(DWORD)((DWORD)((DWORD)(uD1) & 0xffffL) *                  \
                         (DWORD)((DWORD)(uD2) >>     16));                  \
            (x3)=(DWORD)((DWORD)((DWORD)(uD1) >>     16) *                  \
                         (DWORD)((DWORD)(uD2) >>     16));                  \
            (QH)=(DWORD)(((xT)=(x1)+(x2)) >> 16) + (x3) +                   \
                 (DWORD)(((xT)<(x1)) ? 0x10000L : 0);                       \
            if (((QL)=(x0)+(DWORD)((xT) << 16)) < (x0)) { ++(QH); } }

#define NEG_U64(QH, QL)                                                     \
        (DWORD)(QH)=(DWORD)~(DWORD)(QH); (DWORD)(QL)=(DWORD)~(DWORD)(QL);   \
	if (!(++((DWORD)(QL)))) { ++((DWORD)(QH)); }

#define U64AddU64(QH, QL, Q0H, Q0L)                                         \
	if (((DWORD)(QL)+=(DWORD)(Q0L))<(DWORD)(Q0L)) { ++((DWORD)(QH)); }  \
        (DWORD)(QH) += (DWORD)(Q0H)

#define U64AddU32(QH, QL, uD)                                               \
	if (((DWORD)(QL)+=(DWORD)(uD))<(DWORD)(uD)) { ++((DWORD)(QH)); }

#define U64DivFD6_1(xH, xL, uD) {                                           \
        DWORD   xT;                                                         \
	if (((DWORD)(xL)+=(DWORD)FD6_p5)<(DWORD)FD6_p5) { ++((DWORD)(xH)); }\
        (DWORD)(uD)=(DWORD)(((xT=(DWORD)((DWORD)(xH) << 12) |               \
                                 (DWORD)((DWORD)(xL) >> 20)) /              \
                             (DWORD)62500) << 16);                          \
        (DWORD)(uD)|=(DWORD)((DWORD)((DWORD)((xT % (DWORD)62500)<<16) |     \
                                     (DWORD)(((DWORD)(xL)>>4) & 0xffffL)) / \
                             (DWORD)62500);  }




FD6
HTENTRY
MulFD6(
    FD6 Multiplicand,
    FD6 Multiplier
    )

/*++

Routine Description:

    This function multiply two FD6 numbers.

Arguments:

    Multiplicand    - The Multiplicand in FD6 format.

    Multiplier      - The Multiplier in FD6 format.


Return Value:

    No error returned, the return value is the products of multiplicand and
    multiplier.


Author:

    10-Oct-1991 Thu 11:14:24 created  -by-  Daniel Chou (danielc)


Revision History:



--*/

{
    DWORD   xH;
    DWORD   xL;
    DWORD   Result;
    BOOL    Sign;


    if (Sign = (BOOL)(Multiplicand <= 0L)) {

        if (!(Multiplicand = -Multiplicand)) {

            return(0L);                     // if one of them is '0' then...
        }
    }

    if (Multiplier <= 0L) {

        if (Multiplier = -Multiplier) {

            Sign = !Sign;

        } else {

            return(FD6_0);              // if one of them is '0' then...
        }
    }

    if (Multiplicand == FD6_1) {

        Result = Multiplier;

    } else if (Multiplier == FD6_1) {

        Result = Multiplicand;

    } else {

        U32xU32_U64(Multiplicand, Multiplier, xH, xL);
        U64DivFD6_1(xH, xL, Result);
    }

    return((Sign) ? -(FD6)Result : (FD6)Result);
}



DWORD
HTENTRY
U64DivU32RoundUp(
    DWORD   Dividend64H,
    DWORD   Dividend64L,
    DWORD   Divisor32
    )

/*++

Routine Description:

    This function divide a unsigned 64-bit number by a 32-bit unsigned number

Arguments:

    Dividend64H - High 32-bit of a 64-bit unsigned dividend number

    Dividend64L - Low 32-bit of a 64-bit unsigned dividend number

    Divisor32   - 32-bit unsigned divisor number. (must not zero);

Return Value:

    No error returned, the return value is the round up quotient of the
    Divndend/Divisor.

    if Dividend is equal to 0 then a 0 is returned,


Author:

    10-Oct-1991 Thu 11:14:24 created  -by-  Daniel Chou (danielc)


Revision History:



--*/

{
    DWORD   xH;
    DWORD   xL;
    DWORD   xT;
    DWORD   xR;
    WORD    Correct;
    WORD    DvsrL;
    WORD    DvsrH;
    WORD    QH;
    WORD    QL;



    ASSERT(Divisor32 != 0L);


    if ((xL = Dividend64L + (Divisor32 >> 1)) < Dividend64L) {

        xH = ++Dividend64H;

    } else {

        xH = Dividend64H;
    }

    DvsrH = U16_H_U32(Divisor32);

    if ((DvsrL = U16_L_U32(Divisor32)) && (DvsrH)) {

        //
        // Both DvsrH/DvsrL are non-zero
        //

        xT = (DWORD)(QH = (WORD)(xH / (DWORD)DvsrH)) * (DWORD)DvsrL;
        xR = ((xH - ((DWORD)QH * (DWORD)DvsrH)) << 16) | (DWORD)U16_H_U32(xL);

        if ((LONG)xT < 0L) {

            //
            // The overrun just too high, let's reduce it so we can manage it
            // (we like it to have overrun less then 0x80000000L
            //

            QH -= (Correct = (WORD)((xT - xR) / Divisor32));
            xT -= (DWORD)Correct * Divisor32;
        }

        if ((LONG)(xR -= xT) < 0L) {

            --QH;

            if ((LONG)(xR += Divisor32) < 0L) {

                --QH;

                if ((LONG)(xR += Divisor32) < 0L) {

                    --QH;

                    if ((LONG)(xR += Divisor32) < 0L) {

                        --QH;

                        if ((LONG)(xR += Divisor32) < 0L) {

                            --QH;

                            if ((LONG)(xR += Divisor32) < 0L) {

                                --QH;

                                if ((LONG)(xR += Divisor32) < 0L) {

                                    DWORD   Rem;

                                    QH -= (WORD)(NEGDW(xR) / Divisor32);

                                    if (Rem = (DWORD)(NEGDW(xR) % Divisor32)) {

                                        --QH;
                                        xR = Divisor32 - Rem;
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }

        if (U16_H_U32(xR) < DvsrH) {

            xT = (DWORD)(QL = (WORD)(xR / (DWORD)DvsrH)) * (DWORD)DvsrL;
            xR = ((xR - ((DWORD)QL * (DWORD)DvsrH)) << 16) | (xL & 0xffffL);

            if (xR < xT) {

                --QL;

                if ((xR += Divisor32) < xT) {

                    --QL;

                    if ((xR += Divisor32) < xT) {

                        --QL;

                        if ((xR += Divisor32) < xT) {

                            --QL;

                            if ((xR += Divisor32) < xT) {

                                QL -= Correct = (WORD)((xT -= xR)/Divisor32);

                                if (xT > (DWORD)Correct * Divisor32) {

                                    --QL;
                                }
                            }
                        }
                    }
                }
            }

        } else {

            xR = ((DWORD)DvsrL << 16) - ((xR << 16) | (xL & 0xffffL));
            QL = (WORD)(xR / Divisor32);

            if (xR > ((DWORD)QL * Divisor32)) {

                ++QL;
            }

            QL = -QL;
        }

    } else if (DvsrL) {

        QH = (WORD)((xH = (xH << 16) | (xL >> 16)) / (DWORD)DvsrL);
        QL = (WORD)((((xH % (DWORD)DvsrL) << 16) | (xL & 0xffffL)) /
                      (DWORD)DvsrL);

    } else {                                // DvsrL = 0

        QH = (WORD)(xH / (DWORD)DvsrH);
        QL = (WORD)((((xH % (DWORD)DvsrH) << 16) | (xL >> 16)) /
                      (DWORD)DvsrH);
    }

    return(((DWORD)QH << 16) | (DWORD)QL);

}




FD6
HTENTRY
DivFD6(
    FD6 Dividend,
    FD6 Divisor
    )

/*++

Routine Description:

    This function divide two FD6 numbers.

Arguments:

    Dividend    - The Dividend in FD6 format.

    Divisor     - The Divosr in FD6 format.

Return Value:

    No error returned, the return value is the round up quotient of the
    Divndend/Divisor.

    if Dividend is equal to 0 then a 0 is returned,
    if Divisor is equal to zero then Dividend is returned.


Author:

    10-Oct-1991 Thu 11:14:24 created  -by-  Daniel Chou (danielc)


Revision History:



--*/

{
    DWORD   x0;
    DWORD   x1;
    DWORD   xH;
    DWORD   xL;
    BOOL    Sign;


    if (Sign = (BOOL)(Divisor <= FD6_0)) {

        if (!(Divisor = -Divisor)) {

            return((Dividend < 0) ? MAX_FD6 : MIN_FD6);
        }
    }

    if (Divisor == FD6_1) {

        return((Sign) ? -Dividend : Dividend);
    }

    if (Dividend <= 0L) {

        if (Dividend = -Dividend) {

            Sign = (BOOL)!Sign;

        } else {

            return(FD6_0);          // nothing to divide, so return 0
        }
    }

    if (Dividend == Divisor) {

        return((Sign) ? -FD6_1 : FD6_1);
    }

    x0 = (DWORD)U16_L_U32(Dividend) * (DWORD)62500;
    x1 = (DWORD)U16_H_U32(Dividend) * (DWORD)62500;

    xH = (DWORD)U16_H_U32(x1);

    if ((xL = x0 + (x1 << 16)) < x0) {

        ++xH;
    }

    xH = (xH << 4) | (DWORD)(U16_H_U32(xL) >> 12);
    xL <<= 4;

    if (Sign) {

        return(-(FD6)U64DivU32RoundUp(xH, xL, Divisor));

    } else {

        return((FD6)U64DivU32RoundUp(xH, xL, Divisor));
    }
}



FD6
HTENTRY
FD6DivL(
    FD6     Dividend,
    LONG    Divisor
    )

/*++

Routine Description:

    This function divide a FD6 number by a LONG integer.

Arguments:

    Dividend    - The Dividend in FD6 format.

    Divisor     - The Divosr in long format.

Return Value:

    No error returned, the return value is the round up quotient of the
    Divndend/Divisor.

    if Dividend is equal to 0 then a 0 is returned,
    if Divisor is equal to zero then Dividend is returned.


Author:

    10-Oct-1991 Thu 11:14:24 created  -by-  Daniel Chou (danielc)


Revision History:



--*/

{
    DWORD   Quot;
    BOOL    Sign;


    if (Sign = (BOOL)(Divisor <= 0L)) {

        if (!(Divisor = -Divisor)) {

            return(Dividend);           // can not divide by 0, return as 1
        }
    }

    if (Dividend <= 0L) {

        if (Dividend = -Dividend) {

            Sign = (BOOL)!Sign;

        } else {

            return(FD6_0);          // nothing to divide, so return 0
        }
    }

    Quot = ((DWORD)Dividend + (DWORD)((DWORD)Divisor >> 1)) / (DWORD)Divisor;

    return((Sign) ? -(FD6)Quot : (FD6)Quot);
}



FD6
HTENTRY
MulDivFD6Pairs(
    PMULDIVPAIR pMulDivPair
    )

/*++

Routine Description:

    This function multiply TotalFD6Pairs of FD6 numbers and optional divide by
    passed divisor.

Arguments:

    pMulDivPair - Pointer to array of MULDIVPAIR data structure, the first
                  structure in the array tell the count of the FD6 pairs,
                  a Divisor present flag and a Divisor, the FD6 pairs start
                  from second element in the array.

Return Value:

    The return value is the 32-bit FD6 number which is round up from 7th
    decimal points, there is no remainder returned.

    NO ERROR returned, if divisor is zero then it assume no divisor is present,
    if Count of FD6 pairs is zero then it return FD6_0

Author:

    27-Aug-1992 Thu 18:13:55 updated  -by-  Daniel Chou (danielc)
        Re-write to remove variable argument conflict, and make it only passed
        a pointer to the MULDIVPAIR structure array

    10-Oct-1991 Thu 11:14:24 created  -by-  Daniel Chou (danielc)


Revision History:



--*/

{
    FD6     Multiplicand;
    FD6     Multiplier;
    FD6     Divisor;
    DWORD   xH;
    DWORD   xL;
    DWORD   xPH;
    DWORD   xPL;
    DWORD   Result;
    BOOL    Sign;
    INT     cFD6Pairs;


    if (!(cFD6Pairs = (INT)pMulDivPair->Pair1.Info.Size)) {

        return(FD6_0);
    }

    Divisor = FD6_0;

    if (pMulDivPair->Pair1.Info.Flag & MULDIV_HAS_DIVISOR) {

        if ((Divisor = pMulDivPair->Pair2) == FD6_1) {

            Divisor = FD6_0;
        }
    }

    xH = xL = (DWORD)0;

    while (cFD6Pairs--) {

        ++pMulDivPair;

        Multiplicand = pMulDivPair->Pair1.Mul;
        Multiplier   = pMulDivPair->Pair2;

        if (Sign = (BOOL)(Multiplicand <= 0L)) {

            if (!(Multiplicand = -Multiplicand)) {

                continue;           // this one will be zero, check next pair
            }
        }

        if (Multiplier <= 0L) {

            if (Multiplier = -Multiplier) {

                Sign = (BOOL)!Sign;

            } else {

                continue;           // this one will be zero, check next pair
            }
        }

        U32xU32_U64(Multiplicand, Multiplier, xPH, xPL);

        if (Sign) {

            NEG_U64(xPH, xPL);
        }

        U64AddU64(xH, xL, xPH, xPL);

    }

    if (Sign = (BOOL)((LONG)xH < 0)) {

        NEG_U64(xH, xL);
    }

    if (Divisor) {

        if (Divisor < FD6_0) {

            Divisor = -Divisor;
            Sign    = !Sign;
        }

        Result = U64DivU32RoundUp(xH, xL, (DWORD)Divisor);

    } else {

        //
        // No Divisor, so just divide it by FD6_1
        //

        U64DivFD6_1(xH, xL, Result);
    }

    return((Sign) ? -(FD6)Result : (FD6)Result);
}



FD6
HTENTRY
FractionToMantissa(
    FD6     Fraction,
    DWORD   CorrectData
    )

/*++

Routine Description:

    This function take decimal fraction and correct the logarithm mantissa
    between x.xxyyyy x.xxzzzz, where fraction is laid between yyyy to zzzz.

Arguments:

    Fraction        - the fraction number after decimal place, because
                      we have mantissa table up to two decimal places, the
                      correction is necessary because logarithm numbers are
                      no linear.  The number is range from 0.000000-0.999999

    CorrectData     - The correction data which from MantissaCorrectData[]

Return Value:

    No error returned, the return value is the Mantissa value for the fraction
    passed in.


Author:

    10-Oct-1991 Thu 11:14:24 created  -by-  Daniel Chou (danielc)


Revision History:



--*/

{
    DWORD   Mantissa;
    DWORD   Rem;
    INT     Loop;
    WORD    Base;
    WORD    Error;
    WORD    NextErr;
    WORD    CorrL;
    WORD    CorrH;


    //
    // Mantissa Correction Data Bits Usage:
    //
    //
    //       <---High Word---> <----Low Word--->
    //  Bit#  3          2          1          0
    //       10987654 32109876 54321098 76543210
    //       | | | |  | |  |   ||  |  |
    //       | | | |  | |  |   ||  |  +-- x.000 Minimum Difference
    //       | | | |  | |  |   ||  +----- x.001-x.002 (0-7) Correct 1
    //       | | | |  | |  |   |+-------- x.000-x.001 (0-7) Correct 2
    //       | | | |  | |  |   +--------- x.009-y.000 (0-1) Correct 10
    //       | | | |  | |  +------------- x.009-y.000 (0-7) Correct 3
    //       | | | |  | +---------------- x.008-x.009 (0-7) Correct 4
    //       | | | |  +------------------ x.007-x.008 (0-3) Correct 5
    //       | | | +--------------------- x.006-x.007 (0-3) Correct 6
    //       | | +----------------------- x.005-x.006 (0-3) Correct 7
    //       | +------------------------- x.004-x.005 (0-3) Correct 8
    //       +--------------------------- x.003-x.004 (0-3) Correct 9
    //

    CorrL = U16_L_U32(CorrectData);
    CorrH = U16_H_U32(CorrectData);
    Rem   = (DWORD)(Fraction % 100000L);
    Loop  = (INT)(Fraction / 100000L);
    Base  = (WORD)(CorrL & 0x1ff);
    Error = 0;

    NextErr = (WORD)(Base + ((CorrL >>= 9) & 0x07));

    if (Loop--) {

        Error   += NextErr;

        //
        // bit 6, 0x40 = correct 10
        //

        NextErr  = (WORD)(Base + ((CorrL >> 3) & 0x07));

        if (Loop--) {

            Error   += NextErr;
            NextErr  = (WORD)(Base + (CorrH & 0x07));

            if (Loop--) {

                Error   += NextErr;
                NextErr  = (WORD)(Base + ((CorrH >>= 3) & 0x07));

                if (CorrL & 0x40) {

                    CorrH |= 0x2000;        // add in correction 10
                }

                CorrH >>= 1;                // pre-shift for next while

                while (Loop--) {

                    Error += NextErr;
                    NextErr = (WORD)(Base + ((CorrH >>= 2) & 0x03));
                }
            }
        }
    }

    Mantissa = (DWORD)Error +
               ((((Rem * (DWORD)NextErr) >> 1) + 25000L) / 50000L);

    return(FD6FromL(Mantissa));
}




FD6
HTENTRY
MantissaToFraction(
    FD6     Mantissa,
    DWORD   CorrectData
    )

/*++

Routine Description:

    This function take mantissa number and convert it to the decimal fraction

Arguments:

    Mantissa        - the mantissa values which will converted to the the
                      fraction number.

    CorrectData     - The correction data which from MantissaCorrectData[]

Return Value:

    No error returned, the return value is the fraction value for the mantissa
    passed in, it range from 0.000000 - 1.000000


Author:

    10-Oct-1991 Thu 11:14:24 created  -by-  Daniel Chou (danielc)


Revision History:



--*/

{
    static  DWORD   ul100000To900000[] = { 100000L, 200000L, 300000L, 400000L,
                                           500000L, 600000L, 700000L, 800000L,
                                           900000L
                                         };
    DWORD   Fraction;
    SHORT   Index;
    SHORT   Base;
    SHORT   Error;
    SHORT   NextErr;
    WORD    CorrL;
    WORD    CorrH;

    //
    // Mantissa Correction Data Bits Usage:
    //
    //
    //       <---High Word---> <----Low Word--->
    //  Bit#  3          2          1          0
    //       10987654 32109876 54321098 76543210
    //       | | | |  | |  |   ||  |  |
    //       | | | |  | |  |   ||  |  +-- x.000 Minimum Difference
    //       | | | |  | |  |   ||  +----- x.001-x.002 (0-7) Correct 1
    //       | | | |  | |  |   |+-------- x.000-x.001 (0-7) Correct 2
    //       | | | |  | |  |   +--------- x.009-y.000 (0-1) Correct 10
    //       | | | |  | |  +------------- x.009-y.000 (0-7) Correct 3
    //       | | | |  | +---------------- x.008-x.009 (0-7) Correct 4
    //       | | | |  +------------------ x.007-x.008 (0-3) Correct 5
    //       | | | +--------------------- x.006-x.007 (0-3) Correct 6
    //       | | +----------------------- x.005-x.006 (0-3) Correct 7
    //       | +------------------------- x.004-x.005 (0-3) Correct 8
    //       +--------------------------- x.003-x.004 (0-3) Correct 9
    //

    Error    = (SHORT)FD6ToL(Mantissa);         // only need 16 bits
    CorrL    = U16_L_U32(CorrectData);
    CorrH    = U16_H_U32(CorrectData);
    Base     = (SHORT)(CorrL & 0x1ff);
    Fraction = 0L;

    Index = 1;                                  // assume 1
    NextErr = (WORD)(Base + ((CorrL >>= 9) & 0x07));

    if ((Error -= NextErr) > 0) {

        ++Index;

        //
        // bit 6, 0x40 = correct 10
        //

        NextErr = (WORD)(Base + ((CorrL >> 3) & 0x07));

        if ((Error -= NextErr) > 0) {

            ++Index;
            NextErr = (WORD)(Base + (CorrH & 0x07));

            if ((Error -= NextErr) > 0) {

                ++Index;
                NextErr = (WORD)(Base + ((CorrH >>= 3) & 0x07));

                if (CorrL & 0x40) {

                    CorrH |= 0x2000;        // add in correction 10
                }

                CorrH >>= 1;                // pre-shift for next while

                while ((Error -= NextErr) > 0) {

                    ++Index;
                    NextErr = (WORD)(Base + ((CorrH >>= 2) & 0x03));
                }
            }
        }
    }

    if (Error) {

        --Index;
        Fraction = (((((DWORD)(Error + NextErr) * 50000L) << 1) +
                    (DWORD)(NextErr >> 1)) / (DWORD)NextErr);
    }

    if (Index--) {

        Fraction += ul100000To900000[Index];
    }

    return(FD6FromL(Fraction));
}




DWORD
HTENTRY
ComputeChecksum(
    LPBYTE  pData,
    DWORD   InitialChecksum,
    DWORD   DataSize
    )

/*++

Routine Description:

    This function compute a 32-bit check sum for the pData passed in

Arguments:

    pData           - Pointer to data which checksum to be computed

    InitChecksum    - Initial checksum value, this value can be a checksum
                      value from last computed result, so it can generate a
                      single checksum from a large linked data.

    DataSize        - pData size in bytes


    The Checksum is forming by two 16-bit checksum octets R,S and n is the
    octet number, the addition is performed in one's complement arithmic.

    S(n)     = S(n-1) + Data(n)
    R(n)     = R(n-1) + S(n)

    Checksum = (DWORD)(R << 16) | (DWORDS;


Return Value:

    return value is a 32-bit checksum


Author:

    27-Apr-1992 Mon 18:36:03 created  -by-  Daniel Chou (danielc)


Revision History:


--*/

{
    W2B     w2b;
    WORD    OctetR;
    WORD    OctetS;


    //
    // We using two 16-bit checksum octets with one's complement arithmic
    //

    //
    // 1. Get initial values for OctetR and OctetS
    //

    OctetR = HIWORD(InitialChecksum);
    OctetS = LOWORD(InitialChecksum);

    //
    // 2. Since we doing 16-bit at a time, we will pack high byte with zero
    //    if data size in bytes is odd number
    //

    if (DataSize & 0x01) {

        OctetR += (OctetS += (WORD)*pData++);
    }

    //
    // 3. Now forming checksum 16-bit at a time
    //

    DataSize >>= 1;

    while (DataSize--) {

        w2b.b[0] = *pData++;
        w2b.b[1] = *pData++;

        OctetR += (OctetS += w2b.w);
    }

    return((DWORD)((DWORD)OctetR << 16) | (DWORD)OctetS);
}



#endif  // HT_OK_GEN_80x86_CODES
