/*++ build version: 0002    // increment this if a change has global effects

/****************************** Module Header ******************************\
* Module Name: user.h
*
* Copyright (c) 1985-95, Microsoft Corporation
*
* This header file contains stuff shared by all the modules of the USER.DLL.
*
* History:
* 09-18-90 DarrinM      Created.
* 04-27-91 DarrinM      Merged in USERCALL.H, removed some dead wood.
\***************************************************************************/

#ifndef _USER_
#define _USER_

#include "winerrp.h"

//
// BUGBUG Will be moved to GDI
//

#define GDI_FIXUP_HANDLE(h) h


/*
 * Enable warnings that are turned off default for NT but we want on
 */
#ifndef RC_INVOKED       // RC can't handle #pragmas
#pragma warning(error:4101)   // Unreferenced local variable
#endif


#if !defined(FASTCALL)
#if defined(_X86_)
#define FASTCALL    _fastcall
#else
#define FASTCALL
#endif
#endif

#ifdef UNICODE
#define UTCHAR WCHAR
#else
#define UTCHAR UCHAR
#endif

typedef struct _LOCKRECORD          *PLR;
typedef struct _TL                  *PTL;
typedef struct tagWINDOWSTATION     *PWINDOWSTATION;
typedef struct tagDESKTOP           *PDESKTOP;
typedef struct tagTDB               *PTDB;
typedef struct tagSVR_INSTANCE_INFO *PSVR_INSTANCE_INFO;
typedef struct _MOVESIZEDATA        *PMOVESIZEDATA;
typedef struct tagCURSOR            *PCURSOR;
typedef struct tagPOPUPMENU         *PPOPUPMENU;
typedef struct tagQMSG              *PQMSG;
typedef struct tagWND               *PWND;
typedef struct _ETHREAD             *PETHREAD;
typedef struct tagDESKTOPINFO       *PDESKTOPINFO;
typedef struct tagDISPLAYINFO       *PDISPLAYINFO;
typedef struct tagCLIENTTHREADINFO  *PCLIENTTHREADINFO;
typedef struct tagDCE               *PDCE;
typedef struct tagSPB               *PSPB;

#define ARRAY_SIZE(a) (sizeof(a) / sizeof((a)[0]))

/***************************************************************************\
* These cool constants can be used to specify rops
\***************************************************************************/

#define DESTINATION (DWORD)0x00AA0000
#define SOURCE      (DWORD)0x00CC0000
#define PATTERN     (DWORD)0x00F00000

/**************************
*  Chicago equates
***************************/
#define BI_CHECKBOX       0
#define BI_RADIOBUTTON    1
#define BI_3STATE         2

#define NUM_BUTTON_TYPES  3
#define NUM_BUTTON_STATES 4

/*
 * Total number of strings used as button strings in MessageBoxes
 */
#define  MAX_MB_STRINGS    9


/*
 * Rectangle macros.  Inlining these is both faster and smaller
 */
#undef CopyRect
#undef EqualRect
#undef SetRectEmpty
#define CopyRect(prc1, prc2)  ((*prc1) = (*prc2))
#define EqualRect(prc1, prc2) RtlEqualMemory((prc1), (prc2), sizeof(RECT))
#define SetRectEmpty(prc)     RtlZeroMemory((prc), sizeof(RECT))

/***************************************************************************\
* ANSI/Unicode function names
*
* For non-API Client/Server stubs, an "A" or "W" suffix must be added.
* (API function names are generated by running wcshdr.exe over winuser.x)
*
\***************************************************************************/
#ifdef UNICODE
#define TEXT_FN(fn) fn##W
#else
#define TEXT_FN(fn) fn##A
#endif

#ifdef UNICODE
#define BYTESTOCHARS(cb) ((cb) / sizeof(TCHAR))
#define CHARSTOBYTES(cch) ((cch) * sizeof(TCHAR))
#else
#define BYTESTOCHARS(cb) (cb)
#define CHARSTOBYTES(cch) (cch)
#endif

/*
 * Internal window class names
 */
#define DESKTOPCLASS    MAKEINTATOM(0x8001)
#define DIALOGCLASS     MAKEINTATOM(0x8002)
#define SWITCHWNDCLASS  MAKEINTATOM(0x8003)
#define ICONTITLECLASS  MAKEINTATOM(0x8004)
#define INFOCLASS       MAKEINTATOM(0x8005)

/*
 * These should be made public and moved to WINUSER.H.
 */
#define MENUCLASS           MAKEINTATOM(0x8000)     /* Public Knowledge */

//
// System timer IDs
//
#define IDSYS_MOUSEHOVER    0x0000FFFAL
#define IDSYS_LBSEARCH      0x0000FFFCL
#define IDSYS_STANIMATE     0x0000FFFDL
#define IDSYS_SCROLL        0x0000FFFEL
#define IDSYS_MNSHOW        0x0000FFFEL
#define IDSYS_MNHIDE        0x0000FFFFL
#define IDSYS_CARET         0x0000FFFFL


/*
 * Special case string token codes.  These must be the same as in the resource
 * compiler's RC.H file.
 */
/*
 * NOTE: Order is assumed and much be this way for applications to be
 * compatable with windows 2.0
 */
#define CODEBIT             0x80
#define BUTTONCODE          0x80
#define EDITCODE            0x81
#define STATICCODE          0x82
#define LISTBOXCODE         0x83
#define SCROLLBARCODE       0x84
#define COMBOBOXCODE        0x85
#define MDICLIENTCODE       0x86
#define COMBOLISTBOXCODE    0x87

/*
 * Internal window classes. These numbers serve as indices into the
 * atomSysClass table so that we can get the atoms for the various classes.
 * The order of the control classes (through COMBOLISTBOXCLASS) is assumed
 * to be the same as the class codes above.
 */
#define ICLS_BUTTON         0
#define ICLS_EDIT           1
#define ICLS_STATIC         2
#define ICLS_LISTBOX        3
#define ICLS_SCROLLBAR      4
#define ICLS_COMBOBOX       5       // End of special dlgmgr indices

#define ICLS_CTL_MAX        6       // Number of public control classes

#define ICLS_DESKTOP        6
#define ICLS_DIALOG         7
#define ICLS_MENU           8
#define ICLS_SWITCH         9
#define ICLS_ICONTITLE      10
#define ICLS_MDICLIENT      11
#define ICLS_COMBOLISTBOX   12
#define ICLS_DDEMLEVENT     13
#define ICLS_DDEMLMOTHER    14
#define ICLS_DDEML16BIT     15
#define ICLS_DDEMLCLIENTA   16
#define ICLS_DDEMLCLIENTW   17
#define ICLS_DDEMLSERVERA   18
#define ICLS_DDEMLSERVERW   19

#ifdef FE_IME
#define ICLS_IME            20
#define ICLS_MAX            19      // Number of system classes
#else
#define ICLS_MAX            20      // Number of system classes
#endif

/*
 * Directory name for windowstations and desktops
 */
#define WINSTA_DIR  L"\\Windows\\WindowStations"

/***************************************************************************\
* Normal Stuff
*
* Nice normal typedefs, defines, prototypes, etc that everyone wants to share.
*
\***************************************************************************/


/*
 * These constants have to be known during pass one of the compilier because
 * they are used by in-line assembly so they are defined here and check at run
 * time by the TEBOffsetCheck macro in UserServerDllInitialization
 */

#define TEB_Win32ThreadInfo         0x40
#define TEB_Win32ClientInfo         0x44

#ifdef DBG
#define TEBOffsetCheck()    {UserAssert(TEB_Win32ThreadInfo  == FIELD_OFFSET(TEB, Win32ThreadInfo));  \
                             UserAssert(TEB_Win32ClientInfo  == FIELD_OFFSET(TEB, Win32ClientInfo));  }
#else
#define TEBOffsetCheck()
#endif

/*
 * Define size limit of callback data.  Below or equal to this limit, put data
 * on the client-side stack.  Above this limit allocate virtual memory
 * for the data
 */
#define CALLBACKSTACKLIMIT  (PAGE_SIZE / 2)

/*
 * Capture buffer definition for callbacks
 */
typedef struct _CAPTUREBUF {
    DWORD cbCallback;
    DWORD cbCapture;
    DWORD cCapturedPointers;
    PBYTE pbFree;
    DWORD offPointers;
    PVOID pvVirtualAddress;
} CAPTUREBUF, *PCAPTUREBUF;

/*
 * Callback return status
 */
typedef struct _CALLBACKSTATUS {
    DWORD retval;
    DWORD cbOutput;
    PVOID pOutput;
} CALLBACKSTATUS, *PCALLBACKSTATUS;

//
// Strings are counted 16-bit character strings. If they are
// NULL terminated, Length does not include trailing NULL.
//
typedef struct _LARGE_STRING {
    ULONG Length;
    ULONG MaximumLength : 31;
    ULONG bAnsi : 1;
    PVOID Buffer;
} LARGE_STRING, *PLARGE_STRING;

typedef struct _LARGE_ANSI_STRING {
    ULONG Length;
    ULONG MaximumLength : 31;
    ULONG bAnsi : 1;
    PSTR Buffer;
} LARGE_ANSI_STRING, *PLARGE_ANSI_STRING;

typedef struct _LARGE_UNICODE_STRING {
    ULONG Length;
    ULONG MaximumLength : 31;
    ULONG bAnsi : 1;
    PWSTR Buffer;
} LARGE_UNICODE_STRING, *PLARGE_UNICODE_STRING;

/*
 * String macros
 */
__inline BOOL IsEmptyString(PVOID p, ULONG bAnsi)
{
    return (BOOL)!(bAnsi ? *(LPSTR)p : *(LPWSTR)p);
}
__inline void NullTerminateString(PVOID p, ULONG bAnsi)
{
    if (bAnsi) *(LPSTR)p = (CHAR)0; else *(LPWSTR)p = (WCHAR)0;
}
__inline UINT StringLength(PVOID p, ULONG bAnsi)
{
    return (bAnsi ? strlen((LPSTR)p) : wcslen((LPWSTR)p));
}

typedef struct _CTLCOLOR {
    COLORREF crText;
    COLORREF crBack;
    int iBkMode;
} CTLCOLOR, *PCTLCOLOR;

#ifdef _NTCSRMSG_

/*
 * Generic message format used by several server side APIs.
 *
 * N.B. This MUST identically match the individual API structures since it
 *      is used by the User server API dispatcher.
 *
 */

typedef struct _FNGENERICMSG {
    HWND hwnd;
    UINT msg;
    DWORD wParam;
    LONG lParam;
    DWORD xParam;
    DWORD xpfnProc;
} FNGENERICMSG, *PFNGENERICMSG;

#endif  // _NTCSRMSG_

/*
 * This is used by the cool client side DrawIcon code
 */
typedef struct _DRAWICONEXDATA {
    HBITMAP hbmMask;
    HBITMAP hbmColor;
    int cx;
    int cy;
} DRAWICONEXDATA;

/*
 * Version macros
 */
#define VER40           0x0400
#define VER31           0x030A
#define VER30           0x0300
#define VER20           0x0201

#define Is400Compat(dwExpWinVer)  (LOWORD(dwExpWinVer) >= 0x0400)
#define Is310Compat(dwExpWinVer)  (LOWORD(dwExpWinVer) >= 0x030A)

/*
 * Static items stored in the TEB
 */
typedef struct _CALLBACKWND {
    HWND hwnd;
    PWND pwnd;
} CALLBACKWND, *PCALLBACKWND;

#define CVKKEYCACHE                 32
#define CBKEYCACHE                  (CVKKEYCACHE >> 2)

#define CVKASYNCKEYCACHE            16
#define CBASYNCKEYCACHE             (CVKASYNCKEYCACHE >> 2)

/*
 * The offset to cSpins must match WIN32_CLIENT_INFO_SPIN_COUNT defined
 * in ntpsapi.h.  GDI uses this offset to reset the spin count.
 * WARNING! This struct cannot be made larger without changing the TEB struct:
 * It must fit in ULONG Win32ClientInfo[WIN32_CLIENT_INFO_LENGTH]; (ntpsapi.h)
 * (ifdef FE_SB, sizeof(CLIENTINFO) == 0x7c == 4 * WIN32_CLIENT_INFO_LENGTH)
 */
typedef struct _CLIENTINFO {
    DWORD               CI_flags;               // Needs to be first because CSR
    DWORD               cSpins;
    HANDLE              hEventQueueClient;      //   clears it on failure
    DWORD               dwExpWinVer;
    DWORD               dwCompatFlags;
    DWORD               dwTIFlags;
    PDESKTOPINFO        pDeskInfo;
    ULONG               ulClientDelta;
    struct tagHOOK      *phkCurrent;
    DWORD               fsHooks;
    CALLBACKWND         CallbackWnd;
    DWORD               dwHookCurrent;
    int                 cInDDEMLCallback;
    HANDLE              hDdemlCallbackInst;
    PCLIENTTHREADINFO   pClientThreadInfo;
    DWORD               dwHookData;
    DWORD               dwKeyCache;
    BYTE                afKeyState[CBKEYCACHE];
    DWORD               dwAsyncKeyCache;
    BYTE                afAsyncKeyState[CBASYNCKEYCACHE];
    BYTE                afAsyncKeyStateRecentDown[CBASYNCKEYCACHE];
    WORD                CodePage;
#ifdef FE_SB // _CLIENTINFO
    BYTE                achDbcsCF[2]; // Save ANSI DBCS LeadByte character code in this field for ANSI to Unicode.
                                      // Uses SendMessageA/PostMessageA from CLIENT to SERVER (index 0)
                                      //  And...
                                      // Uses SendMessageA/DispatchMessageA for CLIENT to CLIENT (index 1)
    MSG                 msgDbcsCB;    // Save ANSI DBCS character message in this field for convert Unicode to ANSI.
                                      // Uses GetMessageA/PeekMessageA from SERVER to CLIENT
#endif // FE_SB
} CLIENTINFO, *PCLIENTINFO;

#define CI_IN_SYNC_TRANSACTION 0x00000001
#define CI_PROCESSING_QUEUE    0x00000002
#define CI_16BIT               0x00000004
#define CI_INITIALIZED         0x00000008
#define CI_INTERTHREAD_HOOK    0x00000010

// We don't grab it this way in the kernel in case it is a kernel only thread
#ifndef _USERK_
#define GetClientInfo() ((PCLIENTINFO)((NtCurrentTeb())->Win32ClientInfo))
#endif  // _USERK_

#ifdef FE_SB // WMCR_IR_DBCSCHAR and DBCS Macros
/*
 * Flags used for the WM_CHAR  HIWORD of wParam for DBCS messaging.
 *  (LOWORD of wParam will have character codepoint)
 */
#define WMCR_IR_DBCSCHAR       0x80000000

/*
 * Macros to determine this is DBCS message or not.
 */
#define IS_DBCS_MESSAGE(DbcsChar)      (((DWORD)(DbcsChar)) & 0x0000FF00)

/*
 * Macros for IR_DBCSCHAR format to/from regular format.
 */
#define MAKE_IR_DBCSCHAR(DbcsChar)     (IS_DBCS_MESSAGE((DbcsChar)) ?                                     \
                                        (MAKEWPARAM(MAKEWORD(HIBYTE((DbcsChar)),LOBYTE((DbcsChar))),0)) : \
                                        ((WPARAM)((DbcsChar) & 0x00FF))                                   \
                                       )

#define MAKE_WPARAM_DBCSCHAR(DbcsChar) (IS_DBCS_MESSAGE((DbcsChar)) ?                                     \
                                        (MAKEWPARAM(MAKEWORD(HIBYTE((DbcsChar)),LOBYTE((DbcsChar))),0)) : \
                                        ((WPARAM)((DbcsChar) & 0x00FF))                                   \
                                       )
#endif // FE_SB

/*
 * Flags used for the WM_CLIENTSHUTDOWN wParam.
 */
#define WMCS_EXIT             0x0001
#define WMCS_QUERYEND         0x0002
#define WMCS_SHUTDOWN         0x0004
#define WMCS_CONTEXTLOGOFF    0x0008
#define WMCS_LOGOFF           ENDSESSION_LOGOFF  /* from winuser.w */

typedef struct tagDISPLAYRESOURCE {
    WORD cyThunb;
    WORD cxThumb;
    WORD xCompressIcon;
    WORD yCompressIcon;
    WORD xCompressCursor;
    WORD yCompressCursor;
    WORD yKanji;
    WORD cxBorder;
    WORD cyBorder;
} DISPLAYRESOURCE, *PDISPLAYRESOURCE;

/*
 * We don't need 64-bit intermediate precision so we use this macro
 * instead of calling MulDiv.
 */
#define MultDiv(x, y, z)        (((INT)(x) * (INT)(y) + (INT)(z) / 2) / (INT)(z))

typedef DWORD  ICH;
typedef ICH *LPICH;

typedef struct _PROPSET {
    HANDLE hData;
    ATOM atom;
} PROPSET, *PPROPSET;

/*
 * Special internal codes for menu item bitmaps. So that internally, we can
 * have menu items with bitmaps without having to store a second (or more)
 * copy of the bitmap.  Currently, these are only used for MDI hacks to place
 * restore and close bitmaps into the menu bar.
 */
#ifdef MEMPHIS_MENUS
#define MENUHBM_CALLBACK    0xFFFFFFFF
#endif // MEMPHIS_MENUS
#define MENUHBM_SYSTEM      1
#define MENUHBM_RESTORE     2
#define MENUHBM_MINIMIZE    3
#define MENUHBM_BULLET      4
#define MENUHBM_CLOSE       5
#define MENUHBM_CLOSE_D     6
#define MENUHBM_MINIMIZE_D  7
#define MENUHBM_MAX         8

#ifdef MEMPHIS_MENUS
#define HBMMENU_CALLBACK    ((HBITMAP) MENUHBM_CALLBACK  )
#define HBMMENU_SYSTEM      ((HBITMAP) MENUHBM_SYSTEM    )
#define HBMMENU_RESTORE     ((HBITMAP) MENUHBM_RESTORE   )
#define HBMMENU_MINIMIZE    ((HBITMAP) MENUHBM_MINIMIZE  )
#define HBMMENU_BULLET      ((HBITMAP) MENUHBM_BULLET    )
#define HBMMENU_CLOSE       ((HBITMAP) MENUHBM_CLOSE     )
#define HBMMENU_CLOSE_D     ((HBITMAP) MENUHBM_CLOSE_D   )
#define HBMMENU_MINIMIZE_D  ((HBITMAP) MENUHBM_MINIMIZE_D)
#define HBMMENU_MAX         ((HBITMAP) MENUHBM_MAX       )
#endif // MEMPHIS_MENUS

// Event stuff --------------------------------------------

typedef struct tagEVENT_PACKET {
    DWORD EventType;    // == apropriate afCmd filter flag
    WORD  fSense;       // TRUE means flag on is passed.
    WORD  cbEventData;  // size of data starting at Data field.
    DWORD Data;         // event specific data - must be last
} EVENT_PACKET, *PEVENT_PACKET;

// Window long offsets in mother window     (szDDEMLMOTHERCLASS)

#define GWL_INSTANCE_INFO   0       // PCL_INSTANCE_INFO


// Window long offsets in client window     (szDDEMLCLIENTCLASS)

#define GWL_PCI             0
#define GWL_CONVCONTEXT     GWL_PCI + sizeof(PVOID)
#define GWL_CONVSTATE       GWL_CONVCONTEXT + sizeof(CONVCONTEXT)   // See CLST_ flags
#define GWL_SHINST          GWL_CONVSTATE + sizeof(LONG)
#define GWL_CHINST          GWL_SHINST + sizeof(LONG)

#define CLST_CONNECTED              0
#define CLST_SINGLE_INITIALIZING    1
#define CLST_MULT_INITIALIZING      2

// Window long offsets in server window     (szDDEMLSERVERCLASS)

#define GWL_PSI             0

// Window long offsets in event window      (szDDEMLEVENTCLASS)

#define GWL_PSII            0

/*
 * Reserved console space.
 *
 * This was moved from the console code so that we can localize it
 * in one place.  This was necessary for dealing with the background
 * color, which we need to have for the hungapp drawing.  These are
 * stored in the extra-window-bytes of each console.
 */
#define GWL_CONSOLE_WNDALLOC  (3 * sizeof(DWORD))
#define GWL_CONSOLE_PID       0
#define GWL_CONSOLE_TID       4
#define GWL_CONSOLE_BKCOLOR   8


/*
 * DrawFrame defines
 */
#define DF_SHIFT0           0x0000
#define DF_SHIFT1           0x0001
#define DF_SHIFT2           0x0002
#define DF_SHIFT3           0x0003
#define DF_PATCOPY          0x0000
#define DF_PATINVERT        0x0004
#define DF_SHIFTMASK (DF_SHIFT0 | DF_SHIFT1 | DF_SHIFT2 | DF_SHIFT3)
#define DF_ROPMASK   (DF_PATCOPY | DF_PATINVERT)
#define DF_HBRMASK   ~(DF_SHIFTMASK | DF_ROPMASK)

#define DF_SCROLLBAR        (COLOR_SCROLLBAR << 3)
#define DF_BACKGROUND       (COLOR_BACKGROUND << 3)
#define DF_ACTIVECAPTION    (COLOR_ACTIVECAPTION << 3)
#define DF_INACTIVECAPTION  (COLOR_INACTIVECAPTION << 3)
#define DF_MENU             (COLOR_MENU << 3)
#define DF_WINDOW           (COLOR_WINDOW << 3)
#define DF_WINDOWFRAME      (COLOR_WINDOWFRAME << 3)
#define DF_MENUTEXT         (COLOR_MENUTEXT << 3)
#define DF_WINDOWTEXT       (COLOR_WINDOWTEXT << 3)
#define DF_CAPTIONTEXT      (COLOR_CAPTIONTEXT << 3)
#define DF_ACTIVEBORDER     (COLOR_ACTIVEBORDER << 3)
#define DF_INACTIVEBORDER   (COLOR_INACTIVEBORDER << 3)
#define DF_APPWORKSPACE     (COLOR_APPWORKSPACE << 3)
#define DF_3DSHADOW         (COLOR_3DSHADOW << 3)
#define DF_3DFACE           (COLOR_3DFACE << 3)
#define DF_GRAY             (COLOR_MAX << 3)


/*
 * CreateWindowEx internal flags for dwExStyle
 */

#define WS_EX_MDICHILD      0x00000040L         // Internal
#define WS_EX_ANSICREATOR   0x80000000L         // Internal

/*
 * Calculate the byte offset of a field in a structure of type type.
 */
#define FIELDOFFSET(type, field)    ((UINT)&(((type *)0)->field))

#define FLASTKEY 0x80

/*
 * Special types we've fabricated for special thunks.
 */
typedef struct {
    POINT point1;
    POINT point2;
    POINT point3;
    POINT point4;
    POINT point5;
} POINT5, *LPPOINT5;

typedef struct {
    DWORD dwRecipients;
    DWORD dwFlags;
} BROADCASTSYSTEMMSGPARAMS, *LPBROADCASTSYSTEMMSGPARAMS;
/*
 * Server side address constants. When we want to call a server side proc,
 * we pass an index indentifying the function, rather than the server side
 * address itself. More robust.  The functions between WNDPROCSTART/END
 * have client side sutbs which map to this routines.
 *
 * Adding a new FNID (This is just what I figured out...so fix it if wrong or incomplete)
 * -Decide what range it should be in:
 *      FIND_WNDPROCSTART to FIND_WNDPROCEND: Server side proc with client
 *          stub
 *      FIND_CONTROLSTART to FNID_CONTROLEND: Client side controls with no
 *          server side proc
 *      After FNID_CONTROLEND: other, like server side only procs or client
 *          side only....
 * -Make sure to adjust FNID_*START and FNID_*END appropriately.
 * -If the ID is to be associated with a window class, and it is for all
 *      windows of the class, make sure that the InternalRegisterClassEx call
 *      receives the id as a parameter.
 * -If in FNID_WNDPROCSTART-END range, make the proper STOCID call in InitFunctionTables.
 * -Add proper FNID call in InitFunctionTables.
 * -If the class has a client side worker function (pcls->lpfnWorker) or you expect
 *   apps to send messages to it or call its window proc directly, define
 *   a message table in kernel\server.c and initialize it in InitMessageTables.
 * -If there is a client side for this proc, you probably need to add it to
 *   PFNCLIENT.
 * -Add the debug-only text description of this FNID to in gapszFNID in globals.c
 */
#define FNID_START                  0x0000029A
#define FNID_WNDPROCSTART           0x0000029A

#define FNID_SCROLLBAR              0x0000029A      // xxxSBWndProc;
#define FNID_ICONTITLE              0x0000029B      // xxxTitleWndProc;
#define FNID_MENU                   0x0000029C      // xxxMenuWindowProc;
#define FNID_DESKTOP                0x0000029D      // xxxDesktopWndProc;
#define FNID_DEFWINDOWPROC          0x0000029E      // xxxDefWindowProc;

#define FNID_WNDPROCEND             0x0000029E      // see PatchThreadWindows
#define FNID_CONTROLSTART           0x0000029F

#define FNID_BUTTON                 0x0000029F      // No server side proc
#define FNID_COMBOBOX               0x000002A0      // No server side proc
#define FNID_COMBOLISTBOX           0x000002A1      // No server side proc
#define FNID_DIALOG                 0x000002A2      // No server side proc
#define FNID_EDIT                   0x000002A3      // No server side proc
#define FNID_LISTBOX                0x000002A4      // No server side proc
#define FNID_MDICLIENT              0x000002A5      // No server side proc
#define FNID_STATIC                 0x000002A6      // No server side proc

#ifdef FE_IME
#define FNID_IME                    0x000002A7      // No server side proc
#define FNID_CONTROLEND             0x000002A7

#define FNID_HKINLPCWPEXSTRUCT      0x000002A8
#define FNID_HKINLPCWPRETEXSTRUCT   0x000002A9
#define FNID_DEFFRAMEPROC           0x000002AA      // No server side proc
#define FNID_DEFMDICHILDPROC        0x000002AB      // No server side proc
#define FNID_MB_DLGPROC             0x000002AC      // No server side proc
#define FNID_MDIACTIVATEDLGPROC     0x000002AD      // No server side proc
#define FNID_SENDMESSAGE            0x000002AE
#else
#define FNID_CONTROLEND             0x000002A6

#define FNID_HKINLPCWPEXSTRUCT      0x000002A7
#define FNID_HKINLPCWPRETEXSTRUCT   0x000002A8
#define FNID_DEFFRAMEPROC           0x000002A9      // No server side proc
#define FNID_DEFMDICHILDPROC        0x000002AA      // No server side proc
#define FNID_MB_DLGPROC             0x000002AB      // No server side proc
#define FNID_MDIACTIVATEDLGPROC     0x000002AC      // No server side proc
#define FNID_SENDMESSAGE            0x000002AD
#define FNID_UNUSED                 0x000002AE      // !!! unused
#endif

#define FNID_CALLNEXTHOOKPROC       0x000002AF
#define FNID_SENDMESSAGEFF          0x000002B0
#define FNID_SENDMESSAGEEX          0x000002B1
#define FNID_CALLWINDOWPROC         0x000002B2
#define FNID_SENDMESSAGEBSM         0x000002B3
#define FNID_SWITCH                 0x000002B4      // Just used by GetTopMostInserAfter

#define FNID_END                    0x000002B4

/*
 * The size of the server side function table is defined as a power of two
 * so a simple "and" operation can be used to determine if a function index
 * is legal or not. Unused entries in the table are fill with a routine that
 * catches invalid functions that have indices within range, but are not
 * implemented.
 */

#define FNID_ARRAY_SIZE             32
#if (FNID_END - FNID_START + 1) > FNID_ARRAY_SIZE
#error"The size of the function array is greater than the allocated storage"
#endif

#define FNID_DDE_BIT                0x00002000    // Used by RegisterClassExWOW
#define FNID_CLEANEDUP_BIT          0x00004000
#define FNID_DELETED_BIT            0x00008000
#define FNID_STATUS_BITS            (FNID_CLEANEDUP_BIT | FNID_DELETED_BIT)

#define FNID(s)     (gpsi->mpFnidPfn[((DWORD)(s) - FNID_START) & (FNID_ARRAY_SIZE - 1)])
#define STOCID(s)   (gpsi->aStoCidPfn[(DWORD)((s) & ~FNID_STATUS_BITS) - FNID_START])
#define CBFNID(s)   (gpsi->mpFnid_serverCBWndProc[(DWORD)((s) & ~FNID_STATUS_BITS) - FNID_START])
#define GETFNID(pwnd)       ((pwnd)->fnid & ~FNID_STATUS_BITS)

#define FNID_TO_CLIENT_PFNA(s) (*(((DWORD *)&gpsi->apfnClientA) + (s - FNID_START)))
#define FNID_TO_CLIENT_PFNW(s) (*(((DWORD *)&gpsi->apfnClientW) + (s - FNID_START)))

/*
 * Structure passed by client during process initialization that holds some
 * client-side callback addresses.
 */
typedef struct _PFNCLIENT {
    PROC pfnScrollBarWndProc;       // and must be paired Unicode then ANSI
    PROC pfnTitleWndProc;
    PROC pfnMenuWndProc;
    PROC pfnDesktopWndProc;
    PROC pfnDefWindowProc;

// Below not in FNID_WNDPROCSTART FNID_WNDPROCEND range

    PROC pfnButtonWndProc;
    PROC pfnComboBoxWndProc;
    PROC pfnComboListBoxProc;
    PROC pfnDialogWndProc;
    PROC pfnEditWndProc;
    PROC pfnListBoxWndProc;
    PROC pfnMDIClientWndProc;
    PROC pfnStaticWndProc;
#ifdef FE_IME
    PROC pfnImeWndProc;
#endif

// Below not in FNID_CONTROLSTART FNID_CONTROLEND range

    PROC pfnHkINLPCWPSTRUCT;    // client-side callback for hook thunks
    PROC pfnHkINLPCWPRETSTRUCT; // client-side callback for hook thunks
    PROC pfnDispatchHook;
    PROC pfnDispatchMessage;
    PROC pfnMB_DlgProc;
    PROC pfnMDIActivateDlgProc;
} PFNCLIENT, *PPFNCLIENT;

/*
 * These types are needed before they are fully defined.
 */
typedef struct tagWND *PWND;
typedef struct tagQ *PQ;
typedef struct tagTHREADINFO *PTHREADINFO;
typedef struct tagPROCESSINFO *PPROCESSINFO;

DECLARE_HANDLE(HQ);

typedef LONG (APIENTRY *WNDPROC_PWND)(PWND, UINT, DWORD, LONG);
typedef LONG (APIENTRY *WNDPROC_PWNDEX)(PWND, UINT, DWORD, LONG, DWORD);
typedef BOOL (APIENTRY *WNDENUMPROC_PWND)(PWND, LPARAM);

/*
 * Object types
 *
 * NOTE: Changing this table means changing hard-coded arrays that depend
 * on the index number (in security.c and in debug.c)
 */
#define TYPE_FREE           0           // must be zero!
#define TYPE_WINDOW         1           // in order of use for C code lookups
#define TYPE_MENU           2
#define TYPE_CURSOR         3
#define TYPE_SETWINDOWPOS   4
#define TYPE_HOOK           5
#define TYPE_THREADINFO     6           // thread specific info structure
#define TYPE_CLIPDATA       7           // clipboard data
#define TYPE_CALLPROC       8
#define TYPE_ACCELTABLE     9
#define TYPE_DDEACCESS      10
#define TYPE_DDECONV        11
#define TYPE_DDEXACT        12          // DDE transaction tracking info.
#define TYPE_ZOMBIE         13
#define TYPE_KBDLAYOUT      14          // Keyboard Layout handle (HKL) object.
#define TYPE_KBDFILE        15          // Keyboard Layout file object.
#ifdef FE_IME
#define TYPE_INPUTCONTEXT   16          // Input Context info structure
#define TYPE_CTYPES         17          // Count of TYPEs; Must be LAST + 1
#else
#define TYPE_CTYPES         16          // Count of TYPEs; Must be LAST + 1
#endif
#define TYPE_GENERIC        255         // used for generic handle validation

/* OEM Bitmap Information Structure */
typedef struct tagOEMBITMAPINFO
{
    int     x;
    int     y;
    int     cx;
    int     cy;
} OEMBITMAPINFO, *POEMBITMAPINFO;

// For the following OBI_ defines :
//
// a  pushed   state bitmap should be at +1 from it's normal state bitmap
// an inactive state bitmap should be at +2 from it's normal state bitmap
// A small caption bitmap should be +2 from the normal bitmap

#define DOBI_NORMAL     0
#define DOBI_PUSHED     1
#define DOBI_INACTIVE   2

#define DOBI_CHECK      1   // checkbox/radio/3state button states
#define DOBI_DOWN       2
#define DOBI_CHECKDOWN  3

#define DOBI_CAPON      0   // caption states
#define DOBI_CAPOFF     1

// shared bitmap mappings
#define DOBI_3STATE         8   // offset from checkbox to 3state
#define DOBI_MBAR          13   // offset to menu bar equivalent

#define OBI_CLOSE            0      // caption close button
#define OBI_CLOSE_D          1
#define OBI_CLOSE_I          2
#define OBI_REDUCE           3      // caption minimize button
#define OBI_REDUCE_D         4
#define OBI_REDUCE_I         5
#define OBI_RESTORE          6      // caption restore button
#define OBI_RESTORE_D        7
#define OBI_HELP             8
#define OBI_HELP_D           9
#define OBI_ZOOM            10      // caption maximize button
#define OBI_ZOOM_D          11
#define OBI_ZOOM_I          12
#define OBI_CLOSE_MBAR      13      // menu bar close button
#define OBI_CLOSE_MBAR_D    14
#define OBI_CLOSE_MBAR_I    15
#define OBI_REDUCE_MBAR     16      // menu bar minimize button
#define OBI_REDUCE_MBAR_D   17
#define OBI_REDUCE_MBAR_I   18
#define OBI_RESTORE_MBAR    19      // menu bar restore button
#define OBI_RESTORE_MBAR_D  20
#define OBI_CAPCACHE1       21      // caption icon cache entry #1
#define OBI_CAPCACHE1_I     22
#define OBI_CAPCACHE2       23      // caption icon cache entry #2
#define OBI_CAPCACHE2_I     24
#define OBI_CAPCACHE3       25      // caption icon cache entry #3
#define OBI_CAPCACHE3_I     26
#define OBI_CAPCACHE4       27      // caption icon cache entry #4
#define OBI_CAPCACHE4_I     28
#define OBI_CAPCACHE5       29      // caption icon cache entry #5
#define OBI_CAPCACHE5_I     30
#define OBI_CAPBTNS         31      // caption buttons cache
#define OBI_CAPBTNS_I       32
#define OBI_CLOSE_PAL       33      // small caption close button
#define OBI_CLOSE_PAL_D     34
#define OBI_CLOSE_PAL_I     35
#define OBI_NCGRIP          36      // bottom/right size grip
#define OBI_UPARROW         37      // up scroll arrow
#define OBI_UPARROW_D       38
#define OBI_UPARROW_I       39
#define OBI_DNARROW         40      // down scroll arrow
#define OBI_DNARROW_D       41
#define OBI_DNARROW_I       42
#define OBI_RGARROW         43      // right scroll arrow
#define OBI_RGARROW_D       44
#define OBI_RGARROW_I       45
#define OBI_LFARROW         46      // left scroll arrow
#define OBI_LFARROW_D       47
#define OBI_LFARROW_I       48
#define OBI_MENUARROW       49      // menu hierarchy arrow
#define OBI_MENUCHECK       50      // menu check mark
#define OBI_MENUBULLET      51      // menu bullet mark
#define OBI_RADIOMASK       52      // radio button mask
#define OBI_CHECK           53      // check box
#define OBI_CHECK_C         54
#define OBI_CHECK_D         55
#define OBI_CHECK_CD        56
#define OBI_CHECK_CDI       57
#define OBI_RADIO           58      // radio button
#define OBI_RADIO_C         59
#define OBI_RADIO_D         60
#define OBI_RADIO_CD        61
#define OBI_RADIO_CDI       62
#define OBI_3STATE          63      // 3-state button
#define OBI_3STATE_C        64
#define OBI_3STATE_D        65
#define OBI_3STATE_CD       66
#define OBI_3STATE_CDI      67
#define OBI_COUNT           68      // bitmap count

typedef struct tagOEMINFO {

    OEMBITMAPINFO bm[OBI_COUNT];
    UINT          cyPixelsPerInch;    // logical pixels per inch in Y direction
    WORD          DispDrvExpWinVer;   // Display driver expected win version no
    BYTE          Planes;             // Planes
    BYTE          BitsPixel;          // Depth
    WORD          BitCount;           // Planes * Depth

    UINT          cxPixelsPerInch;    // Remove these when finished porting.
    int           fMouse;             //

}   OEMINFO, *POEMINFO;

#define RIPF_PROMPT             0x00000007
#define RIPF_PRINT              0x00000070
#define RIPF_VALIDUSERFLAGS     0x00000177

#define RIPF_PROMPTONERROR      0x00000001
#define RIPF_PROMPTONWARNING    0x00000002
#define RIPF_PROMPTONVERBOSE    0x00000004
#define RIPF_PRINTONERROR       0x00000010
#define RIPF_PRINTONWARNING     0x00000020
#define RIPF_PRINTONVERBOSE     0x00000040
#define RIPF_PRINTFILELINE      0x00000100
#define RIPF_KERNEL             0x08000000
#define RIPF_CAIRO              0x10000000
#define RIPF_DAYTONA            0x20000000
#define RIPF_CHECKED            0x40000000
#define RIPF_FREE               0x80000000

#define SET_RIP_FLAG(f)         gpsi->RipFlags |= (f)
#define CLEAR_RIP_FLAG(f)       gpsi->RipFlags &= ~(f)
#define TEST_RIP_FLAG(f)        (gpsi->RipFlags & (f))
#define TOGGLE_RIP_FLAG(f)      gpsi->RipFlags ^= (f)


/*
 * One global instance of this structure is allocated into memory that is
 * mapped into all clients' address space.  Client-side functions will
 * read this data to avoid calling the server.
 */

typedef struct tagSERVERINFO {      // si
    UINT RipFlags;                  // RIPF_ flags

    DWORD cHandleEntries;           // count of handle entries in array

    /*
     * Array of server-side function pointers.
     * Client passes servers function ID so they can be easily validated;
     * this array maps function ID into server-side function address.
     * The order of these are enforced by the FNID_ constants, and must match
     * the client-side mpFnidClientPfn[] order as well.
     */
    WNDPROC_PWNDEX mpFnidPfn[FNID_ARRAY_SIZE]; // function mapping table
    WNDPROC_PWND aStoCidPfn[(FNID_WNDPROCEND - FNID_START) + 1];

    // mapping of fnid to min bytes need by public windproc user
    WORD mpFnid_serverCBWndProc[(FNID_END - FNID_START) + 1];

    /*
     * Client side functions pointer structure.
     */
    struct _PFNCLIENT apfnClientA;
    struct _PFNCLIENT apfnClientW;

    DWORD dwDebugErrorLevel;

    /*
     * All of this information should be mapped to the server, but put in
     * the desktop section so it can vary from desktop to desktop.
     */

    int aiSysMet[SM_CMETRICS];
    COLORREF argbSystem[COLOR_MAX];
    POINT ptCursor;
    DWORD cbHandleTable;
    int nEvents;

    OEMINFO    oemInfo;
    int gclBorder;              /* # of logical units in window frame */

    UINT dtScroll;
    UINT dtLBSearch;
    UINT dtCaretBlink;
    BOOL fSnapTo;
    UINT ucWheelScrollLines;    /* # of lines to scroll when wheel is rolled */

    /*
     * Is the device palette managed ?
     */
    BOOL fPaletteDisplay;

    /*
     * Class atoms to allow fast checks on the client.
     */
    ATOM atomSysClass[ICLS_MAX];   // Atoms for control classes

    DWORD dwDefaultHeapBase;            // so WOW can do handle validation
    DWORD dwDefaultHeapSize;


    int  wMaxLeftOverlapChars;
    int  wMaxRightOverlapChars;

    RECT rcWork;

    UINT uiShellMsg;         // message for shell hooks
    /*
     * these are here to lose a thunk for GetDialogBaseUnits
     */
    int cxSysFontChar;
    int cySysFontChar;
    int cxMsgFontChar;
    int cyMsgFontChar;
    TEXTMETRIC tmSysFont;

    UINT wMaxBtnSize;   /* Size of the longest button string in any MessageBox */
    DWORD mpAllMBbtnStringsToSTR[MAX_MB_STRINGS];  /* MB button String IDs */
    DWORD AllMBbtnStrings[MAX_MB_STRINGS]; /* MB button String buffer offsets*/
    WCHAR szOK[10];
    WCHAR szCANCEL[15];
    WCHAR szYES[10];
    WCHAR szNO[10];
    WCHAR szABORT[15];
    WCHAR szRETRY[15];
    WCHAR szIGNORE[15];
    WCHAR szCLOSE[15];
    WCHAR szHELP[15];

    /*
     * values to allow HasCaptionIcon to be in user32
     */
    ATOM atomIconSmProp;
    ATOM atomIconProp;
    HICON hIconSmWindows;
    HICON hIcoWindows;
    HFONT hCaptionFont;
    HFONT hMsgFont;

    int cntMBox;

    ATOM atomContextHelpIdProp;

    DWORD dwKeyCache;
    DWORD dwAsyncKeyCache;
} SERVERINFO, *PSERVERINFO;

/* MessageBox String pointers from offset in the gpsi struct */
#define GETGPSIMBPSTR(u) (LPWSTR) ((LPBYTE)gpsi->AllMBbtnStrings + *(gpsi->AllMBbtnStrings+(u)))

typedef struct _WNDMSG {
    UINT maxMsgs;
    BYTE *abMsgs;
} WNDMSG, *PWNDMSG;

typedef struct tagSHAREDINFO {
    struct tagSERVERINFO  *psi;
    struct _HANDLEENTRY   *aheList;   // handle table pointer

    /*
     * This field is used for DLL preloading to allow custom functinality
     * for all windows processes.
     */
    LPWSTR pszDllList;

    WNDMSG awmControl[FNID_END - FNID_START + 1];

    WNDMSG DefWindowMsgs;
    WNDMSG DefWindowSpecMsgs;
} SHAREDINFO, *PSHAREDINFO;

typedef struct _USERCONNECT {
    IN  ULONG ulVersion;
    OUT ULONG ulCurrentVersion;
    OUT SHAREDINFO siClient;
} USERCONNECT, *PUSERCONNECT;

#define USER_MAJOR_VERSION  0x0002
#define USER_MINOR_VERSION  0x0002

#define USERCURRENTVERSION   MAKELONG(USER_MINOR_VERSION, USER_MAJOR_VERSION)

#define ptCursor (gpsi->ptCursor)
#define oemInfo (gpsi->oemInfo)

#define SYSRGB(index)       gpsi->argbSystem[COLOR_##index]
#define SYSHBR(index)       ahbrSystem[COLOR_##index]
#define SYSMET(index)       ((int)(gpsi->aiSysMet)[SM_##index])

/*
 * Options used for NtUserSetSysColors
 */
#define SSCF_NOTIFY             0x00000001
#define SSCF_FORCESOLIDCOLOR    0x00000002
#define SSCF_SETMAGICCOLORS     0x00000004

/*
 * Structure used for GetClipboardData, where we can have
 * extra information returned from the kernel.
 */
typedef struct tagGETCLIPBDATA {

    UINT   uFmtRet;          // Identifies returned format.
    BOOL   fGlobalHandle;    // Indicates if handle is global.
    HANDLE hLocale;          // Locale (text-type formats only).

} GETCLIPBDATA, *PGETCLIPBDATA;

/*
 * Structure used for SetClipboardData, where we can have
 * extra information passed to the kernel.
 */
typedef struct tagSETCLIPBDATA {

    BOOL fGlobalHandle;      // Indicates if handle is global.
    BOOL fIncSerialNumber;   // Indicates if we should increment serial#

} SETCLIPBDATA, *PSETCLIPBDATA;

/*
 * The following is the header of all objects managed in the handle list.
 * (allocated as part of the object for easy access).  All object
 * headers must start with the members of a HEAD structure.
 */
typedef struct _HEAD {
    HANDLE h;
    DWORD cLockObj;
} HEAD, *PHEAD;

typedef struct _SHROBJHEAD {
    HEAD;
    PDESKTOP rpdesk;
    PBYTE pSelf;
} SHROBJHEAD, *PSHROBJHEAD;

typedef struct _THROBJHEAD {
    SHROBJHEAD;
    PTHREADINFO pti;
} THROBJHEAD, *PTHROBJHEAD;

typedef struct _PROCOBJHEAD {
    SHROBJHEAD;
    struct tagPROCESSINFO *ppi;
    DWORD hTaskWow;
} PROCOBJHEAD, *PPROCOBJHEAD;

#define HANDLEF_DESTROY        0x01
#define HANDLEF_INDESTROY      0x02
#define HANDLEF_INWAITFORDEATH 0x04
#define HANDLEF_FINALDESTROY   0x08
#define HANDLEF_MARKED_OK      0x10

#define GETPTI(p)           ((p)->head.pti)

/*
 * The following is a handle table entry.
 *
 * Note that by keeping a pointer to the owning entity (process or
 * thread), cleanup will touch only those objects that belong to
 * the entity being destroyed.  This helps keep the working set
 * size down.  Look at DestroyProcessesObjects() for an example.
 */
typedef struct _HANDLEENTRY {
    PHEAD   phead;                  /* pointer to the real object */
    PVOID   pOwner;                 /* pointer to owning entity (pti or ppi) */
    BYTE    bType;                  /* type of object */
    BYTE    bFlags;                 /* flags - like destroy flag */
    WORD    wUniq;                  /* uniqueness count */
#ifdef DEBUG
    PLR     plr;                    /* lock record pointer */
#endif
} HANDLEENTRY, *PHE;

/*
 * Change HMINDEXBITS for bits that make up table index in handle
 * Change HMUNIQSHIFT for count of bits to shift uniqueness left.
 * Change HMUNIQBITS for bits that make up uniqueness.
 *
 * Currently 64K handles can be created, w/16 bits of uniqueness.
 */
#define HMINDEXBITS             0x0000FFFF      // bits where index is stored
#define HMUNIQSHIFT             16              // bits to shift uniqueness
#define HMUNIQBITS              0xFFFF          // valid uniqueness bits

#define HMHandleFromIndex(i)    ((HANDLE)(i | (gSharedInfo.aheList[i].wUniq << HMUNIQSHIFT)))
#define HMIndexFromHandle(h)    (((DWORD)h) & HMINDEXBITS)
#define HMPheFromObject(p)      (&gSharedInfo.aheList[HMIndexFromHandle(((PHEAD)p)->h)])
#define HMObjectFromHandle(h)   ((PVOID)(gSharedInfo.aheList[HMIndexFromHandle(h)].phead))
#define HMUniqFromHandle(h)     ((WORD)((((DWORD)h) >> HMUNIQSHIFT) & HMUNIQBITS))
#define HMObjectType(p)         (HMPheFromObject(p)->bType)

#define HMIsMarkDestroy(p)      (HMPheFromObject(p)->bFlags & HANDLEF_DESTROY)

#ifdef DEBUG
__inline HANDLE DebugPtoHq(HANDLE p)
{
    if (p == NULL) {
        UserAssert(0 && "PtoHq received NULL handle");
        return NULL;
    }

    return ((PHEAD) p)->h;
}
#endif


/*
 * Validation, handle mapping, etc.
 */
#define HMRevalidateHandle(h)       HMValidateHandle(h, TYPE_GENERIC)
#define HMRevalidateHandleNoRip(h)  HMValidateHandleNoRip(h, TYPE_GENERIC)
#define RevalidateHmenu(hmenuX)     HMValidateHandleNoRip(hmenuX, TYPE_MENU)
#define PtoH(p)     ((HANDLE)((p) == NULL ? NULL : ((PHEAD)(p))->h))

#ifdef DEBUG
#define PtoHq(p)    DebugPtoHq(p)
#else
#define PtoHq(p)    ((HANDLE)(((PHEAD)p)->h))
#endif

#define HW(pwnd)    ((HWND)PtoH(pwnd))
#define HWq(pwnd)   ((HWND)PtoHq(pwnd))

/*
 * NOTE!: there is code in exitwin.c that assumes HMIsMarkDestroy is defined as
 *      (HMPheFromObject(p)->bFlags & HANDLEF_DESTROY)
 */

#define CPD_ANSI_TO_UNICODE     0x0001      /* CPD represents ansi to U transition */
#define CPD_UNICODE_TO_ANSI     0x0002
#define CPD_TRANSITION_TYPES    (CPD_ANSI_TO_UNICODE|CPD_UNICODE_TO_ANSI)

#define CPD_CLASS               0x0010      /* Get CPD for a class */
#define CPD_WND                 0x0020
#define CPD_DIALOG              0x0040
#define CPD_WNDTOCLS            0x0080

#define CPDHANDLE_HI            0xFFFF
#define MAKE_CPDHANDLE(h)       (MAKELONG((WORD)h,CPDHANDLE_HI))
#define ISCPDTAG(x)             (HIWORD(x) == CPDHANDLE_HI)

/*
 * Call Proc Handle Info
 */
typedef struct _CALLPROCDATA {
    THROBJHEAD      head;
    struct _CALLPROCDATA *pcpdNext;
    DWORD           pfnClientPrevious;
    WORD            wType;
} CALLPROCDATA, *PCALLPROCDATA;

/*
 * Class styles
 */
#define CFVREDRAW         0x0001
#define CFHREDRAW         0x0002
#define CFKANJIWINDOW     0x0004
#define CFDBLCLKS         0x0008
#define CFSERVERSIDEPROC  0x0010    // documented as reserved in winuser.h
#define CFOWNDC           0x0020
#define CFCLASSDC         0x0040
#define CFPARENTDC        0x0080
#define CFNOKEYCVT        0x0101
#define CFNOCLOSE         0x0102
#define CFLVB             0x0104
#define CFSAVEBITS        0x0108
#define CFOEMCHARS        0x0140
#ifdef FE_IME
#define CFIME             0x0201
#endif
#define CFCACHEDSMICON    0x0304

/*
 * Offset from the beginning of the CLS structure to the WNDCLASS section.
 */
#define CFOFFSET             (sizeof(CLS) - sizeof(COMMON_WNDCLASS))

#define TestCF(hwnd, flag)   (*((BYTE *)((PWND)(hwnd))->pcls + CFOFFSET + HIBYTE(flag)) & LOBYTE(flag))
#define SetCF(hwnd, flag)    (*((BYTE *)((PWND)(hwnd))->pcls + CFOFFSET + HIBYTE(flag)) |= LOBYTE(flag))
#define ClrCF(pcls, flag)    (*((BYTE *)((PWND)(hwnd))->pcls + CFOFFSET + HIBYTE(flag)) &= ~LOBYTE(flag))

#define TestCF2(pcls, flag)  (*((BYTE *)(pcls) + CFOFFSET + (int)HIBYTE(flag)) & LOBYTE(flag))
#define SetCF2(pcls, flag)   (*((BYTE *)(pcls) + CFOFFSET + (int)HIBYTE(flag)) |= LOBYTE(flag))
#define ClrCF2(pcls, flag)   (*((BYTE *)(pcls) + CFOFFSET + (int)HIBYTE(flag)) &= ~LOBYTE(flag))

/* Window class structure */
typedef struct tagCOMMON_WNDCLASS
{
    UINT        style;
    WNDPROC_PWND lpfnWndProc;       // HI BIT on means WOW PROC
    int         cbclsExtra;
    int         cbwndExtra;
    HANDLE      hModule;
    struct tagCURSOR *spicn;
    struct tagCURSOR *spcur;
    HBRUSH      hbrBackground;
    LPWSTR      lpszMenuName;
    LPSTR       lpszAnsiClassName;
    struct tagCURSOR *spicnSm;
} COMMON_WNDCLASS;
/*
 * Class Menu names structure. For performance reasons (GetClassInfo)
 *  we keep two client side copies of wndcls.lpszMenu and another kernel side copy.
 * This structure is used to pass menu names info between client and kernel.
 */
typedef struct tagCLSMENUNAME
{
    LPSTR               pszClientAnsiMenuName;
    LPWSTR              pwszClientUnicodeMenuName;
    PUNICODE_STRING     pusMenuName;
} CLSMENUNAME, *PCLSMENUNAME;

/*
 * This is the window class structure.  All window classes are linked
 * together in a master list pointed to by pclsList.
 *
 * RED ALERT! Do not add any fields after the COMMON_WNDCLASS structure;
 *            CFOFFSET depends on this.
 */

typedef struct tagCLS {
    /* NOTE: The order of the following fields is assumed. */
    struct tagCLS *pclsNext;
    ATOM        atomClassName;
    WORD        fnid;               // record window proc used by this hwnd
                                    // access through GETFNID
    PVOID       hheapDesktop;       /* Allocation source */
    struct tagDESKTOP *rpdeskParent;/* Parent desktop */
    struct tagDCE *pdce;            /* PDCE to DC associated with class */
    int         cWndReferenceCount; /* The number of windows registered
                                       with this class */
    DWORD       flags;              /* internal class flags */
    LPSTR       lpszClientAnsiMenuName;     /* string or resource ID */
    LPWSTR      lpszClientUnicodeMenuName;  /* string or resource ID */

    /*
     * These DWORDs are used by WOW only.  See wow32\walias.c for the WC
     * structure definition.
     */
    DWORD       adwWOW[2];
                                    /* LATER: No one uses dwExpWinVer. wow? */
    DWORD       hTaskWow;           /* LATER: is wow using this? */
    PCALLPROCDATA  spcpdFirst;      /* Pointer to first CallProcData element (or 0) */
    struct tagCLS *pclsBase;        /* Pointer to base class */
    struct tagCLS *pclsClone;       /* Pointer to clone class list */

    PROC        lpfnWorker;         /* Client side worker proc */

    COMMON_WNDCLASS;
    /*
     * WARNING:
     * CFOFFSET expects COMMON_WNDCLASS to be last fields in CLS
     */
} CLS, *PCLS, *LPCLS, **PPCLS;

/*
 * This class flag is used to distinguish classes that were registered
 * by the server (most system classes) from those registered by the client.
 */
#define CSF_SERVERSIDEPROC      0x00000001
#define CSF_ANSIPROC            0x00000002
#define CSF_WOWDEFERDESTROY     0x00000004
#define CSF_SYSTEMCLASS         0x00000008

/*
 * SBDATA are the values for one scrollbar
 */

typedef struct tagSBDATA {
    int    posMin;
    int    posMax;
    int    page;
    int    pos;
} SBDATA, *PSBDATA;

/*
 * SBINFO is the set of values that hang off of a window structure, if the
 * window has scrollbars.
 */
typedef struct tagSBINFO {
    int WSBflags;
    SBDATA Horz;
    SBDATA Vert;
} SBINFO, *PSBINFO;

typedef struct tagWND {          // wnd
    THROBJHEAD    head;

    struct tagWND *spwndNext;    // Handle to the next window
    struct tagWND *spwndParent;  // Backpointer to the parent window.
    struct tagWND *spwndChild;   // Handle to child
    struct tagWND *spwndOwner;   // Popup window owner field

    PVOID         pwo;          // WNDOBJ in gdi that is associated with window

    RECT          rcWindow;     // Window outer rectangle
    RECT          rcClient;     // Client rectangle

    WNDPROC_PWND lpfnWndProc;   // HI BIT on means WOW PROC

    PCLS          pcls;         // Pointer to window class
    int           cbwndExtra;   // Extra bytes in window

    HRGN          hrgnUpdate;   // Accumulated paint region

    struct tagWND *spwndLastActive; // Last active in owner/ownee list
    struct tagPROP *ppropList;  // Pointer to first property in list
    PSBINFO        pSBInfo;   // Words used for scrolling

    struct tagMENU *spmenuSys;  // Handle to system menu
    struct tagMENU *spmenu;     // Menu handle or ID
    LARGE_UNICODE_STRING strName;

    /*
     * Fullscreen information
     */
    BYTE          bFullScreen;  // record full screen state info
    BYTE          cDC;          // count of DCs associated with window
    WORD          fnid;         // record window proc used by this hwnd
                                // access through GETFNID
    DWORD         dwExpWinVer;  // matches expwinver of hModule

    DWORD         dwUserData;   // Reserved for random application data
    HDC           hdcOwn;
    HRGN          hrgnClip;     // Clipping region for this window
    int           iHungRedraw;  // Index into hung redraw table
#ifdef FE_IME
    DWORD         hImc;         // Associated input context handle
#endif

    WW;         // WOW-USER common fields. Defined in wowuserp.h
                //  The position of this structure is assumed by
                //  the STATEOFFSET macro. Specifically, WW must be the
                //  last "field" of WND.
} WND;

#define NEEDSPAINT(pwnd)    (pwnd->hrgnUpdate != NULL || TestWF(pwnd, WFINTERNALPAINT))

/*
 * Window Property structure
 */
typedef struct tagPROP {        // prop
    struct tagPROP *ppropNext;
    HANDLE hData;
    ATOM atomKey;
    UINT fs;
} PROP, *PPROP;

#define PROPF_INTERNAL   0x0001
#define PROPF_STRING     0x0002

#ifdef FE_IME
/*
 * kernel side input context structure.
 */
typedef struct tagIMC {    /* hImc */
    THROBJHEAD      head;
    struct tagIMC   *pImcNext;
    DWORD           dwClientImcData;        // Client side data
    HWND            hImeWnd;                // in use Ime Window
} IMC, *PIMC;
#endif


/*
 * Hook structure.
 */
#undef HOOKBATCH
typedef struct tagHOOK {   /* hk */
    THROBJHEAD      head;
    struct tagHOOK  *sphkNext;
    int             iHook;              // WH_xxx hook type
    DWORD           offPfn;
    UINT            flags;              // HF_xxx flags
    int             ihmod;
    PTHREADINFO     ptiHooked;
#ifdef HOOKBATCH
    DWORD           cEventMessages;     // Number of events in the cache
    DWORD           iCurrentEvent;      // Current cache event
    DWORD           CacheTimeOut;       // Timeout between keys
    PEVENTMSG       aEventCache;        // The array of Events
#endif // HOOKBATCH
} HOOK, *PHOOK;

/*
 * Hook defines.
 */
#define HF_GLOBAL          0x0001
#define HF_ANSI            0x0002
#define HF_NEEDHC_SKIP     0x0004
#define HF_HUNG            0x0008      // Hook Proc hung don't call if system
#define HF_HOOKFAULTED     0x0010      // Hook Proc faulted
#define HF_NOPLAYBACKDELAY 0x0020      // Ignore requested delay
#define HF_WX86KNOWNDLL    0x0040      // Hook Module is x86 machine type

/*
 * Macro to convert the WH_* index into a bit position for
 * the fsHooks fields of SERVERINFO and THREADINFO.
 */
#define WHF_FROM_WH(n)     (1 << (n + 1))

/*
 * Flags for IsHooked().
 */
#define WHF_MSGFILTER       WHF_FROM_WH(WH_MSGFILTER)
#define WHF_JOURNALRECORD   WHF_FROM_WH(WH_JOURNALRECORD)
#define WHF_JOURNALPLAYBACK WHF_FROM_WH(WH_JOURNALPLAYBACK)
#define WHF_KEYBOARD        WHF_FROM_WH(WH_KEYBOARD)
#define WHF_GETMESSAGE      WHF_FROM_WH(WH_GETMESSAGE)
#define WHF_CALLWNDPROC     WHF_FROM_WH(WH_CALLWNDPROC)
#define WHF_CALLWNDPROCRET  WHF_FROM_WH(WH_CALLWNDPROCRET)
#define WHF_CBT             WHF_FROM_WH(WH_CBT)
#define WHF_SYSMSGFILTER    WHF_FROM_WH(WH_SYSMSGFILTER)
#define WHF_MOUSE           WHF_FROM_WH(WH_MOUSE)
#define WHF_HARDWARE        WHF_FROM_WH(WH_HARDWARE)
#define WHF_DEBUG           WHF_FROM_WH(WH_DEBUG)
#define WHF_SHELL           WHF_FROM_WH(WH_SHELL)
#define WHF_FOREGROUNDIDLE  WHF_FROM_WH(WH_FOREGROUNDIDLE)


/*
 * Windowstation and desktop enum list structure.
 */
typedef struct tagNAMELIST {
    DWORD cb;
    DWORD cNames;
    WCHAR awchNames[1];
} NAMELIST, *PNAMELIST;

/*
 * Device Information Structure.
 *
 *   Contains devmodes and 3D-DDI information
 *   for each graphics mode for each adapter.
 */

#define USER_DEVICE_NOTOWNED   0
#define USER_DEVICE_SHARED     1
#define USER_DEVICE_EXCLUSIVE  2

typedef struct tagPHYSICAL_DEV_INFO {

    WCHAR     szNtDeviceName[16]; // Log-name of device (\\Device\\Videox)
    PVOID     pDeviceHandle;      // Handle for that device, if it exist
    PVOID     pFileObject;        // Handle for that device, if it exist
    UCHAR     DevOwned;           // If device is used, and if exclusive or not.
    ULONG     cOwnCount;          // How many times the handle has been given.
    DWORD     stateFlags;         // Flags describing the state of the device
    PDEVMODEW pCurrentDevmode;    // Pointer to the current DEVMODE for this device.
    ULONG     cbdevmodeInfo;      // Size of the devmode information
    PDEVMODEW devmodeInfo;        // Pointer to list of modes for the device

} PHYSICAL_DEV_INFO, *PPHYSICAL_DEV_INFO;

/*
 * Display Information Structure.
 *
 *   This structure defines the display attributes for the
 *   desktop.  This is usually maintained in the DESKTOPINFO
 *   structure.
 */
typedef struct tagDISPLAYINFO {

    HDC                hdcScreen;        // Device-Context for screen
    HDC                hdcGray;          // GrayString DC.
    HDC                hdcBits;          // Holds system-bitmap resource
    HBITMAP            hbmGray;          // GrayString Bitmap Surface.
    RECT               rcScreen;         // Rectangle of entire desktop surface
    RECT               rcPrimaryScreen;  // Rectangle of main screen
    int                cxGray;           //
    int                cyGray;           //
    PDCE               pdceFirst;        //
    PSPB               pspbFirst;        //
    HANDLE             hDev;             //
    LPVOID             pDevLock;         //
    PPHYSICAL_DEV_INFO pDevInfo;         //

    UINT               cxPixelsPerInch;  // when the gpsi is moved to the
    UINT               cyPixelsPerInch;  // desktop.  There's no need
    UINT               cPlanes;          // to maintain two copies then.
    UINT               cBitsPixel;       //

} DISPLAYINFO, *PDISPLAYINFO;

#define DTF_NEEDSPALETTECHANGED      0x00000001
#define DTF_NEEDSREDRAW              0x00000002

#define CWINHOOKS       (WH_MAX - WH_MIN + 1)

/*
 * Desktop Information Structure.
 *
 *   This structure contains information regading the
 *   desktop.  This is viewable from both the client and
 *   kernel processes.
 */
typedef struct tagDESKTOPINFO {

    PVOID                 pvDesktopBase;          // For handle validation
    PVOID                 pvDesktopLimit;         //
    struct tagWND         *spwnd;                 // Desktop window
    DWORD                 fsHooks;                // Deskop global hooks
    struct tagHOOK        *asphkStart[CWINHOOKS]; // List of hooks
    struct tagWND         *spwndShell;            // Shell window
    DWORD                 idShellProcess;         // Shell Process ID
    struct tagWND         *spwndBkGnd;            // Shell background window
    struct tagWND         *spwndTaskman;          // Task-Manager window
    struct tagWND         *spwndProgman;          // Program-Manager window
    int                   nShellHookPwnd;         //
    struct tagWND         **papwndShellHook;      //

} DESKTOPINFO, *PDESKTOPINFO;

#define CURSOR_ALWAYSDESTROY    0
#define CURSOR_CALLFROMCLIENT   1
#define CURSOR_THREADCLEANUP    2

#define CURSORF_FROMRESOURCE    0x0001 // it was loaded from a resource
#define CURSORF_GLOBAL          0x0002 // it never dies
#define CURSORF_LRSHARED        0x0004 // its cached
#define CURSORF_ACON            0x0008 // its animated
#define CURSORF_WOWCLEANUP      0x0010 // marked for cleanup at wow task exit time
#define CURSORF_ACONFRAME       0x0040 // its a frame of an acon
#define CURSORF_SECRET          0x0080 // created internally - not exposed to apps
#define CURSORF_LINKED          0x0100 // linked into a cache
#define CURSORF_VALID           0x01DF

typedef struct tagCURSORDATA {
    DWORD   CURSORF_flags;
    LPWSTR  lpName;
    LPWSTR  lpModName;
    WORD    rt;
    WORD    dummy;
    DWORD   bpp;                // --------------------------------------
    DWORD   cx;                 //  SetCursorIconData() hack:
    DWORD   cy;                 //  This part must
    SHORT   xHotspot;           //  match the end of
    SHORT   yHotspot;           //  the CURSOR
    HBITMAP hbmMask;            //  structure!
    HBITMAP hbmColor;           // ---------------------------------------

    int     cpcur;              // ---------------------------------------
    int     cicur;              //  This part must
    struct  tagCURSOR **aspcur; //  match the end of
    DWORD   *aicur;             //  the ACON
    PJIF    ajifRate;           //  Structure!
    int     iicur;              //
    DWORD   fl;                 // ---------------------------------------
} CURSORDATA, *PCURSORDATA;


typedef struct tagCURSORFIND {

    HCURSOR hcur;
    DWORD   rt;
    DWORD   cx;
    DWORD   cy;
    DWORD   bpp;

} CURSORFIND, *PCURSORFIND;



#define WIDTHBYTES(i) \
    ((((i) + 31) & ~31) >> 3)

#define BITMAPWIDTHSIZE(cx, cy, planes, bpp) \
    (WIDTHBYTES((cx * bpp)) * (cy) * (planes))

/*** AWESOME HACK ALERT!
 *
 * Window Style and State Masks -
 *
 * High byte of word is byte index from the start of the state field
 * in the WND structure, low byte is the mask to use on the byte.
 * These masks assume the order of the state and style fields of a
 * window instance structure.
 *
 * This is how the Test/Set/Clr/MaskWF value ranges map to the corresponding
 * fields in the window structure.
 *
 *   offset                 WND field
 *   0 - 3                  state
 *   4 - 7                  state2
 *   8 - B                  ExStyle
 *   C - F                  style
 *
 */

/*
 * State flags
 */
#define WFMPRESENT              0x0001
#define WFVPRESENT              0x0002
#define WFHPRESENT              0x0004
#define WFCPRESENT              0x0008
#define WFSENDSIZEMOVE          0x0010
#define WFNOPAINT               0x0020
#define WFFRAMEON               0x0040
#define WFHASSPB                0x0080
#define WFNONCPAINT             0x0101
#define WFSENDERASEBKGND        0x0102
#define WFERASEBKGND            0x0104
#define WFSENDNCPAINT           0x0108
#define WFINTERNALPAINT         0x0110
#define WFUPDATEDIRTY           0x0120
#define WFHIDDENPOPUP           0x0140
#define WFMENUDRAW              0x0180

/*
 * Place to throw more internal flags: in 0x05?? thru 0x07??.
 */
#define WFDIALOGWINDOW          0x0201
#define WFTITLESET              0x0202
#define WFSERVERSIDEPROC        0x0204
#define WFANSIPROC              0x0208
#define WF16BIT                 0x0210
#define WFHASPALETTE            0x0220
#define WFPAINTNOTPROCESSED     0x0240  // WM_PAINT message not processed
#define WFWIN31COMPAT           0x0280  // Win 3.1 compatible window
#define WFALWAYSSENDNCPAINT     0x0301  // Always send WM_NCPAINT to children
#define WFPIXIEHACK             0x0302  // Send (HRGN)1 to WM_NCPAINT (see PixieHack)
#define WFTOGGLETOPMOST         0x0304  // Toggle the WS_EX_TOPMOST bit ChangeStates
#define WFREDRAWIFHUNG          0x0308
#define WFREDRAWFRAMEIFHUNG     0x0310
#define WFANYHUNGREDRAW         0x0318
#define WFANSICREATOR           0x0320
#define WFPALETTEWINDOW         0x0340
#define WFDESTROYED             0x0380
#define WFWMPAINTSENT           0x0401
#define WFDONTVALIDATE          0x0402
#define WFSTARTPAINT            0x0404
#define WFOLDUI                 0x0408
#define WFCEPRESENT             0x0410  // Client edge present
#define WFBOTTOMMOST            0x0420  // Bottommost window
#define WFFULLSCREEN            0x0440
#define WFWIN40COMPAT           0x0480  // Win 4.0 compatible app
#define WFSYNCPAINTPENDING      0x0501
#define WFBEINGACTIVATED        0x0502  // prevent recursion in xxxActivateThis Window
#define WFINDESTROY             0x0504

/*
 * Window Extended Style
 */
#define WEFDLGMODALFRAME        0x0801
#define WEFDRAGOBJECT           0x0802
#define WEFNOPARENTNOTIFY       0x0804
#define WEFTOPMOST              0x0808
#define WEFACCEPTFILES          0x0810
#define WEFTRANSPARENT          0x0820  // "Transparent" child window
#define WEFMDICHILD             0x0840
#define WEFTOOLWINDOW           0x0880
#define WEFWINDOWEDGE           0x0901
#define WEFCLIENTEDGE           0x0902
#define WEFEDGEMASK             0x0903
#define WEFCONTEXTHELP          0x0904

// intl styles
#define WEFRIGHT                0x0910
#define WEFRTLREADING           0x0920
#define WEFLEFTSCROLL           0x0940

#define WEFCONTROLPARENT        0x0A01
#define WEFSTATICEDGE           0x0A02
#define WEFAPPWINDOW            0x0A04
#define WFNOANIMATE             0x0A10
#define WFSMQUERYDRAGICON       0x0A20  // Small icon comes from WM_QUERYDRAGICON
#define WFSHELLHOOKWND          0x0A80


/*
 * Window styles
 */
#define WFMAXBOX                0x0E01
#define WFTABSTOP               0x0E01
#define WFMINBOX                0x0E02
#define WFGROUP                 0x0E02
#define WFSIZEBOX               0x0E04
#define WFSYSMENU               0x0E08
#define WFHSCROLL               0x0E10
#define WFVSCROLL               0x0E20
#define WFDLGFRAME              0x0E40
#define WFTOPLEVEL              0x0E40
#define WFBORDER                0x0E80
#define WFBORDERMASK            0x0EC0
#define WFCAPTION               0x0EC0

#define WFTILED                 0x0F00
#define WFMAXIMIZED             0x0F01
#define WFCLIPCHILDREN          0x0F02
#define WFCLIPSIBLINGS          0x0F04
#define WFDISABLED              0x0F08
#define WFVISIBLE               0x0F10
#define WFMINIMIZED             0x0F20
#define WFCHILD                 0x0F40
#define WFPOPUP                 0x0F80
#define WFTYPEMASK              0x0FC0
#define WFICONICPOPUP           0x0FC0
#define WFICONIC                WFMINIMIZED

// Buttons
#define BFTYPEMASK              0x0C0F

#define BFRIGHTBUTTON           0x0C20
#define BFICON                  0x0C40
#define BFBITMAP                0x0C80
#define BFIMAGEMASK             0x0CC0

#define BFLEFT                  0x0D01
#define BFRIGHT                 0x0D02
#define BFCENTER                0x0D03
#define BFHORZMASK              0x0D03
#define BFTOP                   0x0D04
#define BFBOTTOM                0x0D08
#define BFVCENTER               0x0D0C
#define BFVERTMASK              0x0D0C
#define BFALIGNMASK             0x0D0F

#define BFPUSHLIKE              0x0D10
#define BFMULTILINE             0x0D20
#define BFNOTIFY                0x0D40
#define BFFLAT                  0x0D80

// Combos
#define CBFSIMPLE               0x0C01
#define CBFDROPDOWN             0x0C02
#define CBFDROPDOWNLIST         0x0C03

#define CBFEDITABLE             0x0C01
#define CBFDROPPABLE            0x0C02
#define CBFDROPTYPE             0x0C03

#define CBFOWNERDRAWFIXED       0x0C10
#define CBFOWNERDRAWVAR         0x0C20
#define CBFOWNERDRAW            0x0C30

#define CBFAUTOHSCROLL          0x0C40
#define CBFOEMCONVERT           0x0C80
#define CBFSORT                 0x0D01
#define CBFHASSTRINGS           0x0D02
#define CBFNOINTEGRALHEIGHT     0x0D04
#define CBFDISABLENOSCROLL      0x0D08
#define CBFBUTTONUPTRACK        0x0D10

#define CBFUPPERCASE            0x0D20
#define CBFLOWERCASE            0x0D40

// Dialogs
#define DFSYSMODAL              0x0C02
#define DF3DLOOK                0x0C04
#define DFNOFAILCREATE          0x0C10
#define DFLOCALEDIT             0x0C20
#define WFNOIDLEMSG             0x0D01
#define DFCONTROL               0x0D04

// Edits
#define EFMULTILINE             0x0C04
#define EFUPPERCASE             0x0C08
#define EFLOWERCASE             0x0C10
#define EFPASSWORD              0x0C20
#define EFAUTOVSCROLL           0x0C40
#define EFAUTOHSCROLL           0x0C80
#define EFNOHIDESEL             0x0D01
#define EFCOMBOBOX              0x0D02
#define EFOEMCONVERT            0x0D04
#define EFREADONLY              0x0D08
#define EFWANTRETURN            0x0D10
#define EFNUMBER                0x0D20

// Scrollbars
#define SBFSIZEBOXTOPLEFT       0x0C02
#define SBFSIZEBOXBOTTOMRIGHT   0x0C04
#define SBFSIZEBOX              0x0C08
#define SBFSIZEGRIP             0x0C10

// Statics
#define SFTYPEMASK              0x0C1F
#define SFNOPREFIX              0x0C80
#define SFNOTIFY                0x0D01
#define SFCENTERIMAGE           0x0D02
#define SFRIGHTJUST             0x0D04
#define SFREALSIZEIMAGE         0x0D08
#define SFSUNKEN                0x0D10
#define SFEDITCONTROL           0x0D20
#define SFELLIPSISMASK          0x0DC0


/*
 *
 */
#define SYS_ALTERNATE           0x2000
#define SYS_PREVKEYSTATE        0x4000

/*** AWESOME HACK ALERT!!!
 *
 * The low byte of the WF?PRESENT state flags must NOT be the
 * same as the low byte of the WFBORDER and WFCAPTION flags,
 * since these are used as paint hint masks.  The masks are calculated
 * with the MaskWF macro below.
 *
 * The magnitude of this hack compares favorably with that of the national debt.
 *
 * STATEOFFSET is the offset into the WND structure of the state field.
 * The state field is actually part of the WW structure defined in wowuserp.h
 * which is embedded at the end of the WND structure.
 */
#define STATEOFFSET (sizeof(WND) - sizeof(WW) + (WND_CNT_WOWDWORDS * sizeof(DWORD)))


/*
 * Redefine LOBYTE to get rid of compiler warning C4309:
 * 'cast' : truncation of constant value
 */
#ifdef LOBYTE
#undef LOBYTE
#endif
#define LOBYTE(w)            ((BYTE)((w) & 0x00FF))

#define TestWF(hwnd, flag)   (*(((BYTE *)(hwnd)) + STATEOFFSET + (int)HIBYTE(flag)) & LOBYTE(flag))
#define SetWF(hwnd, flag)    (*(((BYTE *)(hwnd)) + STATEOFFSET + (int)HIBYTE(flag)) |= LOBYTE(flag))
#define ClrWF(hwnd, flag)    (*(((BYTE *)(hwnd)) + STATEOFFSET + (int)HIBYTE(flag)) &= ~LOBYTE(flag))
#define MaskWF(flag)         ((WORD)( (HIBYTE(flag) & 1) ? LOBYTE(flag) << 8 : LOBYTE(flag)))


#define TestwndChild(hwnd)   (TestWF(hwnd, WFTYPEMASK) == LOBYTE(WFCHILD))
#define TestwndIPopup(hwnd)  (TestWF(hwnd, WFTYPEMASK) == LOBYTE(WFICONICPOPUP))
#define TestwndTiled(hwnd)   (TestWF(hwnd, WFTYPEMASK) == LOBYTE(WFTILED))
#define TestwndNIPopup(hwnd) (TestWF(hwnd, WFTYPEMASK) == LOBYTE(WFPOPUP))
#define TestwndPopup(hwnd)   (TestwndNIPopup(hwnd) || TestwndIPopup(hwnd))
#define TestwndHI(hwnd)      (TestwndTiled(hwnd) || TestwndIPopup(hwnd))

#define GetChildParent(pwnd) (TestwndChild(pwnd) ? pwnd->spwndParent : NULL)
#define GetWindowCreator(pwnd) (TestwndChild(pwnd) ? pwnd->spwndParent : pwnd->spwndOwner)
#define TestwndFrameOn(pwnd) (TestWF(pwnd, WFFRAMEON) && (GETPTI(pwnd)->pq == gpqForeground))
//#define FTrueVis(pwnd)       (pwnd->fs & WF_TRUEVIS)
#define FTrueVis(pwnd)       (_IsWindowVisible(pwnd))
#define _IsWindowEnabled(pwnd) (TestWF(pwnd, WFDISABLED)  == 0)
#define _IsIconic(pwnd)        (TestWF(pwnd, WFMINIMIZED) != 0)
#define _IsZoomed(pwnd)        (TestWF(pwnd, WFMAXIMIZED) != 0)

#define SV_UNSET        0x0000
#define SV_SET          0x0001
#define SV_CLRFTRUEVIS  0x0002

/*
 * System menu IDs
 */
#define ID_SYSMENU              0x10
#define ID_CLOSEMENU            0x20
#define CHILDSYSMENU            ID_CLOSEMENU
#define ID_DIALOGSYSMENU        0x30

/*
 * Menu Item Structure
 */
typedef struct tagITEM {
    UINT    fType;          // Item Type  Flags
    UINT    fState;         // Item State Flags
    UINT    wID;
    struct tagMENU *spSubMenu;  /* Handle to a popup */
    HANDLE  hbmpChecked;    /* Bitmap for an on  check */
    HANDLE  hbmpUnchecked;   /* Bitmap for an off check */
#ifdef MEMPHIS_MENUS
    LPWSTR  lpstr;          //item's text
#endif // MEMPHIS_MENUS
    HANDLE  hTypeData;     // if ownerdraw, MAKELONG(width, height)
                            // if bitmap,    hBitmap
                            // if separator, 0L
                            // if string,    LPWSTR
    DWORD   cch;                /* String: WCHAR count */
    DWORD   dwItemData;
    DWORD   xItem;
    DWORD   yItem;
    DWORD   cxItem;

    DWORD   cyItem;
    DWORD   dxTab;
    DWORD   ulX;                /* String: Underline start */
    DWORD   ulWidth;            /* String: underline width */
#ifdef MEMPHIS_MENUS
    HBITMAP hbmp;           // item's bitmap
    int     cxBmp;          // bitmap width
    int     cyBmp;          // bitmap height
#endif // MEMPHIS_MENUS
} ITEM, *PITEM, *LPITEM;

/*
 * Menu Structure
 */
typedef struct tagMENU {
    PROCOBJHEAD     head;
    DWORD           fFlags;         /* Menu Flags */
    int             iItem;          /* Contains the position of the selected
                                       item in the menu. -1 if no selection */
    int             iPopupMenuItem; /* Contains the position of the hierarchical
                                       item menu popup */
    UINT            cAlloced;       // Number of items that can fit in rgItems
    UINT            cItems;         /* Number of items in rgItems */

    DWORD           cxMenu;
    DWORD           cyMenu;
    struct tagWND *spwndNotify;     /* The owner hwnd of this menu */
    PITEM           rgItems;        /* The list of items in this menu */
    DWORD           dwContextHelpId;// Context help Id for the whole menu
#ifdef MEMPHIS_MENU_WATERMARKS
    HBRUSH          hbrBack;        // background brush for menu
#endif // MEMPHIS_MENU_WATERMARKS

} MENU, *PMENU;


/*
 *  Items used for WinHelp and Context Sensitive help support
 */

#define ID_HELPMENU            4

// WINHELP4 invoked type
enum {
        TYPE_NORMAL,
        TYPE_POPUP,
        TYPE_TCARD
};

typedef struct tagDLGENUMDATA {
    PWND    pwndDialog;
    PWND    pwndControl;
    POINT   ptCurHelp;
} DLGENUMDATA, *PDLGENUMDATA;

BOOL CALLBACK EnumPwndDlgChildProc(PWND pwnd, LPARAM lParam);
BOOL FIsParentDude(PWND pwnd);


#define MNF_DONTSKIPSEPARATORS      0x0001

/*
 * The following masks can be used along with the wDisableFlags field of SB
 * to find if the Up/Left or Down/Right arrow or Both are disabled;
 * Now it is possible to selectively Enable/Disable just one or both the
 * arrows in a scroll bar control;
 */
#define LTUPFLAG    0x0001  // Left/Up arrow disable flag.
#define RTDNFLAG    0x0002  // Right/Down arrow disable flag.

typedef struct tagSBCALC {
    SBDATA;               /* this must be first -- we cast structure pointers */
    int    pxTop;
    int    pxBottom;
    int    pxLeft;
    int    pxRight;
    int    cpxThumb;
    int    pxUpArrow;
    int    pxDownArrow;
    int    pxStart;         /* Initial position of thumb */
    int    pxThumbBottom;
    int    pxThumbTop;
    int    cpx;
    int    pxMin;
} SBCALC, *PSBCALC;

typedef struct tagSBTRACK {
    DWORD  fHitOld : 1;
    DWORD  fTrackVert : 1;
    DWORD  fCtlSB : 1;
    DWORD  fTrackRecalc: 1;
    PWND   spwndTrack;
    PWND   spwndSB;
    PWND   spwndSBNotify;
    RECT   rcTrack;
    VOID   (*xxxpfnSB)(PWND, UINT, DWORD, LONG, PSBCALC);
    UINT   cmdSB;
    UINT   hTimerSB;
    int    dpxThumb;        /* Offset from mouse point to start of thumb box */
    int    pxOld;           /* Previous position of thumb */
    int    posOld;
    int    posNew;
    int    nBar;
    PSBCALC pSBCalc;
} SBTRACK, *PSBTRACK;

/*
 * How many times a thread can spin through get/peek message without idling
 * before the system puts the app in the background.
 */
#define CSPINBACKGROUND 100

#define CCHTITLEMAX     256

#define SW_MDIRESTORE   0xCC    /* special xxxMinMaximize() command for MDI */

/*
 * This is used by CreateWindow() - the 16 bit version of CW_USEDEFAULT,
 * that we still need to support.
 */
#define CW2_USEDEFAULT      0x8000
#define CW_FLAGS_DIFFHMOD   0x80000000


/*
 * Menu commands
 */
//#define MENUBIT             (0x8000)
//#define MENUUP              (0x8000 | VK_UP)
//#define MENUDOWN            (0x8000 | VK_DOWN)
//#define MENULEFT            (0x8000 | VK_LEFT)
//#define MENURIGHT           (0x8000 | VK_RIGHT)
//#define MENUEXECUTE         TEXT('\r')      /* Return character */
#define MENUSYSMENU         TEXT(' ')       /* Space character */
#define MENUCHILDSYSMENU    TEXT('-')       /* Hyphen */

#define MF_ALLSTATE         0x00FF
#define MF_MAINMENU         0xFFFF
#define MFMWFP_OFFMENU      0
#define MFMWFP_MAINMENU     0x0000FFFF
#define MFMWFP_NOITEM       (UINT)(-1)
#define MFMWFP_ALTMENU      (UINT)(-2)
#define MFMWFP_FIRSTITEM    0


/*
 * NOTE: SMF() can only be used on single bit flags (NOT MRGFDISABLED!).
 */
#define SetMF(pmenu, flag)    ((pmenu)->fFlags |=  flag)
#define ClearMF(pmenu, flag)  ((pmenu)->fFlags &= ~flag)
#define TestMF(pmenu, flag)   ((pmenu)->fFlags &   flag)

#define SetMFS(pitem, flag)   ((pitem)->fState |=  (flag))
#define TestMFS(pitem, flag)  ((pitem)->fState &   (flag))
#define ClearMFS(pitem, flag) ((pitem)->fState &= ~(flag))

#define SetMFT(pitem, flag)   ((pitem)->fType |=  (flag))
#define TestMFT(pitem, flag)  ((pitem)->fType &   (flag))
#define ClearMFT(pitem, flag) ((pitem)->fType &= ~(flag))

/*
 * Dialog structure (dlg). The window-words for the dialog structure must
 * be EXACTLY 30 bytes long! This is because Windows 3.0 exported a constant
 * called DLGWINDOWEXTRA that resolved to 30. Although we could redefine this
 * for 32-bit windows apps, we cannot redefine it for 16 bit apps (it is
 * a difficult problem). So instead we peg the window-words at 30 bytes
 * exactly, and allocate storage for the other information.
 */
typedef struct _DLG {
    WNDPROC lpfnDlg;
    DWORD   flags;          /* Various useful flags -- see definitions below */
    int     cxChar;
    int     cyChar;
    HWND    hwndFocusSave;
    UINT    fEnd      : 1;
    UINT    fDisabled : 1;
    int     result;         /* DialogBox result */
    HANDLE  hData;          /* Global handle for edit ctl storage. */
    HFONT   hUserFont;      /* Handle of the font mentioned by the user in template*/
    HWND    hwndSysModalSave;  /* Previous sysmodal window saved here */
} DLG, *PDLG;

typedef struct _DIALOG {
    WND     wnd;
    long    resultWP;       /* window proc result -- DWL_MSGRESULT (+0) */
    PDLG    pdlg;
    long    unused;         /* DWL_USER (+8) */
    BYTE    reserved[DLGWINDOWEXTRA - sizeof(long) - sizeof(PDLG) - sizeof(long)];
} DIALOG, *PDIALOG;

#define PDLG(pwnd) (((PDIALOG)pwnd)->pdlg)

/*
 * Flags definitions for DLG.flags
 */
#define DLGF_ANSI           0x01    /* lpfnDlg is an ANSI proc */

#define TIF_INCLEANUP               (UINT)0x00000001
#define TIF_16BIT                   (UINT)0x00000002
#define TIF_SYSTEMTHREAD            (UINT)0x00000004
#define TIF_CSRSSTHREAD             (UINT)0x00000008
#define TIF_TRACKRECTVISIBLE        (UINT)0x00000010
#define TIF_ALLOWFOREGROUNDACTIVATE (UINT)0x00000020
#define TIF_DONTATTACHQUEUE         (UINT)0x00000040
#define TIF_DONTJOURNALATTACH       (UINT)0x00000080
#define TIF_SCREENSAVER             (UINT)0x00000100
#define TIF_INACTIVATEAPPMSG        (UINT)0x00000200
#define TIF_SPINNING                (UINT)0x00000400
#define TIF_PALETTEAWARE            (UINT)0x00000800
#define TIF_SHAREDWOW               (UINT)0x00001000
#define TIF_FIRSTIDLE               (UINT)0x00002000
#define TIF_WAITFORINPUTIDLE        (UINT)0x00004000
#define TIF_MOVESIZETRACKING        (UINT)0x00008000
#define TIF_VDMAPP                  (UINT)0x00010000
#define TIF_DOSEMULATOR             (UINT)0x00020000
#define TIF_GLOBALHOOKER            (UINT)0x00040000
#define TIF_DELAYEDEVENT            (UINT)0x00080000
#define TIF_ALLOWSHUTDOWN           (UINT)0x00100000
#define TIF_SHUTDOWNCOMPLETE        (UINT)0x00200000
#define TIF_IGNOREPLAYBACKDELAY     (UINT)0x00400000
#define TIF_ALLOWOTHERACCOUNTHOOK   (UINT)0x00800000
#define TIF_GUITHREADINITIALIZED    (UINT)0x02000000
#ifdef FE_IME
#define TIF_DISABLEIME              (UINT)0x04000000
#endif
#ifdef FE_SB // TIF_INGETTEXTLENGTH
#define TIF_INGETTEXTLENGTH         (UINT)0x08000000
#endif // FE_SB
#define TIF_DISABLEHOOKS            (UINT)0x10000000

/*
 * Client Thread Information Structure.
 *
 *   This structure contains information regarding the
 *   thread.  This is viewable from both the client and
 *   kernel processes.
 */
typedef struct tagCLIENTTHREADINFO {
    UINT        CTIF_flags;
    WORD        fsChangeBits;           // Bits changes since last compared
    WORD        fsWakeBits;             // Bits currently available
    WORD        fsWakeBitsJournal;      // Bits saved while journalling
    WORD        fsWakeMask;             // Bits looking for when asleep
    LONG        timeLastRead;           // Time of last input read
} CLIENTTHREADINFO, *PCLIENTTHREADINFO;

#define CTIF_SYSQUEUELOCKED         (UINT)0x00000001

/*
 * First check for a 0, 0 filter which means we want all input.
 * If inverted message range, filter is exclusive.
 */
#define CheckMsgFilter(wMsg, wMsgFilterMin, wMsgFilterMax)                 \
    (   ((wMsgFilterMin) == 0 && (wMsgFilterMax) == 0xFFFFFFFF)            \
     || (  ((wMsgFilterMin) > (wMsgFilterMax))                             \
         ? (((wMsg) <  (wMsgFilterMax)) || ((wMsg) >  (wMsgFilterMin)))    \
         : (((wMsg) >= (wMsgFilterMin)) && ((wMsg) <= (wMsgFilterMax)))))

UINT    CalcWakeMask(UINT wMsgFilterMin, UINT wMsgFilterMax);

typedef struct tagCARET {
    struct tagWND *spwnd;
    UINT    fVisible : 1;
    UINT    fOn      : 1;
    int     iHideLevel;
    int     x;
    int     y;
    int     cy;
    int     cx;
    HBITMAP hBitmap;
    UINT    hTimer;
    DWORD   tid;
} CARET, *PCARET;

/*
 * vkey table counts, macros, etc. input synchonized key state tables have
 * 2 bits per vkey: fDown, fToggled. Async key state tables have 3 bits:
 * fDown, fToggled, fDownSinceLastRead.
 *
 * Important! The array gafAsyncKeyState matches the bit positions of the
 * afKeyState array in each thread info block. The fDownSinceLastRead bit
 * for the async state is stored in a separate bit array, called
 * gafAsyncKeyStateRecentDown.
 *
 * It is important that the bit positions of gafAsyncKeyState and
 * pti->afKeyState match because we copy from one to the other to maintain
 * key state synchronization between threads.
 *
 * These macros below MUST be used when setting / querying key state.
 */
#define CVKKEYSTATE                 256
#define CBKEYSTATE                  (CVKKEYSTATE >> 2)
#define CBKEYSTATERECENTDOWN        (CVKKEYSTATE >> 3)

#define TestKeyDownBit(pb, vk)\
        (pb[vk >> 2] & (1 << ((vk & 3) << 1)))
#define SetKeyDownBit(pb, vk)\
        (pb[vk >> 2] |= (1 << ((vk & 3) << 1)))
#define ClearKeyDownBit(pb, vk)\
        (pb[vk >> 2] &= ~(1 << ((vk & 3) << 1)))
#define TestKeyToggleBit(pb, vk)\
        (pb[vk >> 2] & (1 << (((vk & 3) << 1) + 1)))
#define SetKeyToggleBit(pb, vk)\
        (pb[vk >> 2] |= (1 << (((vk & 3) << 1) + 1)))
#define ClearKeyToggleBit(pb, vk)\
        (pb[vk >> 2] &= ~(1 << (((vk & 3) << 1) + 1)))
#define TestKeyRecentDownBit(pb, vk)\
        (pb[vk >> 3] & (1 << (vk & 7)))
#define SetKeyRecentDownBit(pb, vk)\
        (pb[vk >> 3] |= (1 << (vk & 7)))
#define ClearKeyRecentDownBit(pb, vk)\
        (pb[vk >> 3] &= ~(1 << (vk & 7)))

#define TestKeyStateDown(pq, vk)\
        TestKeyDownBit(pq->afKeyState, vk)
#define SetKeyStateDown(pq, vk)\
        SetKeyDownBit(pq->afKeyState, vk)
#define ClearKeyStateDown(pq, vk)\
        ClearKeyDownBit(pq->afKeyState, vk)
#define TestKeyStateToggle(pq, vk)\
        TestKeyToggleBit(pq->afKeyState, vk)
#define SetKeyStateToggle(pq, vk)\
        SetKeyToggleBit(pq->afKeyState, vk)
#define ClearKeyStateToggle(pq, vk)\
        ClearKeyToggleBit(pq->afKeyState, vk)

#define TestAsyncKeyStateDown(vk)\
        TestKeyDownBit(gafAsyncKeyState, vk)
#define SetAsyncKeyStateDown(vk)\
        SetKeyDownBit(gafAsyncKeyState, vk)
#define ClearAsyncKeyStateDown(vk)\
        ClearKeyDownBit(gafAsyncKeyState, vk)
#define TestAsyncKeyStateToggle(vk)\
        TestKeyToggleBit(gafAsyncKeyState, vk)
#define SetAsyncKeyStateToggle(vk)\
        SetKeyToggleBit(gafAsyncKeyState, vk)
#define ClearAsyncKeyStateToggle(vk)\
        ClearKeyToggleBit(gafAsyncKeyState, vk)

#define TestAsyncKeyStateRecentDown(vk)\
        TestKeyRecentDownBit(gafAsyncKeyStateRecentDown, vk)
#define SetAsyncKeyStateRecentDown(vk)\
        SetKeyRecentDownBit(gafAsyncKeyStateRecentDown, vk)
#define ClearAsyncKeyStateRecentDown(vk)\
        ClearKeyRecentDownBit(gafAsyncKeyStateRecentDown, vk)

#define XPixFromXDU(x, cxChar)       MultDiv(x, cxChar, 4)
#define YPixFromYDU(y, cyChar)       MultDiv(y, cyChar, 8)
#define XDUFromXPix(x, cxChar)       MultDiv(x, 4, cxChar)
#define YDUFromYPix(y, cyChar)       MultDiv(y, 8, cyChar)


/*
 * Flags for the Q structure.
 */
#define QF_UPDATEKEYSTATE         (UINT)0x00001
#define QF_INALTTAB               (UINT)0x00002
#define QF_FMENUSTATUSBREAK       (UINT)0x00004
#define QF_FMENUSTATUS            (UINT)0x00008
#define QF_FF10STATUS             (UINT)0x00010
#define QF_MOUSEMOVED             (UINT)0x00020
#define QF_ACTIVATIONCHANGE       (UINT)0x00040 // This flag is examined in the
                                                // menu loop code so that we
                                                // exit from menu mode if
                                                // another window was activated
                                                // while we were tracking
                                                // menus. This flag is set
                                                // whenever we activate a new
                                                // window.

#define QF_TABSWITCHING           (UINT)0x00080 // This bit is used as a
                                                // safety check when alt-
                                                // tabbing between apps.  It
                                                // tells us when to expect
                                                // a tab-switch in dwp.c.

#define QF_KEYSTATERESET          (UINT)0x00100
#define QF_INDESTROY              (UINT)0x00200
#define QF_LOCKNOREMOVE           (UINT)0x00400
#define QF_FOCUSNULLSINCEACTIVE   (UINT)0x00800
#define QF_DIALOGACTIVE           (UINT)0x04000
#define QF_EVENTDEACTIVATEREMOVED (UINT)0x08000
#define QF_TRACKMOUSELEAVE        (UINT)0x20000
#define QF_TRACKMOUSEHOVER        (UINT)0x40000
#define QF_TRACKMOUSEFIRING       (UINT)0x80000

/*
 * Constants for GetRealClientRect
 */
#define GRC_SCROLLS     0x0001
#define GRC_MINWNDS     0x0002
#define GRC_FULLSCREEN  0x0004

/*
 * Scroll bar info structure
 */
typedef struct tagSBWND {
    WND    wnd;
    BOOL   fVert;
    UINT   wDisableFlags;       /* Indicates which arrow is disabled; */
    SBCALC SBCalc;
} SBWND, *PSBWND, *LPSBWND;

#define MAXREGION       (HRGN)1

/*
 * SendMsgTimeout client/server transition struct
 */
typedef struct tagSNDMSGTIMEOUT {   /* smto */
    UINT fuFlags;                       // how to send the message, SMTO_BLOCK, SMTO_ABORTIFHUNG
    UINT uTimeout;                      // time-out duration
    UINT lSMTOReturn;                   // return value TRUE or FALSE
    UINT lSMTOResult;                   // result value for lpdwResult
} SNDMSGTIMEOUT, *PSNDMSGTIMEOUT;

/*
 *  Button data structures (use to be in usercli.h)
 */
typedef struct tagBUTN {
    PWND spwnd;
    UINT buttonState;   // Leave this a word for compatibility with SetWindowWord( 0L )
    HANDLE hFont;
    HANDLE hImage;
} BUTN, *PBUTN;

typedef struct tagBUTNWND {
    WND wnd;
    PBUTN pbutn;
} BUTNWND, *PBUTNWND;

#ifdef FE_IME
/*
 * IME control data structures
 */
typedef struct tagIMEUI {
    PWND  spwnd;
    DWORD hIMC;
    HWND  hwndIMC;
    HKL   hKL;
    HWND  hwndUI;               // To keep handle for UI window.
    int   nCntInIMEProc;        // Non-zero if hwnd has called into ImeWndProc.
    BOOL  fShowStatus:1;        // TRUE if don't want to show IME's window.
    BOOL  fActivate:1;          // TRUE if hwnd has called into ImeWndProc.
    BOOL  fDestroy:1;           // TRUE if hwnd has called into ImeWndProc.
    BOOL  fDefault:1;           // TRUE if this is the default IME.
    BOOL  fChildThreadDef:1;    // TRUE if this is the default IME which
                                // thread has only child window.
} IMEUI, *PIMEUI;

typedef struct tagIMEWND {
    WND wnd;
    PIMEUI pimeui;
} IMEWND, *PIMEWND;

#endif

/*
 * SysErrorBox is a 3.1 API that has no 32-bit equivalent.  It's
 * implemented for WOW in harderr.c.
 */
#define MAX_SEB_STYLES  9  /* number of SEB_* values */

#define  SEB_OK         1  /* Button with "OK".     */
#define  SEB_CANCEL     2  /* Button with "Cancel"  */
#define  SEB_YES        3  /* Button with "&Yes"     */
#define  SEB_NO         4  /* Button with "&No"      */
#define  SEB_RETRY      5  /* Button with "&Retry"   */
#define  SEB_ABORT      6  /* Button with "&Abort"   */
#define  SEB_IGNORE     7  /* Button with "&Ignore"  */
#define  SEB_CLOSE      8  /* Button with "&Close"   */
#define  SEB_HELP       9  /* Button with "&Help"    */

#define  SEB_DEFBUTTON  0x8000  /* Mask to make this button default */

typedef struct _MSGBOXDATA {            // mbd
    MSGBOXPARAMS;                       // Must be 1st item in structure
    PWND     pwndOwner;                 // Converted hwndOwner
    WORD     wLanguageId;
    INT    * pidButton;                 // Array of button IDs
    LPWSTR * ppszButtonText;            // Array of button text strings
    UINT     cButtons;                  // Number of buttons
    UINT     DefButton;
    UINT     CancelId;
} MSGBOXDATA, *PMSGBOXDATA, *LPMSGBOXDATA;

LPWSTR MB_GetString(UINT wBtn);
int    SoftModalMessageBox(LPMSGBOXDATA lpmb);

DWORD GetContextHelpId(PWND pwnd);

PITEM  MNLookUpItem(PMENU pMenu, UINT wCmd, BOOL fByPosition, PMENU *ppMenuItemIsOn);
BOOL _MNCanClose(PWND pwnd);
PMENU GetSysMenuHandle(PWND pwnd);
PWND    GetPrevPwnd(PWND pwndList, PWND pwndFind);
BOOL   _RegisterServicesProcess(DWORD dwProcessId);

BOOL _FChildVisible(PWND pwnd);

#define CH_PREFIX TEXT('&')


BOOL RtlWCSMessageWParamCharToMB(DWORD msg, PDWORD pWParam);
BOOL RtlMBMessageWParamCharToWCS(DWORD msg, PDWORD pWParam);

VOID RtlInitLargeAnsiString(PLARGE_ANSI_STRING plstr, LPCSTR psz,
        UINT cchLimit);
VOID RtlInitLargeUnicodeString(PLARGE_UNICODE_STRING plstr, LPCWSTR psz,
        UINT cchLimit);

DWORD RtlGetExpWinVer(HANDLE hmod);


/***************************************************************************\
*
*  Structure for client-side thread-info.
*   dwHookCurrent HIWORD is current hook filter type (eg: WH_GETMESSAGE)
*                 LOWORD is TRUE if current hook is ANSI, FALSE if Unicode
*
\***************************************************************************/


/*
 * Hook thunks.
 */
DWORD CALLBACK fnHkINLPRECT(DWORD nCode,
        DWORD wParam, LPRECT lParam,
        DWORD xParam, DWORD xpfnProc);
DWORD CALLBACK fnHkINDWORD(DWORD nCode,
        DWORD wParam, LONG lParam,
        DWORD xParam, DWORD xpfnProc, LPDWORD lpFlags);
DWORD CALLBACK fnHkINLPMSG(DWORD nCode,
        DWORD wParam, LPMSG lParam,
        DWORD xParam, DWORD xpfnProc, BOOL bAnsi, LPDWORD lpFlags);
DWORD CALLBACK fnHkOPTINLPEVENTMSG(DWORD nCode,
        DWORD wParam, LPEVENTMSGMSG lParam,
        DWORD xParam, DWORD xpfnProc);
DWORD CALLBACK fnHkINLPDEBUGHOOKSTRUCT(DWORD nCode,
        DWORD wParam, LPDEBUGHOOKINFO lParam,
        DWORD xParam, DWORD xpfnProc);
DWORD CALLBACK fnHkINLPMOUSEHOOKSTRUCT(DWORD nCode,
        DWORD wParam, LPMOUSEHOOKSTRUCT lParam,
        DWORD xParam, DWORD xpfnProc, LPDWORD lpFlags);
DWORD CALLBACK fnHkINLPCBTACTIVATESTRUCT(DWORD nCode,
        DWORD wParam, LPCBTACTIVATESTRUCT lParam,
        DWORD xParam, DWORD xpfnProc);
DWORD CALLBACK fnHkINLPCBTCSTRUCT(UINT msg,
        DWORD wParam, LPCBT_CREATEWND pcbt,
        DWORD xpfnProc, BOOL bAnsi);
DWORD CALLBACK fnHkINLPCBTMDICCSTRUCT(UINT msg,
        DWORD wParam, LPCBT_CREATEWND pcbt,
        DWORD xpfnProc, BOOL bAnsi);


/***************************************************************************\
*
* Definitions for client/server-specific data referenced by rtl routines.
*
\***************************************************************************/

extern HBRUSH ahbrSystem[];
extern HBRUSH   ghbrWhite;
extern HBRUSH   ghbrBlack;
extern HBRUSH   ghbrGray;


DWORD GetCPD(PVOID pWndOrCls, DWORD options, DWORD dwData);

BOOL TestWindowProcess(PWND pwnd);
DWORD GetAppCompatFlags(PTHREADINFO pti);
PWND _GetDesktopWindow(VOID);

/***************************************************************************\
*
* Shared function prototypes
*
\***************************************************************************/


PVOID FASTCALL HMValidateHandle(HANDLE h, BYTE btype);
PVOID FASTCALL HMValidateHandleNoRip(HANDLE h, BYTE btype);

DWORD   MapClientNeuterToClientPfn(PCLS pcls, DWORD dw, BOOL bAnsi);
DWORD   MapServerToClientPfn(DWORD dw, BOOL bAnsi);

BOOL IsSysFontAndDefaultMode(HDC hdc);
int GetCharDimensions(HDC hDC, TEXTMETRICW *lpTextMetrics, LPINT lpcy);
int GetWindowBorders(LONG lStyle, DWORD dwExStyle, BOOL fWindow, BOOL fClient);
PWND SizeBoxHwnd(PWND pwnd);
WORD  _GetWindowWord(PWND pwnd, int index);
DWORD _GetWindowLong(PWND pwnd, int index, BOOL bAnsi);
BOOL _GetClientRect(PWND pwnd, LPRECT prc);
void GetRealClientRect(PWND pwnd, LPRECT prc, UINT uFlags);
BOOL _GetWindowRect(PWND pwnd, LPRECT prc);
PWND _GetLastActivePopup(PWND pwnd);
PWND GetTopLevelTiled(PWND pwnd);
BOOL _IsChild(PWND pwndParent, PWND pwnd);
BOOL _AdjustWindowRectEx(LPRECT lprc, LONG style, BOOL fMenu, DWORD dwExStyle);
BOOL NeedsWindowEdge(DWORD dwStyle, DWORD dwExStyle, BOOL fNewApp);
BOOL _ClientToScreen(PWND pwnd, PPOINT ppt);
BOOL _ScreenToClient(PWND pwnd, PPOINT ppt);
int _MapWindowPoints(PWND pwndFrom, PWND pwndTo, LPPOINT lppt, DWORD cpt);
BOOL _IsWindowVisible(PWND pwnd);
BOOL _IsDescendant(PWND pwndParent, PWND pwndChild);
BOOL IsVisible(PWND pwnd);
PWND _GetWindow(PWND pwnd, UINT cmd);
PWND _GetParent(PWND pwnd);
int    FindNCHit(PWND pwnd, LONG lPt);
SHORT  _GetKeyState(int vk);
PHOOK  _PhkNext(PHOOK phk);

PPROP _FindProp(PWND pwnd, LPWSTR pszKey, BOOL fInternal);
HANDLE _GetProp(PWND pwnd, LPWSTR pszKey, BOOL fInternal);
BOOL _HasCaptionIcon(PWND pwnd);
PWND GetTopLevelWindow(PWND pwnd);

BOOL _SBGetParms(PWND pwnd, int code, PSBDATA pw, LPSCROLLINFO lpsi);
BOOL PSMGetTextExtent(HDC hdc, LPWSTR lpstr, int cch, PSIZE psize);

LONG   GetPrefixCount(LPCWSTR lpstr, int cb, LPWSTR lpstrCopy, int cbCopy);
PMENU _GetSubMenu(PMENU pMenu, int nPos);
DWORD _GetMenuDefaultItem(PMENU pMenu, BOOL fByPosition, UINT uFlags);
UINT _GetMenuState(PMENU pMenu, UINT wID, UINT dwFlags);

BOOL APIENTRY CopyInflateRect(LPRECT prcDst, CONST RECT *prcSrc, int cx, int cy);
BOOL APIENTRY CopyOffsetRect(LPRECT prcDst, CONST RECT *prcSrc, int cx, int cy);

DWORD FindCharPosition(LPWSTR lpString, WCHAR ch);
LPWSTR  TextAlloc(LPCWSTR lpsz);
UINT  TextCopy(PLARGE_UNICODE_STRING pstr, LPWSTR lpstr, UINT size);
DWORD wcsncpycch(LPWSTR pwsDest, LPCWSTR pwszSrc, DWORD cch);
DWORD strncpycch(LPSTR pszDest, LPCSTR pszSrc, DWORD cch);

#define TextPointer(h) ((LPWSTR)h)

BOOL DrawFrame(HDC hdc, LPRECT prect, int clFrame, int cmd);
void DrawPushButton(HDC hdc, LPRECT lprc, UINT state, UINT flags);
void ClientFrame(HDC hDC, CONST RECT *pRect, HBRUSH hBrush, DWORD patOp);

void PSMTextOut( HDC hdc, int xLeft, int yTop,
    LPWSTR lpsz, int cch);

HBITMAP OwnerLoadBitmap(
    HANDLE hInstLoad,
    LPWSTR lpName,
    HANDLE hOwner);

PCURSOR ClassSetSmallIcon(
    PCLS pcls,
    PCURSOR pcursor,
    BOOL fServerCreated);

#define DO_DROPFILE 0x454C4946L

/*
 * EndTask, ExitWindows, hung app, etc time outs
 */
#define CMSSLEEP                250
#define CMSHUNGAPPTIMEOUT       (5 * 1000)
#define CMSWAITTOKILLTIMEOUT    (20 * 1000)

void KernelBP(void);

#endif // _USER_
