/* macro definitions for compressed-table C/FTL programs generated by flex */

#include "flexcom.h"

/* reinitializes everything except the current start condition.  The last
 * input character is set to a newline so an initial beginning-of-line
 * rule will match
 */
#define YY_INIT \
	{ \
	yyleng = yy_c_buf_p = yy_e_buf_p = 0; \
	yy_hold_char = yy_ch_buf[yy_c_buf_p] = '\n'; \
	yytext = &yy_ch_buf[yy_c_buf_p]; \
	yy_saw_eof = 0; \
	}

/* returns the length of the matched text */
#define YY_LENG (yy_c_buf_p - yy_b_buf_p + 1)

/* done before the next pattern has been matched action */
#define YY_DO_BEFORE_SCAN \
	yytext[yyleng] = yy_hold_char;

/* done after the current pattern has been matched and before the corresponding action */
#define YY_DO_BEFORE_ACTION \
	yytext = &yy_ch_buf[yy_b_buf_p]; \
	yyleng = YY_LENG; \
	yy_hold_char = yytext[yyleng]; \
	yytext[yyleng] = '\0';

/* find the next rule matched */
#ifdef FLEX_REJECT_ENABLED
#define REJECT \
        { \
	YY_DO_BEFORE_SCAN; /* undo effects of setting up yytext */ \
	yy_c_buf_p = yy_full_match; /* restore possibly backed-over text */ \
        ++yy_lp; \
        goto find_rule; \
        }
#else
#define REJECT YY_FATAL_ERROR( "REJECT used and scanner was not generated using -r" )
#endif
