
 #	Copyright 1992,1993, Digital Equipment Corporation
 #
 # This software is furnished under a license and may be used and  copied
 # only  in  accordance  with  the  terms  of  such  license and with the
 # inclusion of the above copyright notice.  This software or  any  other
 # copies  thereof may not be provided or otherwise made available to any
 # other person.  No title to and ownership of  the  software  is  hereby
 # transferred.
 #
 # The information in this software is subject to change  without  notice
 # and  should  not  be  construed  as  a commitment by Digital Equipment
 # Corporation.
 #
 # Digital assumes no responsibility for the use or  reliability  of  its
 # software on equipment which is not supplied by Digital.
 #
 #   009	  15 Jul 1992	KDG	- Can't have .end for Alpha/OSF - use
 #				  new ots_data_end macro
 #				- Need .data for OSF
 #
 #   010	   4 Sep 1992	KDG	Switch PSECT from ots_div_data to ots_lit
 #
 #   011	  26 Jan 1993	KDG	Add underscore, OSF uses CS name
 #
 #   012    5 Apr 1993	WBN	Use 16-byte entries, up to 512, and
 #				support computing 1/(a+x).

#include	"ots_defs.hs"

 # Data area description
 #
 #	The data area "ots_div_data" is an array of structures, indexed
 #	by the divisor value, with each array entry being 16 bytes in size
 #	formatted as follows:
 #
 #	 6                                             1 1
 #	 3                                             6 5       6 5   0 
 #	+-------+-------+-------+-------+-------+-------+-------+-------+
 #	|         32 bit reciprocal (48 bits)           | recip^2 |shift|
 #	+-------+-------+-------+-------+-------+-------+-------+-------+
 #	|                       64 bit reciprocal                       |
 #	+---------------------------------------------------------------+
 #
 #	The 64-bit reciprocal has the leading '1' bit omitted, so it provides
 #	65 bits of precision -- enough to handle unsigned 64-bit dividends.
 #
 #	The first quadword contains the 6-bit shift amount needed to handle
 #	64-bit cases and powers of two.  For divisors between 256 and 512,
 #	this quadword also contains a 10-bit coefficient for linearly
 #	approximating larger reciprocals (1/(a+x) = 1/a - x/a^2 + ...).
 #	
 #	The 32-bit reciprocal has the shift count built in, so a UMULH gives
 #	the correct quotient without shifting.  The reciprocal needs 33 bits
 #	of precision.  The 10-bit reciprocal-squared, and 6-bit shift amount,
 #	are noise in the reciprocal that can be ignored for divisors less than
 #	512.  (The only possible exception is for 1/257, and it checks out OK.)
 #
 #	Powers of two are flagged with a 32-bit reciprocal that is negative,
 #	and a 64-bit reciprocal that is zero.

	# OTS division data table
	#

#ifdef	VMS
	.psect	ots_lit
	.align	4   # octaword alignment
ots_div_data::
#endif
#ifdef	OSF
	.globl	_OtsDivData
	.data
	.align	4
_OtsDivData:
#endif
#ifdef	WNT
	.globl	_OtsDivData
	.data
	.align	4
_OtsDivData:
#endif
		#     recip^2--. .-shift
		#32b recip    / \|   64 bit reciprocal	 divisor
 	.quad	0x0000000000000000, 0x0000000000000000	#   0
 	.quad	0x8000000000000000, 0x0000000000000000	#   1
 	.quad	0x8000000000000001, 0x0000000000000000	#   2
 	.quad	0x5555555555560002, 0x5555555555555556	#   3
 	.quad	0x8000000000000002, 0x0000000000000000	#   4
 	.quad	0x3333333333340003, 0x999999999999999A	#   5
 	.quad	0x2AAAAAAAAAAB0003, 0x5555555555555556	#   6
 	.quad	0x24924924924A0003, 0x2492492492492493	#   7
 	.quad	0x8000000000000003, 0x0000000000000000	#   8
 	.quad	0x1C71C71C71C80004, 0xC71C71C71C71C71D	#   9
 	.quad	0x19999999999A0004, 0x999999999999999A	#  10
 	.quad	0x1745D1745D180004, 0x745D1745D1745D18	#  11
 	.quad	0x1555555555560004, 0x5555555555555556	#  12
 	.quad	0x13B13B13B13C0004, 0x3B13B13B13B13B14	#  13
 	.quad	0x1249249249250004, 0x2492492492492493	#  14
 	.quad	0x1111111111120004, 0x1111111111111112	#  15
 	.quad	0x8000000000000004, 0x0000000000000000	#  16
 	.quad	0x0F0F0F0F0F100005, 0xE1E1E1E1E1E1E1E2	#  17
 	.quad	0x0E38E38E38E40005, 0xC71C71C71C71C71D	#  18
 	.quad	0x0D79435E50D80005, 0xAF286BCA1AF286BD	#  19
 	.quad	0x0CCCCCCCCCCD0005, 0x999999999999999A	#  20
 	.quad	0x0C30C30C30C40005, 0x8618618618618619	#  21
 	.quad	0x0BA2E8BA2E8C0005, 0x745D1745D1745D18	#  22
 	.quad	0x0B21642C85910005, 0x642C8590B21642C9	#  23
 	.quad	0x0AAAAAAAAAAB0005, 0x5555555555555556	#  24
 	.quad	0x0A3D70A3D70B0005, 0x47AE147AE147AE15	#  25
 	.quad	0x09D89D89D89E0005, 0x3B13B13B13B13B14	#  26
 	.quad	0x097B425ED0980005, 0x2F684BDA12F684BE	#  27
 	.quad	0x0924924924930005, 0x2492492492492493	#  28
 	.quad	0x08D3DCB08D3E0005, 0x1A7B9611A7B9611B	#  29
 	.quad	0x0888888888890005, 0x1111111111111112	#  30
 	.quad	0x0842108421090005, 0x0842108421084211	#  31
 	.quad	0x8000000000000005, 0x0000000000000000	#  32
 	.quad	0x07C1F07C1F080006, 0xF07C1F07C1F07C20	#  33
 	.quad	0x0787878787880006, 0xE1E1E1E1E1E1E1E2	#  34
 	.quad	0x0750750750760006, 0xD41D41D41D41D41E	#  35
 	.quad	0x071C71C71C720006, 0xC71C71C71C71C71D	#  36
 	.quad	0x06EB3E45306F0006, 0xBACF914C1BACF915	#  37
 	.quad	0x06BCA1AF286C0006, 0xAF286BCA1AF286BD	#  38
 	.quad	0x06906906906A0006, 0xA41A41A41A41A41B	#  39
 	.quad	0x0666666666670006, 0x999999999999999A	#  40
 	.quad	0x063E7063E7070006, 0x8F9C18F9C18F9C19	#  41
 	.quad	0x0618618618620006, 0x8618618618618619	#  42
 	.quad	0x05F417D05F420006, 0x7D05F417D05F417E	#  43
 	.quad	0x05D1745D17460006, 0x745D1745D1745D18	#  44
 	.quad	0x05B05B05B05C0006, 0x6C16C16C16C16C17	#  45
 	.quad	0x0590B21642C90006, 0x642C8590B21642C9	#  46
 	.quad	0x0572620AE4C50006, 0x5C9882B931057263	#  47
 	.quad	0x0555555555560006, 0x5555555555555556	#  48
 	.quad	0x05397829CBC20006, 0x4E5E0A72F0539783	#  49
 	.quad	0x051EB851EB860006, 0x47AE147AE147AE15	#  50
 	.quad	0x0505050505060006, 0x4141414141414142	#  51
 	.quad	0x04EC4EC4EC4F0006, 0x3B13B13B13B13B14	#  52
 	.quad	0x04D4873ECADF0006, 0x3521CFB2B78C1353	#  53
 	.quad	0x04BDA12F684C0006, 0x2F684BDA12F684BE	#  54
 	.quad	0x04A7904A79050006, 0x29E4129E4129E413	#  55
 	.quad	0x04924924924A0006, 0x2492492492492493	#  56
 	.quad	0x047DC11F70480006, 0x1F7047DC11F7047E	#  57
 	.quad	0x0469EE58469F0006, 0x1A7B9611A7B9611B	#  58
 	.quad	0x0456C797DD4A0006, 0x15B1E5F75270D046	#  59
 	.quad	0x0444444444450006, 0x1111111111111112	#  60
 	.quad	0x04325C53EF370006, 0x0C9714FBCDA3AC11	#  61
 	.quad	0x0421084210850006, 0x0842108421084211	#  62
 	.quad	0x0410410410420006, 0x0410410410410411	#  63
 	.quad	0x8000000000000006, 0x0000000000000000	#  64
 	.quad	0x03F03F03F0400007, 0xF81F81F81F81F820	#  65
 	.quad	0x03E0F83E0F840007, 0xF07C1F07C1F07C20	#  66
 	.quad	0x03D226357E170007, 0xE9131ABF0B7672A1	#  67
 	.quad	0x03C3C3C3C3C40007, 0xE1E1E1E1E1E1E1E2	#  68
 	.quad	0x03B5CC0ED7310007, 0xDAE6076B981DAE61	#  69
 	.quad	0x03A83A83A83B0007, 0xD41D41D41D41D41E	#  70
 	.quad	0x039B0AD120740007, 0xCD85689039B0AD13	#  71
 	.quad	0x038E38E38E390007, 0xC71C71C71C71C71D	#  72
 	.quad	0x0381C0E070390007, 0xC0E070381C0E0704	#  73
 	.quad	0x03759F2298380007, 0xBACF914C1BACF915	#  74
 	.quad	0x0369D0369D040007, 0xB4E81B4E81B4E81C	#  75
 	.quad	0x035E50D794360007, 0xAF286BCA1AF286BD	#  76
 	.quad	0x03531DEC0D4D0007, 0xA98EF606A63BD81B	#  77
 	.quad	0x0348348348350007, 0xA41A41A41A41A41B	#  78
 	.quad	0x033D91D2A2070007, 0x9EC8E951033D91D3	#  79
 	.quad	0x0333333333340007, 0x999999999999999A	#  80
 	.quad	0x0329161F9ADE0007, 0x948B0FCD6E9E0653	#  81
 	.quad	0x031F3831F3840007, 0x8F9C18F9C18F9C19	#  82
 	.quad	0x03159721ED7F0007, 0x8ACB90F6BF3A9A38	#  83
 	.quad	0x030C30C30C310007, 0x8618618618618619	#  84
 	.quad	0x0303030303040007, 0x8181818181818182	#  85
 	.quad	0x02FA0BE82FA10007, 0x7D05F417D05F417E	#  86
 	.quad	0x02F149902F150007, 0x78A4C8178A4C8179	#  87
 	.quad	0x02E8BA2E8BA30007, 0x745D1745D1745D18	#  88
 	.quad	0x02E05C0B81710007, 0x702E05C0B81702E1	#  89
 	.quad	0x02D82D82D82E0007, 0x6C16C16C16C16C17	#  90
 	.quad	0x02D02D02D02E0007, 0x6816816816816817	#  91
 	.quad	0x02C8590B21650007, 0x642C8590B21642C9	#  92
 	.quad	0x02C0B02C0B030007, 0x6058160581605817	#  93
 	.quad	0x02B9310572630007, 0x5C9882B931057263	#  94
 	.quad	0x02B1DA46102C0007, 0x58ED2308158ED231	#  95
 	.quad	0x02AAAAAAAAAB0007, 0x5555555555555556	#  96
 	.quad	0x02A3A0FD5C600007, 0x51D07EAE2F8151D1	#  97
 	.quad	0x029CBC14E5E10007, 0x4E5E0A72F0539783	#  98
 	.quad	0x0295FAD40A580007, 0x4AFD6A052BF5A815	#  99
 	.quad	0x028F5C28F5C30007, 0x47AE147AE147AE15	# 100
 	.quad	0x0288DF0CAC5C0007, 0x446F86562D9FAEE5	# 101
 	.quad	0x0282828282830007, 0x4141414141414142	# 102
 	.quad	0x027C45979C960007, 0x3E22CBCE4A9027C5	# 103
 	.quad	0x0276276276280007, 0x3B13B13B13B13B14	# 104
 	.quad	0x0270270270280007, 0x3813813813813814	# 105
 	.quad	0x026A439F65700007, 0x3521CFB2B78C1353	# 106
 	.quad	0x02647C6945630007, 0x323E34A2B10BF66F	# 107
 	.quad	0x025ED097B4260007, 0x2F684BDA12F684BE	# 108
 	.quad	0x02593F69B0260007, 0x2C9FB4D812C9FB4E	# 109
 	.quad	0x0253C8253C830007, 0x29E4129E4129E413	# 110
 	.quad	0x024E6A1710250007, 0x27350B88127350B9	# 111
 	.quad	0x0249249249250007, 0x2492492492492493	# 112
 	.quad	0x0243F6F024400007, 0x21FB78121FB78122	# 113
 	.quad	0x023EE08FB8240007, 0x1F7047DC11F7047E	# 114
 	.quad	0x0239E0D5B4510007, 0x1CF06ADA2811CF07	# 115
 	.quad	0x0234F72C23500007, 0x1A7B9611A7B9611B	# 116
 	.quad	0x0230230230240007, 0x1811811811811812	# 117
 	.quad	0x022B63CBEEA50007, 0x15B1E5F75270D046	# 118
 	.quad	0x0226B90226BA0007, 0x135C81135C81135D	# 119
 	.quad	0x0222222222230007, 0x1111111111111112	# 120
 	.quad	0x021D9EAD7CD40007, 0x0ECF56BE69C8FDE3	# 121
 	.quad	0x02192E29F79C0007, 0x0C9714FBCDA3AC11	# 122
 	.quad	0x0214D0214D030007, 0x0A6810A6810A6811	# 123
 	.quad	0x0210842108430007, 0x0842108421084211	# 124
 	.quad	0x020C49BA5E360007, 0x0624DD2F1A9FBE77	# 125
 	.quad	0x0208208208210007, 0x0410410410410411	# 126
 	.quad	0x0204081020410007, 0x0204081020408103	# 127
 	.quad	0x8000000000000007, 0x0000000000000000	# 128
 	.quad	0x01FC07F01FC10008, 0xFC07F01FC07F01FD	# 129
 	.quad	0x01F81F81F8200008, 0xF81F81F81F81F820	# 130
 	.quad	0x01F44659E4A50008, 0xF44659E4A4271580	# 131
 	.quad	0x01F07C1F07C20008, 0xF07C1F07C1F07C20	# 132
 	.quad	0x01ECC07B301F0008, 0xECC07B301ECC07B4	# 133
 	.quad	0x01E9131ABF0C0008, 0xE9131ABF0B7672A1	# 134
 	.quad	0x01E573AC901F0008, 0xE573AC901E573ACA	# 135
 	.quad	0x01E1E1E1E1E20008, 0xE1E1E1E1E1E1E1E2	# 136
 	.quad	0x01DE5D6E3F890008, 0xDE5D6E3F8868A471	# 137
 	.quad	0x01DAE6076B990008, 0xDAE6076B981DAE61	# 138
 	.quad	0x01D77B654B830008, 0xD77B654B82C33918	# 139
 	.quad	0x01D41D41D41E0008, 0xD41D41D41D41D41E	# 140
 	.quad	0x01D0CB58F6ED0008, 0xD0CB58F6EC07432E	# 141
 	.quad	0x01CD8568903A0008, 0xCD85689039B0AD13	# 142
 	.quad	0x01CA4B3055EF0008, 0xCA4B3055EE19101D	# 143
 	.quad	0x01C71C71C71D0008, 0xC71C71C71C71C71D	# 144
 	.quad	0x01C3F8F01C400008, 0xC3F8F01C3F8F01C4	# 145
 	.quad	0x01C0E070381D0008, 0xC0E070381C0E0704	# 146
 	.quad	0x01BDD2B899410008, 0xBDD2B899406F74AF	# 147
 	.quad	0x01BACF914C1C0008, 0xBACF914C1BACF915	# 148
 	.quad	0x01B7D6C3DDA40008, 0xB7D6C3DDA338B2B0	# 149
 	.quad	0x01B4E81B4E820008, 0xB4E81B4E81B4E81C	# 150
 	.quad	0x01B2036406C90008, 0xB2036406C80D901C	# 151
 	.quad	0x01AF286BCA1B0008, 0xAF286BCA1AF286BD	# 152
 	.quad	0x01AC5701AC580008, 0xAC5701AC5701AC58	# 153
 	.quad	0x01A98EF606A70008, 0xA98EF606A63BD81B	# 154
 	.quad	0x01A6D01A6D020008, 0xA6D01A6D01A6D01B	# 155
 	.quad	0x01A41A41A41B0008, 0xA41A41A41A41A41B	# 156
 	.quad	0x01A16D3F97A50008, 0xA16D3F97A4B01A17	# 157
 	.quad	0x019EC8E951040008, 0x9EC8E951033D91D3	# 158
 	.quad	0x019C2D14EE4B0008, 0x9C2D14EE4A1019C3	# 159
 	.quad	0x01999999999A0008, 0x999999999999999A	# 160
 	.quad	0x01970E4F80CC0008, 0x970E4F80CB8727C1	# 161
 	.quad	0x01948B0FCD6F0008, 0x948B0FCD6E9E0653	# 162
 	.quad	0x01920FB49D0F0008, 0x920FB49D0E228D5A	# 163
 	.quad	0x018F9C18F9C20008, 0x8F9C18F9C18F9C19	# 164
 	.quad	0x018D3018D3020008, 0x8D3018D3018D3019	# 165
 	.quad	0x018ACB90F6C00008, 0x8ACB90F6BF3A9A38	# 166
 	.quad	0x01886E5F0ABC0008, 0x886E5F0ABB04994C	# 167
 	.quad	0x0186186186190008, 0x8618618618618619	# 168
 	.quad	0x0183C977AB2C0008, 0x83C977AB2BEDD28F	# 169
 	.quad	0x0181818181820008, 0x8181818181818182	# 170
 	.quad	0x017F405FD0180008, 0x7F405FD017F405FE	# 171
 	.quad	0x017D05F417D10008, 0x7D05F417D05F417E	# 172
 	.quad	0x017AD2208E0F0008, 0x7AD2208E0ECC3546	# 173
 	.quad	0x0178A4C8178B0008, 0x78A4C8178A4C8179	# 174
 	.quad	0x01767DCE434B0008, 0x767DCE434A9B1018	# 175
 	.quad	0x01745D1745D20008, 0x745D1745D1745D18	# 176
 	.quad	0x01724287F46E0008, 0x724287F46DEBC05D	# 177
 	.quad	0x01702E05C0B90008, 0x702E05C0B81702E1	# 178
 	.quad	0x016E1F76B4340008, 0x6E1F76B4337C6CB2	# 179
 	.quad	0x016C16C16C170008, 0x6C16C16C16C16C17	# 180
 	.quad	0x016A13CD15380008, 0x6A13CD153729043F	# 181
 	.quad	0x0168168168170008, 0x6816816816816817	# 182
 	.quad	0x01661EC6A5130008, 0x661EC6A5122F9017	# 183
 	.quad	0x01642C8590B30008, 0x642C8590B21642C9	# 184
 	.quad	0x01623FA770170008, 0x623FA7701623FA78	# 185
 	.quad	0x0160581605820008, 0x6058160581605817	# 186
 	.quad	0x015E75BB8D020008, 0x5E75BB8D015E75BC	# 187
 	.quad	0x015C9882B9320008, 0x5C9882B931057263	# 188
 	.quad	0x015AC056B0160008, 0x5AC056B015AC056C	# 189
 	.quad	0x0158ED2308160008, 0x58ED2308158ED231	# 190
 	.quad	0x01571ED3C5070008, 0x571ED3C506B39A23	# 191
 	.quad	0x0155555555560008, 0x5555555555555556	# 192
 	.quad	0x015390948F410008, 0x5390948F40FEAC70	# 193
 	.quad	0x0151D07EAE300008, 0x51D07EAE2F8151D1	# 194
 	.quad	0x0150150150160008, 0x5015015015015016	# 195
 	.quad	0x014E5E0A72F10008, 0x4E5E0A72F0539783	# 196
 	.quad	0x014CAB88725B0008, 0x4CAB88725AF6E750	# 197
 	.quad	0x014AFD6A052C0008, 0x4AFD6A052BF5A815	# 198
 	.quad	0x0149539E3B2E0008, 0x49539E3B2D066EA3	# 199
 	.quad	0x0147AE147AE20008, 0x47AE147AE147AE15	# 200
 	.quad	0x01460CBC7F5D0008, 0x460CBC7F5CF9A1C1	# 201
 	.quad	0x01446F86562E0008, 0x446F86562D9FAEE5	# 202
 	.quad	0x0142D6625D520008, 0x42D6625D51F86EFA	# 203
 	.quad	0x0141414141420008, 0x4141414141414142	# 204
 	.quad	0x013FB013FB020008, 0x3FB013FB013FB014	# 205
 	.quad	0x013E22CBCE4B0008, 0x3E22CBCE4A9027C5	# 206
 	.quad	0x013C995A47BB0008, 0x3C995A47BABE7441	# 207
 	.quad	0x013B13B13B140008, 0x3B13B13B13B13B14	# 208
 	.quad	0x013991C2C1880008, 0x3991C2C187F63372	# 209
 	.quad	0x0138138138140008, 0x3813813813813814	# 210
 	.quad	0x013698DF3DE10008, 0x3698DF3DE0747954	# 211
 	.quad	0x013521CFB2B80008, 0x3521CFB2B78C1353	# 212
 	.quad	0x0133AE45B57C0008, 0x33AE45B57BCB1E0D	# 213
 	.quad	0x01323E34A2B20008, 0x323E34A2B10BF66F	# 214
 	.quad	0x0130D190130E0008, 0x30D190130D190131	# 215
 	.quad	0x012F684BDA130008, 0x2F684BDA12F684BE	# 216
 	.quad	0x012E025C04B90008, 0x2E025C04B8097013	# 217
 	.quad	0x012C9FB4D8130008, 0x2C9FB4D812C9FB4E	# 218
 	.quad	0x012B404AD0130008, 0x2B404AD012B404AE	# 219
 	.quad	0x0129E4129E420008, 0x29E4129E4129E413	# 220
 	.quad	0x01288B01288C0008, 0x288B01288B01288C	# 221
 	.quad	0x0127350B88130008, 0x27350B88127350B9	# 222
 	.quad	0x0125E227080A0008, 0x25E22708092F1139	# 223
 	.quad	0x0124924924930008, 0x2492492492492493	# 224
 	.quad	0x0123456789AC0008, 0x23456789ABCDF013	# 225
 	.quad	0x0121FB7812200008, 0x21FB78121FB78122	# 226
 	.quad	0x0120B470C67D0008, 0x20B470C67C0D8876	# 227
 	.quad	0x011F7047DC120008, 0x1F7047DC11F7047E	# 228
 	.quad	0x011E2EF3B3FC0008, 0x1E2EF3B3FB874432	# 229
 	.quad	0x011CF06ADA290008, 0x1CF06ADA2811CF07	# 230
 	.quad	0x011BB4A4046F0008, 0x1BB4A4046ED29012	# 231
 	.quad	0x011A7B9611A80008, 0x1A7B9611A7B9611B	# 232
 	.quad	0x0119453808CB0008, 0x19453808CA29C047	# 233
 	.quad	0x0118118118120008, 0x1811811811811812	# 234
 	.quad	0x0116E06894280008, 0x16E0689427378EB5	# 235
 	.quad	0x0115B1E5F7530008, 0x15B1E5F75270D046	# 236
 	.quad	0x011485F0E0AD0008, 0x1485F0E0ACD3B68D	# 237
 	.quad	0x01135C81135D0008, 0x135C81135C81135D	# 238
 	.quad	0x0112358E75D40008, 0x12358E75D30336A1	# 239
 	.quad	0x0111111111120008, 0x1111111111111112	# 240
 	.quad	0x010FEF010FF00008, 0x0FEF010FEF010FF0	# 241
 	.quad	0x010ECF56BE6A0008, 0x0ECF56BE69C8FDE3	# 242
 	.quad	0x010DB20A88F50008, 0x0DB20A88F469598D	# 243
 	.quad	0x010C9714FBCE0008, 0x0C9714FBCDA3AC11	# 244
 	.quad	0x010B7E6EC25A0008, 0x0B7E6EC259DC7936	# 245
 	.quad	0x010A6810A6820008, 0x0A6810A6810A6811	# 246
 	.quad	0x010953F390110008, 0x0953F39010953F3A	# 247
 	.quad	0x0108421084220008, 0x0842108421084211	# 248
 	.quad	0x01073260A4800008, 0x073260A47F7C66D0	# 249
 	.quad	0x010624DD2F1B0008, 0x0624DD2F1A9FBE77	# 250
 	.quad	0x0105197F7D740008, 0x05197F7D73404147	# 251
 	.quad	0x0104104104110008, 0x0410410410410411	# 252
 	.quad	0x0103091B51F60008, 0x03091B51F5E1A4EF	# 253
 	.quad	0x0102040810210008, 0x0204081020408103	# 254
 	.quad	0x0101010101020008, 0x0101010101010102	# 255
 	.quad	0x800000000000FFC8, 0x0000000000000000	# 256
 	.quad	0x00FF00FF0100FE09, 0xFE01FE01FE01FE02	# 257
 	.quad	0x00FE03F80FE1FC09, 0xFC07F01FC07F01FD	# 258
 	.quad	0x00FD08E55010FA09, 0xFA11CAA01FA11CAB	# 259
 	.quad	0x00FC0FC0FC10F849, 0xF81F81F81F81F820	# 260
 	.quad	0x00FB18856507F649, 0xF6310ACA0DBB574C	# 261
 	.quad	0x00FA232CF253F489, 0xF44659E4A4271580	# 262
 	.quad	0x00F92FB22119F289, 0xF25F644230AB50CB	# 263
 	.quad	0x00F83E0F83E1F0C9, 0xF07C1F07C1F07C20	# 264
 	.quad	0x00F74E3FC22DEF09, 0xEE9C7F8458E01EEA	# 265
 	.quad	0x00F6603D9810ED09, 0xECC07B301ECC07B4	# 266
 	.quad	0x00F57403D5D1EB49, 0xEAE807ABA01EAE81	# 267
 	.quad	0x00F4898D5F86E989, 0xE9131ABF0B7672A1	# 268
 	.quad	0x00F3A0D52CBBE7C9, 0xE741AA59750E466D	# 269
 	.quad	0x00F2B9D64810E649, 0xE573AC901E573ACA	# 270
 	.quad	0x00F1D48BCEE1E489, 0xE3A9179DC1A733F5	# 271
 	.quad	0x00F0F0F0F0F1E2C9, 0xE1E1E1E1E1E1E1E2	# 272
 	.quad	0x00F00F00F010E109, 0xE01E01E01E01E01F	# 273
 	.quad	0x00EF2EB71FC5DF89, 0xDE5D6E3F8868A471	# 274
 	.quad	0x00EE500EE501DDC9, 0xDCA01DCA01DCA01E	# 275
 	.quad	0x00ED7303B5CDDC49, 0xDAE6076B981DAE61	# 276
 	.quad	0x00EC979118F4DAC9, 0xD92F2231E7F89B44	# 277
 	.quad	0x00EBBDB2A5C2D909, 0xD77B654B82C33918	# 278
 	.quad	0x00EAE56403ACD789, 0xD5CAC807572B201E	# 279
 	.quad	0x00EA0EA0EA0FD609, 0xD41D41D41D41D41E	# 280
 	.quad	0x00E939651FE3D489, 0xD272CA3FC5B1A6B9	# 281
 	.quad	0x00E865AC7B77D309, 0xD0CB58F6EC07432E	# 282
 	.quad	0x00E79372E226D189, 0xCF26E5C44BFC61B3	# 283
 	.quad	0x00E6C2B4481DD009, 0xCD85689039B0AD13	# 284
 	.quad	0x00E5F36CB00FCE89, 0xCBE6D9601CBE6D97	# 285
 	.quad	0x00E525982AF8CD09, 0xCA4B3055EE19101D	# 286
 	.quad	0x00E45932D7DDCBC9, 0xC8B265AFB8A4201D	# 287
 	.quad	0x00E38E38E38FCA49, 0xC71C71C71C71C71D	# 288
 	.quad	0x00E2C4A6886BC8C9, 0xC5894D10D4985C20	# 289
 	.quad	0x00E1FC780E20C789, 0xC3F8F01C3F8F01C4	# 290
 	.quad	0x00E135A9C976C609, 0xC26B5392EA01C26C	# 291
 	.quad	0x00E070381C0FC4C9, 0xC0E070381C0E0704	# 292
 	.quad	0x00DFAC1F7435C389, 0xBF583EE868D8AEBF	# 293
 	.quad	0x00DEE95C4CA1C209, 0xBDD2B899406F74AF	# 294
 	.quad	0x00DE27EB2C42C0C9, 0xBC4FD65883E7B3A3	# 295
 	.quad	0x00DD67C8A60EBF89, 0xBACF914C1BACF915	# 296
 	.quad	0x00DCA8F158C8BE49, 0xB951E2B18FF23571	# 297
 	.quad	0x00DBEB61EED2BD09, 0xB7D6C3DDA338B2B0	# 298
 	.quad	0x00DB2F171DF8BBC9, 0xB65E2E3BEEE05232	# 299
 	.quad	0x00DA740DA741BA89, 0xB4E81B4E81B4E81C	# 300
 	.quad	0x00D9BA4256C1B949, 0xB37484AD806CDD22	# 301
 	.quad	0x00D901B20365B809, 0xB2036406C80D901C	# 302
 	.quad	0x00D84A598ECAB6C9, 0xB094B31D922A3E86	# 303
 	.quad	0x00D79435E50EB589, 0xAF286BCA1AF286BD	# 304
 	.quad	0x00D6DF43FCA5B449, 0xADBE87F94905E01B	# 305
 	.quad	0x00D62B80D62CB349, 0xAC5701AC5701AC58	# 306
 	.quad	0x00D578E97C40B209, 0xAAF1D2F87EBFCAA2	# 307
 	.quad	0x00D4C77B0354B0C9, 0xA98EF606A63BD81B	# 308
 	.quad	0x00D417328988AFC9, 0xA82E65130E158A5C	# 309
 	.quad	0x00D3680D3681AE89, 0xA6D01A6D01A6D01B	# 310
 	.quad	0x00D2BA083B45AD89, 0xA574107688A4A157	# 311
 	.quad	0x00D20D20D20EAC49, 0xA41A41A41A41A41B	# 312
 	.quad	0x00D161543E29AB49, 0xA2C2A87C51CA04E9	# 313
 	.quad	0x00D0B69FCBD3AA49, 0xA16D3F97A4B01A17	# 314
 	.quad	0x00D00D00D00EA909, 0xA01A01A01A01A01B	# 315
 	.quad	0x00CF6474A882A809, 0x9EC8E951033D91D3	# 316
 	.quad	0x00CEBCF8BB5CA709, 0x9D79F176B682D396	# 317
 	.quad	0x00CE168A7726A609, 0x9C2D14EE4A1019C3	# 318
 	.quad	0x00CD712752A9A4C9, 0x9AE24EA5510DA484	# 319
 	.quad	0x00CCCCCCCCCDA3C9, 0x999999999999999A	# 320
 	.quad	0x00CC29786C77A2C9, 0x9852F0D8EC0FF33E	# 321
 	.quad	0x00CB8727C066A1C9, 0x970E4F80CB8727C1	# 322
 	.quad	0x00CAE5D85F1CA0C9, 0x95CBB0BE377AD92B	# 323
 	.quad	0x00CA4587E6B89FC9, 0x948B0FCD6E9E0653	# 324
 	.quad	0x00C9A633FCDA9EC9, 0x934C67F9B2CE601A	# 325
 	.quad	0x00C907DA4E889DC9, 0x920FB49D0E228D5A	# 326
 	.quad	0x00C86A78900D9D09, 0x90D4F120190D4F13	# 327
 	.quad	0x00C7CE0C7CE19C09, 0x8F9C18F9C18F9C19	# 328
 	.quad	0x00C73293D78A9B09, 0x8E6527AF1373F071	# 329
 	.quad	0x00C6980C69819A09, 0x8D3018D3018D3019	# 330
 	.quad	0x00C5FE7403189949, 0x8BFCE8062FF3A019	# 331
 	.quad	0x00C565C87B609849, 0x8ACB90F6BF3A9A38	# 332
 	.quad	0x00C4CE07B00D9749, 0x899C0F601899C0F7	# 333
 	.quad	0x00C4372F855E9689, 0x886E5F0ABB04994C	# 334
 	.quad	0x00C3A13DE6059589, 0x87427BCC092B8EE7	# 335
 	.quad	0x00C30C30C30D9489, 0x8618618618618619	# 336
 	.quad	0x00C2780613C193C9, 0x84F00C2780613C04	# 337
 	.quad	0x00C1E4BBD59692C9, 0x83C977AB2BEDD28F	# 338
 	.quad	0x00C152500C169209, 0x82A4A0182A4A0183	# 339
 	.quad	0x00C0C0C0C0C19149, 0x8181818181818182	# 340
 	.quad	0x00C0300C03019049, 0x8060180601806019	# 341
 	.quad	0x00BFA02FE80C8F89, 0x7F405FD017F405FE	# 342
 	.quad	0x00BF112A8AD38E89, 0x7E225515A4F1D1BA	# 343
 	.quad	0x00BE82FA0BE98DC9, 0x7D05F417D05F417E	# 344
 	.quad	0x00BDF59C91718D09, 0x7BEB3922E017BEB4	# 345
 	.quad	0x00BD691047088C49, 0x7AD2208E0ECC3546	# 346
 	.quad	0x00BCDD535DB28B49, 0x79BAA6BB6398B6F7	# 347
 	.quad	0x00BC52640BC68A89, 0x78A4C8178A4C8179	# 348
 	.quad	0x00BBC8408CD789C9, 0x77908119AC60D342	# 349
 	.quad	0x00BB3EE721A68909, 0x767DCE434A9B1018	# 350
 	.quad	0x00BAB656100C8849, 0x756CAC201756CAC3	# 351
 	.quad	0x00BA2E8BA2E98789, 0x745D1745D1745D18	# 352
 	.quad	0x00B9A7862A1086C9, 0x734F0C541FE8CB10	# 353
 	.quad	0x00B92143FA378609, 0x724287F46DEBC05D	# 354
 	.quad	0x00B89BC36CE48549, 0x713786D9C7C08A75	# 355
 	.quad	0x00B81702E05D8489, 0x702E05C0B81702E1	# 356
 	.quad	0x00B79300B79483C9, 0x6F26016F26016F27	# 357
 	.quad	0x00B70FBB5A1A8309, 0x6E1F76B4337C6CB2	# 358
 	.quad	0x00B68D31340F8249, 0x6D1A62681C860FB1	# 359
 	.quad	0x00B60B60B60C8189, 0x6C16C16C16C16C17	# 360
 	.quad	0x00B58A48551980C9, 0x6B1490AA31A3CFC8	# 361
 	.quad	0x00B509E68A9C8009, 0x6A13CD153729043F	# 362
 	.quad	0x00B48A39D4477F49, 0x691473A88D0BFD2E	# 363
 	.quad	0x00B40B40B40C7E89, 0x6816816816816817	# 364
 	.quad	0x00B38CF9B00C7E09, 0x6719F36016719F37	# 365
 	.quad	0x00B30F63528A7D49, 0x661EC6A5122F9017	# 366
 	.quad	0x00B2927C29DB7C89, 0x6524F853B4AA339F	# 367
 	.quad	0x00B21642C85A7C09, 0x642C8590B21642C9	# 368
 	.quad	0x00B19AB5C4577B49, 0x63356B88AC0DE017	# 369
 	.quad	0x00B11FD3B80C7A89, 0x623FA7701623FA78	# 370
 	.quad	0x00B0A59B418E7A09, 0x614B36831AE93AA7	# 371
 	.quad	0x00B02C0B02C17949, 0x6058160581605817	# 372
 	.quad	0x00AFB321A14A7889, 0x5F66434292DFBE1D	# 373
 	.quad	0x00AF3ADDC6817809, 0x5E75BB8D015E75BC	# 374
 	.quad	0x00AEC33E1F687749, 0x5D867C3ECE2A534A	# 375
 	.quad	0x00AE4C415C9976C9, 0x5C9882B931057263	# 376
 	.quad	0x00ADD5E632407609, 0x5BABCC647FA9150D	# 377
 	.quad	0x00AD602B580B7589, 0x5AC056B015AC056C	# 378
 	.quad	0x00ACEB0F891F74C9, 0x59D61F123CCAA377	# 379
 	.quad	0x00AC7691840B7449, 0x58ED2308158ED231	# 380
 	.quad	0x00AC02B00AC17389, 0x5805601580560159	# 381
 	.quad	0x00AB8F69E2847309, 0x571ED3C506B39A23	# 382
 	.quad	0x00AB1CBDD3E37249, 0x56397BA7C52E1EC0	# 383
 	.quad	0x00AAAAAAAAAB71C9, 0x5555555555555556	# 384
 	.quad	0x00AA392F35DD7149, 0x54725E6BB82FE016	# 385
 	.quad	0x00A9C84A47A17089, 0x5390948F40FEAC70	# 386
 	.quad	0x00A957FAB5417009, 0x52AFF56A8054ABFE	# 387
 	.quad	0x00A8E83F57186F89, 0x51D07EAE2F8151D1	# 388
 	.quad	0x00A87917088F6EC9, 0x50F22E111C4C56DF	# 389
 	.quad	0x00A80A80A80B6E49, 0x5015015015015016	# 390
 	.quad	0x00A79C7B16EB6DC9, 0x4F38F62DD4C9A845	# 391
 	.quad	0x00A72F0539796D49, 0x4E5E0A72F0539783	# 392
 	.quad	0x00A6C21DF6E26CC9, 0x4D843BEDC2C4B900	# 393
 	.quad	0x00A655C4392E6C09, 0x4CAB88725AF6E750	# 394
 	.quad	0x00A5E9F6ED356B89, 0x4BD3EDDA68FE0E43	# 395
 	.quad	0x00A57EB502966B09, 0x4AFD6A052BF5A815	# 396
 	.quad	0x00A513FD6BB16A89, 0x4A27FAD76014A280	# 397
 	.quad	0x00A4A9CF1D976A09, 0x49539E3B2D066EA3	# 398
 	.quad	0x00A44029100B6989, 0x4880522014880523	# 399
 	.quad	0x00A3D70A3D7168C9, 0x47AE147AE147AE15	# 400
 	.quad	0x00A36E71A2CC6849, 0x46DCE34596066251	# 401
 	.quad	0x00A3065E3FAF67C9, 0x460CBC7F5CF9A1C1	# 402
 	.quad	0x00A29ECF163C6749, 0x453D9E2C776CA015	# 403
 	.quad	0x00A237C32B1766C9, 0x446F86562D9FAEE5	# 404
 	.quad	0x00A1D13985606649, 0x43A2730ABEE4D1DC	# 405
 	.quad	0x00A16B312EA965C9, 0x42D6625D51F86EFA	# 406
 	.quad	0x00A105A932F36549, 0x420B5265E595123E	# 407
 	.quad	0x00A0A0A0A0A164C9, 0x4141414141414142	# 408
 	.quad	0x00A03C1688746449, 0x40782D10E6566065	# 409
 	.quad	0x009FD809FD8163C9, 0x3FB013FB013FB014	# 410
 	.quad	0x009F747A152E6349, 0x3EE8F42A5AF06DA1	# 411
 	.quad	0x009F1165E72662C9, 0x3E22CBCE4A9027C5	# 412
 	.quad	0x009EAECC8D546249, 0x3D5D991AA75C5BBE	# 413
 	.quad	0x009E4CAD23DE6209, 0x3C995A47BABE7441	# 414
 	.quad	0x009DEB06C91A6189, 0x3BD60D923295482D	# 415
 	.quad	0x009D89D89D8A6109, 0x3B13B13B13B13B14	# 416
 	.quad	0x009D2921C3D76089, 0x3A524387AC822610	# 417
 	.quad	0x009CC8E160C46009, 0x3991C2C187F63372	# 418
 	.quad	0x009C69169B315F89, 0x38D22D366088DBF4	# 419
 	.quad	0x009C09C09C0A5F09, 0x3813813813813814	# 420
 	.quad	0x009BAADE8E4B5EC9, 0x3755BD1C945EDC20	# 421
 	.quad	0x009B4C6F9EF15E49, 0x3698DF3DE0747954	# 422
 	.quad	0x009AEE72FCFA5DC9, 0x35DCE5F9F2AF821F	# 423
 	.quad	0x009A90E7D95C5D49, 0x3521CFB2B78C1353	# 424
 	.quad	0x009A33CD67015D09, 0x34679ACE0134679B	# 425
 	.quad	0x0099D722DABE5C89, 0x33AE45B57BCB1E0D	# 426
 	.quad	0x00997AE76B515C09, 0x32F5CED6A1DFA014	# 427
 	.quad	0x00991F1A51595B89, 0x323E34A2B10BF66F	# 428
 	.quad	0x0098C3BAC7505B49, 0x3187758E9EBB6014	# 429
 	.quad	0x009868C809875AC9, 0x30D190130D190131	# 430
 	.quad	0x00980E4156215A49, 0x301C82AC40260391	# 431
 	.quad	0x0097B425ED0A5A09, 0x2F684BDA12F684BE	# 432
 	.quad	0x00975A750FF75989, 0x2EB4EA1FED14B15F	# 433
 	.quad	0x0097012E025D5909, 0x2E025C04B8097013	# 434
 	.quad	0x0096A850096B58C9, 0x2D50A012D50A012E	# 435
 	.quad	0x00964FDA6C0A5849, 0x2C9FB4D812C9FB4E	# 436
 	.quad	0x0095F7CC72D257C9, 0x2BEF98E5A3710FD2	# 437
 	.quad	0x0095A025680A5789, 0x2B404AD012B404AE	# 438
 	.quad	0x009548E4979F5709, 0x2A91C92F3C1053FA	# 439
 	.quad	0x0094F2094F2156C9, 0x29E4129E4129E413	# 440
 	.quad	0x00949B92DDC15649, 0x293725BB804A4DCA	# 441
 	.quad	0x0094458094465609, 0x288B01288B01288C	# 442
 	.quad	0x0093EFD1C50F5589, 0x27DFA38A1CE4D6F9	# 443
 	.quad	0x00939A85C40A5509, 0x27350B88127350B9	# 444
 	.quad	0x0093459BE6B154C9, 0x268B37CD601268B4	# 445
 	.quad	0x0092F11384055449, 0x25E22708092F1139	# 446
 	.quad	0x00929CEBF48C5409, 0x2539D7E9177B21CB	# 447
 	.quad	0x00924924924A5389, 0x2492492492492493	# 448
 	.quad	0x0091F5BCB8BC5349, 0x23EB79717605B39A	# 449
 	.quad	0x0091A2B3C4D652C9, 0x23456789ABCDF013	# 450
 	.quad	0x0091500915015289, 0x22A0122A0122A013	# 451
 	.quad	0x0090FDBC09105209, 0x21FB78121FB78122	# 452
 	.quad	0x0090ABCC024351C9, 0x21579804855E6013	# 453
 	.quad	0x00905A38633F5189, 0x20B470C67C0D8876	# 454
 	.quad	0x00900900900A5109, 0x2012012012012013	# 455
 	.quad	0x008FB823EE0950C9, 0x1F7047DC11F7047E	# 456
 	.quad	0x008F67A1E3FE5049, 0x1ECF43C7FB84C2F1	# 457
 	.quad	0x008F1779D9FE5009, 0x1E2EF3B3FB874432	# 458
 	.quad	0x008EC7AB39734FC9, 0x1D8F5672E4ABC83B	# 459
 	.quad	0x008E78356D154F49, 0x1CF06ADA2811CF07	# 460
 	.quad	0x008E2917E0E84F09, 0x1C522FC1CE058D9B	# 461
 	.quad	0x008DDA5202384E89, 0x1BB4A4046ED29012	# 462
 	.quad	0x008D8BE33F964E49, 0x1B17C67F2BAE2B21	# 463
 	.quad	0x008D3DCB08D44E09, 0x1A7B9611A7B9611B	# 464
 	.quad	0x008CF008CF014D89, 0x19E0119E0119E012	# 465
 	.quad	0x008CA29C04664D49, 0x19453808CA29C047	# 466
 	.quad	0x008C55841C824D09, 0x18AB083902BDAB95	# 467
 	.quad	0x008C08C08C094C89, 0x1811811811811812	# 468
 	.quad	0x008BBC50C8DF4C49, 0x1778A191BD684181	# 469
 	.quad	0x008B70344A144C09, 0x16E0689427378EB5	# 470
 	.quad	0x008B246A87E24BC9, 0x1648D50FC3201165	# 471
 	.quad	0x008AD8F2FBAA4B49, 0x15B1E5F75270D046	# 472
 	.quad	0x008A8DCD1FEF4B09, 0x151B9A3FDD5C8CB9	# 473
 	.quad	0x008A42F870574AC9, 0x1485F0E0ACD3B68D	# 474
 	.quad	0x0089F87469A34A49, 0x13F0E8D3447241C1	# 475
 	.quad	0x0089AE4089AF4A09, 0x135C81135C81135D	# 476
 	.quad	0x0089645C4F6F49C9, 0x12C8B89EDC0ABBD8	# 477
 	.quad	0x00891AC73AEA4989, 0x12358E75D30336A1	# 478
 	.quad	0x0088D180CD3B4909, 0x11A3019A748267AF	# 479
 	.quad	0x00888888888948C9, 0x1111111111111112	# 480
 	.quad	0x00883FDDF0094889, 0x107FBBE01107FBBF	# 481
 	.quad	0x0087F78087F84849, 0x0FEF010FEF010FF0	# 482
 	.quad	0x0087AF6FD59A4809, 0x0F5EDFAB325A1A81	# 483
 	.quad	0x008767AB5F354789, 0x0ECF56BE69C8FDE3	# 484
 	.quad	0x00872032AC144749, 0x0E40655826010E41	# 485
 	.quad	0x0086D905447B4709, 0x0DB20A88F469598D	# 486
 	.quad	0x00869222B1AD46C9, 0x0D24456359E39D2D	# 487
 	.quad	0x00864B8A7DE74689, 0x0C9714FBCDA3AC11	# 488
 	.quad	0x0086053C345B4649, 0x0C0A7868B41708E7	# 489
 	.quad	0x0085BF37612D4609, 0x0B7E6EC259DC7936	# 490
 	.quad	0x0085797B91784589, 0x0AF2F722EECB5713	# 491
 	.quad	0x0085340853414549, 0x0A6810A6810A6811	# 492
 	.quad	0x0084EEDD357D4509, 0x09DDBA6AF836010A	# 493
 	.quad	0x0084A9F9C80944C9, 0x0953F39010953F3A	# 494
 	.quad	0x0084655D9BAC4489, 0x08CABB37565E2011	# 495
 	.quad	0x0084210842114449, 0x0842108421084211	# 496
 	.quad	0x0083DCF94DC84409, 0x07B9F29B8EAE19C2	# 497
 	.quad	0x00839930524043C9, 0x073260A47F7C66D0	# 498
 	.quad	0x008355ACE3C94389, 0x06AB59C7912FB620	# 499
 	.quad	0x0083126E978E4309, 0x0624DD2F1A9FBE77	# 500
 	.quad	0x0082CF75039442C9, 0x059EEA0727586633	# 501
 	.quad	0x00828CBFBEBA4289, 0x05197F7D73404147	# 502
 	.quad	0x00824A4E60B44249, 0x04949CC1664C578A	# 503
 	.quad	0x0082082082094209, 0x0410410410410411	# 504
 	.quad	0x0081C635BC1341C9, 0x038C6B78247FBF1D	# 505
 	.quad	0x0081848DA8FB4189, 0x03091B51F5E1A4EF	# 506
 	.quad	0x00814327E3BA4149, 0x02864FC7729E8C5F	# 507
 	.quad	0x0081020408114109, 0x0204081020408103	# 508
 	.quad	0x0080C121B28C40C9, 0x0182436517A37530	# 509
 	.quad	0x0080808080814089, 0x0101010101010102	# 510
 	.quad	0x0080402010094049, 0x0080402010080403	# 511
 	.quad	0x8000000000004009, 0x0000000000000000	# 512

