/*
 * TOKENS - This file contains the initialized tables of text, token pairs for
 * all the C language symbols and keywords, and the mapped value for YACC
 * and inline assembler.
 *
 * IMPORTANT : this MUST be in the same order as the %token list in grammar.y
 *
 */
/* token        TEXT             MAPPED TO       IL OPCODE       ASM TOKEN */

DAT(L_NOTOKEN,  L"newline",      L_NOTOKEN,      MAX_OPCODE,     ML_NL)
DAT(L_IDENT,    L"identifier",   L_IDENT,        OPname,         ML_IDENT)
DAT(L_STRING,   L"string",       L_STRING,       OPconstant,     ML_NOTOKEN)
DAT(L_CFLOAT,   L"float constant", L_CONSTANT,   OPconstant,     ML_NOTOKEN)
DAT(L_CDOUBLE,  L"double constant", L_CONSTANT,  OPconstant,     ML_NOTOKEN)
DAT(L_CLDOUBLE, L"long double constant",L_CONSTANT, OPconstant,  ML_NOTOKEN)
DAT(L_CINTEGER, L"int constant", L_CONSTANT,     OPconstant,     ML_CONSTANT)
DAT(L_LONGINT,  L"long constant", L_CONSTANT,    OPconstant,     ML_CONSTANT)
DAT(L_CUNSIGNED,L"unsigned int constant",L_CONSTANT,OPconstant,  ML_CONSTANT)
DAT(L_LONGUNSIGNED,L"unsigned long constant",L_CONSTANT,OPconstant,ML_CONSTANT)
DAT(L_AUTO,     L"auto",         L_CLASS,        MAX_OPCODE,     ML_IDENT)
DAT(L_STATIC,   L"static",       L_CLASS,        MAX_OPCODE,     ML_IDENT)
DAT(L_EXTERN,   L"extern",       L_CLASS,        MAX_OPCODE,     ML_IDENT)
DAT(L_REGISTER, L"register",     L_CLASS,        MAX_OPCODE,     ML_IDENT)
DAT(L_TYPEDEF,  L"typedef",      L_CLASS,        MAX_OPCODE,     ML_IDENT)
DAT(L_FORTRAN,  Fortran_str,     L_MODIFIER,     MAX_OPCODE,     ML_IDENT)
DAT(L_PASCAL,   Pascal_str,      L_MODIFIER,     MAX_OPCODE,     ML_IDENT)
DAT(L_C,        Cdecl_str,       L_MODIFIER,     MAX_OPCODE,     ML_IDENT)
DAT(L_INTERRUPT,L"interrupt",    L_MODIFIER,     MAX_OPCODE,     ML_IDENT)
DAT(L_SAVEREGS, L"saveregs",     L_MODIFIER,     MAX_OPCODE,     ML_IDENT)
DAT(L_LOADDS,   L"loadds",       L_MODIFIER,     MAX_OPCODE,     ML_IDENT)
DAT(L_EXPORT,   L"export",       L_MODIFIER,     MAX_OPCODE,     ML_IDENT)
DAT(L_ASM,      L"_asm",         L_ASM,          MAX_OPCODE,     ML_NL)
DAT(L_NEAR,     L"near",         L_MODIFIER,     MAX_OPCODE,     ML_IDENT)
DAT(L_FAR,      L"far",          L_MODIFIER,     MAX_OPCODE,     ML_IDENT)
DAT(L_HUGE,     L"huge",         L_MODIFIER,     MAX_OPCODE,     ML_IDENT)
DAT(L_CONST,    L"const",        L_MODIFIER,     MAX_OPCODE,     ML_CDATATYPE)
DAT(L_VOLATILE, L"volatile",     L_MODIFIER,     MAX_OPCODE,     ML_CDATATYPE)
DAT(L_CHAR,     L"char",         L_TYPE,         MAX_OPCODE,     ML_CDATATYPE)
DAT(L_INT,      L"int",          L_TYPE,         MAX_OPCODE,     ML_CDATATYPE)
DAT(L_FLOAT,    L"float",        L_TYPE,         MAX_OPCODE,     ML_CDATATYPE)
DAT(L_DOUBLE,   L"double",       L_TYPE,         MAX_OPCODE,     ML_CDATATYPE)
DAT(L_SHORT,    L"short",        L_TYPE,         MAX_OPCODE,     ML_CDATATYPE)
DAT(L_LONG,     L"long",         L_TYPE,         MAX_OPCODE,     ML_CDATATYPE)
DAT(L_VOID,     L"void",         L_TYPE,         MAX_OPCODE,     ML_IDENT)
DAT(L_SIGNED,   L"signed",       L_TYPE,         MAX_OPCODE,     ML_CDATATYPE)
DAT(L_UNSIGNED, L"unsigned",     L_TYPE,         MAX_OPCODE,     ML_CDATATYPE)
DAT(L_ENUM,     L"enum",         L_ENUM,         MAX_OPCODE,     ML_IDENT)
DAT(L_ENUM_TAG, L"enum tag",     L_ENUM_TAG,     MAX_OPCODE,     ML_NOTOKEN)
DAT(L_STRUCT,   L"struct",       L_STRUCT,       MAX_OPCODE,     ML_IDENT)
DAT(L_STRUCT_TAG,L"struct tag",  L_STRUCT_TAG,   MAX_OPCODE,     ML_NOTOKEN)
DAT(L_UNION,    L"union",        L_UNION,        MAX_OPCODE,     ML_IDENT)
DAT(L_UNION_TAG,L"union tag",    L_UNION_TAG,    MAX_OPCODE,     ML_NOTOKEN)
DAT(L_AND,      L"&",            L_AND,          OPband,         ML_AND)
DAT(L_ANDAND,   L"&&",           L_ANDAND,       OPandif,        ML_NOTOKEN)
DAT(L_ANDEQ,    L"&=",           L_ASOP,         OPandeq,        ML_NOTOKEN)
DAT(L_ASSIGN,   L"=",            L_ASSIGN,       OPassign,       ML_NOTOKEN)
DAT(L_BIT,      L"bit field",    L_BIT,          OPbit,          ML_NOTOKEN)
DAT(L_COLON,    L":",            L_COLON,        OPcolon,        ML_COLON)
DAT(L_COMMA,    L",",            L_COMMA,        OPcomma,        ML_COMMA)
DAT(L_DECR,     L"--",           L_INCOP,        OPpostdecr,     ML_NOTOKEN)
DAT(L_DIV,      L"/",            L_DIVOP,        OPdiv,          ML_DIV)
DAT(L_DIVEQ,    L"/=",           L_ASOP,         OPdiveq,        ML_NOTOKEN)
DAT(L_EQUALS,   L"==",           L_EQUOP,        OPeq,           ML_EQ)
DAT(L_EXCLAIM,  L"!",            L_EXCLAIM,      OPnot,          ML_NOTOKEN)
DAT(L_EXTRACT,  L"*",            L_EXTRACT,      OPextract,      ML_NOTOKEN)
DAT(L_GT,       L">",            L_RELOP,        OPgt,           ML_GT)
DAT(L_GTEQ,     L">=",           L_RELOP,        OPge,           ML_GE)
DAT(L_INCR,     L"++",           L_INCOP,        OPpostincr,     ML_NOTOKEN)
DAT(L_LBRACK,   L"[",            L_LBRACK,       OPindex,        ML_LBRACK)
DAT(L_LSHFTEQ,  L"<<=",          L_ASOP,         OPlsheq,        ML_NOTOKEN)
DAT(L_LSHIFT,   L"<<",           L_SHIFTOP,      OPlshift,       ML_SHL)
DAT(L_LT,       L"<",            L_RELOP,        OPlt,           ML_LT)
DAT(L_LTEQ,     L"<=",           L_RELOP,        OPle,           ML_LE)
DAT(L_MINUS,    L"-",            L_MINUS,        OPminus,        ML_SUB)
DAT(L_MINUSEQ,  L"-=",           L_ASOP,         OPminuseq,      ML_NOTOKEN)
DAT(L_MOD,      L"%",            L_DIVOP,        OPrem,          ML_MOD)
DAT(L_MODEQ,    L"%=",           L_ASOP,         OPremeq,        ML_NOTOKEN)
DAT(L_MULT,     L"*",            L_MULT,         OPmult,         ML_MUL)
DAT(L_MULTEQ,   L"*=",           L_ASOP,         OPmulteq,       ML_NOTOKEN)
DAT(L_NOTEQ,    L"!=",           L_EQUOP,        OPne,           ML_NE)
DAT(L_OR,       L"|",            L_OR,           OPbor,          ML_OR)
DAT(L_OREQ,     L"|=",           L_ASOP,         OPoreq,         ML_NOTOKEN)
DAT(L_OROR,     L"||",           L_OROR,         OPorelse,       ML_NOTOKEN)
DAT(L_PERIOD,   L".",            L_STUNOP,       OPfield,        ML_PERIOD)
DAT(L_PLUS,     L"+",            L_PLUS,         OPplus,         ML_ADD)
DAT(L_PLUSEQ,   L"+=",           L_ASOP,         OPpluseq,       ML_NOTOKEN)
DAT(L_POINTSTO, L"->",           L_STUNOP,       OPfield,        ML_NOTOKEN)
DAT(L_PREDECR,  L"--",           L_INCOP,        OPminuseq,      ML_NOTOKEN)
DAT(L_PREINCR,  L"++",           L_INCOP,        OPpluseq,       ML_NOTOKEN)
DAT(L_QUEST,    L"?",            L_QUEST,        OPquestion,     ML_NOTOKEN)
DAT(L_RSHFTEQ,  L">>=",          L_ASOP,         OPrsheq,        ML_NOTOKEN)
DAT(L_RSHIFT,   L">>",           L_SHIFTOP,      OPrshift,       ML_SHR)
DAT(L_TILDE,    L"~",            L_TILDE,        OPcompl,        ML_NOT)
DAT(L_UMINUS,   L"unary minus",  L_UMINUS,       OPneg,          ML_NOTOKEN)
DAT(L_XOR,      L"^",            L_XOR,          OPxor,          ML_XOR)
DAT(L_XOREQ,    L"^=",           L_ASOP,         OPxoreq,        ML_NOTOKEN)
DAT(L_ARG,      L"argument",     L_ARG,          OPargument,     ML_NOTOKEN)
DAT(L_ASOP,     L"assign op",    L_ASOP,         MAX_OPCODE,     ML_NOTOKEN)
DAT(L_BREAK,    L"break",        L_BREAK,        MAX_OPCODE,     ML_IDENT)
DAT(L_CASE,     L"case",         L_CASE,         OPcase,         ML_IDENT)
DAT(L_CAST,     L"cast",         L_CAST,         OPcast,         ML_NOTOKEN)
DAT(L_CLASS,    L"storage class",L_CLASS,        MAX_OPCODE,     ML_IDENT)
DAT(L_CONSTANT, L"constant",     L_CONSTANT,     MAX_OPCODE,     ML_MAPPED)
DAT(L_CONTINUE, L"continue",     L_CONTINUE,     MAX_OPCODE,     ML_IDENT)
DAT(L_DEFAULT,  L"default",      L_DEFAULT,      MAX_OPCODE,     ML_IDENT)
DAT(L_DIVOP,    L"div op",       L_DIVOP,        MAX_OPCODE,     ML_MAPPED)
DAT(L_DO,       L"do",           L_DO,           MAX_OPCODE,     ML_IDENT)
DAT(L_ELLIPSIS, L"...",          L_ELLIPSIS,     MAX_OPCODE,     ML_NOTOKEN)
DAT(L_ELSE,     L"else",         L_ELSE,         MAX_OPCODE,     ML_IDENT)
DAT(L_ENTRY,    L"entry",        L_ENTRY,        OPentry,        ML_NOTOKEN)
DAT(L_EOF,      L"end of file",  0,              MAX_OPCODE,     ML_EOF)
DAT(L_EQUOP,    L"equ op",       L_EQUOP,        MAX_OPCODE,     ML_NOTOKEN)
DAT(L_FILE,     0,               L_FILE,         MAX_OPCODE,     ML_NOTOKEN)
DAT(L_FOR,      L"for",          L_FOR,          MAX_OPCODE,     ML_IDENT)
DAT(L_FUNCTION, L"argument",     L_FUNCTION,     MAX_OPCODE,     ML_NOTOKEN)
DAT(L_GOTO,     L"goto",         L_GOTO,         MAX_OPCODE,     ML_IDENT)
DAT(L_IF,       L"if",           L_IF,           MAX_OPCODE,     ML_IDENT)
DAT(L_INCOP,    L"incr op",      L_INCOP,        MAX_OPCODE,     ML_NOTOKEN)
DAT(L_INIT,     L"initializing", L_INIT,         MAX_OPCODE,     ML_NOTOKEN)
DAT(L_LCURLY,   L"{",            L_LCURLY,       MAX_OPCODE,     ML_LCURLY)
DAT(L_LINE,     L"line",         L_LINE,         MAX_OPCODE,     ML_NOTOKEN)
DAT(L_LPAREN,   L"(",            L_LPAREN,       OPfunction,     ML_LPAREN)
DAT(L_INTRINSIC,L"intrinsic",    L_INTRINSIC,    OPintrinsic,    ML_NOTOKEN)
DAT(L_MODIFIER, L"modifier",     L_MODIFIER,     MAX_OPCODE,     ML_MAPPED)
DAT(L_MODULE,   L"module",       L_MODULE,       MAX_OPCODE,     ML_NOTOKEN)
DAT(L_RBRACK,   L"]",            L_RBRACK,       MAX_OPCODE,     ML_RBRACK)
DAT(L_RCURLY,   L"}",            L_RCURLY,       MAX_OPCODE,     ML_NL)
DAT(L_RELOP,    L"rel op",       L_RELOP,        MAX_OPCODE,     ML_MAPPED)
DAT(L_RETURN,   L"return",       L_RETURN,       MAX_OPCODE,     ML_IDENT)
DAT(L_RPAREN,   L")",            L_RPAREN,       MAX_OPCODE,     ML_RPAREN)
DAT(L_SELF,     L"_self",        L_SELF,         OPself,         ML_IDENT)
DAT(L_SEMI,     L";",            L_SEMI,         MAX_OPCODE,     ML_SEMI)
DAT(L_SHIFTOP,  L"shift op",     L_SHIFTOP,      MAX_OPCODE,     ML_MAPPED)
DAT(L_SIZEOF,   L"sizeof",       L_SIZEOF,       MAX_OPCODE,     ML_IDENT)
DAT(L_STUNOP,   L"struct op",    L_STUNOP,       MAX_OPCODE,     ML_MAPPED)
DAT(L_SW,       L"switch",       L_SW,           OPswitch,       ML_IDENT)
DAT(L_SWEXP,    0,               L_SWEXP,        OPswexp,        ML_NOTOKEN)
DAT(L_TYPE,     L"type",         L_TYPE,         MAX_OPCODE,     ML_MAPPED)
DAT(L_TYPENAME, L"typedef name", L_TYPENAME,     MAX_OPCODE,     ML_CTYPENAME)
DAT(L_UPLUS,    L"unary plus",   L_UPLUS,        OPparen,        ML_NOTOKEN)
DAT(L_WHILE,    L"while",        L_WHILE,        MAX_OPCODE,     ML_IDENT)
DAT(0,          0,               0,              MAX_OPCODE,     ML_NOTOKEN)

