
/*++

       File: Zbase.c

	  Profiling dll for kernel32.dll

          NOTE: This file is generated by WRAPPER code generator

--*/
#include <nt.h>
#include <ntrtl.h>
#include <nturtl.h>
#include "windows.h"
#include "api32prf.h"     //Data Structures
#include "zwinbase.h"

extern BOOLEAN fInitDone;



ATOM  ZAddAtomA (LPCSTR lpString)
{

    ATOM RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = AddAtomA(lpString);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_AddAtomA, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

ATOM  ZAddAtomW (LPCWSTR lpString)
{

    ATOM RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = AddAtomW(lpString);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_AddAtomW, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZAllocConsole ()
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = AllocConsole();
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_AllocConsole, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZBackupRead (HANDLE hFile,LPBYTE lpBuffer,DWORD nNumberOfBytesToRead,LPDWORD lpNumberOfBytesRead,BOOL bAbort,BOOL bProcessSecurity,LPVOID* lpContext)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = BackupRead(hFile,lpBuffer,nNumberOfBytesToRead,lpNumberOfBytesRead,bAbort,bProcessSecurity,lpContext);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_BackupRead, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZBackupSeek (HANDLE hFile,DWORD dwLowBytesToSeek,DWORD dwHighBytesToSeek,LPDWORD lpdwLowByteSeeked,LPDWORD lpdwHighByteSeeked,LPVOID* lpContext)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = BackupSeek(hFile,dwLowBytesToSeek,dwHighBytesToSeek,lpdwLowByteSeeked,lpdwHighByteSeeked,lpContext);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_BackupSeek, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZBackupWrite (HANDLE hFile,LPBYTE lpBuffer,DWORD nNumberOfBytesToWrite,LPDWORD lpNumberOfBytesWritten,BOOL bAbort,BOOL bProcessSecurity,LPVOID* lpContext)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = BackupWrite(hFile,lpBuffer,nNumberOfBytesToWrite,lpNumberOfBytesWritten,bAbort,bProcessSecurity,lpContext);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_BackupWrite, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZBeep (DWORD dwFreq,DWORD dwDuration)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = Beep(dwFreq,dwDuration);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_Beep, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

HANDLE  ZBeginUpdateResourceA (LPCSTR pFileName,BOOL bDeleteExistingResources)
{

    HANDLE RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = BeginUpdateResourceA(pFileName,bDeleteExistingResources);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_BeginUpdateResourceA, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

HANDLE  ZBeginUpdateResourceW (LPCWSTR pFileName,BOOL bDeleteExistingResources)
{

    HANDLE RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = BeginUpdateResourceW(pFileName,bDeleteExistingResources);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_BeginUpdateResourceW, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZBuildCommDCBA (LPCSTR lpDef,LPDCB lpDCB)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = BuildCommDCBA(lpDef,lpDCB);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_BuildCommDCBA, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZBuildCommDCBAndTimeoutsA (LPCSTR lpDef,LPDCB lpDCB,LPCOMMTIMEOUTS lpCommTimeouts)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = BuildCommDCBAndTimeoutsA(lpDef,lpDCB,lpCommTimeouts);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_BuildCommDCBAndTimeoutsA, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZBuildCommDCBAndTimeoutsW (LPCWSTR lpDef,LPDCB lpDCB,LPCOMMTIMEOUTS lpCommTimeouts)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = BuildCommDCBAndTimeoutsW(lpDef,lpDCB,lpCommTimeouts);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_BuildCommDCBAndTimeoutsW, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZBuildCommDCBW (LPCWSTR lpDef,LPDCB lpDCB)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = BuildCommDCBW(lpDef,lpDCB);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_BuildCommDCBW, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZCallNamedPipeA (LPCSTR lpNamedPipeName,LPVOID lpInBuffer,DWORD nInBufferSize,LPVOID lpOutBuffer,DWORD nOutBufferSize,LPDWORD lpBytesRead,DWORD nTimeOut)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = CallNamedPipeA(lpNamedPipeName,lpInBuffer,nInBufferSize,lpOutBuffer,nOutBufferSize,lpBytesRead,nTimeOut);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_CallNamedPipeA, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZCallNamedPipeW (LPCWSTR lpNamedPipeName,LPVOID lpInBuffer,DWORD nInBufferSize,LPVOID lpOutBuffer,DWORD nOutBufferSize,LPDWORD lpBytesRead,DWORD nTimeOut)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = CallNamedPipeW(lpNamedPipeName,lpInBuffer,nInBufferSize,lpOutBuffer,nOutBufferSize,lpBytesRead,nTimeOut);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_CallNamedPipeW, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZClearCommBreak (HANDLE hFile)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = ClearCommBreak(hFile);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_ClearCommBreak, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZClearCommError (HANDLE hFile,LPDWORD lpErrors,LPCOMSTAT lpStat)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = ClearCommError(hFile,lpErrors,lpStat);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_ClearCommError, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZCloseHandle (HANDLE hObject)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = CloseHandle(hObject);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_CloseHandle, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

LONG  ZCompareFileTime (const FILETIME* lpFileTime1,const FILETIME* lpFileTime2)
{

    LONG RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = CompareFileTime(lpFileTime1,lpFileTime2);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_CompareFileTime, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

int  ZCompareStringW (LCID Locale,DWORD dwCmpFlags,LPCWSTR lpString1,int cchCount1,LPCWSTR lpString2,int cchCount2)
{

    int RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = CompareStringW(Locale,dwCmpFlags,lpString1,cchCount1,lpString2,cchCount2);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_CompareStringW, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZConnectNamedPipe (HANDLE hNamedPipe,LPOVERLAPPED lpOverlapped)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = ConnectNamedPipe(hNamedPipe,lpOverlapped);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_ConnectNamedPipe, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZContinueDebugEvent (DWORD dwProcessId,DWORD dwThreadId,DWORD dwContinueStatus)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = ContinueDebugEvent(dwProcessId,dwThreadId,dwContinueStatus);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_ContinueDebugEvent, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZCopyFileA (LPCSTR lpExistingFileName,LPCSTR lpNewFileName,BOOL bFailIfExists)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = CopyFileA(lpExistingFileName,lpNewFileName,bFailIfExists);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_CopyFileA, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZCopyFileW (LPCWSTR lpExistingFileName,LPCWSTR lpNewFileName,BOOL bFailIfExists)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = CopyFileW(lpExistingFileName,lpNewFileName,bFailIfExists);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_CopyFileW, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

HANDLE  ZCreateConsoleScreenBuffer (DWORD dwDesiredAccess,DWORD dwShareMode,LPSECURITY_ATTRIBUTES lpSecurityAttributes,DWORD dwFlags,PVOID lpScreenBufferData)
{

    HANDLE RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = CreateConsoleScreenBuffer(dwDesiredAccess,dwShareMode,lpSecurityAttributes,dwFlags,lpScreenBufferData);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_CreateConsoleScreenBuffer, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZCreateDirectoryA (LPCSTR lpPathName,LPSECURITY_ATTRIBUTES lpSecurityAttributes)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = CreateDirectoryA(lpPathName,lpSecurityAttributes);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_CreateDirectoryA, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZCreateDirectoryExA (LPCSTR lpTemplateDirectory,LPCSTR lpNewDirectory,LPSECURITY_ATTRIBUTES lpSecurityAttributes)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = CreateDirectoryExA(lpTemplateDirectory,lpNewDirectory,lpSecurityAttributes);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_CreateDirectoryExA, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZCreateDirectoryExW (LPCWSTR lpTemplateDirectory,LPCWSTR lpNewDirectory,LPSECURITY_ATTRIBUTES lpSecurityAttributes)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = CreateDirectoryExW(lpTemplateDirectory,lpNewDirectory,lpSecurityAttributes);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_CreateDirectoryExW, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZCreateDirectoryW (LPCWSTR lpPathName,LPSECURITY_ATTRIBUTES lpSecurityAttributes)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = CreateDirectoryW(lpPathName,lpSecurityAttributes);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_CreateDirectoryW, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

HANDLE  ZCreateEventA (LPSECURITY_ATTRIBUTES lpEventAttributes,BOOL bManualReset,BOOL bInitialState,LPCSTR lpName)
{

    HANDLE RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = CreateEventA(lpEventAttributes,bManualReset,bInitialState,lpName);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_CreateEventA, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

HANDLE  ZCreateEventW (LPSECURITY_ATTRIBUTES lpEventAttributes,BOOL bManualReset,BOOL bInitialState,LPCWSTR lpName)
{

    HANDLE RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = CreateEventW(lpEventAttributes,bManualReset,bInitialState,lpName);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_CreateEventW, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

HANDLE  ZCreateFileA (LPCSTR lpFileName,DWORD dwDesiredAccess,DWORD dwShareMode,LPSECURITY_ATTRIBUTES lpSecurityAttributes,DWORD dwCreationDisposition,DWORD dwFlagsAndAttributes,HANDLE hTemplateFile)
{

    HANDLE RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = CreateFileA(lpFileName,dwDesiredAccess,dwShareMode,lpSecurityAttributes,dwCreationDisposition,dwFlagsAndAttributes,hTemplateFile);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_CreateFileA, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

HANDLE  ZCreateFileMappingA (HANDLE hFile,LPSECURITY_ATTRIBUTES lpFileMappingAttributes,DWORD flProtect,DWORD dwMaximumSizeHigh,DWORD dwMaximumSizeLow,LPCSTR lpName)
{

    HANDLE RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = CreateFileMappingA(hFile,lpFileMappingAttributes,flProtect,dwMaximumSizeHigh,dwMaximumSizeLow,lpName);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_CreateFileMappingA, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

HANDLE  ZCreateFileMappingW (HANDLE hFile,LPSECURITY_ATTRIBUTES lpFileMappingAttributes,DWORD flProtect,DWORD dwMaximumSizeHigh,DWORD dwMaximumSizeLow,LPCWSTR lpName)
{

    HANDLE RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = CreateFileMappingW(hFile,lpFileMappingAttributes,flProtect,dwMaximumSizeHigh,dwMaximumSizeLow,lpName);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_CreateFileMappingW, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

HANDLE  ZCreateFileW (LPCWSTR lpFileName,DWORD dwDesiredAccess,DWORD dwShareMode,LPSECURITY_ATTRIBUTES lpSecurityAttributes,DWORD dwCreationDisposition,DWORD dwFlagsAndAttributes,HANDLE hTemplateFile)
{

    HANDLE RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = CreateFileW(lpFileName,dwDesiredAccess,dwShareMode,lpSecurityAttributes,dwCreationDisposition,dwFlagsAndAttributes,hTemplateFile);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_CreateFileW, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

HANDLE  ZCreateMailslotA (LPCSTR lpName,DWORD nMaxMessageSize,DWORD lReadTimeout,LPSECURITY_ATTRIBUTES lpSecurityAttributes)
{

    HANDLE RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = CreateMailslotA(lpName,nMaxMessageSize,lReadTimeout,lpSecurityAttributes);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_CreateMailslotA, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

HANDLE  ZCreateMailslotW (LPCWSTR lpName,DWORD nMaxMessageSize,DWORD lReadTimeout,LPSECURITY_ATTRIBUTES lpSecurityAttributes)
{

    HANDLE RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = CreateMailslotW(lpName,nMaxMessageSize,lReadTimeout,lpSecurityAttributes);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_CreateMailslotW, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

HANDLE  ZCreateMutexA (LPSECURITY_ATTRIBUTES lpMutexAttributes,BOOL bInitialOwner,LPCSTR lpName)
{

    HANDLE RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = CreateMutexA(lpMutexAttributes,bInitialOwner,lpName);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_CreateMutexA, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

HANDLE  ZCreateMutexW (LPSECURITY_ATTRIBUTES lpMutexAttributes,BOOL bInitialOwner,LPCWSTR lpName)
{

    HANDLE RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = CreateMutexW(lpMutexAttributes,bInitialOwner,lpName);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_CreateMutexW, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

HANDLE  ZCreateNamedPipeA (LPCSTR lpName,DWORD dwOpenMode,DWORD dwPipeMode,DWORD nMaxInstances,DWORD nOutBufferSize,DWORD nInBufferSize,DWORD nDefaultTimeOut,LPSECURITY_ATTRIBUTES lpSecurityAttributes)
{

    HANDLE RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = CreateNamedPipeA(lpName,dwOpenMode,dwPipeMode,nMaxInstances,nOutBufferSize,nInBufferSize,nDefaultTimeOut,lpSecurityAttributes);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_CreateNamedPipeA, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

HANDLE  ZCreateNamedPipeW (LPCWSTR lpName,DWORD dwOpenMode,DWORD dwPipeMode,DWORD nMaxInstances,DWORD nOutBufferSize,DWORD nInBufferSize,DWORD nDefaultTimeOut,LPSECURITY_ATTRIBUTES lpSecurityAttributes)
{

    HANDLE RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = CreateNamedPipeW(lpName,dwOpenMode,dwPipeMode,nMaxInstances,nOutBufferSize,nInBufferSize,nDefaultTimeOut,lpSecurityAttributes);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_CreateNamedPipeW, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZCreatePipe (PHANDLE hReadPipe,PHANDLE hWritePipe,LPSECURITY_ATTRIBUTES lpPipeAttributes,DWORD nSize)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = CreatePipe(hReadPipe,hWritePipe,lpPipeAttributes,nSize);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_CreatePipe, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZCreateProcessA (LPCSTR lpApplicationName,LPCSTR lpCommandLine,LPSECURITY_ATTRIBUTES lpProcessAttributes,LPSECURITY_ATTRIBUTES lpThreadAttributes,BOOL bInheritHandles,DWORD dwCreationFlags,LPVOID lpEnvironment,LPCSTR lpCurrentDirectory,LPSTARTUPINFOA lpStartupInfo,LPPROCESS_INFORMATION lpProcessInformation)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = CreateProcessA(lpApplicationName,lpCommandLine,lpProcessAttributes,lpThreadAttributes,bInheritHandles,dwCreationFlags,lpEnvironment,lpCurrentDirectory,lpStartupInfo,lpProcessInformation);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_CreateProcessA, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZCreateProcessW (LPCWSTR lpApplicationName,LPCWSTR lpCommandLine,LPSECURITY_ATTRIBUTES lpProcessAttributes,LPSECURITY_ATTRIBUTES lpThreadAttributes,BOOL bInheritHandles,DWORD dwCreationFlags,LPVOID lpEnvironment,LPCWSTR lpCurrentDirectory,LPSTARTUPINFOW lpStartupInfo,LPPROCESS_INFORMATION lpProcessInformation)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = CreateProcessW(lpApplicationName,lpCommandLine,lpProcessAttributes,lpThreadAttributes,bInheritHandles,dwCreationFlags,lpEnvironment,lpCurrentDirectory,lpStartupInfo,lpProcessInformation);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_CreateProcessW, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

HANDLE  ZCreateRemoteThread (HANDLE hProcess,LPSECURITY_ATTRIBUTES lpThreadAttributes,DWORD dwStackSize,LPTHREAD_START_ROUTINE lpStartAddress,LPVOID lpParameter,DWORD dwCreationFlags,LPDWORD lpThreadId)
{

    HANDLE RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = CreateRemoteThread(hProcess,lpThreadAttributes,dwStackSize,lpStartAddress,lpParameter,dwCreationFlags,lpThreadId);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_CreateRemoteThread, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

HANDLE  ZCreateSemaphoreA (LPSECURITY_ATTRIBUTES lpSemaphoreAttributes,LONG lInitialCount,LONG lMaximumCount,LPCSTR lpName)
{

    HANDLE RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = CreateSemaphoreA(lpSemaphoreAttributes,lInitialCount,lMaximumCount,lpName);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_CreateSemaphoreA, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

HANDLE  ZCreateSemaphoreW (LPSECURITY_ATTRIBUTES lpSemaphoreAttributes,LONG lInitialCount,LONG lMaximumCount,LPCWSTR lpName)
{

    HANDLE RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = CreateSemaphoreW(lpSemaphoreAttributes,lInitialCount,lMaximumCount,lpName);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_CreateSemaphoreW, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

DWORD  ZCreateTapePartition (HANDLE hDevice,DWORD dwPartitionMethod,DWORD dwCount,DWORD dwSize)
{

    DWORD RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = CreateTapePartition(hDevice,dwPartitionMethod,dwCount,dwSize);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_CreateTapePartition, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

HANDLE  ZCreateThread (LPSECURITY_ATTRIBUTES lpThreadAttributes,DWORD dwStackSize,LPTHREAD_START_ROUTINE lpStartAddress,LPVOID lpParameter,DWORD dwCreationFlags,LPDWORD lpThreadId)
{

    HANDLE RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = CreateThread(lpThreadAttributes,dwStackSize,lpStartAddress,lpParameter,dwCreationFlags,lpThreadId);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_CreateThread, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZDebugActiveProcess (DWORD dwProcessId)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = DebugActiveProcess(dwProcessId);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_DebugActiveProcess, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

void  ZDebugBreak ()
{

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    DebugBreak();
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_DebugBreak, ulElapsedTime);
    TimerClose(sTimerHandle);

    return;
}

BOOL  ZDefineDosDeviceA (DWORD dwFlags,LPCSTR lpDeviceName,LPCSTR lpTargetPath)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = DefineDosDeviceA(dwFlags,lpDeviceName,lpTargetPath);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_DefineDosDeviceA, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZDefineDosDeviceW (DWORD dwFlags,LPCWSTR lpDeviceName,LPCWSTR lpTargetPath)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = DefineDosDeviceW(dwFlags,lpDeviceName,lpTargetPath);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_DefineDosDeviceW, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

ATOM  ZDeleteAtom (ATOM nAtom)
{

    ATOM RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = DeleteAtom(nAtom);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_DeleteAtom, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

void  ZDeleteCriticalSection (LPCRITICAL_SECTION lpCriticalSection)
{

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    DeleteCriticalSection(lpCriticalSection);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_DeleteCriticalSection, ulElapsedTime);
    TimerClose(sTimerHandle);

    return;
}

BOOL  ZDeleteFileA (LPCSTR lpFileName)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = DeleteFileA(lpFileName);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_DeleteFileA, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZDeleteFileW (LPCWSTR lpFileName)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = DeleteFileW(lpFileName);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_DeleteFileW, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZDeviceIoControl (HANDLE hDevice,DWORD dwIoControlCode,LPVOID lpInBuffer,DWORD nInBufferSize,LPVOID lpOutBuffer,DWORD nOutBufferSize,LPDWORD lpBytesReturned,LPOVERLAPPED lpOverlapped)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = DeviceIoControl(hDevice,dwIoControlCode,lpInBuffer,nInBufferSize,lpOutBuffer,nOutBufferSize,lpBytesReturned,lpOverlapped);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_DeviceIoControl, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZDisconnectNamedPipe (HANDLE hNamedPipe)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = DisconnectNamedPipe(hNamedPipe);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_DisconnectNamedPipe, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZDosDateTimeToFileTime (WORD wFatDate,WORD wFatTime,LPFILETIME lpFileTime)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = DosDateTimeToFileTime(wFatDate,wFatTime,lpFileTime);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_DosDateTimeToFileTime, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZDuplicateHandle (HANDLE hSourceProcessHandle,HANDLE hSourceHandle,HANDLE hTargetProcessHandle,LPHANDLE lpTargetHandle,DWORD dwDesiredAccess,BOOL bInheritHandle,DWORD dwOptions)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = DuplicateHandle(hSourceProcessHandle,hSourceHandle,hTargetProcessHandle,lpTargetHandle,dwDesiredAccess,bInheritHandle,dwOptions);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_DuplicateHandle, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZEndUpdateResourceA (HANDLE hUpdate,BOOL fDiscard)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = EndUpdateResourceA(hUpdate,fDiscard);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_EndUpdateResourceA, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZEndUpdateResourceW (HANDLE hUpdate,BOOL fDiscard)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = EndUpdateResourceW(hUpdate,fDiscard);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_EndUpdateResourceW, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

void  ZEnterCriticalSection (LPCRITICAL_SECTION lpCriticalSection)
{

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    EnterCriticalSection(lpCriticalSection);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_EnterCriticalSection, ulElapsedTime);
    TimerClose(sTimerHandle);

    return;
}

BOOL  ZEnumResourceLanguagesA (HMODULE hModule,LPCSTR lpType,LPCSTR lpName,ENUMRESLANGPROC lpEnumFunc,LONG lParam)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = EnumResourceLanguagesA(hModule,lpType,lpName,lpEnumFunc,lParam);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_EnumResourceLanguagesA, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZEnumResourceLanguagesW (HMODULE hModule,LPCWSTR lpType,LPCWSTR lpName,ENUMRESLANGPROC lpEnumFunc,LONG lParam)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = EnumResourceLanguagesW(hModule,lpType,lpName,lpEnumFunc,lParam);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_EnumResourceLanguagesW, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZEnumResourceNamesA (HMODULE hModule,LPCSTR lpType,ENUMRESNAMEPROC lpEnumFunc,LONG lParam)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = EnumResourceNamesA(hModule,lpType,lpEnumFunc,lParam);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_EnumResourceNamesA, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZEnumResourceNamesW (HMODULE hModule,LPCWSTR lpType,ENUMRESNAMEPROC lpEnumFunc,LONG lParam)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = EnumResourceNamesW(hModule,lpType,lpEnumFunc,lParam);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_EnumResourceNamesW, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZEnumResourceTypesA (HMODULE hModule,ENUMRESTYPEPROC lpEnumFunc,LONG lParam)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = EnumResourceTypesA(hModule,lpEnumFunc,lParam);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_EnumResourceTypesA, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZEnumResourceTypesW (HMODULE hModule,ENUMRESTYPEPROC lpEnumFunc,LONG lParam)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = EnumResourceTypesW(hModule,lpEnumFunc,lParam);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_EnumResourceTypesW, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

DWORD  ZEraseTape (HANDLE hDevice,DWORD dwEraseType,BOOL bImmediate)
{

    DWORD RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = EraseTape(hDevice,dwEraseType,bImmediate);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_EraseTape, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZEscapeCommFunction (HANDLE hFile,DWORD dwFunc)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = EscapeCommFunction(hFile,dwFunc);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_EscapeCommFunction, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

void  ZExitProcess (UINT uExitCode)
{

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    ExitProcess(uExitCode);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_ExitProcess, ulElapsedTime);
    TimerClose(sTimerHandle);

    return;
}

void  ZExitThread (DWORD dwExitCode)
{

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    ExitThread(dwExitCode);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_ExitThread, ulElapsedTime);
    TimerClose(sTimerHandle);

    return;
}

DWORD  ZExpandEnvironmentStringsA (LPCSTR lpSrc,LPSTR lpDst,DWORD nSize)
{

    DWORD RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = ExpandEnvironmentStringsA(lpSrc,lpDst,nSize);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_ExpandEnvironmentStringsA, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

DWORD  ZExpandEnvironmentStringsW (LPCWSTR lpSrc,LPWSTR lpDst,DWORD nSize)
{

    DWORD RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = ExpandEnvironmentStringsW(lpSrc,lpDst,nSize);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_ExpandEnvironmentStringsW, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

void  ZFatalAppExitA (UINT uAction,LPCSTR lpMessageText)
{

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    FatalAppExitA(uAction,lpMessageText);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_FatalAppExitA, ulElapsedTime);
    TimerClose(sTimerHandle);

    return;
}

void  ZFatalAppExitW (UINT uAction,LPCWSTR lpMessageText)
{

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    FatalAppExitW(uAction,lpMessageText);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_FatalAppExitW, ulElapsedTime);
    TimerClose(sTimerHandle);

    return;
}

void  ZFatalExit (int ExitCode)
{

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    FatalExit(ExitCode);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_FatalExit, ulElapsedTime);
    TimerClose(sTimerHandle);

    return;
}

BOOL  ZFileTimeToDosDateTime (const FILETIME* lpFileTime,LPWORD lpFatDate,LPWORD lpFatTime)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = FileTimeToDosDateTime(lpFileTime,lpFatDate,lpFatTime);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_FileTimeToDosDateTime, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZFileTimeToLocalFileTime (const FILETIME* lpFileTime,LPFILETIME lpLocalFileTime)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = FileTimeToLocalFileTime(lpFileTime,lpLocalFileTime);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_FileTimeToLocalFileTime, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZFileTimeToSystemTime (const FILETIME* lpFileTime,LPSYSTEMTIME lpSystemTime)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = FileTimeToSystemTime(lpFileTime,lpSystemTime);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_FileTimeToSystemTime, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZFillConsoleOutputAttribute (HANDLE hConsoleOutput,WORD wAttribute,DWORD nLength,COORD dwWriteCoord,LPDWORD lpNumberOfAttrsWritten)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = FillConsoleOutputAttribute(hConsoleOutput,wAttribute,nLength,dwWriteCoord,lpNumberOfAttrsWritten);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_FillConsoleOutputAttribute, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZFillConsoleOutputCharacterA (HANDLE hConsoleOutput,CHAR cCharacter,DWORD nLength,COORD dwWriteCoord,LPDWORD lpNumberOfCharsWritten)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = FillConsoleOutputCharacterA(hConsoleOutput,cCharacter,nLength,dwWriteCoord,lpNumberOfCharsWritten);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_FillConsoleOutputCharacterA, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZFillConsoleOutputCharacterW (HANDLE hConsoleOutput,WCHAR cCharacter,DWORD nLength,COORD dwWriteCoord,LPDWORD lpNumberOfCharsWritten)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = FillConsoleOutputCharacterW(hConsoleOutput,cCharacter,nLength,dwWriteCoord,lpNumberOfCharsWritten);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_FillConsoleOutputCharacterW, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

ATOM  ZFindAtomA (LPCSTR lpString)
{

    ATOM RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = FindAtomA(lpString);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_FindAtomA, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

ATOM  ZFindAtomW (LPCWSTR lpString)
{

    ATOM RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = FindAtomW(lpString);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_FindAtomW, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZFindClose (HANDLE hFindFile)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = FindClose(hFindFile);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_FindClose, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZFindCloseChangeNotification (HANDLE hChangeHandle)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = FindCloseChangeNotification(hChangeHandle);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_FindCloseChangeNotification, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

HANDLE  ZFindFirstChangeNotificationA (LPCSTR lpPathName,BOOL bWatchSubtree,DWORD dwNotifyFilter)
{

    HANDLE RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = FindFirstChangeNotificationA(lpPathName,bWatchSubtree,dwNotifyFilter);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_FindFirstChangeNotificationA, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

HANDLE  ZFindFirstChangeNotificationW (LPCWSTR lpPathName,BOOL bWatchSubtree,DWORD dwNotifyFilter)
{

    HANDLE RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = FindFirstChangeNotificationW(lpPathName,bWatchSubtree,dwNotifyFilter);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_FindFirstChangeNotificationW, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

HANDLE  ZFindFirstFileA (LPCSTR lpFileName,LPWIN32_FIND_DATAA lpFindFileData)
{

    HANDLE RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = FindFirstFileA(lpFileName,lpFindFileData);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_FindFirstFileA, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

HANDLE  ZFindFirstFileW (LPCWSTR lpFileName,LPWIN32_FIND_DATAW lpFindFileData)
{

    HANDLE RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = FindFirstFileW(lpFileName,lpFindFileData);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_FindFirstFileW, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZFindNextChangeNotification (HANDLE hChangeHandle)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = FindNextChangeNotification(hChangeHandle);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_FindNextChangeNotification, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZFindNextFileA (HANDLE hFindFile,LPWIN32_FIND_DATAA lpFindFileData)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = FindNextFileA(hFindFile,lpFindFileData);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_FindNextFileA, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZFindNextFileW (HANDLE hFindFile,LPWIN32_FIND_DATAW lpFindFileData)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = FindNextFileW(hFindFile,lpFindFileData);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_FindNextFileW, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

HRSRC  ZFindResourceA (HMODULE hModule,LPCSTR lpName,LPCSTR lpType)
{

    HRSRC RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = FindResourceA(hModule,lpName,lpType);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_FindResourceA, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

HRSRC  ZFindResourceExA (HMODULE hModule,LPCSTR lpType,LPCSTR lpName,WORD wLanguage)
{

    HRSRC RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = FindResourceExA(hModule,lpType,lpName,wLanguage);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_FindResourceExA, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

HRSRC  ZFindResourceExW (HMODULE hModule,LPCWSTR lpType,LPCWSTR lpName,WORD wLanguage)
{

    HRSRC RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = FindResourceExW(hModule,lpType,lpName,wLanguage);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_FindResourceExW, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

HRSRC  ZFindResourceW (HMODULE hModule,LPCWSTR lpName,LPCWSTR lpType)
{

    HRSRC RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = FindResourceW(hModule,lpName,lpType);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_FindResourceW, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZFlushConsoleInputBuffer (HANDLE hConsoleInput)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = FlushConsoleInputBuffer(hConsoleInput);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_FlushConsoleInputBuffer, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZFlushFileBuffers (HANDLE hFile)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = FlushFileBuffers(hFile);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_FlushFileBuffers, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZFlushInstructionCache (HANDLE hProcess,LPCVOID lpBaseAddress,DWORD dwSize)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = FlushInstructionCache(hProcess,lpBaseAddress,dwSize);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_FlushInstructionCache, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZFlushViewOfFile (LPCVOID lpBaseAddress,DWORD dwNumberOfBytesToFlush)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = FlushViewOfFile(lpBaseAddress,dwNumberOfBytesToFlush);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_FlushViewOfFile, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

int  ZFoldStringW (DWORD dwMapFlags,LPCWSTR lpSrcStr,int cchSrc,LPWSTR lpDestStr,int cchDest)
{

    int RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = FoldStringW(dwMapFlags,lpSrcStr,cchSrc,lpDestStr,cchDest);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_FoldStringW, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

DWORD  ZFormatMessageA (DWORD dwFlags,LPCVOID lpSource,DWORD dwMessageId,DWORD dwLanguageId,LPSTR lpBuffer,DWORD nSize,va_list* Arguments)
{

    DWORD RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = FormatMessageA(dwFlags,lpSource,dwMessageId,dwLanguageId,lpBuffer,nSize,Arguments);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_FormatMessageA, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

DWORD  ZFormatMessageW (DWORD dwFlags,LPCVOID lpSource,DWORD dwMessageId,DWORD dwLanguageId,LPWSTR lpBuffer,DWORD nSize,va_list* Arguments)
{

    DWORD RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = FormatMessageW(dwFlags,lpSource,dwMessageId,dwLanguageId,lpBuffer,nSize,Arguments);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_FormatMessageW, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZFreeConsole ()
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = FreeConsole();
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_FreeConsole, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZFreeLibrary (HMODULE hLibModule)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = FreeLibrary(hLibModule);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_FreeLibrary, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZFreeResource (HGLOBAL hResData)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = FreeResource(hResData);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_FreeResource, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZGenerateConsoleCtrlEvent (DWORD dwCtrlEvent,DWORD dwProcessGroupId)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = GenerateConsoleCtrlEvent(dwCtrlEvent,dwProcessGroupId);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_GenerateConsoleCtrlEvent, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

UINT  ZGetACP ()
{

    UINT RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = GetACP();
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_GetACP, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

UINT  ZGetAtomNameA (ATOM nAtom,LPSTR lpBuffer,int nSize)
{

    UINT RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = GetAtomNameA(nAtom,lpBuffer,nSize);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_GetAtomNameA, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

UINT  ZGetAtomNameW (ATOM nAtom,LPWSTR lpBuffer,int nSize)
{

    UINT RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = GetAtomNameW(nAtom,lpBuffer,nSize);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_GetAtomNameW, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZGetCPInfo (UINT CodePage,LPCPINFO lpCPInfo)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = GetCPInfo(CodePage,lpCPInfo);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_GetCPInfo, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZGetCommMask (HANDLE hFile,LPDWORD lpEvtMask)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = GetCommMask(hFile,lpEvtMask);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_GetCommMask, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZGetCommModemStatus (HANDLE hFile,LPDWORD lpModemStat)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = GetCommModemStatus(hFile,lpModemStat);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_GetCommModemStatus, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZGetCommProperties (HANDLE hFile,LPCOMMPROP lpCommProp)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = GetCommProperties(hFile,lpCommProp);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_GetCommProperties, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZGetCommState (HANDLE hFile,LPDCB lpDCB)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = GetCommState(hFile,lpDCB);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_GetCommState, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZGetCommTimeouts (HANDLE hFile,LPCOMMTIMEOUTS lpCommTimeouts)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = GetCommTimeouts(hFile,lpCommTimeouts);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_GetCommTimeouts, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

LPSTR  ZGetCommandLineA ()
{

    LPSTR RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = GetCommandLineA();
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_GetCommandLineA, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

LPWSTR  ZGetCommandLineW ()
{

    LPWSTR RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = GetCommandLineW();
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_GetCommandLineW, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZGetComputerNameA (LPSTR lpBuffer,LPDWORD nSize)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = GetComputerNameA(lpBuffer,nSize);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_GetComputerNameA, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZGetComputerNameW (LPWSTR lpBuffer,LPDWORD nSize)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = GetComputerNameW(lpBuffer,nSize);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_GetComputerNameW, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

UINT  ZGetConsoleCP ()
{

    UINT RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = GetConsoleCP();
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_GetConsoleCP, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZGetConsoleCursorInfo (HANDLE hConsoleOutput,PCONSOLE_CURSOR_INFO lpConsoleCursorInfo)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = GetConsoleCursorInfo(hConsoleOutput,lpConsoleCursorInfo);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_GetConsoleCursorInfo, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZGetConsoleMode (HANDLE hConsoleHandle,LPDWORD lpMode)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = GetConsoleMode(hConsoleHandle,lpMode);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_GetConsoleMode, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

UINT  ZGetConsoleOutputCP ()
{

    UINT RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = GetConsoleOutputCP();
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_GetConsoleOutputCP, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZGetConsoleScreenBufferInfo (HANDLE hConsoleOutput,PCONSOLE_SCREEN_BUFFER_INFO lpConsoleScreenBufferInfo)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = GetConsoleScreenBufferInfo(hConsoleOutput,lpConsoleScreenBufferInfo);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_GetConsoleScreenBufferInfo, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

DWORD  ZGetConsoleTitleA (LPSTR lpConsoleTitle,DWORD nSize)
{

    DWORD RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = GetConsoleTitleA(lpConsoleTitle,nSize);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_GetConsoleTitleA, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

DWORD  ZGetConsoleTitleW (LPWSTR lpConsoleTitle,DWORD nSize)
{

    DWORD RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = GetConsoleTitleW(lpConsoleTitle,nSize);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_GetConsoleTitleW, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

DWORD  ZGetCurrentDirectoryA (DWORD nBufferLength,LPSTR lpBuffer)
{

    DWORD RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = GetCurrentDirectoryA(nBufferLength,lpBuffer);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_GetCurrentDirectoryA, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

DWORD  ZGetCurrentDirectoryW (DWORD nBufferLength,LPWSTR lpBuffer)
{

    DWORD RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = GetCurrentDirectoryW(nBufferLength,lpBuffer);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_GetCurrentDirectoryW, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

HANDLE  ZGetCurrentProcess ()
{

    HANDLE RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = GetCurrentProcess();
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_GetCurrentProcess, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

DWORD  ZGetCurrentProcessId ()
{

    DWORD RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = GetCurrentProcessId();
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_GetCurrentProcessId, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

HANDLE  ZGetCurrentThread ()
{

    HANDLE RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = GetCurrentThread();
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_GetCurrentThread, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

DWORD  ZGetCurrentThreadId ()
{

    DWORD RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = GetCurrentThreadId();
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_GetCurrentThreadId, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

int  ZGetDateFormatW (LCID Locale,DWORD dwFlags,const SYSTEMTIME* lpDate,LPCWSTR lpFormat,LPWSTR lpDateStr,int cchDate)
{

    int RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = GetDateFormatW(Locale,dwFlags,lpDate,lpFormat,lpDateStr,cchDate);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_GetDateFormatW, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZGetDiskFreeSpaceA (LPCSTR lpRootPathName,LPDWORD lpSectorsPerCluster,LPDWORD lpBytesPerSector,LPDWORD lpNumberOfFreeClusters,LPDWORD lpTotalNumberOfClusters)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = GetDiskFreeSpaceA(lpRootPathName,lpSectorsPerCluster,lpBytesPerSector,lpNumberOfFreeClusters,lpTotalNumberOfClusters);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_GetDiskFreeSpaceA, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZGetDiskFreeSpaceW (LPCWSTR lpRootPathName,LPDWORD lpSectorsPerCluster,LPDWORD lpBytesPerSector,LPDWORD lpNumberOfFreeClusters,LPDWORD lpTotalNumberOfClusters)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = GetDiskFreeSpaceW(lpRootPathName,lpSectorsPerCluster,lpBytesPerSector,lpNumberOfFreeClusters,lpTotalNumberOfClusters);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_GetDiskFreeSpaceW, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

UINT  ZGetDriveTypeA (LPCSTR lpRootPathName)
{

    UINT RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = GetDriveTypeA(lpRootPathName);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_GetDriveTypeA, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

UINT  ZGetDriveTypeW (LPCWSTR lpRootPathName)
{

    UINT RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = GetDriveTypeW(lpRootPathName);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_GetDriveTypeW, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

LPVOID  ZGetEnvironmentStringsA ()
{

    LPVOID RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = GetEnvironmentStringsA();
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_GetEnvironmentStringsA, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

LPVOID  ZGetEnvironmentStringsW ()
{

    LPVOID RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = GetEnvironmentStringsW();
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_GetEnvironmentStringsW, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}


DWORD  ZGetEnvironmentVariableA (LPCSTR lpName,LPSTR lpBuffer,DWORD nSize)
{

    DWORD RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = GetEnvironmentVariableA(lpName,lpBuffer,nSize);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_GetEnvironmentVariableA, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

DWORD  ZGetEnvironmentVariableW (LPCWSTR lpName,LPWSTR lpBuffer,DWORD nSize)
{

    DWORD RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = GetEnvironmentVariableW(lpName,lpBuffer,nSize);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_GetEnvironmentVariableW, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZGetExitCodeProcess (HANDLE hProcess,LPDWORD lpExitCode)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = GetExitCodeProcess(hProcess,lpExitCode);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_GetExitCodeProcess, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZGetExitCodeThread (HANDLE hThread,LPDWORD lpExitCode)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = GetExitCodeThread(hThread,lpExitCode);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_GetExitCodeThread, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

DWORD  ZGetFileAttributesA (LPCSTR lpFileName)
{

    DWORD RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = GetFileAttributesA(lpFileName);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_GetFileAttributesA, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

DWORD  ZGetFileAttributesW (LPCWSTR lpFileName)
{

    DWORD RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = GetFileAttributesW(lpFileName);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_GetFileAttributesW, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZGetFileInformationByHandle (HANDLE hFile,LPBY_HANDLE_FILE_INFORMATION lpFileInformation)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = GetFileInformationByHandle(hFile,lpFileInformation);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_GetFileInformationByHandle, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

DWORD  ZGetFileSize (HANDLE hFile,LPDWORD lpFileSizeHigh)
{

    DWORD RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = GetFileSize(hFile,lpFileSizeHigh);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_GetFileSize, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZGetFileTime (HANDLE hFile,LPFILETIME lpCreationTime,LPFILETIME lpLastAccessTime,LPFILETIME lpLastWriteTime)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = GetFileTime(hFile,lpCreationTime,lpLastAccessTime,lpLastWriteTime);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_GetFileTime, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

DWORD  ZGetFileType (HANDLE hFile)
{

    DWORD RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = GetFileType(hFile);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_GetFileType, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

DWORD  ZGetFullPathNameA (LPCSTR lpFileName,DWORD nBufferLength,LPSTR lpBuffer,LPSTR* lpFilePart)
{

    DWORD RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = GetFullPathNameA(lpFileName,nBufferLength,lpBuffer,lpFilePart);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_GetFullPathNameA, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

DWORD  ZGetFullPathNameW (LPCWSTR lpFileName,DWORD nBufferLength,LPWSTR lpBuffer,LPWSTR* lpFilePart)
{

    DWORD RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = GetFullPathNameW(lpFileName,nBufferLength,lpBuffer,lpFilePart);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_GetFullPathNameW, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

COORD  ZGetLargestConsoleWindowSize (HANDLE hConsoleOutput)
{

    COORD RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = GetLargestConsoleWindowSize(hConsoleOutput);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_GetLargestConsoleWindowSize, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

DWORD  ZGetLastError ()
{

    DWORD RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = GetLastError();
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_GetLastError, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

void  ZGetLocalTime (LPSYSTEMTIME lpSystemTime)
{

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    GetLocalTime(lpSystemTime);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_GetLocalTime, ulElapsedTime);
    TimerClose(sTimerHandle);

    return;
}

int  ZGetLocaleInfoW (LCID Locale,LCTYPE LCType,LPWSTR lpLCData,int cchData)
{

    int RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = GetLocaleInfoW(Locale,LCType,lpLCData,cchData);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_GetLocaleInfoW, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

DWORD  ZGetLogicalDriveStringsA (DWORD nBufferLength,LPSTR lpBuffer)
{

    DWORD RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = GetLogicalDriveStringsA(nBufferLength,lpBuffer);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_GetLogicalDriveStringsA, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

DWORD  ZGetLogicalDriveStringsW (DWORD nBufferLength,LPWSTR lpBuffer)
{

    DWORD RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = GetLogicalDriveStringsW(nBufferLength,lpBuffer);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_GetLogicalDriveStringsW, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

DWORD  ZGetLogicalDrives ()
{

    DWORD RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = GetLogicalDrives();
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_GetLogicalDrives, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZGetMailslotInfo (HANDLE hMailslot,LPDWORD lpMaxMessageSize,LPDWORD lpNextSize,LPDWORD lpMessageCount,LPDWORD lpReadTimeout)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = GetMailslotInfo(hMailslot,lpMaxMessageSize,lpNextSize,lpMessageCount,lpReadTimeout);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_GetMailslotInfo, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

DWORD  ZGetModuleFileNameA (HMODULE hModule,LPSTR lpFilename,DWORD nSize)
{

    DWORD RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = GetModuleFileNameA(hModule,lpFilename,nSize);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_GetModuleFileNameA, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

DWORD  ZGetModuleFileNameW (HMODULE hModule,LPWSTR lpFilename,DWORD nSize)
{

    DWORD RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = GetModuleFileNameW(hModule,lpFilename,nSize);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_GetModuleFileNameW, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

HMODULE  ZGetModuleHandleA (LPCSTR lpModuleName)
{

    HMODULE RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = GetModuleHandleA(lpModuleName);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_GetModuleHandleA, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

HMODULE  ZGetModuleHandleW (LPCWSTR lpModuleName)
{

    HMODULE RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = GetModuleHandleW(lpModuleName);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_GetModuleHandleW, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZGetNamedPipeHandleStateA (HANDLE hNamedPipe,LPDWORD lpState,LPDWORD lpCurInstances,LPDWORD lpMaxCollectionCount,LPDWORD lpCollectDataTimeout,LPSTR lpUserName,DWORD nMaxUserNameSize)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = GetNamedPipeHandleStateA(hNamedPipe,lpState,lpCurInstances,lpMaxCollectionCount,lpCollectDataTimeout,lpUserName,nMaxUserNameSize);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_GetNamedPipeHandleStateA, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZGetNamedPipeHandleStateW (HANDLE hNamedPipe,LPDWORD lpState,LPDWORD lpCurInstances,LPDWORD lpMaxCollectionCount,LPDWORD lpCollectDataTimeout,LPWSTR lpUserName,DWORD nMaxUserNameSize)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = GetNamedPipeHandleStateW(hNamedPipe,lpState,lpCurInstances,lpMaxCollectionCount,lpCollectDataTimeout,lpUserName,nMaxUserNameSize);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_GetNamedPipeHandleStateW, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZGetNamedPipeInfo (HANDLE hNamedPipe,LPDWORD lpFlags,LPDWORD lpOutBufferSize,LPDWORD lpInBufferSize,LPDWORD lpMaxInstances)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = GetNamedPipeInfo(hNamedPipe,lpFlags,lpOutBufferSize,lpInBufferSize,lpMaxInstances);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_GetNamedPipeInfo, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZGetNumberOfConsoleInputEvents (HANDLE hConsoleInput,LPDWORD lpNumberOfEvents)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = GetNumberOfConsoleInputEvents(hConsoleInput,lpNumberOfEvents);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_GetNumberOfConsoleInputEvents, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZGetNumberOfConsoleMouseButtons (LPDWORD lpNumberOfMouseButtons)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = GetNumberOfConsoleMouseButtons(lpNumberOfMouseButtons);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_GetNumberOfConsoleMouseButtons, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

UINT  ZGetOEMCP ()
{

    UINT RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = GetOEMCP();
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_GetOEMCP, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZGetOverlappedResult (HANDLE hFile,LPOVERLAPPED lpOverlapped,LPDWORD lpNumberOfBytesTransferred,BOOL bWait)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = GetOverlappedResult(hFile,lpOverlapped,lpNumberOfBytesTransferred,bWait);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_GetOverlappedResult, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

DWORD  ZGetPriorityClass (HANDLE hProcess)
{

    DWORD RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = GetPriorityClass(hProcess);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_GetPriorityClass, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

UINT  ZGetPrivateProfileIntA (LPCSTR lpAppName,LPCSTR lpKeyName,INT nDefault,LPCSTR lpFileName)
{

    UINT RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = GetPrivateProfileIntA(lpAppName,lpKeyName,nDefault,lpFileName);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_GetPrivateProfileIntA, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

UINT  ZGetPrivateProfileIntW (LPCWSTR lpAppName,LPCWSTR lpKeyName,INT nDefault,LPCWSTR lpFileName)
{

    UINT RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = GetPrivateProfileIntW(lpAppName,lpKeyName,nDefault,lpFileName);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_GetPrivateProfileIntW, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

DWORD  ZGetPrivateProfileSectionA (LPCSTR lpAppName,LPSTR lpReturnedString,DWORD nSize,LPCSTR lpFileName)
{

    DWORD RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = GetPrivateProfileSectionA(lpAppName,lpReturnedString,nSize,lpFileName);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_GetPrivateProfileSectionA, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

DWORD  ZGetPrivateProfileSectionW (LPCWSTR lpAppName,LPWSTR lpReturnedString,DWORD nSize,LPCWSTR lpFileName)
{

    DWORD RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = GetPrivateProfileSectionW(lpAppName,lpReturnedString,nSize,lpFileName);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_GetPrivateProfileSectionW, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

DWORD  ZGetPrivateProfileStringA (LPCSTR lpAppName,LPCSTR lpKeyName,LPCSTR lpDefault,LPSTR lpReturnedString,DWORD nSize,LPCSTR lpFileName)
{

    DWORD RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = GetPrivateProfileStringA(lpAppName,lpKeyName,lpDefault,lpReturnedString,nSize,lpFileName);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_GetPrivateProfileStringA, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

DWORD  ZGetPrivateProfileStringW (LPCWSTR lpAppName,LPCWSTR lpKeyName,LPCWSTR lpDefault,LPWSTR lpReturnedString,DWORD nSize,LPCWSTR lpFileName)
{

    DWORD RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = GetPrivateProfileStringW(lpAppName,lpKeyName,lpDefault,lpReturnedString,nSize,lpFileName);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_GetPrivateProfileStringW, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

FARPROC  ZGetProcAddress (HMODULE hModule,LPCSTR lpProcName)
{

    FARPROC RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = GetProcAddress(hModule,lpProcName);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_GetProcAddress, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

HANDLE  ZGetProcessHeap ()
{

    HANDLE RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = GetProcessHeap();
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_GetProcessHeap, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZGetProcessShutdownParameters (LPDWORD lpdwLevel,LPDWORD lpdwFlags)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = GetProcessShutdownParameters(lpdwLevel,lpdwFlags);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_GetProcessShutdownParameters, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZGetProcessTimes (HANDLE hProcess,LPFILETIME lpCreationTime,LPFILETIME lpExitTime,LPFILETIME lpKernelTime,LPFILETIME lpUserTime)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = GetProcessTimes(hProcess,lpCreationTime,lpExitTime,lpKernelTime,lpUserTime);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_GetProcessTimes, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

UINT  ZGetProfileIntA (LPCSTR lpAppName,LPCSTR lpKeyName,INT nDefault)
{

    UINT RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = GetProfileIntA(lpAppName,lpKeyName,nDefault);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_GetProfileIntA, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

UINT  ZGetProfileIntW (LPCWSTR lpAppName,LPCWSTR lpKeyName,INT nDefault)
{

    UINT RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = GetProfileIntW(lpAppName,lpKeyName,nDefault);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_GetProfileIntW, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

DWORD  ZGetProfileSectionA (LPCSTR lpAppName,LPSTR lpReturnedString,DWORD nSize)
{

    DWORD RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = GetProfileSectionA(lpAppName,lpReturnedString,nSize);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_GetProfileSectionA, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

DWORD  ZGetProfileSectionW (LPCWSTR lpAppName,LPWSTR lpReturnedString,DWORD nSize)
{

    DWORD RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = GetProfileSectionW(lpAppName,lpReturnedString,nSize);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_GetProfileSectionW, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

DWORD  ZGetProfileStringA (LPCSTR lpAppName,LPCSTR lpKeyName,LPCSTR lpDefault,LPSTR lpReturnedString,DWORD nSize)
{

    DWORD RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = GetProfileStringA(lpAppName,lpKeyName,lpDefault,lpReturnedString,nSize);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_GetProfileStringA, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

DWORD  ZGetProfileStringW (LPCWSTR lpAppName,LPCWSTR lpKeyName,LPCWSTR lpDefault,LPWSTR lpReturnedString,DWORD nSize)
{

    DWORD RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = GetProfileStringW(lpAppName,lpKeyName,lpDefault,lpReturnedString,nSize);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_GetProfileStringW, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

void  ZGetStartupInfoA (LPSTARTUPINFOA lpStartupInfo)
{

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    GetStartupInfoA(lpStartupInfo);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_GetStartupInfoA, ulElapsedTime);
    TimerClose(sTimerHandle);

    return;
}

void  ZGetStartupInfoW (LPSTARTUPINFOW lpStartupInfo)
{

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    GetStartupInfoW(lpStartupInfo);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_GetStartupInfoW, ulElapsedTime);
    TimerClose(sTimerHandle);

    return;
}

HANDLE  ZGetStdHandle (DWORD nStdHandle)
{

    HANDLE RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = GetStdHandle(nStdHandle);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_GetStdHandle, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZGetStringTypeW (DWORD dwInfoType,LPCWSTR lpSrcStr,int cchSrc,LPWORD lpCharType)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = GetStringTypeW(dwInfoType,lpSrcStr,cchSrc,lpCharType);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_GetStringTypeW, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

LCID  ZGetSystemDefaultLCID ()
{

    LCID RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = GetSystemDefaultLCID();
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_GetSystemDefaultLCID, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

LANGID  ZGetSystemDefaultLangID ()
{

    LANGID RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = GetSystemDefaultLangID();
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_GetSystemDefaultLangID, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

UINT  ZGetSystemDirectoryA (LPSTR lpBuffer,UINT uSize)
{

    UINT RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = GetSystemDirectoryA(lpBuffer,uSize);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_GetSystemDirectoryA, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

UINT  ZGetSystemDirectoryW (LPWSTR lpBuffer,UINT uSize)
{

    UINT RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = GetSystemDirectoryW(lpBuffer,uSize);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_GetSystemDirectoryW, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

void  ZGetSystemInfo (LPSYSTEM_INFO lpSystemInfo)
{

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    GetSystemInfo(lpSystemInfo);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_GetSystemInfo, ulElapsedTime);
    TimerClose(sTimerHandle);

    return;
}

void  ZGetSystemTime (LPSYSTEMTIME lpSystemTime)
{

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    GetSystemTime(lpSystemTime);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_GetSystemTime, ulElapsedTime);
    TimerClose(sTimerHandle);

    return;
}

DWORD  ZGetTapeParameters (HANDLE hDevice,DWORD dwOperation,LPDWORD lpdwSize,LPVOID lpTapeInformation)
{

    DWORD RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = GetTapeParameters(hDevice,dwOperation,lpdwSize,lpTapeInformation);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_GetTapeParameters, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

DWORD  ZGetTapePosition (HANDLE hDevice,DWORD dwPositionType,LPDWORD lpdwPartition,LPDWORD lpdwOffsetLow,LPDWORD lpdwOffsetHigh)
{

    DWORD RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = GetTapePosition(hDevice,dwPositionType,lpdwPartition,lpdwOffsetLow,lpdwOffsetHigh);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_GetTapePosition, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

DWORD  ZGetTapeStatus (HANDLE hDevice)
{

    DWORD RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = GetTapeStatus(hDevice);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_GetTapeStatus, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

UINT  ZGetTempFileNameA (LPCSTR lpPathName,LPCSTR lpPrefixString,UINT uUnique,LPSTR lpTempFileName)
{

    UINT RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = GetTempFileNameA(lpPathName,lpPrefixString,uUnique,lpTempFileName);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_GetTempFileNameA, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

UINT  ZGetTempFileNameW (LPCWSTR lpPathName,LPCWSTR lpPrefixString,UINT uUnique,LPWSTR lpTempFileName)
{

    UINT RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = GetTempFileNameW(lpPathName,lpPrefixString,uUnique,lpTempFileName);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_GetTempFileNameW, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

DWORD  ZGetTempPathA (DWORD nBufferLength,LPSTR lpBuffer)
{

    DWORD RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = GetTempPathA(nBufferLength,lpBuffer);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_GetTempPathA, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

DWORD  ZGetTempPathW (DWORD nBufferLength,LPWSTR lpBuffer)
{

    DWORD RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = GetTempPathW(nBufferLength,lpBuffer);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_GetTempPathW, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZGetThreadContext (HANDLE hThread,LPCONTEXT lpContext)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = GetThreadContext(hThread,lpContext);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_GetThreadContext, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

LCID  ZGetThreadLocale ()
{

    LCID RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = GetThreadLocale();
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_GetThreadLocale, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

int  ZGetThreadPriority (HANDLE hThread)
{

    int RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = GetThreadPriority(hThread);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_GetThreadPriority, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZGetThreadSelectorEntry (HANDLE hThread,DWORD dwSelector,LPLDT_ENTRY lpSelectorEntry)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = GetThreadSelectorEntry(hThread,dwSelector,lpSelectorEntry);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_GetThreadSelectorEntry, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZGetThreadTimes (HANDLE hThread,LPFILETIME lpCreationTime,LPFILETIME lpExitTime,LPFILETIME lpKernelTime,LPFILETIME lpUserTime)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = GetThreadTimes(hThread,lpCreationTime,lpExitTime,lpKernelTime,lpUserTime);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_GetThreadTimes, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

DWORD  ZGetTickCount ()
{

    DWORD RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = GetTickCount();
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_GetTickCount, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

int  ZGetTimeFormatW (LCID Locale,DWORD dwFlags,const SYSTEMTIME* lpTime,LPCWSTR lpFormat,LPWSTR lpTimeStr,int cchTime)
{

    int RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = GetTimeFormatW(Locale,dwFlags,lpTime,lpFormat,lpTimeStr,cchTime);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_GetTimeFormatW, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

DWORD  ZGetTimeZoneInformation (LPTIME_ZONE_INFORMATION lpTimeZoneInformation)
{

    DWORD RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = GetTimeZoneInformation(lpTimeZoneInformation);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_GetTimeZoneInformation, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

LCID  ZGetUserDefaultLCID ()
{

    LCID RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = GetUserDefaultLCID();
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_GetUserDefaultLCID, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

LANGID  ZGetUserDefaultLangID ()
{

    LANGID RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = GetUserDefaultLangID();
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_GetUserDefaultLangID, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

DWORD  ZGetVersion ()
{

    DWORD RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = GetVersion();
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_GetVersion, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZGetVolumeInformationA (LPCSTR lpRootPathName,LPSTR lpVolumeNameBuffer,DWORD nVolumeNameSize,LPDWORD lpVolumeSerialNumber,LPDWORD lpMaximumComponentLength,LPDWORD lpFileSystemFlags,LPSTR lpFileSystemNameBuffer,DWORD nFileSystemNameSize)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = GetVolumeInformationA(lpRootPathName,lpVolumeNameBuffer,nVolumeNameSize,lpVolumeSerialNumber,lpMaximumComponentLength,lpFileSystemFlags,lpFileSystemNameBuffer,nFileSystemNameSize);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_GetVolumeInformationA, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZGetVolumeInformationW (LPCWSTR lpRootPathName,LPWSTR lpVolumeNameBuffer,DWORD nVolumeNameSize,LPDWORD lpVolumeSerialNumber,LPDWORD lpMaximumComponentLength,LPDWORD lpFileSystemFlags,LPWSTR lpFileSystemNameBuffer,DWORD nFileSystemNameSize)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = GetVolumeInformationW(lpRootPathName,lpVolumeNameBuffer,nVolumeNameSize,lpVolumeSerialNumber,lpMaximumComponentLength,lpFileSystemFlags,lpFileSystemNameBuffer,nFileSystemNameSize);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_GetVolumeInformationW, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

UINT  ZGetWindowsDirectoryA (LPSTR lpBuffer,UINT uSize)
{

    UINT RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = GetWindowsDirectoryA(lpBuffer,uSize);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_GetWindowsDirectoryA, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

UINT  ZGetWindowsDirectoryW (LPWSTR lpBuffer,UINT uSize)
{

    UINT RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = GetWindowsDirectoryW(lpBuffer,uSize);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_GetWindowsDirectoryW, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

ATOM  ZGlobalAddAtomA (LPCSTR lpString)
{

    ATOM RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = GlobalAddAtomA(lpString);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_GlobalAddAtomA, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

ATOM  ZGlobalAddAtomW (LPCWSTR lpString)
{

    ATOM RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = GlobalAddAtomW(lpString);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_GlobalAddAtomW, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

HGLOBAL  ZGlobalAlloc (UINT uFlags,DWORD dwBytes)
{

    HGLOBAL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = GlobalAlloc(uFlags,dwBytes);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_GlobalAlloc, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

UINT  ZGlobalCompact (DWORD dwMinFree)
{

    UINT RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = GlobalCompact(dwMinFree);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_GlobalCompact, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

ATOM  ZGlobalDeleteAtom (ATOM nAtom)
{

    ATOM RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = GlobalDeleteAtom(nAtom);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_GlobalDeleteAtom, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

ATOM  ZGlobalFindAtomA (LPCSTR lpString)
{

    ATOM RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = GlobalFindAtomA(lpString);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_GlobalFindAtomA, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

ATOM  ZGlobalFindAtomW (LPCWSTR lpString)
{

    ATOM RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = GlobalFindAtomW(lpString);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_GlobalFindAtomW, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

void  ZGlobalFix (HGLOBAL hMem)
{

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    GlobalFix(hMem);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_GlobalFix, ulElapsedTime);
    TimerClose(sTimerHandle);

    return;
}

UINT  ZGlobalFlags (HGLOBAL hMem)
{

    UINT RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = GlobalFlags(hMem);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_GlobalFlags, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

HGLOBAL  ZGlobalFree (HGLOBAL hMem)
{

    HGLOBAL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = GlobalFree(hMem);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_GlobalFree, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

UINT  ZGlobalGetAtomNameA (ATOM nAtom,LPSTR lpBuffer,int nSize)
{

    UINT RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = GlobalGetAtomNameA(nAtom,lpBuffer,nSize);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_GlobalGetAtomNameA, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

UINT  ZGlobalGetAtomNameW (ATOM nAtom,LPWSTR lpBuffer,int nSize)
{

    UINT RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = GlobalGetAtomNameW(nAtom,lpBuffer,nSize);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_GlobalGetAtomNameW, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

HGLOBAL  ZGlobalHandle (LPCVOID pMem)
{

    HGLOBAL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = GlobalHandle(pMem);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_GlobalHandle, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

LPVOID  ZGlobalLock (HGLOBAL hMem)
{

    LPVOID RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = GlobalLock(hMem);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_GlobalLock, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

void  ZGlobalMemoryStatus (LPMEMORYSTATUS lpBuffer)
{

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    GlobalMemoryStatus(lpBuffer);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_GlobalMemoryStatus, ulElapsedTime);
    TimerClose(sTimerHandle);

    return;
}

HGLOBAL  ZGlobalReAlloc (HGLOBAL hMem,DWORD dwBytes,UINT uFlags)
{

    HGLOBAL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = GlobalReAlloc(hMem,dwBytes,uFlags);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_GlobalReAlloc, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

DWORD  ZGlobalSize (HGLOBAL hMem)
{

    DWORD RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = GlobalSize(hMem);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_GlobalSize, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZGlobalUnWire (HGLOBAL hMem)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = GlobalUnWire(hMem);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_GlobalUnWire, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

void  ZGlobalUnfix (HGLOBAL hMem)
{

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    GlobalUnfix(hMem);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_GlobalUnfix, ulElapsedTime);
    TimerClose(sTimerHandle);

    return;
}

BOOL  ZGlobalUnlock (HGLOBAL hMem)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = GlobalUnlock(hMem);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_GlobalUnlock, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

LPVOID  ZGlobalWire (HGLOBAL hMem)
{

    LPVOID RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = GlobalWire(hMem);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_GlobalWire, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

LPVOID  ZHeapAlloc (HANDLE hHeap,DWORD dwFlags,DWORD dwBytes)
{

    LPVOID RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = HeapAlloc(hHeap,dwFlags,dwBytes);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_HeapAlloc, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

HANDLE  ZHeapCreate (DWORD flOptions,DWORD dwInitialSize,DWORD dwMaximumSize)
{

    HANDLE RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = HeapCreate(flOptions,dwInitialSize,dwMaximumSize);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_HeapCreate, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZHeapDestroy (HANDLE hHeap)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = HeapDestroy(hHeap);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_HeapDestroy, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZHeapFree (HANDLE hHeap,DWORD dwFlags,LPVOID lpMem)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = HeapFree(hHeap,dwFlags,lpMem);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_HeapFree, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

LPVOID  ZHeapReAlloc (HANDLE hHeap,DWORD dwFlags,LPVOID lpMem,DWORD dwBytes)
{

    LPVOID RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = HeapReAlloc(hHeap,dwFlags,lpMem,dwBytes);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_HeapReAlloc, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

DWORD  ZHeapSize (HANDLE hHeap,DWORD dwFlags,LPCVOID lpMem)
{

    DWORD RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = HeapSize(hHeap,dwFlags,lpMem);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_HeapSize, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZInitAtomTable (DWORD nSize)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = InitAtomTable(nSize);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_InitAtomTable, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

void  ZInitializeCriticalSection (LPCRITICAL_SECTION lpCriticalSection)
{

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    InitializeCriticalSection(lpCriticalSection);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_InitializeCriticalSection, ulElapsedTime);
    TimerClose(sTimerHandle);

    return;
}

LONG  ZInterlockedDecrement (LPLONG lpAddend)
{

    LONG RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = InterlockedDecrement(lpAddend);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_InterlockedDecrement, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

LONG  ZInterlockedExchange (LPLONG Target,LONG Value)
{

    LONG RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = InterlockedExchange(Target,Value);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_InterlockedExchange, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

LONG  ZInterlockedIncrement (LPLONG lpAddend)
{

    LONG RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = InterlockedIncrement(lpAddend);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_InterlockedIncrement, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZIsBadCodePtr (FARPROC lpfn)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = IsBadCodePtr(lpfn);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_IsBadCodePtr, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZIsBadHugeReadPtr (const void* lp,UINT ucb)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = IsBadHugeReadPtr(lp,ucb);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_IsBadHugeReadPtr, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZIsBadHugeWritePtr (LPVOID lp,UINT ucb)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = IsBadHugeWritePtr(lp,ucb);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_IsBadHugeWritePtr, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZIsBadReadPtr (const void* lp,UINT ucb)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = IsBadReadPtr(lp,ucb);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_IsBadReadPtr, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZIsBadStringPtrA (LPCSTR lpsz,UINT ucchMax)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = IsBadStringPtrA(lpsz,ucchMax);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_IsBadStringPtrA, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZIsBadStringPtrW (LPCWSTR lpsz,UINT ucchMax)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = IsBadStringPtrW(lpsz,ucchMax);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_IsBadStringPtrW, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZIsBadWritePtr (LPVOID lp,UINT ucb)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = IsBadWritePtr(lp,ucb);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_IsBadWritePtr, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZIsDBCSLeadByte (BYTE TestChar)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = IsDBCSLeadByte(TestChar);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_IsDBCSLeadByte, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZIsValidCodePage (UINT CodePage)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = IsValidCodePage(CodePage);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_IsValidCodePage, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

int  ZLCMapStringW (LCID Locale,DWORD dwMapFlags,LPCWSTR lpSrcStr,int cchSrc,LPWSTR lpDestStr,int cchDest)
{

    int RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = LCMapStringW(Locale,dwMapFlags,lpSrcStr,cchSrc,lpDestStr,cchDest);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_LCMapStringW, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

void  ZLeaveCriticalSection (LPCRITICAL_SECTION lpCriticalSection)
{

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    LeaveCriticalSection(lpCriticalSection);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_LeaveCriticalSection, ulElapsedTime);
    TimerClose(sTimerHandle);

    return;
}

HMODULE  ZLoadLibraryA (LPCSTR lpLibFileName)
{

    HMODULE RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = LoadLibraryA(lpLibFileName);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_LoadLibraryA, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

HMODULE  ZLoadLibraryExA (LPCSTR lpLibFileName,HANDLE hFile,DWORD dwFlags)
{

    HMODULE RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = LoadLibraryExA(lpLibFileName,hFile,dwFlags);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_LoadLibraryExA, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

HMODULE  ZLoadLibraryExW (LPCWSTR lpLibFileName,HANDLE hFile,DWORD dwFlags)
{

    HMODULE RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = LoadLibraryExW(lpLibFileName,hFile,dwFlags);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_LoadLibraryExW, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

HMODULE  ZLoadLibraryW (LPCWSTR lpLibFileName)
{

    HMODULE RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = LoadLibraryW(lpLibFileName);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_LoadLibraryW, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

DWORD  ZLoadModule (LPCSTR lpModuleName,LPVOID lpParameterBlock)
{

    DWORD RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = LoadModule(lpModuleName,lpParameterBlock);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_LoadModule, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

HGLOBAL  ZLoadResource (HMODULE hModule,HRSRC hResInfo)
{

    HGLOBAL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = LoadResource(hModule,hResInfo);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_LoadResource, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

HLOCAL  ZLocalAlloc (UINT uFlags,UINT uBytes)
{

    HLOCAL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = LocalAlloc(uFlags,uBytes);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_LocalAlloc, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

UINT  ZLocalCompact (UINT uMinFree)
{

    UINT RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = LocalCompact(uMinFree);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_LocalCompact, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZLocalFileTimeToFileTime (const FILETIME* lpLocalFileTime,LPFILETIME lpFileTime)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = LocalFileTimeToFileTime(lpLocalFileTime,lpFileTime);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_LocalFileTimeToFileTime, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

UINT  ZLocalFlags (HLOCAL hMem)
{

    UINT RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = LocalFlags(hMem);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_LocalFlags, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

HLOCAL  ZLocalFree (HLOCAL hMem)
{

    HLOCAL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = LocalFree(hMem);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_LocalFree, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

HLOCAL  ZLocalHandle (LPCVOID pMem)
{

    HLOCAL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = LocalHandle(pMem);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_LocalHandle, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

LPVOID  ZLocalLock (HLOCAL hMem)
{

    LPVOID RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = LocalLock(hMem);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_LocalLock, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

HLOCAL  ZLocalReAlloc (HLOCAL hMem,UINT uBytes,UINT uFlags)
{

    HLOCAL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = LocalReAlloc(hMem,uBytes,uFlags);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_LocalReAlloc, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

UINT  ZLocalShrink (HLOCAL hMem,UINT cbNewSize)
{

    UINT RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = LocalShrink(hMem,cbNewSize);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_LocalShrink, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

UINT  ZLocalSize (HLOCAL hMem)
{

    UINT RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = LocalSize(hMem);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_LocalSize, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZLocalUnlock (HLOCAL hMem)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = LocalUnlock(hMem);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_LocalUnlock, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZLockFile (HANDLE hFile,DWORD dwFileOffsetLow,DWORD dwFileOffsetHigh,DWORD nNumberOfBytesToLockLow,DWORD nNumberOfBytesToLockHigh)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = LockFile(hFile,dwFileOffsetLow,dwFileOffsetHigh,nNumberOfBytesToLockLow,nNumberOfBytesToLockHigh);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_LockFile, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZLockFileEx (HANDLE hFile,DWORD dwFlags,DWORD dwReserved,DWORD nNumberOfBytesToLockLow,DWORD nNumberOfBytesToLockHigh,LPOVERLAPPED lpOverlapped)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = LockFileEx(hFile,dwFlags,dwReserved,nNumberOfBytesToLockLow,nNumberOfBytesToLockHigh,lpOverlapped);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_LockFileEx, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

LPVOID  ZLockResource (HGLOBAL hResData)
{

    LPVOID RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = LockResource(hResData);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_LockResource, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

LPVOID  ZMapViewOfFile (HANDLE hFileMappingObject,DWORD dwDesiredAccess,DWORD dwFileOffsetHigh,DWORD dwFileOffsetLow,DWORD dwNumberOfBytesToMap)
{

    LPVOID RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = MapViewOfFile(hFileMappingObject,dwDesiredAccess,dwFileOffsetHigh,dwFileOffsetLow,dwNumberOfBytesToMap);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_MapViewOfFile, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

LPVOID  ZMapViewOfFileEx (HANDLE hFileMappingObject,DWORD dwDesiredAccess,DWORD dwFileOffsetHigh,DWORD dwFileOffsetLow,DWORD dwNumberOfBytesToMap,LPVOID lpBaseAddress)
{

    LPVOID RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = MapViewOfFileEx(hFileMappingObject,dwDesiredAccess,dwFileOffsetHigh,dwFileOffsetLow,dwNumberOfBytesToMap,lpBaseAddress);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_MapViewOfFileEx, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZMoveFileA (LPCSTR lpExistingFileName,LPCSTR lpNewFileName)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = MoveFileA(lpExistingFileName,lpNewFileName);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_MoveFileA, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZMoveFileExA (LPCSTR lpExistingFileName,LPCSTR lpNewFileName,DWORD dwFlags)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = MoveFileExA(lpExistingFileName,lpNewFileName,dwFlags);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_MoveFileExA, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZMoveFileExW (LPCWSTR lpExistingFileName,LPCWSTR lpNewFileName,DWORD dwFlags)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = MoveFileExW(lpExistingFileName,lpNewFileName,dwFlags);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_MoveFileExW, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZMoveFileW (LPCWSTR lpExistingFileName,LPCWSTR lpNewFileName)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = MoveFileW(lpExistingFileName,lpNewFileName);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_MoveFileW, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

int  ZMulDiv (int nNumber,int nNumerator,int nDenominator)
{

    int RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = MulDiv(nNumber,nNumerator,nDenominator);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_MulDiv, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

int  ZMultiByteToWideChar (UINT CodePage,DWORD dwFlags,LPCSTR lpMultiByteStr,int cchMultiByte,LPWSTR lpWideCharStr,int cchWideChar)
{

    int RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = MultiByteToWideChar(CodePage,dwFlags,lpMultiByteStr,cchMultiByte,lpWideCharStr,cchWideChar);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_MultiByteToWideChar, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

HANDLE  ZOpenEventA (DWORD dwDesiredAccess,BOOL bInheritHandle,LPCSTR lpName)
{

    HANDLE RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = OpenEventA(dwDesiredAccess,bInheritHandle,lpName);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_OpenEventA, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

HANDLE  ZOpenEventW (DWORD dwDesiredAccess,BOOL bInheritHandle,LPCWSTR lpName)
{

    HANDLE RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = OpenEventW(dwDesiredAccess,bInheritHandle,lpName);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_OpenEventW, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

HFILE  ZOpenFile (LPCSTR lpFileName,LPOFSTRUCT lpReOpenBuff,UINT uStyle)
{

    HFILE RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = OpenFile(lpFileName,lpReOpenBuff,uStyle);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_OpenFile, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

HANDLE  ZOpenFileMappingA (DWORD dwDesiredAccess,BOOL bInheritHandle,LPCSTR lpName)
{

    HANDLE RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = OpenFileMappingA(dwDesiredAccess,bInheritHandle,lpName);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_OpenFileMappingA, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

HANDLE  ZOpenFileMappingW (DWORD dwDesiredAccess,BOOL bInheritHandle,LPCWSTR lpName)
{

    HANDLE RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = OpenFileMappingW(dwDesiredAccess,bInheritHandle,lpName);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_OpenFileMappingW, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

HANDLE  ZOpenMutexA (DWORD dwDesiredAccess,BOOL bInheritHandle,LPCSTR lpName)
{

    HANDLE RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = OpenMutexA(dwDesiredAccess,bInheritHandle,lpName);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_OpenMutexA, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

HANDLE  ZOpenMutexW (DWORD dwDesiredAccess,BOOL bInheritHandle,LPCWSTR lpName)
{

    HANDLE RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = OpenMutexW(dwDesiredAccess,bInheritHandle,lpName);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_OpenMutexW, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

HANDLE  ZOpenProcess (DWORD dwDesiredAccess,BOOL bInheritHandle,DWORD dwProcessId)
{

    HANDLE RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = OpenProcess(dwDesiredAccess,bInheritHandle,dwProcessId);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_OpenProcess, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

HANDLE  ZOpenSemaphoreA (DWORD dwDesiredAccess,BOOL bInheritHandle,LPCSTR lpName)
{

    HANDLE RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = OpenSemaphoreA(dwDesiredAccess,bInheritHandle,lpName);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_OpenSemaphoreA, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

HANDLE  ZOpenSemaphoreW (DWORD dwDesiredAccess,BOOL bInheritHandle,LPCWSTR lpName)
{

    HANDLE RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = OpenSemaphoreW(dwDesiredAccess,bInheritHandle,lpName);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_OpenSemaphoreW, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

void  ZOutputDebugStringA (LPCSTR lpOutputString)
{

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    OutputDebugStringA(lpOutputString);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_OutputDebugStringA, ulElapsedTime);
    TimerClose(sTimerHandle);

    return;
}

void  ZOutputDebugStringW (LPCWSTR lpOutputString)
{

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    OutputDebugStringW(lpOutputString);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_OutputDebugStringW, ulElapsedTime);
    TimerClose(sTimerHandle);

    return;
}

BOOL  ZPeekConsoleInputA (HANDLE hConsoleInput,PINPUT_RECORD lpBuffer,DWORD nLength,LPDWORD lpNumberOfEventsRead)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = PeekConsoleInputA(hConsoleInput,lpBuffer,nLength,lpNumberOfEventsRead);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_PeekConsoleInputA, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZPeekConsoleInputW (HANDLE hConsoleInput,PINPUT_RECORD lpBuffer,DWORD nLength,LPDWORD lpNumberOfEventsRead)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = PeekConsoleInputW(hConsoleInput,lpBuffer,nLength,lpNumberOfEventsRead);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_PeekConsoleInputW, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZPeekNamedPipe (HANDLE hNamedPipe,LPVOID lpBuffer,DWORD nBufferSize,LPDWORD lpBytesRead,LPDWORD lpTotalBytesAvail,LPDWORD lpBytesLeftThisMessage)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = PeekNamedPipe(hNamedPipe,lpBuffer,nBufferSize,lpBytesRead,lpTotalBytesAvail,lpBytesLeftThisMessage);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_PeekNamedPipe, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

DWORD  ZPrepareTape (HANDLE hDevice,DWORD dwOperation,BOOL bImmediate)
{

    DWORD RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = PrepareTape(hDevice,dwOperation,bImmediate);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_PrepareTape, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZPulseEvent (HANDLE hEvent)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = PulseEvent(hEvent);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_PulseEvent, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZPurgeComm (HANDLE hFile,DWORD dwFlags)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = PurgeComm(hFile,dwFlags);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_PurgeComm, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

DWORD  ZQueryDosDeviceA (LPCSTR lpDeviceName,LPSTR lpTargetPath,DWORD ucchMax)
{

    DWORD RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = QueryDosDeviceA(lpDeviceName,lpTargetPath,ucchMax);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_QueryDosDeviceA, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

DWORD  ZQueryDosDeviceW (LPCWSTR lpDeviceName,LPWSTR lpTargetPath,DWORD ucchMax)
{

    DWORD RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = QueryDosDeviceW(lpDeviceName,lpTargetPath,ucchMax);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_QueryDosDeviceW, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZQueryPerformanceCounter (LARGE_INTEGER* lpPerformanceCount)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = QueryPerformanceCounter(lpPerformanceCount);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_QueryPerformanceCounter, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZQueryPerformanceFrequency (LARGE_INTEGER* lpFrequency)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = QueryPerformanceFrequency(lpFrequency);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_QueryPerformanceFrequency, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

void  ZRaiseException (DWORD dwExceptionCode,DWORD dwExceptionFlags,DWORD nNumberOfArguments,const DWORD* lpArguments)
{

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RaiseException(dwExceptionCode,dwExceptionFlags,nNumberOfArguments,lpArguments);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_RaiseException, ulElapsedTime);
    TimerClose(sTimerHandle);

    return;
}

BOOL  ZReadConsoleA (HANDLE hConsoleInput,LPVOID lpBuffer,DWORD nNumberOfCharsToRead,LPDWORD lpNumberOfCharsRead,LPVOID lpReserved)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = ReadConsoleA(hConsoleInput,lpBuffer,nNumberOfCharsToRead,lpNumberOfCharsRead,lpReserved);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_ReadConsoleA, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZReadConsoleInputA (HANDLE hConsoleInput,PINPUT_RECORD lpBuffer,DWORD nLength,LPDWORD lpNumberOfEventsRead)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = ReadConsoleInputA(hConsoleInput,lpBuffer,nLength,lpNumberOfEventsRead);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_ReadConsoleInputA, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZReadConsoleInputW (HANDLE hConsoleInput,PINPUT_RECORD lpBuffer,DWORD nLength,LPDWORD lpNumberOfEventsRead)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = ReadConsoleInputW(hConsoleInput,lpBuffer,nLength,lpNumberOfEventsRead);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_ReadConsoleInputW, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZReadConsoleOutputA (HANDLE hConsoleOutput,PCHAR_INFO lpBuffer,COORD dwBufferSize,COORD dwBufferCoord,PSMALL_RECT lpReadRegion)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = ReadConsoleOutputA(hConsoleOutput,lpBuffer,dwBufferSize,dwBufferCoord,lpReadRegion);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_ReadConsoleOutputA, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZReadConsoleOutputAttribute (HANDLE hConsoleOutput,LPWORD lpAttribute,DWORD nLength,COORD dwReadCoord,LPDWORD lpNumberOfAttrsRead)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = ReadConsoleOutputAttribute(hConsoleOutput,lpAttribute,nLength,dwReadCoord,lpNumberOfAttrsRead);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_ReadConsoleOutputAttribute, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZReadConsoleOutputCharacterA (HANDLE hConsoleOutput,LPSTR lpCharacter,DWORD nLength,COORD dwReadCoord,LPDWORD lpNumberOfCharsRead)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = ReadConsoleOutputCharacterA(hConsoleOutput,lpCharacter,nLength,dwReadCoord,lpNumberOfCharsRead);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_ReadConsoleOutputCharacterA, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZReadConsoleOutputCharacterW (HANDLE hConsoleOutput,LPWSTR lpCharacter,DWORD nLength,COORD dwReadCoord,LPDWORD lpNumberOfCharsRead)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = ReadConsoleOutputCharacterW(hConsoleOutput,lpCharacter,nLength,dwReadCoord,lpNumberOfCharsRead);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_ReadConsoleOutputCharacterW, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZReadConsoleOutputW (HANDLE hConsoleOutput,PCHAR_INFO lpBuffer,COORD dwBufferSize,COORD dwBufferCoord,PSMALL_RECT lpReadRegion)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = ReadConsoleOutputW(hConsoleOutput,lpBuffer,dwBufferSize,dwBufferCoord,lpReadRegion);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_ReadConsoleOutputW, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZReadConsoleW (HANDLE hConsoleInput,LPVOID lpBuffer,DWORD nNumberOfCharsToRead,LPDWORD lpNumberOfCharsRead,LPVOID lpReserved)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = ReadConsoleW(hConsoleInput,lpBuffer,nNumberOfCharsToRead,lpNumberOfCharsRead,lpReserved);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_ReadConsoleW, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZReadFile (HANDLE hFile,LPVOID lpBuffer,DWORD nNumberOfBytesToRead,LPDWORD lpNumberOfBytesRead,LPOVERLAPPED lpOverlapped)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = ReadFile(hFile,lpBuffer,nNumberOfBytesToRead,lpNumberOfBytesRead,lpOverlapped);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_ReadFile, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZReadFileEx (HANDLE hFile,LPVOID lpBuffer,DWORD nNumberOfBytesToRead,LPOVERLAPPED lpOverlapped,LPOVERLAPPED_COMPLETION_ROUTINE lpCompletionRoutine)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = ReadFileEx(hFile,lpBuffer,nNumberOfBytesToRead,lpOverlapped,lpCompletionRoutine);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_ReadFileEx, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZReadProcessMemory (HANDLE hProcess,LPCVOID lpBaseAddress,LPVOID lpBuffer,DWORD nSize,LPDWORD lpNumberOfBytesRead)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = ReadProcessMemory(hProcess,lpBaseAddress,lpBuffer,nSize,lpNumberOfBytesRead);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_ReadProcessMemory, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZReleaseMutex (HANDLE hMutex)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = ReleaseMutex(hMutex);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_ReleaseMutex, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZReleaseSemaphore (HANDLE hSemaphore,LONG lReleaseCount,LPLONG lpPreviousCount)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = ReleaseSemaphore(hSemaphore,lReleaseCount,lpPreviousCount);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_ReleaseSemaphore, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZRemoveDirectoryA (LPCSTR lpPathName)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = RemoveDirectoryA(lpPathName);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_RemoveDirectoryA, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZRemoveDirectoryW (LPCWSTR lpPathName)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = RemoveDirectoryW(lpPathName);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_RemoveDirectoryW, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZResetEvent (HANDLE hEvent)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = ResetEvent(hEvent);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_ResetEvent, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

DWORD  ZResumeThread (HANDLE hThread)
{

    DWORD RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = ResumeThread(hThread);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_ResumeThread, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

void  ZRtlFillMemory (PVOID Destination,DWORD Length,BYTE Fill)
{

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RtlFillMemory(Destination,Length,Fill);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_RtlFillMemory, ulElapsedTime);
    TimerClose(sTimerHandle);

    return;
}

void  ZRtlMoveMemory (PVOID Destination,const void* Source,DWORD Length)
{

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RtlMoveMemory(Destination,Source,Length);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_RtlMoveMemory, ulElapsedTime);
    TimerClose(sTimerHandle);

    return;
}

void  ZRtlZeroMemory (PVOID Destination,DWORD Length)
{

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RtlZeroMemory(Destination,Length);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_RtlZeroMemory, ulElapsedTime);
    TimerClose(sTimerHandle);

    return;
}

BOOL  ZScrollConsoleScreenBufferA (HANDLE hConsoleOutput,PSMALL_RECT lpScrollRectangle,PSMALL_RECT lpClipRectangle,COORD dwDestinationOrigin,PCHAR_INFO lpFill)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = ScrollConsoleScreenBufferA(hConsoleOutput,lpScrollRectangle,lpClipRectangle,dwDestinationOrigin,lpFill);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_ScrollConsoleScreenBufferA, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZScrollConsoleScreenBufferW (HANDLE hConsoleOutput,PSMALL_RECT lpScrollRectangle,PSMALL_RECT lpClipRectangle,COORD dwDestinationOrigin,PCHAR_INFO lpFill)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = ScrollConsoleScreenBufferW(hConsoleOutput,lpScrollRectangle,lpClipRectangle,dwDestinationOrigin,lpFill);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_ScrollConsoleScreenBufferW, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

DWORD  ZSearchPathA (LPCSTR lpPath,LPCSTR lpFileName,LPCSTR lpExtension,DWORD nBufferLength,LPSTR lpBuffer,LPSTR* lpFilePart)
{

    DWORD RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = SearchPathA(lpPath,lpFileName,lpExtension,nBufferLength,lpBuffer,lpFilePart);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_SearchPathA, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

DWORD  ZSearchPathW (LPCWSTR lpPath,LPCWSTR lpFileName,LPCWSTR lpExtension,DWORD nBufferLength,LPWSTR lpBuffer,LPWSTR* lpFilePart)
{

    DWORD RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = SearchPathW(lpPath,lpFileName,lpExtension,nBufferLength,lpBuffer,lpFilePart);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_SearchPathW, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZSetCommBreak (HANDLE hFile)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = SetCommBreak(hFile);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_SetCommBreak, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZSetCommMask (HANDLE hFile,DWORD dwEvtMask)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = SetCommMask(hFile,dwEvtMask);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_SetCommMask, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZSetCommState (HANDLE hFile,LPDCB lpDCB)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = SetCommState(hFile,lpDCB);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_SetCommState, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZSetCommTimeouts (HANDLE hFile,LPCOMMTIMEOUTS lpCommTimeouts)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = SetCommTimeouts(hFile,lpCommTimeouts);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_SetCommTimeouts, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZSetComputerNameA (LPCSTR lpComputerName)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = SetComputerNameA(lpComputerName);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_SetComputerNameA, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZSetComputerNameW (LPCWSTR lpComputerName)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = SetComputerNameW(lpComputerName);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_SetComputerNameW, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZSetConsoleActiveScreenBuffer (HANDLE hConsoleOutput)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = SetConsoleActiveScreenBuffer(hConsoleOutput);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_SetConsoleActiveScreenBuffer, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZSetConsoleCP (UINT wCodePageID)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = SetConsoleCP(wCodePageID);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_SetConsoleCP, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZSetConsoleCtrlHandler (PHANDLER_ROUTINE HandlerRoutine,BOOL Add)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = SetConsoleCtrlHandler(HandlerRoutine,Add);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_SetConsoleCtrlHandler, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZSetConsoleCursorInfo (HANDLE hConsoleOutput,PCONSOLE_CURSOR_INFO lpConsoleCursorInfo)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = SetConsoleCursorInfo(hConsoleOutput,lpConsoleCursorInfo);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_SetConsoleCursorInfo, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZSetConsoleCursorPosition (HANDLE hConsoleOutput,COORD dwCursorPosition)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = SetConsoleCursorPosition(hConsoleOutput,dwCursorPosition);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_SetConsoleCursorPosition, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZSetConsoleMode (HANDLE hConsoleHandle,DWORD dwMode)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = SetConsoleMode(hConsoleHandle,dwMode);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_SetConsoleMode, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZSetConsoleOutputCP (UINT wCodePageID)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = SetConsoleOutputCP(wCodePageID);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_SetConsoleOutputCP, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZSetConsoleScreenBufferSize (HANDLE hConsoleOutput,COORD dwSize)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = SetConsoleScreenBufferSize(hConsoleOutput,dwSize);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_SetConsoleScreenBufferSize, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZSetConsoleTextAttribute (HANDLE hConsoleOutput,WORD wAttributes)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = SetConsoleTextAttribute(hConsoleOutput,wAttributes);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_SetConsoleTextAttribute, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZSetConsoleTitleA (LPSTR lpConsoleTitle)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = SetConsoleTitleA(lpConsoleTitle);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_SetConsoleTitleA, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZSetConsoleTitleW (LPWSTR lpConsoleTitle)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = SetConsoleTitleW(lpConsoleTitle);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_SetConsoleTitleW, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZSetConsoleWindowInfo (HANDLE hConsoleOutput,BOOL bAbsolute,PSMALL_RECT lpConsoleWindow)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = SetConsoleWindowInfo(hConsoleOutput,bAbsolute,lpConsoleWindow);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_SetConsoleWindowInfo, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZSetCurrentDirectoryA (LPCSTR lpPathName)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = SetCurrentDirectoryA(lpPathName);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_SetCurrentDirectoryA, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZSetCurrentDirectoryW (LPCWSTR lpPathName)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = SetCurrentDirectoryW(lpPathName);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_SetCurrentDirectoryW, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZSetEndOfFile (HANDLE hFile)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = SetEndOfFile(hFile);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_SetEndOfFile, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZSetEnvironmentVariableA (LPCSTR lpName,LPCSTR lpValue)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = SetEnvironmentVariableA(lpName,lpValue);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_SetEnvironmentVariableA, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZSetEnvironmentVariableW (LPCWSTR lpName,LPCWSTR lpValue)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = SetEnvironmentVariableW(lpName,lpValue);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_SetEnvironmentVariableW, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

UINT  ZSetErrorMode (UINT uMode)
{

    UINT RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = SetErrorMode(uMode);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_SetErrorMode, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZSetEvent (HANDLE hEvent)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = SetEvent(hEvent);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_SetEvent, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

void  ZSetFileApisToOEM ()
{

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    SetFileApisToOEM();
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_SetFileApisToOEM, ulElapsedTime);
    TimerClose(sTimerHandle);

    return;
}

BOOL  ZSetFileAttributesA (LPCSTR lpFileName,DWORD dwFileAttributes)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = SetFileAttributesA(lpFileName,dwFileAttributes);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_SetFileAttributesA, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZSetFileAttributesW (LPCWSTR lpFileName,DWORD dwFileAttributes)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = SetFileAttributesW(lpFileName,dwFileAttributes);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_SetFileAttributesW, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

DWORD  ZSetFilePointer (HANDLE hFile,LONG lDistanceToMove,PLONG lpDistanceToMoveHigh,DWORD dwMoveMethod)
{

    DWORD RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = SetFilePointer(hFile,lDistanceToMove,lpDistanceToMoveHigh,dwMoveMethod);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_SetFilePointer, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZSetFileTime (HANDLE hFile,const FILETIME* lpCreationTime,const FILETIME* lpLastAccessTime,const FILETIME* lpLastWriteTime)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = SetFileTime(hFile,lpCreationTime,lpLastAccessTime,lpLastWriteTime);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_SetFileTime, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

UINT  ZSetHandleCount (UINT uNumber)
{

    UINT RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = SetHandleCount(uNumber);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_SetHandleCount, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

void  ZSetLastError (DWORD dwErrCode)
{

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    SetLastError(dwErrCode);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_SetLastError, ulElapsedTime);
    TimerClose(sTimerHandle);

    return;
}

BOOL  ZSetLocalTime (const SYSTEMTIME* lpSystemTime)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = SetLocalTime(lpSystemTime);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_SetLocalTime, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZSetMailslotInfo (HANDLE hMailslot,DWORD lReadTimeout)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = SetMailslotInfo(hMailslot,lReadTimeout);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_SetMailslotInfo, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZSetNamedPipeHandleState (HANDLE hNamedPipe,LPDWORD lpMode,LPDWORD lpMaxCollectionCount,LPDWORD lpCollectDataTimeout)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = SetNamedPipeHandleState(hNamedPipe,lpMode,lpMaxCollectionCount,lpCollectDataTimeout);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_SetNamedPipeHandleState, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZSetPriorityClass (HANDLE hProcess,DWORD dwPriorityClass)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = SetPriorityClass(hProcess,dwPriorityClass);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_SetPriorityClass, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZSetProcessShutdownParameters (DWORD dwLevel,DWORD dwFlags)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = SetProcessShutdownParameters(dwLevel,dwFlags);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_SetProcessShutdownParameters, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZSetStdHandle (DWORD nStdHandle,HANDLE hHandle)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = SetStdHandle(nStdHandle,hHandle);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_SetStdHandle, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZSetSystemTime (const SYSTEMTIME* lpSystemTime)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = SetSystemTime(lpSystemTime);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_SetSystemTime, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

DWORD  ZSetTapeParameters (HANDLE hDevice,DWORD dwOperation,LPVOID lpTapeInformation)
{

    DWORD RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = SetTapeParameters(hDevice,dwOperation,lpTapeInformation);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_SetTapeParameters, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

DWORD  ZSetTapePosition (HANDLE hDevice,DWORD dwPositionMethod,DWORD dwPartition,DWORD dwOffsetLow,DWORD dwOffsetHigh,BOOL bImmediate)
{

    DWORD RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = SetTapePosition(hDevice,dwPositionMethod,dwPartition,dwOffsetLow,dwOffsetHigh,bImmediate);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_SetTapePosition, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZSetThreadContext (HANDLE hThread,const CONTEXT *lpContext)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = SetThreadContext(hThread, lpContext);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_SetThreadContext, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZSetThreadLocale (LCID Locale)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = SetThreadLocale(Locale);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_SetThreadLocale, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZSetThreadPriority (HANDLE hThread,int nPriority)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = SetThreadPriority(hThread,nPriority);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_SetThreadPriority, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZSetTimeZoneInformation (const TIME_ZONE_INFORMATION* lpTimeZoneInformation)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = SetTimeZoneInformation(lpTimeZoneInformation);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_SetTimeZoneInformation, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

LPTOP_LEVEL_EXCEPTION_FILTER  ZSetUnhandledExceptionFilter (LPTOP_LEVEL_EXCEPTION_FILTER lpTopLevelExceptionFilter)
{

    LPTOP_LEVEL_EXCEPTION_FILTER RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = SetUnhandledExceptionFilter(lpTopLevelExceptionFilter);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_SetUnhandledExceptionFilter, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZSetVolumeLabelA (LPCSTR lpRootPathName,LPCSTR lpVolumeName)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = SetVolumeLabelA(lpRootPathName,lpVolumeName);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_SetVolumeLabelA, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZSetVolumeLabelW (LPCWSTR lpRootPathName,LPCWSTR lpVolumeName)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = SetVolumeLabelW(lpRootPathName,lpVolumeName);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_SetVolumeLabelW, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZSetupComm (HANDLE hFile,DWORD dwInQueue,DWORD dwOutQueue)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = SetupComm(hFile,dwInQueue,dwOutQueue);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_SetupComm, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

DWORD  ZSizeofResource (HMODULE hModule,HRSRC hResInfo)
{

    DWORD RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = SizeofResource(hModule,hResInfo);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_SizeofResource, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

void  ZSleep (DWORD dwMilliseconds)
{

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    Sleep(dwMilliseconds);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_Sleep, ulElapsedTime);
    TimerClose(sTimerHandle);

    return;
}

DWORD  ZSleepEx (DWORD dwMilliseconds,BOOL bAlertable)
{

    DWORD RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = SleepEx(dwMilliseconds,bAlertable);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_SleepEx, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

DWORD  ZSuspendThread (HANDLE hThread)
{

    DWORD RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = SuspendThread(hThread);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_SuspendThread, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZSystemTimeToFileTime (const SYSTEMTIME* lpSystemTime,LPFILETIME lpFileTime)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = SystemTimeToFileTime(lpSystemTime,lpFileTime);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_SystemTimeToFileTime, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZTerminateProcess (HANDLE hProcess,UINT uExitCode)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = TerminateProcess(hProcess,uExitCode);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_TerminateProcess, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZTerminateThread (HANDLE hThread,DWORD dwExitCode)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = TerminateThread(hThread,dwExitCode);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_TerminateThread, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

DWORD  ZTlsAlloc ()
{

    DWORD RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = TlsAlloc();
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_TlsAlloc, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZTlsFree (DWORD dwTlsIndex)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = TlsFree(dwTlsIndex);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_TlsFree, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

LPVOID  ZTlsGetValue (DWORD dwTlsIndex)
{

    LPVOID RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = TlsGetValue(dwTlsIndex);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_TlsGetValue, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZTlsSetValue (DWORD dwTlsIndex,LPVOID lpTlsValue)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = TlsSetValue(dwTlsIndex,lpTlsValue);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_TlsSetValue, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZTransactNamedPipe (HANDLE hNamedPipe,LPVOID lpInBuffer,DWORD nInBufferSize,LPVOID lpOutBuffer,DWORD nOutBufferSize,LPDWORD lpBytesRead,LPOVERLAPPED lpOverlapped)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = TransactNamedPipe(hNamedPipe,lpInBuffer,nInBufferSize,lpOutBuffer,nOutBufferSize,lpBytesRead,lpOverlapped);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_TransactNamedPipe, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZTransmitCommChar (HANDLE hFile,char cChar)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = TransmitCommChar(hFile,cChar);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_TransmitCommChar, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

LONG  ZUnhandledExceptionFilter (struct _EXCEPTION_POINTERS* ExceptionInfo)
{

    LONG RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = UnhandledExceptionFilter(ExceptionInfo);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_UnhandledExceptionFilter, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZUnlockFile (HANDLE hFile,DWORD dwFileOffsetLow,DWORD dwFileOffsetHigh,DWORD nNumberOfBytesToUnlockLow,DWORD nNumberOfBytesToUnlockHigh)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = UnlockFile(hFile,dwFileOffsetLow,dwFileOffsetHigh,nNumberOfBytesToUnlockLow,nNumberOfBytesToUnlockHigh);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_UnlockFile, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZUnlockFileEx (HANDLE hFile,DWORD dwReserved,DWORD nNumberOfBytesToUnlockLow,DWORD nNumberOfBytesToUnlockHigh,LPOVERLAPPED lpOverlapped)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = UnlockFileEx(hFile,dwReserved,nNumberOfBytesToUnlockLow,nNumberOfBytesToUnlockHigh,lpOverlapped);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_UnlockFileEx, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZUnmapViewOfFile (LPVOID lpBaseAddress)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = UnmapViewOfFile(lpBaseAddress);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_UnmapViewOfFile, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZUpdateResourceA (HANDLE hUpdate,LPCSTR lpType,LPCSTR lpName,WORD wLanguage,LPVOID lpData,DWORD cbData)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = UpdateResourceA(hUpdate,lpType,lpName,wLanguage,lpData,cbData);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_UpdateResourceA, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZUpdateResourceW (HANDLE hUpdate,LPCWSTR lpType,LPCWSTR lpName,WORD wLanguage,LPVOID lpData,DWORD cbData)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = UpdateResourceW(hUpdate,lpType,lpName,wLanguage,lpData,cbData);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_UpdateResourceW, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

DWORD  ZVerLanguageNameA (DWORD wLang,LPSTR szLang,DWORD nSize)
{

    DWORD RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = VerLanguageNameA(wLang,szLang,nSize);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_VerLanguageNameA, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

DWORD  ZVerLanguageNameW (DWORD wLang,LPWSTR szLang,DWORD nSize)
{

    DWORD RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = VerLanguageNameW(wLang,szLang,nSize);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_VerLanguageNameW, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

LPVOID  ZVirtualAlloc (LPVOID lpAddress,DWORD dwSize,DWORD flAllocationType,DWORD flProtect)
{

    LPVOID RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = VirtualAlloc(lpAddress,dwSize,flAllocationType,flProtect);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_VirtualAlloc, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZVirtualFree (LPVOID lpAddress,DWORD dwSize,DWORD dwFreeType)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = VirtualFree(lpAddress,dwSize,dwFreeType);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_VirtualFree, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZVirtualLock (LPVOID lpAddress,DWORD dwSize)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = VirtualLock(lpAddress,dwSize);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_VirtualLock, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZVirtualProtect (LPVOID lpAddress,DWORD dwSize,DWORD flNewProtect,PDWORD lpflOldProtect)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = VirtualProtect(lpAddress,dwSize,flNewProtect,lpflOldProtect);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_VirtualProtect, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZVirtualProtectEx (HANDLE hProcess,LPVOID lpAddress,DWORD dwSize,DWORD flNewProtect,PDWORD lpflOldProtect)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = VirtualProtectEx(hProcess,lpAddress,dwSize,flNewProtect,lpflOldProtect);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_VirtualProtectEx, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

DWORD  ZVirtualQuery (LPCVOID lpAddress,PMEMORY_BASIC_INFORMATION lpBuffer,DWORD dwLength)
{

    DWORD RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = VirtualQuery(lpAddress,lpBuffer,dwLength);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_VirtualQuery, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

DWORD  ZVirtualQueryEx (HANDLE hProcess,LPCVOID lpAddress,PMEMORY_BASIC_INFORMATION lpBuffer,DWORD dwLength)
{

    DWORD RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = VirtualQueryEx(hProcess,lpAddress,lpBuffer,dwLength);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_VirtualQueryEx, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZVirtualUnlock (LPVOID lpAddress,DWORD dwSize)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = VirtualUnlock(lpAddress,dwSize);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_VirtualUnlock, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZWaitCommEvent (HANDLE hFile,LPDWORD lpEvtMask,LPOVERLAPPED lpOverlapped)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = WaitCommEvent(hFile,lpEvtMask,lpOverlapped);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_WaitCommEvent, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZWaitForDebugEvent (LPDEBUG_EVENT lpDebugEvent,DWORD dwMilliseconds)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = WaitForDebugEvent(lpDebugEvent,dwMilliseconds);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_WaitForDebugEvent, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

DWORD  ZWaitForMultipleObjects (DWORD nCount,const HANDLE* lpHandles,BOOL bWaitAll,DWORD dwMilliseconds)
{

    DWORD RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = WaitForMultipleObjects(nCount,lpHandles,bWaitAll,dwMilliseconds);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_WaitForMultipleObjects, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

DWORD  ZWaitForMultipleObjectsEx (DWORD nCount,const HANDLE* lpHandles,BOOL bWaitAll,DWORD dwMilliseconds,BOOL bAlertable)
{

    DWORD RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = WaitForMultipleObjectsEx(nCount,lpHandles,bWaitAll,dwMilliseconds,bAlertable);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_WaitForMultipleObjectsEx, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

DWORD  ZWaitForSingleObject (HANDLE hHandle,DWORD dwMilliseconds)
{

    DWORD RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = WaitForSingleObject(hHandle,dwMilliseconds);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_WaitForSingleObject, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

DWORD  ZWaitForSingleObjectEx (HANDLE hHandle,DWORD dwMilliseconds,BOOL bAlertable)
{

    DWORD RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = WaitForSingleObjectEx(hHandle,dwMilliseconds,bAlertable);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_WaitForSingleObjectEx, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZWaitNamedPipeA (LPCSTR lpNamedPipeName,DWORD nTimeOut)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = WaitNamedPipeA(lpNamedPipeName,nTimeOut);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_WaitNamedPipeA, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZWaitNamedPipeW (LPCWSTR lpNamedPipeName,DWORD nTimeOut)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = WaitNamedPipeW(lpNamedPipeName,nTimeOut);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_WaitNamedPipeW, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

int  ZWideCharToMultiByte (UINT CodePage,DWORD dwFlags,LPCWSTR lpWideCharStr,int cchWideChar,LPSTR lpMultiByteStr,int cchMultiByte,LPCSTR lpDefaultChar,LPBOOL lpUsedDefaultChar)
{

    int RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = WideCharToMultiByte(CodePage,dwFlags,lpWideCharStr,cchWideChar,lpMultiByteStr,cchMultiByte,lpDefaultChar,lpUsedDefaultChar);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_WideCharToMultiByte, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

UINT  ZWinExec (LPCSTR lpCmdLine,UINT uCmdShow)
{

    UINT RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = WinExec(lpCmdLine,uCmdShow);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_WinExec, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZWriteConsoleA (HANDLE hConsoleOutput,const void* lpBuffer,DWORD nNumberOfCharsToWrite,LPDWORD lpNumberOfCharsWritten,LPVOID lpReserved)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = WriteConsoleA(hConsoleOutput,lpBuffer,nNumberOfCharsToWrite,lpNumberOfCharsWritten,lpReserved);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_WriteConsoleA, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZWriteConsoleInputA (HANDLE hConsoleInput,PINPUT_RECORD lpBuffer,DWORD nLength,LPDWORD lpNumberOfEventsWritten)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = WriteConsoleInputA(hConsoleInput,lpBuffer,nLength,lpNumberOfEventsWritten);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_WriteConsoleInputA, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZWriteConsoleInputW (HANDLE hConsoleInput,PINPUT_RECORD lpBuffer,DWORD nLength,LPDWORD lpNumberOfEventsWritten)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = WriteConsoleInputW(hConsoleInput,lpBuffer,nLength,lpNumberOfEventsWritten);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_WriteConsoleInputW, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZWriteConsoleOutputA (HANDLE hConsoleOutput,PCHAR_INFO lpBuffer,COORD dwBufferSize,COORD dwBufferCoord,PSMALL_RECT lpWriteRegion)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = WriteConsoleOutputA(hConsoleOutput,lpBuffer,dwBufferSize,dwBufferCoord,lpWriteRegion);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_WriteConsoleOutputA, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZWriteConsoleOutputAttribute (HANDLE hConsoleOutput,LPWORD lpAttribute,DWORD nLength,COORD dwWriteCoord,LPDWORD lpNumberOfAttrsWritten)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = WriteConsoleOutputAttribute(hConsoleOutput,lpAttribute,nLength,dwWriteCoord,lpNumberOfAttrsWritten);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_WriteConsoleOutputAttribute, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZWriteConsoleOutputCharacterA (HANDLE hConsoleOutput,LPSTR lpCharacter,DWORD nLength,COORD dwWriteCoord,LPDWORD lpNumberOfCharsWritten)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = WriteConsoleOutputCharacterA(hConsoleOutput,lpCharacter,nLength,dwWriteCoord,lpNumberOfCharsWritten);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_WriteConsoleOutputCharacterA, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZWriteConsoleOutputCharacterW (HANDLE hConsoleOutput,LPWSTR lpCharacter,DWORD nLength,COORD dwWriteCoord,LPDWORD lpNumberOfCharsWritten)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = WriteConsoleOutputCharacterW(hConsoleOutput,lpCharacter,nLength,dwWriteCoord,lpNumberOfCharsWritten);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_WriteConsoleOutputCharacterW, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZWriteConsoleOutputW (HANDLE hConsoleOutput,PCHAR_INFO lpBuffer,COORD dwBufferSize,COORD dwBufferCoord,PSMALL_RECT lpWriteRegion)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = WriteConsoleOutputW(hConsoleOutput,lpBuffer,dwBufferSize,dwBufferCoord,lpWriteRegion);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_WriteConsoleOutputW, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZWriteConsoleW (HANDLE hConsoleOutput,const void* lpBuffer,DWORD nNumberOfCharsToWrite,LPDWORD lpNumberOfCharsWritten,LPVOID lpReserved)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = WriteConsoleW(hConsoleOutput,lpBuffer,nNumberOfCharsToWrite,lpNumberOfCharsWritten,lpReserved);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_WriteConsoleW, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZWriteFile (HANDLE hFile,LPCVOID lpBuffer,DWORD nNumberOfBytesToWrite,LPDWORD lpNumberOfBytesWritten,LPOVERLAPPED lpOverlapped)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = WriteFile(hFile,lpBuffer,nNumberOfBytesToWrite,lpNumberOfBytesWritten,lpOverlapped);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_WriteFile, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZWriteFileEx (HANDLE hFile,LPCVOID lpBuffer,DWORD nNumberOfBytesToWrite,LPOVERLAPPED lpOverlapped,LPOVERLAPPED_COMPLETION_ROUTINE lpCompletionRoutine)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = WriteFileEx(hFile,lpBuffer,nNumberOfBytesToWrite,lpOverlapped,lpCompletionRoutine);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_WriteFileEx, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZWritePrivateProfileSectionA (LPCSTR lpAppName,LPCSTR lpString,LPCSTR lpFileName)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = WritePrivateProfileSectionA(lpAppName,lpString,lpFileName);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_WritePrivateProfileSectionA, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZWritePrivateProfileSectionW (LPCWSTR lpAppName,LPCWSTR lpString,LPCWSTR lpFileName)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = WritePrivateProfileSectionW(lpAppName,lpString,lpFileName);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_WritePrivateProfileSectionW, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZWritePrivateProfileStringA (LPCSTR lpAppName,LPCSTR lpKeyName,LPCSTR lpString,LPCSTR lpFileName)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = WritePrivateProfileStringA(lpAppName,lpKeyName,lpString,lpFileName);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_WritePrivateProfileStringA, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZWritePrivateProfileStringW (LPCWSTR lpAppName,LPCWSTR lpKeyName,LPCWSTR lpString,LPCWSTR lpFileName)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = WritePrivateProfileStringW(lpAppName,lpKeyName,lpString,lpFileName);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_WritePrivateProfileStringW, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZWriteProcessMemory (HANDLE hProcess,LPVOID lpBaseAddress,LPVOID lpBuffer,DWORD nSize,LPDWORD lpNumberOfBytesWritten)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = WriteProcessMemory(hProcess,lpBaseAddress,lpBuffer,nSize,lpNumberOfBytesWritten);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_WriteProcessMemory, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZWriteProfileSectionA (LPCSTR lpAppName,LPCSTR lpString)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = WriteProfileSectionA(lpAppName,lpString);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_WriteProfileSectionA, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZWriteProfileSectionW (LPCWSTR lpAppName,LPCWSTR lpString)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = WriteProfileSectionW(lpAppName,lpString);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_WriteProfileSectionW, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZWriteProfileStringA (LPCSTR lpAppName,LPCSTR lpKeyName,LPCSTR lpString)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = WriteProfileStringA(lpAppName,lpKeyName,lpString);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_WriteProfileStringA, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

BOOL  ZWriteProfileStringW (LPCWSTR lpAppName,LPCWSTR lpKeyName,LPCWSTR lpString)
{

    BOOL RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = WriteProfileStringW(lpAppName,lpKeyName,lpString);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_WriteProfileStringW, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

DWORD  ZWriteTapemark (HANDLE hDevice,DWORD dwTapemarkType,DWORD dwTapemarkCount,BOOL bImmediate)
{

    DWORD RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = WriteTapemark(hDevice,dwTapemarkType,dwTapemarkCount,bImmediate);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_WriteTapemark, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

long  Z_hread (HFILE hFile,LPVOID lpBuffer,long lBytes)
{

    long RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = _hread(hFile,lpBuffer,lBytes);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I__hread, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

long  Z_hwrite (HFILE hFile,LPCSTR lpBuffer,long lBytes)
{

    long RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = _hwrite(hFile,lpBuffer,lBytes);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I__hwrite, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

HFILE  Z_lclose (HFILE hFile)
{

    HFILE RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = _lclose(hFile);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I__lclose, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

HFILE  Z_lcreat (LPCSTR lpPathName,int iAttribute)
{

    HFILE RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = _lcreat(lpPathName,iAttribute);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I__lcreat, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

LONG  Z_llseek (HFILE hFile,LONG lOffset,int iOrigin)
{

    LONG RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = _llseek(hFile,lOffset,iOrigin);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I__llseek, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

HFILE  Z_lopen (LPCSTR lpPathName,int iReadWrite)
{

    HFILE RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = _lopen(lpPathName,iReadWrite);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I__lopen, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

UINT  Z_lread (HFILE hFile,LPVOID lpBuffer,UINT uBytes)
{

    UINT RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = _lread(hFile,lpBuffer,uBytes);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I__lread, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

UINT  Z_lwrite (HFILE hFile,LPCSTR lpBuffer,UINT uBytes)
{

    UINT RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = _lwrite(hFile,lpBuffer,uBytes);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I__lwrite, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

LPSTR  ZlstrcatA (LPSTR lpString1,LPCSTR lpString2)
{

    LPSTR RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = lstrcatA(lpString1,lpString2);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_lstrcatA, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

LPWSTR  ZlstrcatW (LPWSTR lpString1,LPCWSTR lpString2)
{

    LPWSTR RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = lstrcatW(lpString1,lpString2);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_lstrcatW, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

int  ZlstrcmpA (LPCSTR lpString1,LPCSTR lpString2)
{

    int RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = lstrcmpA(lpString1,lpString2);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_lstrcmpA, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

int  ZlstrcmpW (LPCWSTR lpString1,LPCWSTR lpString2)
{

    int RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = lstrcmpW(lpString1,lpString2);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_lstrcmpW, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

int  ZlstrcmpiA (LPCSTR lpString1,LPCSTR lpString2)
{

    int RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = lstrcmpiA(lpString1,lpString2);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_lstrcmpiA, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

int  ZlstrcmpiW (LPCWSTR lpString1,LPCWSTR lpString2)
{

    int RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = lstrcmpiW(lpString1,lpString2);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_lstrcmpiW, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

LPSTR  ZlstrcpyA (LPSTR lpString1,LPCSTR lpString2)
{

    LPSTR RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = lstrcpyA(lpString1,lpString2);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_lstrcpyA, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

LPWSTR  ZlstrcpyW (LPWSTR lpString1,LPCWSTR lpString2)
{

    LPWSTR RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = lstrcpyW(lpString1,lpString2);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_lstrcpyW, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

int  ZlstrlenA (LPCSTR lpString)
{

    int RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = lstrlenA(lpString);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_lstrlenA, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}

int  ZlstrlenW (LPCWSTR lpString)
{

    int RetVal;

    SHORT sTimerHandle;
    ULONG ulElapsedTime;

    if (fInitDone == FALSE) {
        ApfInitDll();
    }
    TimerOpen(&sTimerHandle, MICROSECONDS);
    TimerInit(sTimerHandle);
    //
    // Call the api
    //
    RetVal = lstrlenW(lpString);
    //
    // Get the elapsed time
    //
    ulElapsedTime = TimerRead(sTimerHandle);
    ApfRecordInfo(I_lstrlenW, ulElapsedTime);
    TimerClose(sTimerHandle);

    return(RetVal);
}
