//
//
//  mondata.c        -   a file containing the constant data structures
//                    for the Performance Monitor data in the Configuration
//                    Registry for NT.
//
//

//
//  This file contains a set of (nearly) constant data structures
//  which describe the object types and counters that are defined
//  for NT.  The "nearly" applies to the fact that the Name and Help
//  Title Indexes will be established in these structures when the
//  Performance Data .dll is initialized.  The actual indexes for
//  these Titles will be created at system installation time and
//  retained in the Configuration Registry.  When the Performance
//  Data .dll initializes, it will retrieve the installed indexes
//  and imbed them in these structures for later rapid access.
//
//  Since none of that mechanism is in place yet, we simple assign
//  a static number to each name or help item (see regmonti.h).
//  These are reporduced statically here for the time being.
//

//
//
//  Written by:
//
//        Russ Blake  11/15/91
//
//  Revision History:
//
//
//

#include <nt.h>
#include <ntrtl.h>
#include <nturtl.h>
#include <ntprfctr.h>
#include <windows.h>
#include <winperf.h>
#include "ntconreg.h"
#include "ntmon.h"

//
//  Constant structure initializations
//


SYSTEM_DATA_DEFINITION SystemDataDefinition = {
    {   sizeof(SYSTEM_DATA_DEFINITION) + SIZE_OF_SYSTEM_DATA,
        sizeof(SYSTEM_DATA_DEFINITION),
        sizeof(PERF_OBJECT_TYPE),
        SYSTEM_OBJECT_TITLE_INDEX,
        0,
        3,
        0,
        PERF_DETAIL_NOVICE,
        (sizeof(SYSTEM_DATA_DEFINITION)-sizeof(PERF_OBJECT_TYPE))/
        sizeof(PERF_COUNTER_DEFINITION),
        8,       // Default: TOTAL_PROCESSOR_TIME
        -1,
        UNICODE_CODE_PAGE,
        {0L,0L},
        {10000000L,0L}        
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        10,
        0,
        11,
        0,
        0,
        PERF_DETAIL_NOVICE,
        PERF_COUNTER_COUNTER,
        sizeof(DWORD),
        READ_OPERATIONS_OFFSET
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        12,
        0,
        13,
        0,
        0,
        PERF_DETAIL_NOVICE,
        PERF_COUNTER_COUNTER,
        sizeof(DWORD),
        WRITE_OPERATIONS_OFFSET
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        14,
        0,
        15,
        0,
        0,
        PERF_DETAIL_ADVANCED,
        PERF_COUNTER_COUNTER,
        sizeof(DWORD),
        OTHER_IO_OPERATIONS_OFFSET
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        16,
        0,
        17,
        0,
        -4,
        PERF_DETAIL_EXPERT,
        PERF_COUNTER_BULK_COUNT,
        sizeof(LARGE_INTEGER),
        READ_BYTES_OFFSET
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        18,
        0,
        19,
        0,
        -4,
        PERF_DETAIL_EXPERT,
        PERF_COUNTER_BULK_COUNT,
        sizeof(LARGE_INTEGER),
        WRITE_BYTES_OFFSET
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        20,
        0,
        21,
        0,
        -3,
        PERF_DETAIL_WIZARD,
        PERF_COUNTER_BULK_COUNT,
        sizeof(LARGE_INTEGER),
        OTHER_IO_BYTES_OFFSET
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        146,
        0,
        147,
        0,
        -2,
        PERF_DETAIL_ADVANCED,
        PERF_COUNTER_COUNTER,
        sizeof(DWORD),
        CONTEXT_SWITCHES_OFFSET
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        150,
        0,
        151,
        0,
        -1,
        PERF_DETAIL_ADVANCED,
        PERF_COUNTER_COUNTER,
        sizeof(DWORD),
        SYSTEM_CALLS_OFFSET
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        240,
        0,
        241,
        0,
        0,
        PERF_DETAIL_NOVICE,
        PERF_100NSEC_TIMER_INV,
        sizeof(LARGE_INTEGER),
        TOTAL_PROCESSOR_TIME_OFFSET
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        242,
        0,
        243,
        0,
        0,
        PERF_DETAIL_ADVANCED,
        PERF_100NSEC_TIMER,
        sizeof(LARGE_INTEGER),
        TOTAL_USER_TIME_OFFSET
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        244,
        0,
        245,
        0,
        0,
        PERF_DETAIL_ADVANCED,
        PERF_100NSEC_TIMER,
        sizeof(LARGE_INTEGER),
        TOTAL_PRIVILEGED_TIME_OFFSET
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        246,
        0,
        247,
        0,
        -2,
        PERF_DETAIL_ADVANCED,
        PERF_COUNTER_COUNTER,
        sizeof(DWORD),
        TOTAL_INTERRUPTS_OFFSET
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        406,
        0,
        407,
        0,
        0,
        PERF_DETAIL_NOVICE,
        PERF_COUNTER_COUNTER,
        sizeof(DWORD),
        READ_WRITE_OPERATIONS_OFFSET
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        674,
        0,
        675,
        0,
        -5,
        PERF_DETAIL_NOVICE,
        PERF_ELAPSED_TIME,
        sizeof(LARGE_INTEGER),
        SYSTEM_ELAPSED_TIME_OFFSET
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        44,
        0,
        45,
        0,
        1,
        PERF_DETAIL_WIZARD,
        PERF_COUNTER_RAWCOUNT,
        sizeof(DWORD),
        PROCESSOR_QUEUE_LEN_OFFSET
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        686,
        0,
        687,
        0,
        0,
        PERF_DETAIL_WIZARD,
        PERF_COUNTER_COUNTER,
        sizeof(DWORD),
        ALIGNMENT_FIXUP_OFFSET
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        688,
        0,
        689,
        0,
        0,
        PERF_DETAIL_WIZARD,
        PERF_COUNTER_COUNTER,
        sizeof(DWORD),
        EXCEPTION_DISPATCH_OFFSET
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        690,
        0,
        691,
        0,
        0,
        PERF_DETAIL_WIZARD,
        PERF_COUNTER_COUNTER,
        sizeof(DWORD),
        FLOATING_EMULTAION_OFFSET
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        660,
        0,
        9,
        0,
        0,
        PERF_DETAIL_ADVANCED,
        PERF_100NSEC_TIMER,
        sizeof(LARGE_INTEGER),
        TOTAL_DPC_TIME_OFFSET
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        662,
        0,
        23,
        0,
        0,
        PERF_DETAIL_ADVANCED,
        PERF_100NSEC_TIMER,
        sizeof(LARGE_INTEGER),
        TOTAL_INTERRUPT_TIME_OFFSET
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        1342,
        0,
        1343,
        0,
        0,
        PERF_DETAIL_ADVANCED,
        PERF_COUNTER_COUNTER,
        sizeof(DWORD),
        TOTAL_DPC_COUNT_RATE_OFFSET
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        1344,
        0,
        1345,
        0,
        0,
        PERF_DETAIL_ADVANCED,
        PERF_COUNTER_RAWCOUNT,
        sizeof(DWORD),
        TOTAL_DPC_RATE_OFFSET
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        1346,
        0,
        1347,
        0,
        0,
        PERF_DETAIL_ADVANCED,
        PERF_COUNTER_COUNTER,
        sizeof(DWORD),
        TOTAL_DPC_BYPASS_RATE_OFFSET
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        1348,
        0,
        1349,
        0,
        0,
        PERF_DETAIL_ADVANCED,
        PERF_COUNTER_COUNTER,
        sizeof(DWORD),
        TOTAL_APC_BYPASS_RATE_OFFSET
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        1350,
        0,
        1351,
        0,
        0,
        PERF_DETAIL_ADVANCED,
        PERF_RAW_FRACTION,
        sizeof(DWORD),
        REGISTRY_QUOTA_USED_OFFSET
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        1350,
        0,
        1351,
        0,
        0,
        PERF_DETAIL_ADVANCED,
        PERF_RAW_BASE,
        sizeof(DWORD),
        REGISTRY_QUOTA_ALLOWED_OFFSET
    }
};


PROCESSOR_DATA_DEFINITION ProcessorDataDefinition = {

    {   0,
        sizeof(PROCESSOR_DATA_DEFINITION),
        sizeof(PERF_OBJECT_TYPE),
        PROCESSOR_OBJECT_TITLE_INDEX,
        0,
        239,
        0,
        PERF_DETAIL_NOVICE,
        (sizeof(PROCESSOR_DATA_DEFINITION)-sizeof(PERF_OBJECT_TYPE))/
        sizeof(PERF_COUNTER_DEFINITION),
        0,
        1,
        UNICODE_CODE_PAGE,
        {0L,0L},
        {0L,0L}        
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        6,
        0,
        7,
        0,
        0,
        PERF_DETAIL_NOVICE,
        PERF_100NSEC_TIMER_INV,
        sizeof(LARGE_INTEGER),
        PROCESSOR_TIME_OFFSET
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        142,
        0,
        143,
        0,
        0,
        PERF_DETAIL_ADVANCED,
        PERF_100NSEC_TIMER,
        sizeof(LARGE_INTEGER),
        USER_TIME_OFFSET
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        144,
        0,
        145,
        0,
        0,
        PERF_DETAIL_ADVANCED,
        PERF_100NSEC_TIMER,
        sizeof(LARGE_INTEGER),
        KERNEL_TIME_OFFSET
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        148,
        0,
        149,
        0,
        -2,
        PERF_DETAIL_NOVICE,
        PERF_COUNTER_COUNTER,
        sizeof(DWORD),
        INTERRUPTS_OFFSET
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        696,
        0,
        339,
        0,
        0,
        PERF_DETAIL_ADVANCED,
        PERF_100NSEC_TIMER,
        sizeof(LARGE_INTEGER),
        DPC_TIME_OFFSET
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        698,
        0,
        397,
        0,
        0,
        PERF_DETAIL_ADVANCED,
        PERF_100NSEC_TIMER,
        sizeof(LARGE_INTEGER),
        INTERRUPT_TIME_OFFSET
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        1334,
        0,
        1335,
        0,
        0,
        PERF_DETAIL_ADVANCED,
        PERF_COUNTER_COUNTER,
        sizeof(DWORD),
        DPC_COUNT_OFFSET
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        1336,
        0,
        1337,
        0,
        0,
        PERF_DETAIL_ADVANCED,
        PERF_COUNTER_RAWCOUNT,
        sizeof(DWORD),
        DPC_RATE_OFFSET
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        1338,
        0,
        1339,
        0,
        0,
        PERF_DETAIL_ADVANCED,
        PERF_COUNTER_COUNTER,
        sizeof(DWORD),
        DPC_BYPASS_RATE_OFFSET
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        1340,
        0,
        1341,
        0,
        0,
        PERF_DETAIL_ADVANCED,
        PERF_COUNTER_COUNTER,
        sizeof(DWORD),
        APC_BYPASS_RATE_OFFSET
    }
};


MEMORY_DATA_DEFINITION MemoryDataDefinition = {

    {   sizeof(MEMORY_DATA_DEFINITION) + SIZE_OF_MEMORY_DATA,
        sizeof(MEMORY_DATA_DEFINITION),
        sizeof(PERF_OBJECT_TYPE),
        MEMORY_OBJECT_TITLE_INDEX,
        0,
        5,
        0,
        PERF_DETAIL_NOVICE,
        (sizeof(MEMORY_DATA_DEFINITION)-sizeof(PERF_OBJECT_TYPE))/
        sizeof(PERF_COUNTER_DEFINITION),
        8,
        -1,
        UNICODE_CODE_PAGE,
        {0L,0L},
        {0L,0L}        
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        24,
        0,
        25,
        0,
        -5,
        PERF_DETAIL_EXPERT,
        PERF_COUNTER_RAWCOUNT,
        sizeof(DWORD),
        AVAILABLE_PAGES_OFFSET
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        26,
        0,
        27,
        0,
        -6,
        PERF_DETAIL_EXPERT,
        PERF_COUNTER_RAWCOUNT,
        sizeof(DWORD),
        COMMITTED_PAGES_OFFSET
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        30,
        0,
        31,
        0,
        -6,
        PERF_DETAIL_WIZARD,
        PERF_COUNTER_RAWCOUNT,
        sizeof(DWORD),
        COMMIT_LIMIT_OFFSET
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        28,
        0,
        29,
        0,
        -1,
        PERF_DETAIL_NOVICE,
        PERF_COUNTER_COUNTER,
        sizeof(DWORD),
        PAGE_FAULTS_OFFSET
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        32,
        0,
        33,
        0,
        0,
        PERF_DETAIL_WIZARD,
        PERF_COUNTER_COUNTER,
        sizeof(DWORD),
        WRITE_COPIES_OFFSET
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        34,
        0,
        35,
        0,
        -1,
        PERF_DETAIL_WIZARD,
        PERF_COUNTER_COUNTER,
        sizeof(DWORD),
        TRANSITION_FAULTS_OFFSET
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        36,
        0,
        37,
        0,
        -1,
        PERF_DETAIL_WIZARD,
        PERF_COUNTER_COUNTER,
        sizeof(DWORD),
        CACHE_FAULTS_OFFSET
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        38,
        0,
        39,
        0,
        -1,
        PERF_DETAIL_WIZARD,
        PERF_COUNTER_COUNTER,
        sizeof(DWORD),
        DEMAND_ZERO_FAULTS_OFFSET
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        40,
        0,
        41,
        0,
        0,
        PERF_DETAIL_NOVICE,
        PERF_COUNTER_COUNTER,
        sizeof(DWORD),
        PAGES_OFFSET
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
	     822,
        0,
        823,
        0,
        0,
        PERF_DETAIL_NOVICE,
        PERF_COUNTER_COUNTER,
        sizeof(DWORD),
	     PAGES_INPUT_OFFSET
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        42,
        0,
        43,
        0,
        0,
        PERF_DETAIL_EXPERT,
        PERF_COUNTER_COUNTER,
        sizeof(DWORD),
        PAGE_READS_OFFSET
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        48,
        0,
        49,
        0,
        0,
        PERF_DETAIL_ADVANCED,
        PERF_COUNTER_COUNTER,
        sizeof(DWORD),
        DIRTY_PAGES_OFFSET
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        50,
        0,
        51,
        0,
        0,
        PERF_DETAIL_EXPERT,
        PERF_COUNTER_COUNTER,
        sizeof(DWORD),
        DIRTY_WRITES_OFFSET
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        56,
        0,
        57,
        0,
        -5,
        PERF_DETAIL_ADVANCED,
        PERF_COUNTER_RAWCOUNT,
        sizeof(DWORD),
        PAGED_POOL_OFFSET
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        58,
        0,
        59,
        0,
        -5,
        PERF_DETAIL_ADVANCED,
        PERF_COUNTER_RAWCOUNT,
        sizeof(DWORD),
        NON_PAGED_POOL_OFFSET
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        60,
        0,
        61,
        0,
        -2,
        PERF_DETAIL_WIZARD,
        PERF_COUNTER_RAWCOUNT,
        sizeof(DWORD),
        PAGED_POOL_ALLOCS_OFFSET
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        64,
        0,
        65,
        0,
        -2,
        PERF_DETAIL_WIZARD,
        PERF_COUNTER_RAWCOUNT,
        sizeof(DWORD),
        NON_PAGED_POOL_ALLOCS_OFFSET
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        678,
        0,
        679,
        0,
        -2,
        PERF_DETAIL_WIZARD,
        PERF_COUNTER_RAWCOUNT,
        sizeof(DWORD),
        FREE_SYSTEM_PTES_OFFSET
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        818,
        0,
        819,
        0,
        -5,
        PERF_DETAIL_ADVANCED,
        PERF_COUNTER_RAWCOUNT,
        sizeof(DWORD),
        CACHE_BYTES_OFFSET
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        820,
        0,
        821,
        0,
        -5,
        PERF_DETAIL_ADVANCED,
        PERF_COUNTER_RAWCOUNT,
        sizeof(DWORD),
        PEAK_CACHE_BYTES_OFFSET
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        66,
        0,
        63,
        0,
        -5,
        PERF_DETAIL_ADVANCED,
        PERF_COUNTER_RAWCOUNT,
        sizeof(DWORD),
        RESIDENT_PAGED_POOL_OFFSET
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        68,
        0,
        69,
        0,
        -5,
        PERF_DETAIL_ADVANCED,
        PERF_COUNTER_RAWCOUNT,
        sizeof(DWORD),
        TOTAL_SYSTEM_CODE_OFFSET
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        70,
        0,
        71,
        0,
        -5,
        PERF_DETAIL_ADVANCED,
        PERF_COUNTER_RAWCOUNT,
        sizeof(DWORD),
        RESIDENT_SYSTEM_CODE_OFFSET
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        72,
        0,
        73,
        0,
        -5,
        PERF_DETAIL_ADVANCED,
        PERF_COUNTER_RAWCOUNT,
        sizeof(DWORD),
        TOTAL_SYSTEM_DRIVER_OFFSET
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        74,
        0,
        75,
        0,
        -5,
        PERF_DETAIL_ADVANCED,
        PERF_COUNTER_RAWCOUNT,
        sizeof(DWORD),
        RESIDENT_SYSTEM_DRIVER_OFFSET
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        76,
        0,
        77,
        0,
        -5,
        PERF_DETAIL_ADVANCED,
        PERF_COUNTER_RAWCOUNT,
        sizeof(DWORD),
        RESIDENT_SYSTEM_CACHE_OFFSET
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        1406,
        0,
        1407,
        0,
        0,
        PERF_DETAIL_EXPERT,
        PERF_RAW_FRACTION,
        sizeof(DWORD),
        COMMIT_BYTES_IN_USE_OFFSET
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        1406,
        0,
        1407,
        0,
        0,
        PERF_DETAIL_EXPERT,
        PERF_RAW_BASE,
        sizeof(DWORD),
        COMMIT_BYTES_LIMIT_OFFSET
    }
};



CACHE_DATA_DEFINITION CacheDataDefinition = {

    {   sizeof(CACHE_DATA_DEFINITION) + SIZE_OF_CACHE_DATA,
        sizeof(CACHE_DATA_DEFINITION),
        sizeof(PERF_OBJECT_TYPE),
        CACHE_OBJECT_TITLE_INDEX,
        0,
        87,
        0,
        PERF_DETAIL_ADVANCED,
        (sizeof(CACHE_DATA_DEFINITION)-sizeof(PERF_OBJECT_TYPE))/
        sizeof(PERF_COUNTER_DEFINITION),
        3,
        -1,
        UNICODE_CODE_PAGE,
        {0L,0L},
        {0L,0L}        
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        88,
        0,
        89,
        0,
        0,
        PERF_DETAIL_EXPERT,
        PERF_COUNTER_COUNTER,
        sizeof(DWORD),
        DATA_MAPS_OFFSET
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        90,
        0,
        91,
        0,
        0,
        PERF_DETAIL_WIZARD,
        PERF_COUNTER_COUNTER,
        sizeof(DWORD),
        SYNC_DATA_MAPS_OFFSET
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        92,
        0,
        93,
        0,
        0,
        PERF_DETAIL_WIZARD,
        PERF_COUNTER_COUNTER,
        sizeof(DWORD),
        ASYNC_DATA_MAPS_OFFSET
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        94,
        0,
        95,
        0,
        0,
        PERF_DETAIL_WIZARD,
        PERF_SAMPLE_FRACTION,
        sizeof(DWORD),
        DATA_MAP_HITS_OFFSET
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        94,
        0,
        95,
        0,
        0,
        PERF_DETAIL_WIZARD,
        PERF_SAMPLE_BASE,
        sizeof(DWORD),
        DATA_MAP_HITS_BASE_OFFSET
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        96,
        0,
        97,
        0,
        0,
        PERF_DETAIL_WIZARD,
        PERF_SAMPLE_FRACTION,
        sizeof(DWORD),
        DATA_MAP_PINS_OFFSET
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        96,
        0,
        97,
        0,
        0,
        PERF_DETAIL_WIZARD,
        PERF_SAMPLE_BASE,
        sizeof(DWORD),
        DATA_MAP_PINS_BASE_OFFSET
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        98,
        0,
        99,
        0,
        0,
        PERF_DETAIL_EXPERT,
        PERF_COUNTER_COUNTER,
        sizeof(DWORD),
        PIN_READS_OFFSET
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        100,
        0,
        101,
        0,
        0,
        PERF_DETAIL_WIZARD,
        PERF_COUNTER_COUNTER,
        sizeof(DWORD),
        SYNC_PIN_READS_OFFSET
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        102,
        0,
        103,
        0,
        0,
        PERF_DETAIL_WIZARD,
        PERF_COUNTER_COUNTER,
        sizeof(DWORD),
        ASYNC_PIN_READS_OFFSET
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        104,
        0,
        105,
        0,
        0,
        PERF_DETAIL_EXPERT,
        PERF_SAMPLE_FRACTION,
        sizeof(DWORD),
        PIN_READ_HITS_OFFSET
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        104,
        0,
        105,
        0,
        0,
        PERF_DETAIL_EXPERT,
        PERF_SAMPLE_BASE,
        sizeof(DWORD),
        PIN_READ_HITS_BASE_OFFSET
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        106,
        0,
        107,
        0,
        0,
        PERF_DETAIL_EXPERT,
        PERF_COUNTER_COUNTER,
        sizeof(DWORD),
        COPY_READS_OFFSET
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        108,
        0,
        109,
        0,
        0,
        PERF_DETAIL_WIZARD,
        PERF_COUNTER_COUNTER,
        sizeof(DWORD),
        SYNC_COPY_READS_OFFSET
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        110,
        0,
        111,
        0,
        0,
        PERF_DETAIL_WIZARD,
        PERF_COUNTER_COUNTER,
        sizeof(DWORD),
        ASYNC_COPY_READS_OFFSET
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        112,
        0,
        113,
        0,
        0,
        PERF_DETAIL_EXPERT,
        PERF_SAMPLE_FRACTION,
        sizeof(DWORD),
        COPY_READ_HITS_OFFSET
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        112,
        0,
        113,
        0,
        0,
        PERF_DETAIL_EXPERT,
        PERF_SAMPLE_BASE,
        sizeof(DWORD),
        COPY_READ_HITS_BASE_OFFSET
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        114,
        0,
        115,
        0,
        0,
        PERF_DETAIL_EXPERT,
        PERF_COUNTER_COUNTER,
        sizeof(DWORD),
        MDL_READS_OFFSET
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        116,
        0,
        117,
        0,
        0,
        PERF_DETAIL_WIZARD,
        PERF_COUNTER_COUNTER,
        sizeof(DWORD),
        SYNC_MDL_READS_OFFSET
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        118,
        0,
        119,
        0,
        0,
        PERF_DETAIL_WIZARD,
        PERF_COUNTER_COUNTER,
        sizeof(DWORD),
        ASYNC_MDL_READS_OFFSET
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        120,
        0,
        121,
        0,
        0,
        PERF_DETAIL_EXPERT,
        PERF_SAMPLE_FRACTION,
        sizeof(DWORD),
        MDL_READ_HITS_OFFSET
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        120,
        0,
        121,
        0,
        0,
        PERF_DETAIL_EXPERT,
        PERF_SAMPLE_BASE,
        sizeof(DWORD),
        MDL_READ_HITS_BASE_OFFSET
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        122,
        0,
        123,
        0,
        0,
        PERF_DETAIL_ADVANCED,
        PERF_COUNTER_COUNTER,
        sizeof(DWORD),
        READ_AHEADS_OFFSET
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        124,
        0,
        125,
        0,
        -1,
        PERF_DETAIL_EXPERT,
        PERF_COUNTER_COUNTER,
        sizeof(DWORD),
        FAST_READS_OFFSET
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        126,
        0,
        127,
        0,
        -1,
        PERF_DETAIL_WIZARD,
        PERF_COUNTER_COUNTER,
        sizeof(DWORD),
        SYNC_FAST_READS_OFFSET
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        128,
        0,
        129,
        0,
        -1,
        PERF_DETAIL_WIZARD,
        PERF_COUNTER_COUNTER,
        sizeof(DWORD),
        ASYNC_FAST_READS_OFFSET
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        130,
        0,
        131,
        0,
        0,
        PERF_DETAIL_WIZARD,
        PERF_COUNTER_COUNTER,
        sizeof(DWORD),
        FAST_READ_RESOURCE_MISS_OFFSET
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        132,
        0,
        133,
        0,
        0,
        PERF_DETAIL_WIZARD,
        PERF_COUNTER_COUNTER,
        sizeof(DWORD),
        FAST_READ_NOT_POSSIBLES_OFFSET
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        134,
        0,
        135,
        0,
        0,
        PERF_DETAIL_WIZARD,
        PERF_COUNTER_COUNTER,
        sizeof(DWORD),
        LAZY_WRITE_FLUSHES_OFFSET
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        136,
        0,
        137,
        0,
        0,
        PERF_DETAIL_ADVANCED,
        PERF_COUNTER_COUNTER,
        sizeof(DWORD),
        LAZY_WRITE_PAGES_OFFSET
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        138,
        0,
        139,
        0,
        0,
        PERF_DETAIL_WIZARD,
        PERF_COUNTER_COUNTER,
        sizeof(DWORD),
        DATA_FLUSHES_OFFSET
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        140,
        0,
        141,
        0,
        0,
        PERF_DETAIL_ADVANCED,
        PERF_COUNTER_COUNTER,
        sizeof(DWORD),
        DATA_PAGES_OFFSET
    }
};


PROCESS_DATA_DEFINITION ProcessDataDefinition = {

    {        0,
        sizeof(PROCESS_DATA_DEFINITION),
        sizeof(PERF_OBJECT_TYPE),
        PROCESS_OBJECT_TITLE_INDEX,
        0,
        231,
        0,
        PERF_DETAIL_NOVICE,
        (sizeof(PROCESS_DATA_DEFINITION)-sizeof(PERF_OBJECT_TYPE))/
        sizeof(PERF_COUNTER_DEFINITION),
        0,
        0,
        UNICODE_CODE_PAGE,
        {0L,0L},
        {10000000L,0L}        
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        6,
        0,
        189,
        0,
        0,
        PERF_DETAIL_NOVICE,
        PERF_100NSEC_TIMER,
        sizeof(LARGE_INTEGER),
        P_PROCESSOR_TIME_OFFSET
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        142,
        0,
        157,
        0,
        0,
        PERF_DETAIL_ADVANCED,
        PERF_100NSEC_TIMER,
        sizeof(LARGE_INTEGER),
        P_USER_TIME_OFFSET
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        144,
        0,
        159,
        0,
        0,
        PERF_DETAIL_ADVANCED,
        PERF_100NSEC_TIMER,
        sizeof(LARGE_INTEGER),
        P_KERNEL_TIME_OFFSET
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        172,
        0,
        173,
        0,
        -6,
        PERF_DETAIL_EXPERT,
        PERF_COUNTER_RAWCOUNT,
        sizeof(DWORD),
        PEAK_VIRTUAL_SIZE_OFFSET
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        174,
        0,
        175,
        0,
        -6,
        PERF_DETAIL_EXPERT,
        PERF_COUNTER_RAWCOUNT,
        sizeof(DWORD),
        VIRTUAL_SIZE_OFFSET
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        28,
        0,
        177,
        0,
        -1,
        PERF_DETAIL_NOVICE,
        PERF_COUNTER_COUNTER,
        sizeof(DWORD),
        P_PAGE_FAULTS_OFFSET
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        178,
        0,
        179,
        0,
        -5,
        PERF_DETAIL_ADVANCED,
        PERF_COUNTER_RAWCOUNT,
        sizeof(DWORD),
        PEAK_WORKING_SET_OFFSET
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        180,
        0,
        181,
        0,
        -5,
        PERF_DETAIL_NOVICE,
        PERF_COUNTER_RAWCOUNT,
        sizeof(DWORD),
        WORKING_SET_OFFSET
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        182,
        0,
        183,
        0,
        -6,
        PERF_DETAIL_ADVANCED,
        PERF_COUNTER_RAWCOUNT,
        sizeof(DWORD),
        PEAK_PAGE_FILE_OFFSET
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        184,
        0,
        185,
        0,
        -6,
        PERF_DETAIL_ADVANCED,
        PERF_COUNTER_RAWCOUNT,
        sizeof(DWORD),
        PAGE_FILE_OFFSET
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        186,
        0,
        187,
        0,
        -5,
        PERF_DETAIL_ADVANCED,
        PERF_COUNTER_RAWCOUNT,
        sizeof(DWORD),
        PRIVATE_PAGES_OFFSET
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        680,
        0,
        681,
        0,
        0,
        PERF_DETAIL_ADVANCED,
        PERF_COUNTER_RAWCOUNT,
        sizeof(DWORD),
        P_THREAD_COUNT_OFFSET
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        682,
        0,
        683,
        0,
        0,
        PERF_DETAIL_ADVANCED,
        PERF_COUNTER_RAWCOUNT,
        sizeof(DWORD),
        P_BASE_PRIORITY_OFFSET
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        684,
        0,
        685,
        0,
        -4,
        PERF_DETAIL_ADVANCED,
        PERF_ELAPSED_TIME,
        sizeof(LARGE_INTEGER),
        P_ELAPSED_TIME_OFFSET
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        784,
        0,
        785,
        0,
        -1,
        PERF_DETAIL_NOVICE,
        PERF_COUNTER_RAWCOUNT,
        sizeof(DWORD),
        P_PROCESS_ID_OFFSET
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        1410,
        0,
        1411,
        0,
        -1,
        PERF_DETAIL_NOVICE,
        PERF_COUNTER_RAWCOUNT,
        sizeof(DWORD),
        P_PROCESS_CREATOR_ID_OFFSET
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        56,
        0,
        57,
        0,
        -5,
        PERF_DETAIL_ADVANCED,
        PERF_COUNTER_RAWCOUNT,
        sizeof(DWORD),
        P_PAGEDPOOL_OFFSET
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        58,
        0,
        59,
        0,
        -5,
        PERF_DETAIL_ADVANCED,
        PERF_COUNTER_RAWCOUNT,
        sizeof(DWORD),
        P_NONPAGEDPOOL_OFFSET
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        952,
        0,
        953,
        0,
        0,
        PERF_DETAIL_ADVANCED,
        PERF_COUNTER_RAWCOUNT,
        sizeof(DWORD),
        P_HANDLE_COUNT_OFFSET
    }
};


THREAD_DATA_DEFINITION ThreadDataDefinition = {

    {   0,
        sizeof(THREAD_DATA_DEFINITION),
        sizeof(PERF_OBJECT_TYPE),
        THREAD_OBJECT_TITLE_INDEX,
        0,
        233,
        0,
        PERF_DETAIL_NOVICE,
        (sizeof(THREAD_DATA_DEFINITION)-sizeof(PERF_OBJECT_TYPE))/
        sizeof(PERF_COUNTER_DEFINITION),
        0,
        0,
        UNICODE_CODE_PAGE,
        {0L,0L},
        {10000000L,0L}        
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        6,
        0,
        191,
        0,
        0,
        PERF_DETAIL_NOVICE,
        PERF_100NSEC_TIMER,
        sizeof(LARGE_INTEGER),
        T_PROCESSOR_TIME_OFFSET
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        142,
        0,
        193,
        0,
        0,
        PERF_DETAIL_ADVANCED,
        PERF_100NSEC_TIMER,
        sizeof(LARGE_INTEGER),
        T_USER_TIME_OFFSET
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        144,
        0,
        195,
        0,
        0,
        PERF_DETAIL_ADVANCED,
        PERF_100NSEC_TIMER,
        sizeof(LARGE_INTEGER),
        T_KERNEL_TIME_OFFSET
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        146,
        0,
        197,
        0,
        -2,
        PERF_DETAIL_ADVANCED,
        PERF_COUNTER_COUNTER,
        sizeof(DWORD),
        T_CONTEXT_SWITCHES_OFFSET
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        684,
        0,
        699,
        0,
        -4,
        PERF_DETAIL_ADVANCED,
        PERF_ELAPSED_TIME,
        sizeof(LARGE_INTEGER),
        T_ELAPSED_TIME_OFFSET
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        694,
        0,
        695,
        0,
        0,
        PERF_DETAIL_ADVANCED,
        PERF_COUNTER_RAWCOUNT,
        sizeof(DWORD),
        T_PRIORITY_OFFSET
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        682,
        0,
        697,
        0,
        0,
        PERF_DETAIL_ADVANCED,
        PERF_COUNTER_RAWCOUNT,
        sizeof(DWORD),
        T_BASE_PRIORITY_OFFSET
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        706,
        0,
        707,
        0,
        0,
        PERF_DETAIL_WIZARD,
        PERF_COUNTER_RAWCOUNT,
        sizeof(DWORD),
        T_START_ADDRESS_OFFSET
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        46,
        0,
        47,
        0,
        0,
        PERF_DETAIL_WIZARD,
        PERF_COUNTER_RAWCOUNT,
        sizeof(DWORD),
        T_THREAD_STATE_OFFSET
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        336,
        0,
        337,
        0,
        0,
        PERF_DETAIL_WIZARD,
        PERF_COUNTER_RAWCOUNT,
        sizeof(DWORD),
        T_WAIT_REASON_OFFSET
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        784,
        0,
        785,
        0,
        0,
        PERF_DETAIL_WIZARD,
        PERF_COUNTER_RAWCOUNT,
        sizeof(DWORD),
        T_ID_PROCESS_OFFSET
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        804,
        0,
        805,
        0,
        0,
        PERF_DETAIL_WIZARD,
        PERF_COUNTER_RAWCOUNT,
        sizeof(DWORD),
        T_ID_THREAD_OFFSET
    }
};


PDISK_DATA_DEFINITION PhysicalDiskDataDefinition = {

    {   0,
        sizeof(PDISK_DATA_DEFINITION),
        sizeof(PERF_OBJECT_TYPE),
        PHYSICAL_DISK_OBJECT_TITLE_INDEX,
        0,
        235,
        0,
        PERF_DETAIL_NOVICE,
        (sizeof(PDISK_DATA_DEFINITION)-sizeof(PERF_OBJECT_TYPE))/
        sizeof(PERF_COUNTER_DEFINITION),
        2,
        0,
        UNICODE_CODE_PAGE,
        {0L,0L},
        {0L,0L}        
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        198,
        0,
        199,
        0,
        1,
        PERF_DETAIL_NOVICE,
        PERF_COUNTER_RAWCOUNT,
        sizeof(DWORD),
        PDISK_QUEUE_LENGTH_OFFSET
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        200,
        0,
        201,
        0,
        0,
        PERF_DETAIL_NOVICE,
        PERF_COUNTER_TIMER,
        sizeof(LARGE_INTEGER),
        PDISK_TIME_OFFSET
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        1400,
        0,
        1401,
        0,
        2,
        PERF_DETAIL_NOVICE,
        PERF_COUNTER_LARGE_QUEUELEN_TYPE,
        sizeof(LARGE_INTEGER),
        PDISK_AVG_QUEUE_LENGTH_OFFSET
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        202,
        0,
        203,
        0,
        0,
        PERF_DETAIL_NOVICE,
        PERF_COUNTER_TIMER,
        sizeof(LARGE_INTEGER),
        PDISK_READ_TIME_OFFSET
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        1402,
        0,
        1403,
        0,
        2,
        PERF_DETAIL_NOVICE,
        PERF_COUNTER_LARGE_QUEUELEN_TYPE,
        sizeof(LARGE_INTEGER),
        PDISK_READ_QUEUE_LENGTH_OFFSET
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        204,
        0,
        205,
        0,
        0,
        PERF_DETAIL_NOVICE,
        PERF_COUNTER_TIMER,
        sizeof(LARGE_INTEGER),
        PDISK_WRITE_TIME_OFFSET
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        1404,
        0,
        1405,
        0,
        2,
        PERF_DETAIL_NOVICE,
        PERF_COUNTER_LARGE_QUEUELEN_TYPE,
        sizeof(LARGE_INTEGER),
        PDISK_WRITE_QUEUE_LENGTH_OFFSET
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        206,
        0,
        207,
        0,
        3,
        PERF_DETAIL_ADVANCED,
        PERF_AVERAGE_TIMER,
        sizeof(LARGE_INTEGER),
        PDISK_AVG_TIME_OFFSET
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        206,
        0,
        207,
        0,
        0,
        PERF_DETAIL_ADVANCED,
        PERF_AVERAGE_BASE,
        sizeof(DWORD),
        PDISK_TRANSFERS_BASE_1_OFFSET
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        208,
        0,
        209,
        0,
        3,
        PERF_DETAIL_ADVANCED,
        PERF_AVERAGE_TIMER,
        sizeof(LARGE_INTEGER),
        PDISK_AVG_READ_TIME_OFFSET
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        208,
        0,
        209,
        0,
        0,
        PERF_DETAIL_ADVANCED,
        PERF_AVERAGE_BASE,
        sizeof(DWORD),
        PDISK_READS_BASE_1_OFFSET
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        210,
        0,
        211,
        0,
        3,
        PERF_DETAIL_ADVANCED,
        PERF_AVERAGE_TIMER,
        sizeof(LARGE_INTEGER),
        PDISK_AVG_WRITE_TIME_OFFSET
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        210,
        0,
        211,
        0,
        0,
        PERF_DETAIL_ADVANCED,
        PERF_AVERAGE_BASE,
        sizeof(DWORD),
        PDISK_WRITES_BASE_1_OFFSET
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        212,
        0,
        213,
        0,
        0,
        PERF_DETAIL_NOVICE,
        PERF_COUNTER_COUNTER,
        sizeof(DWORD),
        PDISK_TRANSFERS_OFFSET
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        214,
        0,
        215,
        0,
        0,
        PERF_DETAIL_NOVICE,
        PERF_COUNTER_COUNTER,
        sizeof(DWORD),
        PDISK_READS_OFFSET
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        216,
        0,
        217,
        0,
        0,
        PERF_DETAIL_NOVICE,
        PERF_COUNTER_COUNTER,
        sizeof(DWORD),
        PDISK_WRITES_OFFSET
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        218,
        0,
        219,
        0,
        -4,
        PERF_DETAIL_ADVANCED,
        PERF_COUNTER_BULK_COUNT,
        sizeof(LARGE_INTEGER),
        PDISK_BYTES_OFFSET
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        220,
        0,
        221,
        0,
        -4,
        PERF_DETAIL_ADVANCED,
        PERF_COUNTER_BULK_COUNT,
        sizeof(LARGE_INTEGER),
        PDISK_READ_BYTES_OFFSET
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        222,
        0,
        223,
        0,
        -4,
        PERF_DETAIL_ADVANCED,
        PERF_COUNTER_BULK_COUNT,
        sizeof(LARGE_INTEGER),
        PDISK_WRITE_BYTES_OFFSET
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        224,
        0,
        225,
        0,
        -2,
        PERF_DETAIL_EXPERT,
        PERF_AVERAGE_BULK,
        sizeof(LARGE_INTEGER),
        PDISK_AVG_BYTES_OFFSET
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        224,
        0,
        225,
        0,
        0,
        PERF_DETAIL_EXPERT,
        PERF_AVERAGE_BASE,
        sizeof(DWORD),
        PDISK_TRANSFERS_BASE_2_OFFSET
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        226,
        0,
        227,
        0,
        -2,
        PERF_DETAIL_EXPERT,
        PERF_AVERAGE_BULK,
        sizeof(LARGE_INTEGER),
        PDISK_AVG_READ_BYTES_OFFSET
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        226,
        0,
        227,
        0,
        0,
        PERF_DETAIL_EXPERT,
        PERF_AVERAGE_BASE,
        sizeof(DWORD),
        PDISK_READS_BASE_2_OFFSET
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        228,
        0,
        229,
        0,
        -2,
        PERF_DETAIL_EXPERT,
        PERF_AVERAGE_BULK,
        sizeof(LARGE_INTEGER),
        PDISK_AVG_WRITE_BYTES_OFFSET
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        228,
        0,
        229,
        0,
        0,
        PERF_DETAIL_EXPERT,
        PERF_AVERAGE_BASE,
        sizeof(DWORD),
        PDISK_WRITES_BASE_2_OFFSET
    }
};


LDISK_DATA_DEFINITION LogicalDiskDataDefinition = {

    {   0,
        sizeof(LDISK_DATA_DEFINITION),
        sizeof(PERF_OBJECT_TYPE),
        LOGICAL_DISK_OBJECT_TITLE_INDEX,
        0,
        237,
        0,
        PERF_DETAIL_NOVICE,
        (sizeof(LDISK_DATA_DEFINITION)-sizeof(PERF_OBJECT_TYPE))/
        sizeof(PERF_COUNTER_DEFINITION),
        5,
        0,
        UNICODE_CODE_PAGE,
        {0L,0L},
        {0L,0L}        
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        408,
        0,
        409,
        0,
        0,
        PERF_DETAIL_NOVICE,
        PERF_RAW_FRACTION,
        sizeof(DWORD),
        LDISK_FREE_MBYTES_1_OFFSET
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        408,
        0,
        409,
        0,
        0,
        PERF_DETAIL_NOVICE,
        PERF_RAW_BASE,
        sizeof(DWORD),
        LDISK_TOTAL_MBYTES_OFFSET
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        410,
        0,
        411,
        0,
        0,
        PERF_DETAIL_NOVICE,
        PERF_COUNTER_RAWCOUNT,
        sizeof(DWORD),
        LDISK_FREE_MBYTES_2_OFFSET
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        198,
        0,
        199,
        0,
        1,
        PERF_DETAIL_NOVICE,
        PERF_COUNTER_RAWCOUNT,
        sizeof(DWORD),
        LDISK_QUEUE_LENGTH_OFFSET
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        200,
        0,
        201,
        0,
        0,
        PERF_DETAIL_NOVICE,
        PERF_COUNTER_TIMER,
        sizeof(LARGE_INTEGER),
        LDISK_TIME_OFFSET
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        1400,
        0,
        1401,
        0,
        2,
        PERF_DETAIL_NOVICE,
        PERF_COUNTER_LARGE_QUEUELEN_TYPE,
        sizeof(LARGE_INTEGER),
        LDISK_AVG_QUEUE_LENGTH_OFFSET
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        202,
        0,
        203,
        0,
        0,
        PERF_DETAIL_NOVICE,
        PERF_COUNTER_TIMER,
        sizeof(LARGE_INTEGER),
        LDISK_READ_TIME_OFFSET
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        1402,
        0,
        1403,
        0,
        2,
        PERF_DETAIL_NOVICE,
        PERF_COUNTER_LARGE_QUEUELEN_TYPE,
        sizeof(LARGE_INTEGER),
        LDISK_READ_QUEUE_LENGTH_OFFSET
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        204,
        0,
        205,
        0,
        0,
        PERF_DETAIL_NOVICE,
        PERF_COUNTER_TIMER,
        sizeof(LARGE_INTEGER),
        LDISK_WRITE_TIME_OFFSET
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        1404,
        0,
        1405,
        0,
        2,
        PERF_DETAIL_NOVICE,
        PERF_COUNTER_LARGE_QUEUELEN_TYPE,
        sizeof(LARGE_INTEGER),
        LDISK_WRITE_QUEUE_LENGTH_OFFSET
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        206,
        0,
        207,
        0,
        3,
        PERF_DETAIL_ADVANCED,
        PERF_AVERAGE_TIMER,
        sizeof(LARGE_INTEGER),
        LDISK_AVG_TIME_OFFSET
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        206,
        0,
        207,
        0,
        0,
        PERF_DETAIL_ADVANCED,
        PERF_AVERAGE_BASE,
        sizeof(DWORD),
        LDISK_TRANSFERS_BASE_1_OFFSET
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        208,
        0,
        209,
        0,
        3,
        PERF_DETAIL_ADVANCED,
        PERF_AVERAGE_TIMER,
        sizeof(LARGE_INTEGER),
        LDISK_AVG_READ_TIME_OFFSET
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        208,
        0,
        209,
        0,
        0,
        PERF_DETAIL_ADVANCED,
        PERF_AVERAGE_BASE,
        sizeof(DWORD),
        LDISK_READS_BASE_1_OFFSET
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        210,
        0,
        211,
        0,
        3,
        PERF_DETAIL_ADVANCED,
        PERF_AVERAGE_TIMER,
        sizeof(LARGE_INTEGER),
        LDISK_AVG_WRITE_TIME_OFFSET
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        210,
        0,
        211,
        0,
        0,
        PERF_DETAIL_ADVANCED,
        PERF_AVERAGE_BASE,
        sizeof(DWORD),
        LDISK_WRITES_BASE_1_OFFSET
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        212,
        0,
        213,
        0,
        0,
        PERF_DETAIL_NOVICE,
        PERF_COUNTER_COUNTER,
        sizeof(DWORD),
        LDISK_TRANSFERS_OFFSET
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        214,
        0,
        215,
        0,
        0,
        PERF_DETAIL_NOVICE,
        PERF_COUNTER_COUNTER,
        sizeof(DWORD),
        LDISK_READS_OFFSET
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        216,
        0,
        217,
        0,
        0,
        PERF_DETAIL_NOVICE,
        PERF_COUNTER_COUNTER,
        sizeof(DWORD),
        LDISK_WRITES_OFFSET
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        218,
        0,
        219,
        0,
        -4,
        PERF_DETAIL_ADVANCED,
        PERF_COUNTER_BULK_COUNT,
        sizeof(LARGE_INTEGER),
        LDISK_BYTES_OFFSET
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        220,
        0,
        221,
        0,
        -4,
        PERF_DETAIL_ADVANCED,
        PERF_COUNTER_BULK_COUNT,
        sizeof(LARGE_INTEGER),
        LDISK_READ_BYTES_OFFSET
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        222,
        0,
        223,
        0,
        -4,
        PERF_DETAIL_ADVANCED,
        PERF_COUNTER_BULK_COUNT,
        sizeof(LARGE_INTEGER),
        LDISK_WRITE_BYTES_OFFSET
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        224,
        0,
        225,
        0,
        -2,
        PERF_DETAIL_EXPERT,
        PERF_AVERAGE_BULK,
        sizeof(LARGE_INTEGER),
        LDISK_AVG_BYTES_OFFSET
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        224,
        0,
        225,
        0,
        0,
        PERF_DETAIL_EXPERT,
        PERF_AVERAGE_BASE,
        sizeof(DWORD),
        LDISK_TRANSFERS_BASE_2_OFFSET
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        226,
        0,
        227,
        0,
        -2,
        PERF_DETAIL_EXPERT,
        PERF_AVERAGE_BULK,
        sizeof(LARGE_INTEGER),
        LDISK_AVG_READ_BYTES_OFFSET
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        226,
        0,
        227,
        0,
        0,
        PERF_DETAIL_EXPERT,
        PERF_AVERAGE_BASE,
        sizeof(DWORD),
        LDISK_READS_BASE_2_OFFSET
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        228,
        0,
        229,
        0,
        -2,
        PERF_DETAIL_EXPERT,
        PERF_AVERAGE_BULK,
        sizeof(LARGE_INTEGER),
        LDISK_AVG_WRITE_BYTES_OFFSET
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        228,
        0,
        229,
        0,
        0,
        PERF_DETAIL_EXPERT,
        PERF_AVERAGE_BASE,
        sizeof(DWORD),
        LDISK_WRITES_BASE_2_OFFSET
    }
};


OBJECTS_DATA_DEFINITION ObjectsDataDefinition = {

    {   sizeof(OBJECTS_DATA_DEFINITION) + SIZE_OF_OBJECTS_DATA,
        sizeof(OBJECTS_DATA_DEFINITION),
        sizeof(PERF_OBJECT_TYPE),
        OBJECT_OBJECT_TITLE_INDEX,
        0,
        261,
        0,
        PERF_DETAIL_NOVICE,
        (sizeof(OBJECTS_DATA_DEFINITION)-sizeof(PERF_OBJECT_TYPE))/
        sizeof(PERF_COUNTER_DEFINITION),
        0,
        -1,
        UNICODE_CODE_PAGE,
        {0L,0L},
        {0L,0L}        
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        248,
        0,
        249,
        0,
        0,
        PERF_DETAIL_NOVICE,
        PERF_COUNTER_RAWCOUNT,
        sizeof(DWORD),
        PROCESSES_OFFSET
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        250,
        0,
        251,
        0,
        -1,
        PERF_DETAIL_NOVICE,
        PERF_COUNTER_RAWCOUNT,
        sizeof(DWORD),
        THREADS_OFFSET
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        252,
        0,
        253,
        0,
        -1,
        PERF_DETAIL_EXPERT,
        PERF_COUNTER_RAWCOUNT,
        sizeof(DWORD),
        EVENTS_OFFSET
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        254,
        0,
        255,
        0,
        -1,
        PERF_DETAIL_EXPERT,
        PERF_COUNTER_RAWCOUNT,
        sizeof(DWORD),
        SEMAPHORES_OFFSET
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        256,
        0,
        257,
        0,
        0,
        PERF_DETAIL_EXPERT,
        PERF_COUNTER_RAWCOUNT,
        sizeof(DWORD),
        MUTEXES_OFFSET
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        258,
        0,
        259,
        0,
        -1,
        PERF_DETAIL_EXPERT,
        PERF_COUNTER_RAWCOUNT,
        sizeof(DWORD),
        SECTIONS_OFFSET
    }
};



RDR_DATA_DEFINITION RdrDataDefinition = {

    {   sizeof(RDR_DATA_DEFINITION) + SIZE_OF_RDR_DATA,
        sizeof(RDR_DATA_DEFINITION),
        sizeof(PERF_OBJECT_TYPE),
        REDIRECTOR_OBJECT_TITLE_INDEX,
        0,
        263,
        0,
        PERF_DETAIL_NOVICE,
        (sizeof(RDR_DATA_DEFINITION)-sizeof(PERF_OBJECT_TYPE))/
        sizeof(PERF_COUNTER_DEFINITION),
        0,
        -1,
        UNICODE_CODE_PAGE,
        {0L,0L},
        {0L,0L}        
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        388,
        0,
        389,
        0,
        -4,
        PERF_DETAIL_NOVICE,
        PERF_COUNTER_BULK_COUNT,
        sizeof(LARGE_INTEGER),
        BYTES_OFFSET
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        406,
        0,
        391,
        0,
        0,
        PERF_DETAIL_NOVICE,
        PERF_COUNTER_COUNTER,
        sizeof(DWORD),
        IO_OPERATIONS_OFFSET
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        400,
        0,
        401,
        0,
        -1,
        PERF_DETAIL_NOVICE,
        PERF_COUNTER_BULK_COUNT,
        sizeof(LARGE_INTEGER),
        PACKETS_OFFSET
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        264,
        0,
        265,
        0,
        -4,
        PERF_DETAIL_ADVANCED,
        PERF_COUNTER_BULK_COUNT,
        sizeof(LARGE_INTEGER),
        BYTES_RECEIVED_OFFSET
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        266,
        0,
        267,
        0,
        -1,
        PERF_DETAIL_ADVANCED,
        PERF_COUNTER_BULK_COUNT,
        sizeof(LARGE_INTEGER),
        SMBS_RECEIVED_OFFSET
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        268,
        0,
        269,
        0,
        -4,
        PERF_DETAIL_EXPERT,
        PERF_COUNTER_BULK_COUNT,
        sizeof(LARGE_INTEGER),
        PAGING_READ_BYTES_REQUESTED_OFFSET
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        270,
        0,
        271,
        0,
        -4,
        PERF_DETAIL_EXPERT,
        PERF_COUNTER_BULK_COUNT,
        sizeof(LARGE_INTEGER),
        NONPAGING_READ_BYTES_REQUESTED_OFFSET
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        272,
        0,
        273,
        0,
        -4,
        PERF_DETAIL_EXPERT,
        PERF_COUNTER_BULK_COUNT,
        sizeof(LARGE_INTEGER),
        CACHE_READ_BYTES_REQUESTED_OFFSET
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        274,
        0,
        275,
        0,
        -4,
        PERF_DETAIL_NOVICE,
        PERF_COUNTER_BULK_COUNT,
        sizeof(LARGE_INTEGER),
        NETWORK_READ_BYTES_REQUESTED_OFFSET
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        276,
        0,
        277,
        0,
        -4,
        PERF_DETAIL_ADVANCED,
        PERF_COUNTER_BULK_COUNT,
        sizeof(LARGE_INTEGER),
        BYTES_TRANSMITTED_OFFSET
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        278,
        0,
        279,
        0,
        -1,
        PERF_DETAIL_ADVANCED,
        PERF_COUNTER_BULK_COUNT,
        sizeof(LARGE_INTEGER),
        SMBS_TRANSMITTED_OFFSET
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        280,
        0,
        281,
        0,
        -4,
        PERF_DETAIL_EXPERT,
        PERF_COUNTER_BULK_COUNT,
        sizeof(LARGE_INTEGER),
        PAGING_WRITE_BYTES_REQUESTED_OFFSET
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        282,
        0,
        283,
        0,
        -4,
        PERF_DETAIL_EXPERT,
        PERF_COUNTER_BULK_COUNT,
        sizeof(LARGE_INTEGER),
        NONPAGING_WRITE_BYTES_REQUESTED_OFFSET
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        284,
        0,
        285,
        0,
        -4,
        PERF_DETAIL_EXPERT,
        PERF_COUNTER_BULK_COUNT,
        sizeof(LARGE_INTEGER),
        CACHE_WRITE_BYTES_REQUESTED_OFFSET
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        286,
        0,
        287,
        0,
        -4,
        PERF_DETAIL_NOVICE,
        PERF_COUNTER_BULK_COUNT,
        sizeof(LARGE_INTEGER),
        NETWORK_WRITE_BYTES_REQUESTED_OFFSET
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        10,
        0,
        289,
        0,
        0,
        PERF_DETAIL_NOVICE,
        PERF_COUNTER_COUNTER,
        sizeof(DWORD),
        RDR_READ_OPERATIONS_OFFSET
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        290,
        0,
        291,
        0,
        -1,
        PERF_DETAIL_ADVANCED,
        PERF_COUNTER_COUNTER,
        sizeof(DWORD),
        RANDOM_READ_OPERATIONS_OFFSET
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        292,
        0,
        293,
        0,
        -1,
        PERF_DETAIL_ADVANCED,
        PERF_COUNTER_COUNTER,
        sizeof(DWORD),
        READ_SMBS_OFFSET
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        294,
        0,
        295,
        0,
        0,
        PERF_DETAIL_EXPERT,
        PERF_COUNTER_COUNTER,
        sizeof(DWORD),
        LARGE_READ_SMBS_OFFSET
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        296,
        0,
        297,
        0,
        -1,
        PERF_DETAIL_EXPERT,
        PERF_COUNTER_COUNTER,
        sizeof(DWORD),
        SMALL_READ_SMBS_OFFSET
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        12,
        0,
        299,
        0,
        0,
        PERF_DETAIL_NOVICE,
        PERF_COUNTER_COUNTER,
        sizeof(DWORD),
        RDR_WRITE_OPERATIONS_OFFSET
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        300,
        0,
        301,
        0,
        -1,
        PERF_DETAIL_ADVANCED,
        PERF_COUNTER_COUNTER,
        sizeof(DWORD),
        RANDOM_WRITE_OPERATIONS_OFFSET
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        302,
        0,
        303,
        0,
        -1,
        PERF_DETAIL_ADVANCED,
        PERF_COUNTER_COUNTER,
        sizeof(DWORD),
        WRITE_SMBS_OFFSET
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        304,
        0,
        305,
        0,
        0,
        PERF_DETAIL_EXPERT,
        PERF_COUNTER_COUNTER,
        sizeof(DWORD),
        LARGE_WRITE_SMBS_OFFSET
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        306,
        0,
        307,
        0,
        -1,
        PERF_DETAIL_EXPERT,
        PERF_COUNTER_COUNTER,
        sizeof(DWORD),
        SMALL_WRITE_SMBS_OFFSET
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        308,
        0,
        309,
        0,
        0,
        PERF_DETAIL_ADVANCED,
        PERF_COUNTER_COUNTER,
        sizeof(DWORD),
        RAW_READS_DENIED_OFFSET
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        310,
        0,
        311,
        0,
        0,
        PERF_DETAIL_ADVANCED,
        PERF_COUNTER_COUNTER,
        sizeof(DWORD),
        RAW_WRITES_DENIED_OFFSET
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        312,
        0,
        313,
        0,
        0,
        PERF_DETAIL_NOVICE,
        PERF_COUNTER_COUNTER,
        sizeof(DWORD),
        NETWORK_ERRORS_OFFSET
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        314,
        0,
        315,
        0,
        0,
        PERF_DETAIL_NOVICE,
        PERF_COUNTER_RAWCOUNT,
        sizeof(DWORD),
        SESSIONS_OFFSET
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        316,
        0,
        317,
        0,
        0,
        PERF_DETAIL_ADVANCED,
        PERF_COUNTER_RAWCOUNT,
        sizeof(DWORD),
        RECONNECTS_OFFSET
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        318,
        0,
        319,
        0,
        0,
        PERF_DETAIL_ADVANCED,
        PERF_COUNTER_RAWCOUNT,
        sizeof(DWORD),
        CORE_CONNECTS_OFFSET
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        320,
        0,
        321,
        0,
        0,
        PERF_DETAIL_ADVANCED,
        PERF_COUNTER_RAWCOUNT,
        sizeof(DWORD),
        LANMAN_20_CONNECTS_OFFSET
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        322,
        0,
        323,
        0,
        0,
        PERF_DETAIL_ADVANCED,
        PERF_COUNTER_RAWCOUNT,
        sizeof(DWORD),
        LANMAN_21_CONNECTS_OFFSET
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        324,
        0,
        325,
        0,
        0,
        PERF_DETAIL_ADVANCED,
        PERF_COUNTER_RAWCOUNT,
        sizeof(DWORD),
        LANMAN_NT_CONNECTS_OFFSET
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        326,
        0,
        327,
        0,
        0,
        PERF_DETAIL_ADVANCED,
        PERF_COUNTER_RAWCOUNT,
        sizeof(DWORD),
        SERVER_DISCONNECTS_OFFSET
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        328,
        0,
        329,
        0,
        0,
        PERF_DETAIL_ADVANCED,
        PERF_COUNTER_RAWCOUNT,
        sizeof(DWORD),
        HUNG_SESSIONS_OFFSET
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        392,
        0,
        393,
        0,
        0,
        PERF_DETAIL_ADVANCED,
        PERF_COUNTER_RAWCOUNT,
        sizeof(DWORD),
        CURRENT_COMMANDS_OFFSET
    }
};


SRV_DATA_DEFINITION SrvDataDefinition = {

    {   sizeof(SRV_DATA_DEFINITION) + SIZE_OF_SRV_DATA,
        sizeof(SRV_DATA_DEFINITION),
        sizeof(PERF_OBJECT_TYPE),
        SERVER_OBJECT_TITLE_INDEX,
        0,
        331,
        0,
        PERF_DETAIL_NOVICE,
        (sizeof(SRV_DATA_DEFINITION)-sizeof(PERF_OBJECT_TYPE))/
        sizeof(PERF_COUNTER_DEFINITION),
        0,
        -1,
        UNICODE_CODE_PAGE,
        {0L,0L},
        {0L,0L}        
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        388,
        0,
        395,
        0,
        -4,
        PERF_DETAIL_NOVICE,
        PERF_COUNTER_BULK_COUNT,
        sizeof(LARGE_INTEGER),
        TOTAL_BYTES_OFFSET
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        264,
        0,
        333,
        0,
        -4,
        PERF_DETAIL_ADVANCED,
        PERF_COUNTER_BULK_COUNT,
        sizeof(LARGE_INTEGER),
        TOTAL_BYTES_RECEIVED_OFFSET
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        276,
        0,
        335,
        0,
        -4,
        PERF_DETAIL_ADVANCED,
        PERF_COUNTER_BULK_COUNT,
        sizeof(LARGE_INTEGER),
        TOTAL_BYTES_SENT_OFFSET
    },               
    {   sizeof(PERF_COUNTER_DEFINITION),
        340,
        0,
        341,
        0,
        0,
        PERF_DETAIL_ADVANCED,
        PERF_COUNTER_RAWCOUNT,
        sizeof(DWORD),
        SESSIONS_TIMED_OUT_OFFSET
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        342,
        0,
        343,
        0,
        0,
        PERF_DETAIL_ADVANCED,
        PERF_COUNTER_RAWCOUNT,
        sizeof(DWORD),
        SESSIONS_ERRORED_OUT_OFFSET
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        344,
        0,
        345,
        0,
        0,
        PERF_DETAIL_ADVANCED,
        PERF_COUNTER_RAWCOUNT,
        sizeof(DWORD),
        SESSIONS_LOGGED_OFF_OFFSET
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        346,
        0,
        347,
        0,
        0,
        PERF_DETAIL_ADVANCED,
        PERF_COUNTER_RAWCOUNT,
        sizeof(DWORD),
        SESSIONS_FORCED_LOG_OFF_OFFSET
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        348,
        0,
        349,
        0,
        0,
        PERF_DETAIL_ADVANCED,
        PERF_COUNTER_RAWCOUNT,
        sizeof(DWORD),
        LOGON_ERRORS_OFFSET
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        350,
        0,
        351,
        0,
        0,
        PERF_DETAIL_NOVICE,
        PERF_COUNTER_RAWCOUNT,
        sizeof(DWORD),
        ACCESS_PERMISSION_ERRORS_OFFSET
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        352,
        0,
        353,
        0,
        0,
        PERF_DETAIL_ADVANCED,
        PERF_COUNTER_RAWCOUNT,
        sizeof(DWORD),
        GRANTED_ACCESS_ERRORS_OFFSET
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        354,
        0,
        355,
        0,
        0,
        PERF_DETAIL_EXPERT,
        PERF_COUNTER_RAWCOUNT,
        sizeof(DWORD),
        SYSTEM_ERRORS_OFFSET
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        356,
        0,
        357,
        0,
        0,
        PERF_DETAIL_ADVANCED,
        PERF_COUNTER_COUNTER,
        sizeof(DWORD),
        BLOCKING_SMBS_REJECTED_OFFSET
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        358,
        0,
        359,
        0,
        0,
        PERF_DETAIL_ADVANCED,
        PERF_COUNTER_COUNTER,
        sizeof(DWORD),
        WORK_ITEM_SHORTAGES_OFFSET
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        360,
        0,
        361,
        0,
        -3,
        PERF_DETAIL_NOVICE,
        PERF_COUNTER_RAWCOUNT,
        sizeof(DWORD),
        TOTAL_FILES_OPENED_OFFSET
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        362,
        0,
        363,
        0,
        0,
        PERF_DETAIL_NOVICE,
        PERF_COUNTER_RAWCOUNT,
        sizeof(DWORD),
        CURRENT_OPEN_FILES_OFFSET
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        314,
        0,
        365,
        0,
        0,
        PERF_DETAIL_NOVICE,
        PERF_COUNTER_RAWCOUNT,
        sizeof(DWORD),
        CURRENT_SESSIONS_OFFSET
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        366,
        0,
        367,
        0,
        0,
        PERF_DETAIL_ADVANCED,
        PERF_COUNTER_RAWCOUNT,
        sizeof(DWORD),
        CURRENT_OPEN_SEARCHES_OFFSET
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        58,
        0,
        369,
        0,
        -4,
        PERF_DETAIL_EXPERT,
        PERF_COUNTER_RAWCOUNT,
        sizeof(DWORD),
        CURRENT_NONPAGED_POOL_USAGE_OFFSET
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        370,
        0,
        371,
        0,
        0,
        PERF_DETAIL_WIZARD,
        PERF_COUNTER_COUNTER,
        sizeof(DWORD),
        NONPAGED_POOL_FAILURES_OFFSET
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        372,
        0,
        373,
        0,
        -4,
        PERF_DETAIL_EXPERT,
        PERF_COUNTER_RAWCOUNT,
        sizeof(DWORD),
        PEAK_NONPAGED_POOL_USAGE_OFFSET
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        56,
        0,
        375,
        0,
        -4,
        PERF_DETAIL_EXPERT,
        PERF_COUNTER_RAWCOUNT,
        sizeof(DWORD),
        CURRENT_PAGED_POOL_USAGE_OFFSET
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        376,
        0,
        377,
        0,
        0,
        PERF_DETAIL_WIZARD,
        PERF_COUNTER_RAWCOUNT,
        sizeof(DWORD),
        PAGED_POOL_FAILURES_OFFSET
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        378,
        0,
        379,
        0,
        -4,
        PERF_DETAIL_ADVANCED,
        PERF_COUNTER_RAWCOUNT,
        sizeof(DWORD),
        PEAK_PAGED_POOL_USAGE_OFFSET
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        404,
        0,
        405,
        0,
        -1,
        PERF_DETAIL_NOVICE,
        PERF_COUNTER_COUNTER,
        sizeof(DWORD),
        CONTEXT_BLOCK_QUEUE_RATE_OFFSET
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        692,
        0,
        693,
        0,
        1,
        PERF_DETAIL_NOVICE,
        PERF_COUNTER_COUNTER,
        sizeof(DWORD),
        NETLOGON_OFFSET
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        1260,
        0,
        1261,
        0,
        1,
        PERF_DETAIL_NOVICE,
        PERF_COUNTER_RAWCOUNT,
        sizeof(DWORD),
        NETLOGONTOTAL_OFFSET
    }
};

SRVQ_DATA_DEFINITION SrvQDataDefinition = {
    {
        sizeof(SRVQ_DATA_DEFINITION) + SIZE_OF_SRVQ_DATA,
        sizeof(SRVQ_DATA_DEFINITION),
        sizeof(PERF_OBJECT_TYPE),
        SERVER_QUEUE_OBJECT_TITLE_INDEX,
        0,
        1301,
        0,
        PERF_DETAIL_ADVANCED,
        (sizeof(SRVQ_DATA_DEFINITION)-sizeof(PERF_OBJECT_TYPE))/
          sizeof(PERF_COUNTER_DEFINITION),
        0,
        0,
        UNICODE_CODE_PAGE,
        {0L,0L},
        {0L,0L}        
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        1302,
        0,
        1303,
        0,
        0,
        PERF_DETAIL_ADVANCED,
        PERF_COUNTER_RAWCOUNT,
        sizeof(DWORD),
        SRVQ_QUEUE_LENGTH_OFFSET
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        1304,
        0,
        1305,
        0,
        0,
        PERF_DETAIL_ADVANCED,
        PERF_COUNTER_RAWCOUNT,
        sizeof(DWORD),
        SRVQ_ACTIVE_THREADS_OFFSET
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        1306,
        0,
        1307,
        0,
        0,
        PERF_DETAIL_ADVANCED,
        PERF_COUNTER_RAWCOUNT,
        sizeof(DWORD),
        SRVQ_AVAILABLE_THREADS_OFFSET
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        1308,
        0,
        1309,
        0,
        0,
        PERF_DETAIL_ADVANCED,
        PERF_COUNTER_RAWCOUNT,
        sizeof(DWORD),
        SRVQ_FREE_WORK_ITEMS_OFFSET
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        1310,
        0,
        1311,
        0,
        0,
        PERF_DETAIL_ADVANCED,
        PERF_COUNTER_RAWCOUNT,
        sizeof(DWORD),
        SRVQ_STOLEN_WORK_ITEMS_OFFSET
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        1312,
        0,
        1313,
        0,
        0,
        PERF_DETAIL_ADVANCED,
        PERF_COUNTER_RAWCOUNT,
        sizeof(DWORD),
        SRVQ_NEED_WORK_ITEM_OFFSET
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        1314,
        0,
        1315,
        0,
        0,
        PERF_DETAIL_ADVANCED,
        PERF_COUNTER_RAWCOUNT,
        sizeof(DWORD),
        SRVQ_CURRENT_CLIENTS_OFFSET
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        264,
        0,
        1317,
        0,
        -4,
        PERF_DETAIL_ADVANCED,
        PERF_COUNTER_BULK_COUNT,
        sizeof(LARGE_INTEGER),
        SRVQ_BYTES_RECEIVED_OFFSET
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        506,
        0,
        1319,
        0,
        -4,
        PERF_DETAIL_ADVANCED,
        PERF_COUNTER_BULK_COUNT,
        sizeof(LARGE_INTEGER),
        SRVQ_BYTES_SENT_OFFSET
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        1320,
        0,
        1321,
        0,
        -4,
        PERF_DETAIL_ADVANCED,
        PERF_COUNTER_BULK_COUNT,
        sizeof(LARGE_INTEGER),
        SRVQ_TOTAL_BYTES_TRANSFERED_OFFSET
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        288,
        0,
        1323,
        0,
        0,
        PERF_DETAIL_ADVANCED,
        PERF_COUNTER_BULK_COUNT,
        sizeof(LARGE_INTEGER),
        SRVQ_READ_OPERATIONS_OFFSET
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        1324,
        0,
        1325,
        0,
        -4,
        PERF_DETAIL_ADVANCED,
        PERF_COUNTER_BULK_COUNT,
        sizeof(LARGE_INTEGER),
        SRVQ_BYTES_READ_OFFSET
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        298,
        0,
        1327,
        0,
        0,
        PERF_DETAIL_ADVANCED,
        PERF_COUNTER_BULK_COUNT,
        sizeof(LARGE_INTEGER),
        SRVQ_WRITE_OPERATIONS_OFFSET
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        1328,
        0,
        1329,
        0,
        -4,
        PERF_DETAIL_ADVANCED,
        PERF_COUNTER_BULK_COUNT,
        sizeof(LARGE_INTEGER),
        SRVQ_BYTES_WRITTEN_OFFSET
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        508,
        0,
        1331,
        0,
        -4,
        PERF_DETAIL_ADVANCED,
        PERF_COUNTER_BULK_COUNT,
        sizeof(LARGE_INTEGER),
        SRVQ_TOTAL_BYTES_OFFSET
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        1332,
        0,
        1333,
        0,
        0,
        PERF_DETAIL_ADVANCED,
        PERF_COUNTER_BULK_COUNT,
        sizeof(LARGE_INTEGER),
        SRVQ_TOTAL_OPERATIONS_OFFSET
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        404,
        0,
        405,
        0,
        0,
        PERF_DETAIL_ADVANCED,
        PERF_COUNTER_COUNTER,
        sizeof(DWORD),
        SRVQ_CONTEXT_BLOCK_QUEUED_COUNT_OFFSET
    }
};

PAGEFILE_DATA_DEFINITION  PagefileDataDefinition = {
    {   sizeof (PAGEFILE_DATA_DEFINITION) +  SIZE_OF_PAGEFILE_DATA,
        sizeof (PAGEFILE_DATA_DEFINITION),
        sizeof (PERF_OBJECT_TYPE),
        PAGEFILE_OBJECT_TITLE_INDEX,
        0,
        701,
        0,
        PERF_DETAIL_ADVANCED,
        (sizeof(PAGEFILE_DATA_DEFINITION) - sizeof (PERF_OBJECT_TYPE))/
        sizeof(PERF_COUNTER_DEFINITION),
        0,
        0,
        UNICODE_CODE_PAGE,
        {0L,0L},
        {0L,0L}        
    },
    {   sizeof (PERF_COUNTER_DEFINITION),
        702,
        0,
        703,
        0,
        0,
        PERF_DETAIL_ADVANCED,
        PERF_RAW_FRACTION,
        sizeof (DWORD),
        PAGEFILE_INUSE_OFFSET
    },
    {   sizeof (PERF_COUNTER_DEFINITION),
        702,
        0,
        703,
        0,
        0,
        PERF_DETAIL_ADVANCED,
        PERF_RAW_BASE,
        sizeof (DWORD),
        PAGEFILE_INUSE_BASE_OFFSET
    },
    {   sizeof (PERF_COUNTER_DEFINITION),
        704,
        0,
        705,
        0,
        0,
        PERF_DETAIL_ADVANCED,
        PERF_RAW_FRACTION,
        sizeof (DWORD),
        PAGEFILE_PEAK_OFFSET
    },
    {   sizeof (PERF_COUNTER_DEFINITION),
        704,
        0,
        705,
        0,
        0,
        PERF_DETAIL_ADVANCED,
        PERF_RAW_BASE,
        sizeof (DWORD),
        PAGEFILE_PEAK_BASE_OFFSET
    }
};

IMAGE_DATA_DEFINITION  ImageDataDefinition = {
    {   0,
        sizeof (IMAGE_DATA_DEFINITION),
        sizeof (PERF_OBJECT_TYPE),
        IMAGE_OBJECT_TITLE_INDEX,
        0,
        741,
        0,
        PERF_DETAIL_WIZARD,
        (sizeof(IMAGE_DATA_DEFINITION) - sizeof (PERF_OBJECT_TYPE))/
        sizeof(PERF_COUNTER_DEFINITION),
        0,
        0,
        UNICODE_CODE_PAGE,
        {0L,0L},
        {0L,0L}        
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        788,
        0,
        789,
        0,
        0,
        PERF_DETAIL_WIZARD,
        PERF_COUNTER_RAWCOUNT,
        sizeof(DWORD),
        IMAGE_ADDR_NOACCESS_OFFSET
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        790,
        0,
        791,
        0,
        0,
        PERF_DETAIL_WIZARD,
        PERF_COUNTER_RAWCOUNT,
        sizeof(DWORD),
        IMAGE_ADDR_READONLY_OFFSET
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        792,
        0,
        793,
        0,
        0,
        PERF_DETAIL_WIZARD,
        PERF_COUNTER_RAWCOUNT,
        sizeof(DWORD),
        IMAGE_ADDR_READWRITE_OFFSET
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        794,
        0,
        795,
        0,
        0,
        PERF_DETAIL_WIZARD,
        PERF_COUNTER_RAWCOUNT,
        sizeof(DWORD),
        IMAGE_ADDR_WRITECOPY_OFFSET
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        796,
        0,
        797,
        0,
        0,
        PERF_DETAIL_WIZARD,
        PERF_COUNTER_RAWCOUNT,
        sizeof(DWORD),
        IMAGE_ADDR_EXECUTE_OFFSET
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        798,
        0,
        799,
        0,
        0,
        PERF_DETAIL_WIZARD,
        PERF_COUNTER_RAWCOUNT,
        sizeof(DWORD),
        IMAGE_ADDR_EXECUTE_READ_OFFSET
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        800,
        0,
        801,
        0,
        0,
        PERF_DETAIL_WIZARD,
        PERF_COUNTER_RAWCOUNT,
        sizeof(DWORD),
        IMAGE_ADDR_EXECUTE_READ_WRITE_OFFSET
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        802,
        0,
        803,
        0,
        0,
        PERF_DETAIL_WIZARD,
        PERF_COUNTER_RAWCOUNT,
        sizeof(DWORD),
        IMAGE_ADDR_EXECUTE_WRITE_COPY_OFFSET
    }
};

EXPROCESS_DATA_DEFINITION ExProcessDataDefinition = {
    {   0,
        sizeof (EXPROCESS_DATA_DEFINITION),
        sizeof (PERF_OBJECT_TYPE),
        EXPROCESS_OBJECT_TITLE_INDEX,
        0,
        787,
        0,
        PERF_DETAIL_WIZARD,
        (sizeof(EXPROCESS_DATA_DEFINITION) - sizeof (PERF_OBJECT_TYPE))/
        sizeof(PERF_COUNTER_DEFINITION),
        0,
        0,
        UNICODE_CODE_PAGE,
        {0L,0L},
        {0L,0L}        
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        776,
        0,
        777,
        0,
        -4,
        PERF_DETAIL_WIZARD,
        PERF_COUNTER_RAWCOUNT,
        sizeof(DWORD),
        EX_PROCESS_IMAGE_RESERVED_BYTES_OFFSET
    },              
    {   sizeof(PERF_COUNTER_DEFINITION),
        784,
        0,
        785,
        0,
        0,
        PERF_DETAIL_WIZARD,
        PERF_COUNTER_RAWCOUNT,
        sizeof(DWORD),
        EX_PROCESS_PROCESS_ID_OFFSET
    },              
    {   sizeof(PERF_COUNTER_DEFINITION),
        778,
        0,
        779,
        0,
        -4,
        PERF_DETAIL_WIZARD,
        PERF_COUNTER_RAWCOUNT,
        sizeof(DWORD),
        EX_PROCESS_IMAGE_FREE_BYTES_OFFSET
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        780,
        0,                                 
        781,
        0,
        -4,
        PERF_DETAIL_WIZARD,
        PERF_COUNTER_RAWCOUNT,
        sizeof(DWORD),
        EX_PROCESS_RESERVED_BYTES_OFFSET
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        782,
        0,                               
        783,
        0,   
        -4,
        PERF_DETAIL_WIZARD,
        PERF_COUNTER_RAWCOUNT,
        sizeof(DWORD),
        EX_PROCESS_FREE_BYTES_OFFSET
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        710,
        0,                           
        711,
        0,
        -5,
        PERF_DETAIL_WIZARD,
        PERF_COUNTER_RAWCOUNT,
        sizeof(DWORD),
        EX_PROCESS_COMMIT_NO_ACCESS_OFFSET  
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        712,
        0,
        713,
        0,
        -5,
        PERF_DETAIL_WIZARD,
        PERF_COUNTER_RAWCOUNT,
        sizeof(DWORD),
        EX_PROCESS_COMMIT_READ_ONLY_OFFSET  
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        714,
        0,
        715,
        0,
        -5,
        PERF_DETAIL_WIZARD,
        PERF_COUNTER_RAWCOUNT,
        sizeof(DWORD),
        EX_PROCESS_COMMIT_READ_WRITE_OFFSET 
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        716,
        0,
        717,
        0,
        -5,
        PERF_DETAIL_WIZARD,
        PERF_COUNTER_RAWCOUNT,
        sizeof(DWORD),
        EX_PROCESS_COMMIT_WRITE_COPY_OFFSET 
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        718,
        0,
        719,
        0,
        -5,
        PERF_DETAIL_WIZARD,
        PERF_COUNTER_RAWCOUNT,
        sizeof(DWORD),
        EX_PROCESS_COMMIT_EXECUTE_OFFSET    
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        720,
        0,
        721,
        0,
        -5,
        PERF_DETAIL_WIZARD,
        PERF_COUNTER_RAWCOUNT,
        sizeof(DWORD),
        EX_PROCESS_COMMIT_EXECUTE_READ_OFFSET   
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        722,
        0,
        723,
        0,
        -5,
        PERF_DETAIL_WIZARD,
        PERF_COUNTER_RAWCOUNT,
        sizeof(DWORD),
        EX_PROCESS_COMMIT_EXECUTE_READ_WRITE_OFFSET 
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        724,
        0,
        725,
        0,
        -5,
        PERF_DETAIL_WIZARD,
        PERF_COUNTER_RAWCOUNT,
        sizeof(DWORD),
        EX_PROCESS_COMMIT_EXECUTE_WRITE_COPY_OFFSET 
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        726,
        0,
        727,
        0,
        -5,
        PERF_DETAIL_WIZARD,
        PERF_COUNTER_RAWCOUNT,
        sizeof(DWORD),
        EX_PROCESS_RESERVED_NO_ACCESS_OFFSET    
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        728,
        0,
        729,
        0,
        -5,
        PERF_DETAIL_WIZARD,
        PERF_COUNTER_RAWCOUNT,
        sizeof(DWORD),
        EX_PROCESS_RESERVED_READ_ONLY_OFFSET    
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        730,
        0,
        731,
        0,
        -5,
        PERF_DETAIL_WIZARD,
        PERF_COUNTER_RAWCOUNT,
        sizeof(DWORD),
        EX_PROCESS_RESERVED_READ_WRITE_OFFSET   
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        732,
        0,
        733,
        0,
        -5,
        PERF_DETAIL_WIZARD,
        PERF_COUNTER_RAWCOUNT,
        sizeof(DWORD),
        EX_PROCESS_RESERVED_WRITE_COPY_OFFSET       
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        734,
        0,
        735,
        0,
        -5,
        PERF_DETAIL_WIZARD,
        PERF_COUNTER_RAWCOUNT,
        sizeof(DWORD),
        EX_PROCESS_RESERVED_EXECUTE_OFFSET  
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        736,
        0,
        737,
        0,
        -5,
        PERF_DETAIL_WIZARD,
        PERF_COUNTER_RAWCOUNT,
        sizeof(DWORD),
        EX_PROCESS_RESERVED_EXECUTE_READ_OFFSET 
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        738,
        0,
        739,
        0,
        -5,
        PERF_DETAIL_WIZARD,
        PERF_COUNTER_RAWCOUNT,
        sizeof(DWORD),
        EX_PROCESS_RESERVED_EXECUTE_READ_WRITE_OFFSET   
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        742,
        0,
        743,
        0,
        -5,
        PERF_DETAIL_WIZARD,
        PERF_COUNTER_RAWCOUNT,
        sizeof(DWORD),
        EX_PROCESS_RESERVED_EXECUTE_WRITE_COPY_OFFSET   
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        744,
        0,
        745,
        0,
        -5,
        PERF_DETAIL_WIZARD,
        PERF_COUNTER_RAWCOUNT,
        sizeof(DWORD),
        EX_PROCESS_UNASSIGNED_NO_ACCESS_OFFSET  
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        746,
        0,
        747,
        0,
        -5,
        PERF_DETAIL_WIZARD,
        PERF_COUNTER_RAWCOUNT,
        sizeof(DWORD),
        EX_PROCESS_UNASSIGNED_READ_ONLY_OFFSET  
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        748,
        0,
        749,
        0,
        -5,
        PERF_DETAIL_WIZARD,
        PERF_COUNTER_RAWCOUNT,
        sizeof(DWORD),
        EX_PROCESS_UNASSIGNED_READ_WRITE_OFFSET 
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        750,
        0,
        751,
        0,
        -5,
        PERF_DETAIL_WIZARD,
        PERF_COUNTER_RAWCOUNT,
        sizeof(DWORD),
        EX_PROCESS_UNASSIGNED_WRITE_COPY_OFFSET 
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        752,
        0,
        753,
        0,
        -5,
        PERF_DETAIL_WIZARD,
        PERF_COUNTER_RAWCOUNT,
        sizeof(DWORD),
        EX_PROCESS_UNASSIGNED_EXECUTE_OFFSET    
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        754,
        0,
        755,
        0,
        -5,
        PERF_DETAIL_WIZARD,
        PERF_COUNTER_RAWCOUNT,
        sizeof(DWORD),
        EX_PROCESS_UNASSIGNED_EXECUTE_READ_OFFSET   
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        756,
        0,
        757,
        0,
        -5,
        PERF_DETAIL_WIZARD,
        PERF_COUNTER_RAWCOUNT,
        sizeof(DWORD),
        EX_PROCESS_UNASSIGNED_EXECUTE_READ_WRITE_OFFSET 
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        758,
        0,
        759,
        0,
        -5,
        PERF_DETAIL_WIZARD,
        PERF_COUNTER_RAWCOUNT,
        sizeof(DWORD),
        EX_PROCESS_UNASSIGNED_EXECUTE_WRITE_COPY_OFFSET 
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        760,
        0,
        761,
        0,
        -5,
        PERF_DETAIL_WIZARD,
        PERF_COUNTER_RAWCOUNT,
        sizeof(DWORD),
        EX_PROCESS_IMAGE_TOTAL_NO_ACCESS_OFFSET 
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        762,
        0,
        763,
        0,
        -5,
        PERF_DETAIL_WIZARD,
        PERF_COUNTER_RAWCOUNT,
        sizeof(DWORD),
        EX_PROCESS_IMAGE_TOTAL_READ_ONLY_OFFSET 
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        764,
        0,
        765,
        0,
        -5,
        PERF_DETAIL_WIZARD,
        PERF_COUNTER_RAWCOUNT,
        sizeof(DWORD),
        EX_PROCESS_IMAGE_TOTAL_READ_WRITE_OFFSET    
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        766,
        0,
        767,
        0,
        -5,
        PERF_DETAIL_WIZARD,
        PERF_COUNTER_RAWCOUNT,
        sizeof(DWORD),
        EX_PROCESS_IMAGE_TOTAL_WRITE_COPY_OFFSET    
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        768,
        0,
        769,
        0,
        -5,
        PERF_DETAIL_WIZARD,
        PERF_COUNTER_RAWCOUNT,
        sizeof(DWORD),
        EX_PROCESS_IMAGE_TOTAL_EXECUTE_OFFSET   
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        770,
        0,
        771,
        0,
        -5,
        PERF_DETAIL_WIZARD,
        PERF_COUNTER_RAWCOUNT,
        sizeof(DWORD),
        EX_PROCESS_IMAGE_TOTAL_EXECUTE_READ_OFFSET  
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        772,
        0,
        773,
        0,
        -5,
        PERF_DETAIL_WIZARD,
        PERF_COUNTER_RAWCOUNT,
        sizeof(DWORD),
        EX_PROCESS_IMAGE_TOTAL_EXECUTE_READ_WRITE_OFFSET    
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        774,
        0,
        775,
        0,
        -5,
        PERF_DETAIL_WIZARD,
        PERF_COUNTER_RAWCOUNT,
        sizeof(DWORD),
        EX_PROCESS_IMAGE_TOTAL_EXECUTE_WRITE_COPY_OFFSET    
    }

};

THREAD_DETAILS_DATA_DEFINITION ThreadDetailsDataDefinition =
{
    {
        0,
        sizeof (THREAD_DETAILS_DATA_DEFINITION),
        sizeof (PERF_OBJECT_TYPE),
        THREAD_DETAILS_OBJECT_TITLE_INDEX,
        0,
        (THREAD_DETAILS_OBJECT_TITLE_INDEX+1),
        0,
        PERF_DETAIL_WIZARD,
        (sizeof(THREAD_DETAILS_DATA_DEFINITION) - sizeof(PERF_OBJECT_TYPE)) /
            sizeof (PERF_COUNTER_DEFINITION),
        0,
        0,
        UNICODE_CODE_PAGE,
        {0L, 0L},
        {0L, 0L}
    },
    {
        sizeof (PERF_COUNTER_DEFINITION),
        708,
        0,
        709,
        0,
        0,
        PERF_DETAIL_WIZARD,
        PERF_COUNTER_RAWCOUNT,
        sizeof (DWORD),
        THREAD_D_USER_PC
    }
};

BROWSER_DATA_DEFINITION BrowserDataDefinition =
{
    {   sizeof (BROWSER_DATA_DEFINITION) + SIZE_OF_BROWSER_DATA,
        sizeof (BROWSER_DATA_DEFINITION),
        sizeof (PERF_OBJECT_TYPE),
        BROWSER_OBJECT_TITLE_INDEX,
        0,
        53,
        0,
        PERF_DETAIL_NOVICE,
        (sizeof(BROWSER_DATA_DEFINITION) - sizeof(PERF_OBJECT_TYPE)) /
            sizeof (PERF_COUNTER_DEFINITION),
        0,
        -1,
        UNICODE_CODE_PAGE,
        {0L, 0L},
        {0L, 0L}
    },
    {
        sizeof (PERF_COUNTER_DEFINITION),
        54,
        0,
        55,
        0,
        0,
        PERF_DETAIL_NOVICE,
        PERF_COUNTER_BULK_COUNT,
        sizeof (LARGE_INTEGER),
        SERVER_ANNOUNCE_OFFSET
    },
    {
        sizeof (PERF_COUNTER_DEFINITION),
        78,
        0,
        79,
        0,
        0,
        PERF_DETAIL_NOVICE,
        PERF_COUNTER_BULK_COUNT,
        sizeof (LARGE_INTEGER),
        DOMAIN_ANNOUNCE_OFFSET
    },
    {
        sizeof (PERF_COUNTER_DEFINITION),
        188,
        0,
        813,
        0,
        0,
        PERF_DETAIL_NOVICE,
        PERF_COUNTER_BULK_COUNT,
        sizeof (LARGE_INTEGER),
        TOTAL_ANNOUNCE_OFFSET
    },
    {
        sizeof (PERF_COUNTER_DEFINITION),
        80,
        0,
        81,
        0,
        0,
        PERF_DETAIL_NOVICE,
        PERF_COUNTER_COUNTER,
        sizeof (DWORD),
        ELECTION_PACKET_OFFSET
    },
    {
        sizeof (PERF_COUNTER_DEFINITION),
        82,
        0,
        83,
        0,
        0,
        PERF_DETAIL_NOVICE,
        PERF_COUNTER_COUNTER,
        sizeof (DWORD),
        MAILSLOT_WRITE_OFFSET
    },
    {
        sizeof (PERF_COUNTER_DEFINITION),
        84,
        0,
        85,
        0,
        0,
        PERF_DETAIL_NOVICE,
        PERF_COUNTER_COUNTER,
        sizeof (DWORD),
        SERVER_LIST_OFFSET
    },
    {
        sizeof (PERF_COUNTER_DEFINITION),
        156,
        0,
        161,
        0,
        0,
        PERF_DETAIL_NOVICE,
        PERF_COUNTER_COUNTER,
        sizeof (DWORD),
        SERVER_ENUM_OFFSET
    },
    {
        sizeof (PERF_COUNTER_DEFINITION),
        158,
        0,
        163,
        0,
        0,
        PERF_DETAIL_NOVICE,
        PERF_COUNTER_COUNTER,
        sizeof (DWORD),
        DOMAIN_ENUM_OFFSET
    },
    {
        sizeof (PERF_COUNTER_DEFINITION),
        160,
        0,
        165,
        0,
        0,
        PERF_DETAIL_NOVICE,
        PERF_COUNTER_COUNTER,
        sizeof (DWORD),
        OTHER_ENUM_OFFSET
    },
    {
        sizeof (PERF_COUNTER_DEFINITION),
        190,
        0,
        815,
        0,
        0,
        PERF_DETAIL_NOVICE,
        PERF_COUNTER_COUNTER,
        sizeof (DWORD),
        TOTAL_ENUM_OFFSET
    },
    {
        sizeof (PERF_COUNTER_DEFINITION),
        162,
        0,
        167,
        0,
        0,
        PERF_DETAIL_NOVICE,
        PERF_COUNTER_RAWCOUNT,
        sizeof (DWORD),
        SERVER_ANNOUNCE_MISS_OFFSET
    },
    {
        sizeof (PERF_COUNTER_DEFINITION),
        164,
        0,
        169,
        0,
        0,
        PERF_DETAIL_NOVICE,
        PERF_COUNTER_RAWCOUNT,
        sizeof (DWORD),
        MAILSLOT_DATAGRAM_MISS_OFFSET
    },
    {
        sizeof (PERF_COUNTER_DEFINITION),
        166,
        0,
        171,
        0,
        0,
        PERF_DETAIL_NOVICE,
        PERF_COUNTER_RAWCOUNT,
        sizeof (DWORD),
        SERVER_LIST_MISS_OFFSET
    },
    {
        sizeof (PERF_COUNTER_DEFINITION),
        168,
        0,
        381,
        0,
        0,
        PERF_DETAIL_NOVICE,
        PERF_COUNTER_COUNTER,
        sizeof (DWORD),
        SERVER_ANNOUNCE_ALLO_FAIL_OFFSET
    },
    {
        sizeof (PERF_COUNTER_DEFINITION),
        170,
        0,
        383,
        0,
        0,
        PERF_DETAIL_NOVICE,
        PERF_COUNTER_RAWCOUNT,
        sizeof (DWORD),
        MAILSLOT_ALLO_FAIL_OFFSET
    },
    {
        sizeof (PERF_COUNTER_DEFINITION),
        806,
        0,
        385,
        0,
        0,
        PERF_DETAIL_NOVICE,
        PERF_COUNTER_RAWCOUNT,
        sizeof (DWORD),
        MAILSLOT_RECE_FAIL_OFFSET
    },
    {
        sizeof (PERF_COUNTER_DEFINITION),
        808,
        0,
        387,
        0,
        0,
        PERF_DETAIL_NOVICE,
        PERF_COUNTER_RAWCOUNT,
        sizeof (DWORD),
        MAILSLOT_WRITE_FAIL_OFFSET
    },
    {
        sizeof (PERF_COUNTER_DEFINITION),
        810,
        0,
        807,
        0,
        0,
        PERF_DETAIL_NOVICE,
        PERF_COUNTER_COUNTER,
        sizeof (DWORD),
        MAILSLOT_OPENS_FAIL_OFFSET
    },
    {
        sizeof (PERF_COUNTER_DEFINITION),
        812,
        0,
        809,
        0,
        0,
        PERF_DETAIL_NOVICE,
        PERF_COUNTER_RAWCOUNT,
        sizeof (DWORD),
        MASTER_ANNOUNCE_DUP_OFFSET
    },
    {
        sizeof (PERF_COUNTER_DEFINITION),
        814,
        0,
        811,
        0,
        0,
        PERF_DETAIL_NOVICE,
        PERF_COUNTER_BULK_COUNT,
        sizeof (LARGE_INTEGER),
        DATAGRAM_ILLEGAL_OFFSET
    }
};



