// This is a part of the Microsoft Foundation Classes C++ library.
// Copyright (C) 1992-1995 Microsoft Corporation
// All rights reserved.
//
// This source code is only intended as a supplement to the
// Microsoft Foundation Classes Reference and related
// electronic documentation provided with the library.
// See these sources for detailed information regarding the
// Microsoft Foundation Classes product.

// Inlines for AFXRICH.H

#ifdef _AFXRICH_INLINE

// CWordpadRichEditView
_AFXRICH_INLINE CWordpadRichEditCtrl& CWordpadRichEditView::GetRichEditCtrl() const
	{ return *(CWordpadRichEditCtrl*)this; }
int _AFXRICH_INLINE CWordpadRichEditView::GetPrintWidth() const
	{ return m_sizePaper.cx - m_rectMargin.left - m_rectMargin.right;}
CRect _AFXRICH_INLINE CWordpadRichEditView::GetPrintRect() const
	{ return CRect(m_rectMargin.left, m_rectMargin.top, m_sizePaper.cx - m_rectMargin.right, m_sizePaper.cy - m_rectMargin.bottom); }
CRect _AFXRICH_INLINE CWordpadRichEditView::GetPageRect() const
	{ return CRect(CPoint(0,0), m_sizePaper); }
void _AFXRICH_INLINE CWordpadRichEditView::SetPaperSize(CSize sizePaper)
	{ m_sizePaper = sizePaper; }
CSize _AFXRICH_INLINE CWordpadRichEditView::GetPaperSize() const
	{ return m_sizePaper; }
void _AFXRICH_INLINE CWordpadRichEditView::SetMargins(const CRect& rectMargin)
	{ m_rectMargin = rectMargin; }
CRect _AFXRICH_INLINE CWordpadRichEditView::GetMargins() const
	{ return m_rectMargin; }

_AFXRICH_INLINE long CWordpadRichEditView::GetTextLength() const
	{ return GetRichEditCtrl().GetTextLength(); }
_AFXRICH_INLINE CWordpadRichEditDoc* CWordpadRichEditView::GetDocument() const
{
	ASSERT(m_pDocument != NULL);
	ASSERT(m_pDocument->IsKindOf(RUNTIME_CLASS(CWordpadRichEditDoc)));
	return (CWordpadRichEditDoc*)m_pDocument;
}
_AFXRICH_INLINE int CWordpadRichEditDoc::GetStreamFormat() const
	{ return m_bRTF ? SF_RTF : SF_TEXT; }
_AFXRICH_INLINE void CWordpadRichEditDoc::InvalidateObjectCache()
	{ m_bUpdateObjectCache = TRUE; }

_AFXRICH_INLINE void CWordpadRichEditCntrItem::Mark(BOOL b)
	{ m_bMark = b; }
_AFXRICH_INLINE BOOL CWordpadRichEditCntrItem::IsMarked()
	{ return m_bMark||m_bLock; }
_AFXRICH_INLINE CWordpadRichEditDoc* CWordpadRichEditCntrItem::GetDocument()
	{ return (CWordpadRichEditDoc*)COleClientItem::GetDocument(); }
_AFXRICH_INLINE CWordpadRichEditView* CWordpadRichEditCntrItem::GetActiveView()
	{ return (CWordpadRichEditView*)COleClientItem::GetActiveView(); }
#endif //_AFXRICH_INLINE

/////////////////////////////////////////////////////////////////////////////
