///////////////////////////////////////////////////////////////////////////////
//
// drvapplet.h
//
//
// History:
//      11 May 95 SteveCat
//          Ported to Windows NT and Unicode, cleaned up                  
//
//
// NOTE/BUGS
//
//  Copyright (C) 1994-1995 Microsoft Corporation
//
///////////////////////////////////////////////////////////////////////////////

#ifndef _DRVAPLET_H
#define _DRVAPLET_H


//////////////////////////////////////////////////////////////////////////////
// HDAP: handle to a driver applet

DECLARE_HANDLE( HDAP );


///////////////////////////////////////////////////////////////////////////////
// OpenDriverApplet: opens a handle to the named driver applet

HDAP OpenDriverApplet( LPCTSTR );


///////////////////////////////////////////////////////////////////////////////
// CloseDriverApplet: closes a handle to a driver applet

void CloseDriverApplet( HDAP );


///////////////////////////////////////////////////////////////////////////////
// GetDriverAppletIcon: get's a driver applet's icon (if any)

HICON GetDriverAppletIcon( HDAP );


///////////////////////////////////////////////////////////////////////////////
// CallDriverApplet: sends a message to the driver applet  (CplApplet syntax)

LRESULT CallDriverApplet( HDAP, HWND, UINT, LPARAM, LPARAM );


///////////////////////////////////////////////////////////////////////////////
// RunDriverApplet: runs the driver applet

#define RunDriverApplet( h, w ) CallDriverApplet( h, w, CPL_DBLCLK, 0L, 0L )


///////////////////////////////////////////////////////////////////////////////

extern const TCHAR *c_szCplApplet;    // "CplApplet"

#endif  // _DRVAPLET_H

