/***************************************************************************
 * ELSEPAN.H - Base definitions for ElseWare PANOSE(tm) 1.0 Font Mapper.
 *
 * $keywords: elsepan.h 1.10 19-Jul-93 11:11:34 AM$
 *
 * Copyright (C) 1991-93 ElseWare Corporation.  All rights reserved.
 ***************************************************************************/

#ifndef __ELSEPAN_H__
#define __ELSEPAN_H__

/***************************************************************************
 * ELSEUSER
 *
 * Rather than modify elsepan.h, put flags and additions in elseuser.h, or
 * disable inclusion of elseuser.h by placing "#define NOELSEUSER" ahead of
 * the #include for elsepan.h.
 ***************************************************************************/
#ifdef NOELSEUSER
#define __ELSEUSER_H__
#endif
#ifndef __ELSEUSER_H__
#include "elseuser.h"
#endif

/***************************************************************************
 * ELSETYPE
 *
 * Basic ElseWare types.
 ***************************************************************************/
#ifndef __ELSETYPE_H__
#include "elsetype.h"
#endif

/***************************************************************************
 * C++ SUPPORT
 *
 * If we are compiling with a C++ compiler, make these C-callable functions.
 ***************************************************************************/
#ifdef __cplusplus
extern "C" {
#endif

/***************************************************************************
 * COMPILER FLAG OVERRIDES
 *
 * If we are compiling one of the core ElseWare Font Mapper source files,
 * then override some flags.
 ***************************************************************************/
#ifdef ELSE_MAPPER_CORE
#undef NOELSEPANCONST
#define ELSEPENALTYDB
#endif

/***************************************************************************
 * PANOSE 1.0 PENALTIES DATABASE
 *
 * By default, this is declared as a static data object that stores
 * all the penalty tables in a variable called 's_panDB.' This is in
 * PAN1PTBL.H, which is generated by a stand-alone program in PAN1PTBL.C.
 *
 * Two sets of macros 'allocate' and 'lock' the database, which really
 * just return the pointer to the statically defined 's_panDB.'
 *
 * To override, the user should '#define NOELSEPANDATA' in ELSEUSER.H
 * and provide replacements for the allocate and lock routines. The file
 * PAN1PTBL.H should be used to generate the user-provided penalty database.
 ***************************************************************************/
#ifdef ELSE_MAPPER_CORE
#ifdef NOELSEPANDATA
#define __PAN1PTBL_H__
#endif
#ifndef __PAN1PTBL_H__
#include "pan1ptbl.h"
#define M_lAllocPAN1DATA() (1L)              /* returns data handle     */
#define M_bFreePAN1DATA(hData) (TRUE)        /* returns TRUE/FALSE      */
#define M_lLockPAN1DATA(hData) ((EW_LPPDICT_MEM)s_panDB) /* returns ptr */
#define M_bUnlockPAN1DATA(hData) (TRUE)      /* returns TRUE/FALSE      */
#endif
#endif

/***************************************************************************
 * COMPILATION FLAGS
 *
 * These flags control various aspects of compiling the font mapper.  You
 * turn these flags on by #defining them in elseuser.h.
 ***************************************************************************/

/* ELSEARGS macro
 *
 * Disable argument lists on prototypes by #defining NOELSEARGS.
 */
#ifdef ELSEARGS
#undef ELSEARGS
#endif
#ifndef NOELSEARGS
#define ELSEARGS(args) args
#else
#define ELSEARGS(args) ()
#endif

/* PAN_MATCH_ERROR
 *
 * This constant marks an error.
 */
#ifndef PAN_MATCH_ERROR
#define PAN_MATCH_ERROR 0xFFFF
#endif

/* ELSEMAXSHORT
 *
 * Maximum legal value for a SHORT.
 */
#ifndef ELSEMAXSHORT
#define ELSEMAXSHORT 0x7FFF
#endif

/* ELSEDEFTHRESHOLD
 *
 * Default value for the mapper threshold.
 */
#ifndef ELSEDEFTHRESHOLD
#define ELSEDEFTHRESHOLD 30
#endif

/* M_ELSELMUL
 *
 * a * b long math operation.
 */
#ifndef M_ELSELMUL
#define M_ELSELMUL(a, b) ((long)((long)(a) * (long)(b)))
#endif

/* M_ELSELDIV
 *
 * a / b long math operation.
 */
#ifndef M_ELSELDIV
#define M_ELSELDIV(a, b) ((long)((long)(a) / (long)(b)))
#endif

/* M_ELSEMULDIV
 *
 * (a * b) / c math operation.
 */
#ifndef M_ELSEMULDIV
#define M_ELSEMULDIV(a, b, c) \
   ((int)(M_ELSELDIV((M_ELSELMUL((a), (b)) + M_ELSELDIV((c), 2)), (c))))
#endif

/* M_ELSEMEMCPY
 *
 * memcpy(dst, src, len) operation.
 *
 * Defined in elsepan.c. Override it by defining a macro
 * for M_ELSEMEMCPY(dst, src, len).
 */

/***************************************************************************
 * PANOSE CONSTANTS
 *
 * These constants represent the individual values of the PANOSE digits.
 ***************************************************************************/
#define PANOSE_ANY             0
#define PANOSE_NOFIT           1
#define NUM_PAN_DIGITS         10
#define MAX_PAN1_FAMILY        127
#define MAX_PAN1_DIGIT         31
#define MAX_CUSTOM_WEIGHTS     8
#define SIZE_PAN1_NUM          (sizeof(EW_BYTE) * NUM_PAN_DIGITS)

#ifndef NOELSEPANCONST

/* Latin Text PANOSE values.
 */
#define FAMILY_LATTEXT             2
#define FAMILY_LATSCRIPT           3
#define FAMILY_LATDECORATIVE       4
#define FAMILY_LATPICTORIAL        5
#define FAMILY_KANJI3TEXTANDSCRIPT 6
#define FAMILY_KANJI3DECORATIVE    7
#define FAMILY_KANJI3SYMBOLS       8
#define FAMILY__LAST               8

#define SERIF_COVE             2
#define SERIF_OBTUSECOVE       3
#define SERIF_SQUARECOVE       4
#define SERIF_OBTSQUARECOVE    5
#define SERIF_SQUARE           6
#define SERIF_THIN             7
#define SERIF_BONE             8
#define SERIF_EXAGGERATED      9
#define SERIF_TRIANGLE         10
#define SERIF_NORMALSANS       11
#define SERIF_OBTUSESANS       12
#define SERIF_PERPSANS         13
#define SERIF_FLARED           14
#define SERIF_ROUNDED          15
#define SERIF__LAST            15

#define WEIGHT_VERYLIGHT       2
#define WEIGHT_LIGHT           3
#define WEIGHT_THIN            4
#define WEIGHT_BOOK            5
#define WEIGHT_MEDIUM          6
#define WEIGHT_DEMI            7
#define WEIGHT_BOLD            8
#define WEIGHT_HEAVY           9
#define WEIGHT_BLACK           10
#define WEIGHT_NORD            11
#define WEIGHT__LAST           11

#define PROPORTION_OLDSTYLE    2
#define PROPORTION_MODERN      3
#define PROPORTION_EVENWIDTH   4
#define PROPORTION_EXPANDED    5
#define PROPORTION_CONDENSED   6
#define PROPORTION_VERYEXP     7
#define PROPORTION_VERYCOND    8
#define PROPORTION_MONOSPACE   9
#define PROPORTION__LAST       9

#define CONTRAST_NONE          2
#define CONTRAST_VERYLOW       3
#define CONTRAST_LOW           4
#define CONTRAST_MEDIUMLOW     5
#define CONTRAST_MEDIUM        6
#define CONTRAST_MEDIUMHIGH    7
#define CONTRAST_HIGH          8
#define CONTRAST_VERYHIGH      9
#define CONTRAST__LAST         9

#define STROKE_NOVARIATION     2
#define STROKE_GRADDIAG        3
#define STROKE_GRADTRANS       4
#define STROKE_GRADVERT        5
#define STROKE_GRADHORZ        6
#define STROKE_RAPIDVERT       7
#define STROKE_RAPIDHORZ       8
#define STROKE_INSTANTVERT     9
#define STROKE__LAST           9

#define ARM_STRAIGHTHORZ       2
#define ARM_STRAIGHTWEDGE      3
#define ARM_STRAIGHTVERT       4
#define ARM_STRAIGHTSGLSERIF   5
#define ARM_STRAIGHTDBLSERIF   6
#define ARM_NONSTRTHORZ        7
#define ARM_NONSTRTWEDGE       8
#define ARM_NONSTRTVERT        9
#define ARM_NONSTRTSGLSERIF    10
#define ARM_NONSTRTDBLSERIF    11
#define ARM__LAST              11

#define LTRFORM_NORMCONTACT    2
#define LTRFORM_NORMWEIGHTED   3
#define LTRFORM_NORMBOXED      4
#define LTRFORM_NORMFLATTENED  5
#define LTRFORM_NORMROUNDED    6
#define LTRFORM_NORMOFFCENTER  7
#define LTRFORM_NORMSQUARE     8
#define LTRFORM_OBLQCONTACT    9
#define LTRFORM_OBLQWEIGHTED   10
#define LTRFORM_OBLQBOXED      11
#define LTRFORM_OBLQFLATTENED  12
#define LTRFORM_OBLQROUNDED    13
#define LTRFORM_OBLQOFFCENTER  14
#define LTRFORM_OBLQSQUARE     15
#define LTRFORM__LAST          15

#define MIDLINE_STDTRIMMED     2
#define MIDLINE_STDPOINTED     3
#define MIDLINE_STDSERIFED     4
#define MIDLINE_HIGHTRIMMED    5
#define MIDLINE_HIGHPOINTED    6
#define MIDLINE_HIGHSERIFED    7
#define MIDLINE_CONSTTRIMMED   8
#define MIDLINE_CONSTPOINTED   9
#define MIDLINE_CONSTSERIFED   10
#define MIDLINE_LOWTRIMMED     11
#define MIDLINE_LOWPOINTED     12
#define MIDLINE_LOWSERIFED     13
#define MIDLINE__LAST          13

#define XHEIGHT_CONSTSMALL     2
#define XHEIGHT_CONSTSTD       3
#define XHEIGHT_CONSTLARGE     4
#define XHEIGHT_DUCKSMALL      5
#define XHEIGHT_DUCKSTD        6
#define XHEIGHT_DUCKLARGE      7
#define XHEIGHT__LAST          7

/* Latin Script PANOSE values.
 */
#ifndef NOELSEPANSCRIPT

#define STOOL_FLATNIB          2
#define STOOL_PRESSUREPT       3
#define STOOL_ENGRAVED         4
#define STOOL_BALL             5
#define STOOL_BRUSH            6
#define STOOL_ROUGH            7
#define STOOL_FELTPEN          8
#define STOOL_WILDBRUSH        9
#define STOOL__LAST            9

#define STOP_ROMDISCONNECT     2
#define STOP_ROMTRAIL          3
#define STOP_ROMCONNNECT       4
#define STOP_CURDISCONNECT     5
#define STOP_CURTRAIL          6
#define STOP_CURCONNECT        7
#define STOP_BLACKDISCONNECT   8
#define STOP_BLACKTRAIL        9
#define STOP_BLACKCONNECT      10
#define STOP__LAST             10

#define SFORM_UPNOWRAP         2
#define SFORM_UPSOMEWRAP       3
#define SFORM_UPMOREWRAP       4
#define SFORM_UPEXCESSWRAP     5
#define SFORM_OBNOWRAP         6
#define SFORM_OBSOMEWRAP       7
#define SFORM_OBMOREWRAP       8
#define SFORM_OBEXCESSWRAP     9
#define SFORM_EXNOWRAP         10
#define SFORM_EXSOMEWRAP       11
#define SFORM_EXMOREWRAP       12
#define SFORM_EXEXCESSWRAP     13
#define SFORM__LAST            13

#define SFINIAL_NONENOLOOP     2
#define SFINIAL_NONECLOSELOOP  3
#define SFINIAL_NONEOPENLOOP   4
#define SFINIAL_SHARPNOLOOP    5
#define SFINIAL_SHARPCLOSELOOP 6
#define SFINIAL_SHARPOPENLOOP  7
#define SFINIAL_TAPERNOLOOP    8
#define SFINIAL_TAPERCLOSELOOP 9
#define SFINIAL_TAPEROPENLOOP  10
#define SFINIAL_ROUNDNOLOOP    11
#define SFINIAL_ROUNDCLOSELOOP 12
#define SFINIAL_ROUNDOPENLOOP  13
#define SFINIAL__LAST          13

#define SXASCENT_VERYLOWDIF    2
#define SXASCENT_LOWDIF        3
#define SXASCENT_MEDIUMDIF     4
#define SXASCENT_HIGHDIF       5
#define SXASCENT_VERYHIGHDIF   6
#define SXASCENT__LAST         6

#endif  /* ifndef NOELSEPANSCRIPT */

/* Kanji PANOSE values.
 */
#ifndef NOELSEPANKANJI

#define KSTROKE_TRADBRUSH      2
#define KSTROKE_VIGBRUSH       3
#define KSTROKE_DRYBRUSH       4
#define KSTROKE_FLATNIBPEN     5
#define KSTROKE_SQUARE         6
#define KSTROKE_OBTSQUARE      7
#define KSTROKE_ROUND          8
#define KSTROKE_TAPERED        9
#define KSTROKE_MECHBRUSH      10
#define KSTROKE_STACCATO       11
#define KSTROKE_VOLATE         12
#define KSTROKE__LAST          12

#define KCELL_NORMNOSLANT      2
#define KCELL_NORMSLANTED      3
#define KCELL_WIDENOSLANT      4
#define KCELL_WIDESLANTED      5
#define KCELL_TALLNOSLANT      6
#define KCELL_TALLSLANTED      7
#define KCELL_XTRAWIDENOSLANT  8
#define KCELL_XTRAWIDESLANTED  9
#define KCELL_XTRATALLNOSLANT  10
#define KCELL_XTRATALLSLANTED  11
#define KCELL__LAST            11

#define KSSTROKE_ZOT           2
#define KSSTROKE_LONGZOT       3
#define KSSTROKE_FATZOT        4
#define KSSTROKE_HOOKEDZOT     5
#define KSSTROKE_SHORTRECT     6
#define KSSTROKE_LONGRECT      7
#define KSSTROKE_TAPEREDRECT   8
#define KSSTROKE_SPIKE         9
#define KSSTROKE_ROUNDED       10
#define KSSTROKE_EXAGGERATED   11
#define KSSTROKE_ROUGH         12
#define KSSTROKE__LAST         12

#define KTOP_STDNOSQUARE       2
#define KTOP_MODNOSQUARE       3
#define KTOP_STRONGNOSQUARE    4
#define KTOP_WILDNOSQUARE      5
#define KTOP_STDSQUARE         6
#define KTOP_MODSQUARE         7
#define KTOP_STRONGSQUARE      8
#define KTOP_WILDSQUARE        9
#define KTOP__LAST             9

#define KSTYLESIM_FULL         2
#define KSTYLESIM_COMPLEMENT   3
#define KSTYLESIM_SIMILAR      4
#define KSTYLESIM_DIFFERENT    5
#define KSTYLESIM_DISPARATE    6
#define KSTYLESIM__LAST        6

#define KSTROKEVAR_FULL        2
#define KSTROKEVAR_MODERATE    3
#define KSTROKEVAR_LOW         4
#define KSTROKEVAR_NONE        5
#define KSTROKEVAR__LAST       5

#endif  /* ifndef NOELSEPANKANJI */
#endif  /* ifndef NOELSEPANCONST */

/***************************************************************************
 * LATIN TEXT PANOSE INDICES
 *
 * Indices into an array containing the standard 10-digit PANOSE number.
 ***************************************************************************/
#define PAN_IND_FAMILY         0
#define PAN_IND_SERIF          1
#define PAN_IND_WEIGHT         2
#define PAN_IND_PROPORTION     3
#define PAN_IND_CONTRAST       4
#define PAN_IND_STROKE         5
#define PAN_IND_ARMSTYLE       6
#define PAN_IND_LTRFORM        7
#define PAN_IND_MIDLINE        8
#define PAN_IND_XHEIGHT        9
#define PAN_IND__LAST          9

/***************************************************************************
 * LATIN SCRIPT PANOSE INDICES
 *
 * Indices into an array containing the Latin Script 10-digit PANOSE number.
 ***************************************************************************/
#ifndef NOELSEPANSCRIPT
/* define PAN_IND_FAMILY       0 */
#define SPAN_IND_STOOL         1
#define SPAN_IND_WEIGHT        2
#define SPAN_IND_MONOSPC       3
#define SPAN_IND_ASPECT        4
#define SPAN_IND_CONTRAST      5
#define SPAN_IND_STOP          6
#define SPAN_IND_SFORM         7
#define SPAN_IND_SFINIAL       8
#define SPAN_IND_SXASCENT      9
#define SPAN_IND__LAST         9 
#endif  /* ifndef NOELSEPANSCRIPT */

/***************************************************************************
 * KANJI PANOSE INDICES
 *
 * Indices into an array containing the Kanji 10-digit PANOSE number.
 ***************************************************************************/
#ifndef NOELSEPANKANJI
/* define PAN_IND_FAMILY       0 */
#define KPAN_IND_KSTROKE       1
#define KPAN_IND_WEIGHT        2
#define KPAN_IND_KCELL         3
#define KPAN_IND_MONOSPC       4
#define KPAN_IND_CONTRAST      5
#define KPAN_IND_KSSTROKE      6
#define KPAN_IND_KTOP          7
#define KPAN_IND_KSTYLESIM     8
#define KPAN_IND_KSTROKEVAR    9
#define KPAN_IND__LAST         9
#endif  /* ifndef NOELSEPANKANJI */

/***************************************************************************
 * KANJI-TO-LATIN WEIGHT INDICES
 *
 * Indices into the weights array for the Kanji-to-Latin cross-class
 * penalty database.
 ***************************************************************************/
#ifndef NOELSEPANKANJI
/* define PAN_IND_FAMILY       0 */
#define PAN_IND_WT_KLSTROKETOSERIF 1
#define PAN_IND_WT_KLWEIGHT        2
#define PAN_IND_WT_KLCELLTOPROP    3
#define PAN_IND_WT_KLCELLTOLTRFORM 4
#define PAN_IND_WT_KLMONOTOPROP    5
#define PAN_IND_WT_KLCONTRAST      6
#define PAN_IND_WT_KLTOPTOLTRFORM  7
#endif  /* ifndef NOELSEPANKANJI */

/***************************************************************************
 * PANOSE_PENALTY_VERS
 *
 * Database format version number.
 *
 * 0x0100 - Original implementation.
 * 0x0101 - Modified the compression formats in which the tables are stored,
 *          and added a flat table format (zero compression).
 * 0x0110 - PANOSE version 1.0 penalties, previous versions were
 *          "Expanded PANOSE" penalties. Added C3 compression.
 * 0x0111 - Added byte ordering check, and C4 compression. Also the penalty
 *          table builder will make identical ptbls point to the same data
 *          to further compress the database.
 ***************************************************************************/
#define PANOSE_PENALTY_VERS    0x0111

/***************************************************************************
 * PANOSE PENALTY TABLE data structures
 *
 * The following structures are fused together into one big block.  See
 * the sample code in PAN1PTBL.C (provided with the ElseWare Font Mapper
 * source code) for an example of how to build this structure.
 ***************************************************************************/
#ifdef ELSEPENALTYDB

#define PAN_COMPRESS_C0        0
#define PAN_COMPRESS_C1        1
#define PAN_COMPRESS_C2        2
#define PAN_COMPRESS_C3        3
#define PAN_COMPRESS_C4        4
#define PAN_COMPRESS__LAST     4

/* Byte ordering test: the unByteOrder field of the header is
 * tested to make sure it matches this value -- if the bytes
 * are swapped, the test will fail.
 */
#define PTBL_BYTE_ORDER        0x1234

/* C0 compression == full table provided.  The first two bytes
 * of the table contain its dimensions.  When the need exists
 * to specify the whole table it is usually because it is a
 * non-square, non-symmetrical table.
 */
typedef struct _tagEW_PTBL_C0_MEM {
   EW_BYTE jARangeLast;        /* highest possible A value (table width) */
   EW_BYTE jBRangeLast;        /* highest possible B value (table depth) */
   EW_BYTE jReserved;          /* reserved, should be zero */
   EW_BYTE jPenalties[1];      /* penalty table */
} EW_PTBL_C0_MEM, EW_FAR *EW_LPPTBL_C0_MEM;

/* C1 compression == smooth penalty range symetrical about the
 * diagonal where closest to diagonal == 1 and each increment
 * away from the diagonal == increment penalty by one.  NO table
 * is provided, and the any, no-fit, and match penalties take
 * on the defaults listed in the index entry for the dictionary.
 * The variables ulOffsTbl and unTblSize in the range record
 * should be zero.
 */

/* C2 penalties symmetrical around the diagonal but without
 * a smooth range, lower left half specified.  There is no special
 * record needed: it is an array of bytes where any, no-fit, and
 * match penalties are taken from the header.
 */

/* C3 penalties are identical to C2 except the very first byte
 * is the no-fit penalty value: any and match penalties are taken
 * from the header.
 */

/* C4 penalties are similar to C1: symmetric around the diagonal,
 * increasing in uniform increments the further from the diagonal.
 * The difference is it doesn't start at 1 and/or doesn't increment
 * by 1. The start and increment values are provided.
 */
typedef struct _tagEW_PTBL_C4_MEM {
   EW_BYTE jStart;             /* lowest value in table */
   EW_BYTE jIncrement;         /* increment away from the diagonal */
} EW_PTBL_C4_MEM, EW_FAR *EW_LPPTBL_C4_MEM;

/* Penalty table record, which describes the format of the penalty
 * table and contains its offset and size.  There is an array of
 * 9 of these at the offset unOffsPTbl stored in the index record
 * (there is no penalty table for the family digit). In the case of
 * cross-family mapping, there are unNumAtoB records (instead of 9).
 */
typedef struct _tagEW_PTBL_MEM {
   EW_BYTE jRangeLast;         /* highest possible PANOSE digit value */
   EW_BYTE jCompress;          /* type of compression */
   EW_USHORT unOffsTbl;        /* byte offset to penalty table */
   EW_USHORT unTblSize;        /* # bytes in penalty table */
} EW_PTBL_MEM, EW_FAR *EW_LPPTBL_MEM;

/* The A to B array maps PANOSE digits from one classification to
 * those in another (this happens when the two Family digits are
 * not equal).
 */
typedef struct _tagEW_ATOB_ITEM_MEM {
   EW_BYTE jAttrA;             /* PANOSE number index from family A */
   EW_BYTE jAttrB;             /* related PANOSE number ind from family B */
} EW_ATOB_ITEM_MEM, EW_FAR *EW_LPATOB_ITEM_MEM;

typedef struct _tagEW_ATOB_MEM {
   EW_USHORT unNumAtoB;        /* count of array items */
   EW_ATOB_ITEM_MEM AtoBItem[1]; /* remapping array (variable length) */
} EW_ATOB_MEM, EW_FAR *EW_LPATOB_MEM;

/* Mapper weights are stored in an array of 10 1-byte values.
 * We include a weight for the family digit even though it is
 * ignored by the mapper (it is included so the weights array
 * is parrallel to the PANOSE digits array, allowing the same
 * constants to be used to access both arrays). In cross-family
 * mappings there are still 10 weights, and the unused ones are
 * set to zero.
 */

/* Penalty index record.  Each record contains information for a
 * penalty database, which contains all the penalty tables for one
 * given family pair.
 */
typedef struct _tagEW_PIND_MEM {
   EW_BYTE jFamilyA;           /* family pair for which penalties apply */
   EW_BYTE jFamilyB;           /* ditto */
   EW_BYTE jDefAnyPenalty;     /* default penalty value for 'any' match */
   EW_BYTE jDefNoFitPenalty;   /* default penalty value for 'no fit' match */
   EW_BYTE jDefMatchPenalty;   /* default penalty value for exact match */
   EW_BYTE jReserved;          /* to keep the record word-aligned */
   EW_USHORT unOffsWts;        /* byte offs to mapper weights */
   EW_USHORT unOffsAtoB;       /* byte offs to array relates family A to B */
   EW_USHORT unOffsPTbl;       /* byte offs to penalty tables */
} EW_PIND_MEM, EW_FAR *EW_LPPIND_MEM;

/* Penalty dictionary header.  This is the header to the entire
 * structure.  Its last item is a variable length array of index
 * records.  Each index record points to a penalty database.
 */
typedef struct _tagEW_PDICT_MEM {
   EW_USHORT unVersion;        /* version # of this structure */
   EW_USHORT unByteOrder;      /* byte ordering flag */
   EW_USHORT unNumDicts;       /* number of entries in PANOSE_PINDEX array */
   EW_USHORT unSizeDB;         /* count in bytes of the whole database */
   EW_PIND_MEM pind[1];        /* array of EW_PIND recs (variable len) */
} EW_PDICT_MEM, EW_FAR *EW_LPPDICT_MEM;

#endif  /* ifdef ELSEPENALTYDB */

/***************************************************************************
 * MAP STATE structure
 *
 * This data structure stores the state variables used by the mapper.
 * It is passed into almost all the mapper routines.
 ***************************************************************************/
typedef struct _tagEW_MAPSTATE {
   EW_ULONG ulSanity;
   EW_USHORT unThreshold;
   EW_USHORT unRelaxThresholdCount;
   EW_ULONG ulhPan1Data;
   EW_BOOL bUseDef;
   EW_BYTE ajPanDef[NUM_PAN_DIGITS];
#ifndef NOELSEWEIGHTS
   EW_BYTE ajWtRefA[MAX_CUSTOM_WEIGHTS];
   EW_BYTE ajWtRefB[MAX_CUSTOM_WEIGHTS];
   EW_BYTE ajCustomWt[SIZE_PAN1_NUM * MAX_CUSTOM_WEIGHTS];
#endif
} EW_MAPSTATE, EW_FAR *EW_LPMAPSTATE;

/***************************************************************************
 * ELSEPAN.C: Core PANOSE 1.0 font mapping routines.
 ***************************************************************************/

GLOBAL EW_SHORT EW_FAR EW_PASCAL nPANMapInit
   ELSEARGS (( EW_LPMAPSTATE lpMapState, EW_USHORT unSizeMapState ));

GLOBAL EW_BOOL EW_FAR EW_PASCAL bPANMapClose
   ELSEARGS (( EW_LPMAPSTATE lpMapState ));

GLOBAL EW_USHORT EW_FAR EW_PASCAL unPANMatchFonts
   ELSEARGS (( EW_LPMAPSTATE lpMapState, EW_LPBYTE lpPanWant,
      EW_ULONG ulSizeWant, EW_LPBYTE lpPanThis, EW_ULONG ulSizeThis,
      EW_BYTE jMapToFamily ));

GLOBAL EW_VOID EW_FAR EW_PASCAL vPANMakeDummy
   ELSEARGS (( EW_LPBYTE lpPanThis, EW_USHORT unSize ));


#ifndef NOELSEPICKFONTS

GLOBAL EW_SHORT EW_FAR EW_PASCAL nPANGetMapDefault
   ELSEARGS (( EW_LPMAPSTATE lpMapState, EW_LPBYTE lpPanDef,
      EW_USHORT unSizePanDef ));

GLOBAL EW_SHORT EW_FAR EW_PASCAL nPANSetMapDefault
   ELSEARGS (( EW_LPMAPSTATE lpMapState, EW_LPBYTE lpPanDef,
      EW_USHORT unSizePanDef ));

GLOBAL EW_BOOL EW_FAR EW_PASCAL bPANEnableMapDefault
   ELSEARGS (( EW_LPMAPSTATE lpMapState, EW_BOOL bEnable ));

GLOBAL EW_BOOL EW_FAR EW_PASCAL bPANIsDefaultEnabled
   ELSEARGS (( EW_LPMAPSTATE lpMapState ));

GLOBAL EW_USHORT EW_FAR EW_PASCAL unPANPickFonts
   ELSEARGS (( EW_LPMAPSTATE lpMapState, EW_LPUSHORT lpIndsBest,
      EW_LPUSHORT lpMatchValues, EW_LPBYTE lpPanWant,
      EW_USHORT unNumInds, EW_LPBYTE lpPanFirst, EW_USHORT unNumAvail,
      EW_SHORT nRecSize, EW_BYTE jMapToFamily ));

#endif /* ifndef NOELSEPICKFONTS */


#ifndef NOELSETHRESHOLD

GLOBAL EW_USHORT EW_FAR EW_PASCAL unPANGetMapThreshold
   ELSEARGS (( EW_LPMAPSTATE lpMapState ));

GLOBAL EW_BOOL EW_FAR EW_PASCAL bPANSetMapThreshold
   ELSEARGS (( EW_LPMAPSTATE lpMapState, EW_USHORT unThreshold ));

GLOBAL EW_BOOL EW_FAR EW_PASCAL bPANIsThresholdRelaxed
   ELSEARGS (( EW_LPMAPSTATE lpMapState ));

GLOBAL EW_VOID EW_FAR EW_PASCAL vPANRelaxThreshold
   ELSEARGS (( EW_LPMAPSTATE lpMapState ));

GLOBAL EW_BOOL EW_FAR EW_PASCAL bPANRestoreThreshold
   ELSEARGS (( EW_LPMAPSTATE lpMapState ));

#endif /* ifndef NOELSETHRESHOLD */


#ifndef NOELSEWEIGHTS

GLOBAL EW_BOOL EW_FAR EW_PASCAL bPANGetMapWeights
   ELSEARGS (( EW_LPMAPSTATE lpMapState, EW_BYTE jFamilyA,
      EW_BYTE jFamilyB, EW_LPBYTE lpjWts, EW_LPBOOL lpbIsCustom ));

GLOBAL EW_BOOL EW_FAR EW_PASCAL bPANSetMapWeights
   ELSEARGS (( EW_LPMAPSTATE lpMapState, EW_BYTE jFamilyA,
      EW_BYTE jFamilyB, EW_LPBYTE lpjWts ));

GLOBAL EW_BOOL EW_FAR EW_PASCAL bPANClearMapWeights
   ELSEARGS (( EW_LPMAPSTATE lpMapState, EW_BYTE jFamilyA,
      EW_BYTE jFamilyB ));

#endif /* ifndef NOELSEWEIGHTS */


#ifdef __cplusplus
}
#endif

#endif /* ifndef __ELSEPAN_H__ */

/***************************************************************************
 * Revision log:
 ***************************************************************************/
/*
 * $lgb$
 * 1.0    31-Jan-93    msd PANOSE 1.0 mapper: 10-digit PANOSE.
 * 1.1     2-Feb-93    msd Removed huge pointer stuff.
 * 1.2     2-Feb-93    msd 
 * 1.3     3-Feb-93    msd Removed ctrl-Z at EOF.
 * 1.4     3-Feb-93    msd Fixed bug caused by vcs check-in.
 * 1.5     6-Feb-93    msd Word-aligned C0 penalty header.
 * 1.6    15-Feb-93    msd For extra security, bumped the sanity value from word to a long.
 * 1.7    18-Feb-93    msd Added support for C++ compilers.
 * 1.8    18-Feb-93    msd Added penalty table byte-ordering check, and C4 ptbl compression (new version of ptbl). Use EW_FAR.
 * 1.9    27-Apr-93    msd Added MAX_PAN1_DIGIT.
 * 1.10   19-Jul-93    msd Added compilation flags to selectively disable mapper routines.
 * $lge$
 */
