/*****************************************************************************
*																			 *
*  HELPMISC.H																 *
*																			 *
*  Copyright (C) Microsoft Corporation 1991.								 *
*  All Rights reserved. 													 *
*																			 *
******************************************************************************
*																			 *
*  Module Intent															 *
*																			 *
*  Global, platform independent typedefs, macros, and defines.				 *
*																			 *
******************************************************************************
*																			 *
*  Testing Notes															 *
*																			 *
******************************************************************************
*																			 *
*  Current Owner:  SEVERAL													 *
*																			 *
******************************************************************************
*																			 *
*  Released by Development: 												 *
*																			 *
*****************************************************************************/

/*****************************************************************************
*
*  Revision History:
*
*  02/14/91  RobertBu Added fDEBUGASKFIRST for bug #887
*  15/05/91  Dann	  Added case for HLPMENUDEBUGMEMLEAKS
*
*****************************************************************************/


#define fDEBUGFRAME 	 0x0001
#define fDEBUGALLOC 	 0x0002
#define fDEBUGAPI		 0x0004
#define fDEBUGVERSION	 0x0008
#define fDEBUGASKFIRST	 0x0010 		 /* Ask the user before performing a */
										 /*   a hotspot action. 			 */
#define fDEBUGSTACKUSAGE 0x0040 		 /* Report how much stack we've used */

/* constants */

/* This stuff is from fc.h */
										/* See Notes for wTopicPosHfc() 	*/
typedef WORD   TN;						/* Topic number/label				*/
typedef LONG   ITO; 					/* Index into TO map				*/

/* This from de.h -- the QDE struct ptr type is passed around alot, so it
 *	is "opaquely" defined here so the type is always available.
 */
typedef struct de_tag *QDE;

#define itoNil ((ITO)(-1))

/* This is the standard Topic File Address type.  VA stands for Virtual Addr.
 *
 * It consists of a block number and an offset within that block.
 * This 2-level address is needed so we can compress the data within
 * the 2K blocks.  The bock number is a post-compression block number,
 * the offset is a pre-compression offset.
 *
 * The union with a dword is used so we can compare VA's for equality
 * without performing the bit shuffling the bitfields imply.
 *
 * Note: C 6.0 style nameless struct & union used to make refs brief.
 */
typedef union va {
  DWORD dword;
  struct va_bitfields {
	unsigned long byteoff:14;	// allows max of 16K post-compress block
	unsigned long blknum:18;
  } bf;
} VA, *QVA;

#define vaNil ((DWORD)-1)		// set va.dword = vaNil for invalid VAs

// This translation is used when reading Help 3.0 files which contain
// simple linear addresses:
#define OffsetToVA30( pva, off ) \
 { DWORD toff = off;		   \
 (((pva)->bf.blknum=toff/cbBLOCK_SIZE_30),((pva)->bf.byteoff=toff%cbBLOCK_SIZE_30)); \
 }
#define VAToOffset30( pva ) \
 ( ((pva)->bf.blknum*cbBLOCK_SIZE_30) + (pva)->bf.byteoff)

// Translations used when dealing with 3.5 files:
#define OffsetToVA( pva, off ) \
 { DWORD toff = off;		   \
 (((pva)->bf.blknum=toff/cbBLOCK_SIZE),((pva)->bf.byteoff=toff%cbBLOCK_SIZE)); \
 }
#define VAToOffset( pva ) \
 ( ((pva)->bf.blknum*cbBLOCK_SIZE) + (pva)->bf.byteoff)


// Generic address type, for people who don't care if it's an FCL or a PA

typedef LONG ADDR;
#define addrNil 		 ((ADDR) -1)
#define addrNotNil		 ((ADDR) -2)

// TO: Text offset. Defines the position of a character within a topic

typedef struct {
	VA	 va;		// Virtual address of FC within topic
	LONG ich;		// Position of character within decompressed FC
} TO;

/* TLP: Text layout position.  This defines the position of the layout	*/
/* on the screen.														*/

typedef struct {
	VA	 va;	   // Virtual address of FC within topic
	LONG lScroll;  // Percentage of vertical height scrolled.
} TLP, *QTLP;

// WCmpTlp() returns 0 if the TLPs are the same, nonzero otherwise

#define WCmpTlp(tlp1, tlp2) \
  ( (tlp1).va.dword != (tlp2).va.dword || (tlp1).lScroll != (tlp2).lScroll )


// TP: Text position.  Defines the position of a character in a file

typedef struct {
	TN tn;
	TO to;
} TP;

typedef DWORD CTX;		// Context as generated by APP

#define ctxINDEX -1 			// Context number for index
#define ctxHOH 0xfffc			// Context number for help on help

typedef WORD SCRLAMT;			// Amount to scroll by.
typedef WORD SCRLDIR;			// Which scroll bar (H/V).

/* REVIEW: This should be somewhere else. */
/* This structure is contained in the de, and contains information about */
/* the current layout status.											 */

typedef struct {
	WORD fLayoutAtTop:1;
	WORD fLayoutAtBottom:1;
	WORD fUnused:14;
} MLI, *QMLI;

// handle to annotation mgr info struct

typedef HANDLE HADS;

// BMK: Handle to the bookmark list. Used in DE structure

typedef HANDLE BMK;

// SEARCH: Handle to current search set

typedef HANDLE HSS;

#ifndef _X86_
/* Our compressed data types.  These are required by SDFF in objects.h */
typedef unsigned short GA;
typedef unsigned long  GB;
typedef unsigned long  GC;
typedef signed   short GD;
typedef signed   long  GE;
typedef signed   long  GF;

#ifndef WIN32 

//typedef FARPROC LPFN;   /* Review: shouldn't this be defined in misc.h? */
//typedef LPFN XRPFN;     /* This alias needed for win32 vs. Mac stuff.   */
//typedef LPFN XR;
//#define XRPROC PASCAL   /* for the routine's protos themselves */


#else
/* In windows 32, the pascal, -Gc, #define PASCAL stuff is all awry
 *  -- and designed so everything is Cdecl since all the win32 apis
 *  are cdecl.
 *
 * Therefore we make sure XR really is pascal since
 * we call it in wierd ways (ie manuall) which really are pascal.
 */
//typedef INT (_pascal *XR)();
//typedef XR   XRPFN;     /* This alias needed for win32 vs. Mac stuff.   */
//#define XRPROC _pascal

/* This first arg param deals with the fact that on mips the first four
 * arguments are put in registers and are therefore problematic to deal
 * with algorithmically.
 */

#endif  /* WIN32 */
#endif // _X86_
